<?php

class swt_twitter_widget extends WP_Widget {

	function __construct() {
		
		$widget_options = array( 'classname' => 'swt_twitter_widget', 'description' => __( 'Widget for displaying recent tweets.', 'swt' ) );
		
		parent::WP_Widget( 'swt_twitter_widget', __( 'SWT - Twitter Stream', 'swt' ), $widget_options );
				
	}
		
	function form( $instance ) {
 
		/* Defaults */
		$defaults = array( 
			'title' => '', 
			'username' => '', 
			'tweet_number' => '', 
			'consumer_key' => '', 
			'consumer_secret' => '', 
			'user_token' => '',
			'user_secret' => '',			
			'cache_time' => 60
		);
		
		/* Merge $defaults with saved options */
		$instance = wp_parse_args( (array) $instance, $defaults );
		
		$title 				= 	$instance['title'];
 		$username 			= 	$instance['username'];
 		$tweet_number 		= 	$instance['tweet_number'];
 		$consumer_key 		= 	$instance['consumer_key'];
 		$consumer_secret 	= 	$instance['consumer_secret'];
 		$user_token 		= 	$instance['user_token'];
 		$user_secret 		= 	$instance['user_secret'];
 		$cache_time 		= 	$instance['cache_time'];
  
 		?>
		
		<p>
		<?php _e( 'In order to  use this widget, you\'ll need to create Twitter app for your account, obtain OAuth data (keys) and paste them here. Here\'s tutorial on ', 'swt' ); ?>
		<a target="_blank" href="https://www.youtube.com/watch?v=rWNYZOT0a6o">Youtube.</a>
		</p>
			
		<p>
			<label for="<?php echo $this->get_field_id( 'title' ); ?>"><?php _e( 'Title:', 'swt' ); ?></label>
			<input type="text" class="widefat" id="<?php echo $this->get_field_id( 'title' ); ?>" name="<?php echo $this->get_field_name( 'title' ); ?>" value="<?php echo esc_attr( $title ); ?>" />
		</p>			
 	
		<p>
			<label for="<?php echo $this->get_field_id( 'username' ); ?>"><?php _e( 'Twitter username:', 'swt' ); ?></label>
			<input type="text" class="widefat" id="<?php echo $this->get_field_id( 'username' ); ?>" name="<?php echo $this->get_field_name( 'username' ); ?>" value="<?php echo esc_attr( $username ); ?>" />
		</p>	

		<p>
			<label for="<?php echo $this->get_field_id( 'tweet_number' ); ?>"><?php _e( 'Number of tweets to show:', 'swt' ); ?></label>
			<input type="text" class="widefat" id="<?php echo $this->get_field_id( 'tweet_number' ); ?>" name="<?php echo $this->get_field_name( 'tweet_number' ); ?>" value="<?php echo esc_attr( $tweet_number ); ?>" />
		</p>	

		<p>
			<label for="<?php echo $this->get_field_id( 'cache_time' ); ?>"><?php _e( 'How often to check for new tweets (in minutes)?', 'swt' ); ?></label>
			<input type="text" class="smallfat" id="<?php echo $this->get_field_id( 'cache_time' ); ?>" name="<?php echo $this->get_field_name( 'cache_time' ); ?>" value="<?php echo esc_attr( $cache_time ); ?>" />
		</p>		
		
		<p>
			<label for="<?php echo $this->get_field_id( 'consumer_key' ); ?>"><?php _e( 'Consumer key / API key:', 'swt' ); ?></label>
			<input type="text" class="widefat" id="<?php echo $this->get_field_id( 'consumer_key' ); ?>" name="<?php echo $this->get_field_name( 'consumer_key' ); ?>" value="<?php echo esc_attr( $consumer_key ); ?>" />
		</p>		
		
		<p>
			<label for="<?php echo $this->get_field_id( 'consumer_secret' ); ?>"><?php _e( 'Consumer secret / API secret:', 'swt' ); ?></label>
			<input type="text" class="widefat" id="<?php echo $this->get_field_id( 'consumer_secret' ); ?>" name="<?php echo $this->get_field_name( 'consumer_secret' ); ?>" value="<?php echo esc_attr( $consumer_secret ); ?>" />
		</p>	

		<p>
			<label for="<?php echo $this->get_field_id( 'user_token' ); ?>"><?php _e( 'Access token:', 'swt' ); ?></label>
			<input type="text" class="widefat" id="<?php echo $this->get_field_id( 'user_token' ); ?>" name="<?php echo $this->get_field_name( 'user_token' ); ?>" value="<?php echo esc_attr( $user_token ); ?>" />
		</p>

		<p>
			<label for="<?php echo $this->get_field_id( 'user_secret' ); ?>"><?php _e( 'Access token secret:', 'swt' ); ?></label>
			<input type="text" class="widefat" id="<?php echo $this->get_field_id( 'user_secret' ); ?>" name="<?php echo $this->get_field_name( 'user_secret' ); ?>" value="<?php echo esc_attr( $user_secret ); ?>" />
		</p>	
					
		<?php
		
	}
	
	function update( $new_instance, $old_instance ) {
 
		$instance = $old_instance; 
 
		$instance['title'] 				= strip_tags( $new_instance['title'] ); 
 		$instance['username']			= strip_tags( $new_instance['username'] );
 		$instance['tweet_number']		= strip_tags( $new_instance['tweet_number'] );
 		$instance['consumer_key']		= strip_tags( $new_instance['consumer_key'] );
 		$instance['consumer_secret']	= strip_tags( $new_instance['consumer_secret'] );
 		$instance['user_token']			= strip_tags( $new_instance['user_token'] );
 		$instance['user_secret']		= strip_tags( $new_instance['user_secret'] );
 		$instance['cache_time']			= absint( $new_instance['cache_time'] );
 	
	    return $instance;
	}
	
	function widget( $args, $instance ) {
	
		extract( $args );
		
		$title 				= 	$instance['title'];
 		$username 			= 	$instance['username'];
 		$tweet_number 		= 	$instance['tweet_number'];
 		$consumer_key 		= 	$instance['consumer_key'];
 		$consumer_secret 	= 	$instance['consumer_secret'];
 		$user_token 		= 	$instance['user_token'];
 		$user_secret 		= 	$instance['user_secret'];
 		$cache_time 		= 	$instance['cache_time'];
 			
		echo $before_widget;
 
		if ( !empty( $title ) )
			echo $before_title . apply_filters( 'widget_title', $title ) . $after_title;			
		
		
		$transient_name = 'swt_twitter_cache_' . strtolower( $username );
		
		/* Create unique variable from all widget options to check if there were changes, and if there were changes, delete transient */
		$all_options_var = $tweet_number.$consumer_key.$consumer_secret.$user_token.$user_secret.$cache_time;
		$checker = $transient_name.'-checker';
		
		if ( false === get_option( $checker ) ) {
			update_option( $checker, $all_options_var );			
		} 
		else {			
			$checker_value = get_option( $checker ); 
			
			if ( $checker_value !== $all_options_var ) {  
				update_option( $checker, $all_options_var );
				delete_transient( $transient_name ); 
			} 
		}
		
			
		$twitter_cache = get_transient( $transient_name );
			
		if ( !$twitter_cache ) {	
			
			require_once( trailingslashit( get_template_directory() ) . 'inc/twitter/tmhOAuth.php' );

			$tmhOAuth = new tmhOAuth( array(
					'consumer_key' => $consumer_key, 
					'consumer_secret' => $consumer_secret, 
					'user_token' => $user_token, 
					'user_secret' => $user_secret 
			));

			$twitter_data = $tmhOAuth->request( 'GET', $tmhOAuth->url('1.1/statuses/user_timeline'), array(
					'screen_name' => $username,
					'count' => $tweet_number,
					'include_rts' => true,
					'include_entities' => true
			));

			$data  = $tmhOAuth->response['response'];
			$twitter_array = json_decode( $data, true );	
			
			set_transient( $transient_name, $twitter_array, $cache_time * 60 ); 
			$twitter_cache = get_transient( $transient_name );
		}
		 
		$twitter = '';
		

		if ( $twitter_cache ):
			
			$twitter .= '<ul>';
			
			foreach ( $twitter_cache as $tweet ) {
			
				$tweet_time        = $tweet['created_at'];
				$tweet_text        = $tweet['text'];
				$tweet_permalink   = $tweet['id_str'];
	 
				#Time difference
				$timeDiff = human_time_diff( strtotime( $tweet_time ) );

				# Turn URLs into links
				$tweet_text = preg_replace('@(https?://([-\w\.]+)+(:\d+)?(/([\w/_\./-]*(\?\S+)?)?)?)@', '<a target="blank" title="$1" href="$1">$1</a>', $tweet_text);

				#Turn hashtags into links
				$tweet_text = preg_replace('/#([0-9a-zA-Z_-]+)/', "<a target='blank' title='$1' href=\"http://twitter.com/search?q=%23$1\">#$1</a>",  $tweet_text);

				#Turn @replies into links
				$tweet_text = preg_replace("/@([0-9a-zA-Z_-]+)/", "<a target='blank' title='$1' href=\"http://twitter.com/$1\">@$1</a>",  $tweet_text);


				$twitter .= "<li class='fa fa-twitter'><span class='tweet-text'>" . $tweet_text . "</span>";

				$twitter .= '<span class="tweet-details"><a rel="nofollow" target="_blank" class="time" href="https://twitter.com/'. $username . '/status/'. $tweet_permalink . '">';
				
				$twitter .= __( 'about', 'swt' ) .' '. $timeDiff . ' '. __( 'ago', 'swt' );

				$twitter .= "</a></span></li>"; //end of List

			} //end of foreach

			//store the tweets in options string
			update_option( $transient_name, $twitter );

		endif;
		
		echo stripcslashes( get_option( $transient_name ) );		
		
		$twitter .= '</ul>';

		echo $after_widget;		
	}

}

?>