<?php

class recent_posts_images extends WP_Widget {

	function __construct() {
		
		$widget_options = array( 'classname' => 'recent_posts_images', 'description' => __( 'Displays recent posts images.', 'swt' ) );
		
		parent::WP_Widget( 'recent_posts_images', __( 'SWT - Recent Posts Images', 'swt' ), $widget_options );
				
	}
		
	function form( $instance ) {
 	
		/* Defaults */
		$defaults = array( 
					'title' 		=> '',  
					'posts_type'    => 'recent', // recent or most popular (commented)
					'posts_number' 	=> 3, 
					);
		
		/* Merge $defaults with saved options */
		$instance = wp_parse_args( (array) $instance, $defaults );
		
		$title 			= 	$instance['title'];
 		$posts_type 	= 	$instance['posts_type'];
 		$posts_number 	= 	$instance['posts_number'];
 
 		?>
				 			 								
		<p>
			<label for="<?php echo $this->get_field_id( 'title' ); ?>"><?php _e( 'Title:', 'swt' ); ?></label>
			<input type="text" class="widefat" id="<?php echo $this->get_field_id( 'title' ); ?>" name="<?php echo $this->get_field_name( 'title' ); ?>" value="<?php echo esc_attr( $title ); ?>" />
		</p>			
		
		<p>
			<input type="radio" id="<?php echo $this->get_field_id( 'radio1' ); ?>" name="<?php echo $this->get_field_name( 'posts_type' ); ?>" value="<?php echo esc_attr( 'recent' ); ?>" <?php checked( $posts_type, 'recent' ); ?> />
			<label for="<?php echo $this->get_field_id( 'radio1' ); ?>"><?php _e( 'Recent', 'swt' ); ?></label>
			
			<br />
			
			<input type="radio" id="<?php echo $this->get_field_id( 'radio2' ); ?>" name="<?php echo $this->get_field_name( 'posts_type' ); ?>" value="<?php echo esc_attr( 'comment_count' ); ?>" <?php checked( $posts_type, 'comment_count' ); ?> />
			<label for="<?php echo $this->get_field_id( 'radio2' ); ?>"><?php _e( 'Popular', 'swt' ); ?></label>
 					
		</p>			
		
		<p>
			<label for="<?php echo $this->get_field_id( 'posts_number' ); ?>"><?php _e( 'Number of posts:', 'swt' ); ?></label>
			<input type="text" class="widefat" id="<?php echo $this->get_field_id( 'posts_number' ); ?>" name="<?php echo $this->get_field_name( 'posts_number' ); ?>" value="<?php echo esc_attr( $posts_number ); ?>" />
		</p>
		
		<?php
		
	}
	
	function update( $new_instance, $old_instance ) {
 
		$instance = $old_instance; 
				
		$instance['title'] = strip_tags( $new_instance['title'] );
 			
 		$instance['posts_type'] = strip_tags( $new_instance['posts_type'] );
				
		$instance['posts_number'] = ( empty( $new_instance['posts_number'] ) ? 1 : $new_instance['posts_number'] );

		
	    return $instance;
	}
	
	function widget( $args, $instance ) {
	
		extract( $args );
		
		$title 			= 	$instance['title'];
 		$posts_type 	= 	$instance['posts_type'];
 		$posts_number 	= 	$instance['posts_number'];
 		
		echo $before_widget;
		
		?>
		
 		
		<?php
		
		if ( !empty( $title ) )
 			echo $title = $before_title . apply_filters( 'widget_title', $title ) . $after_title;
 
		if ( $posts_type == 'recent' ) {		
			$orderby = ''; 
		}
		else {
			$orderby = 'comment_count';
		}
		
		$query_args = array(
			'posts_per_page'        => $posts_number,
			'orderby'             	=> $orderby,
			'ignore_sticky_posts'   => false 
		);	
		
		$counter = 1; 
		
		$query = new WP_Query( $query_args );
		
		echo '<ul>';
		
			while ( $query->have_posts() ) : $query->the_post(); 
			
				if ( $counter % 3 == 0 )
					$li = '<li class="no-margin">';
				else
					$li = '<li>';
					
				if ( has_post_thumbnail() ) {
					
					get_the_image( array( 	'size' => 'thumbnail', 
											'order' => array( 'featured', 'attachment' ), 
											'before' => $li, 
											'after' => '</li>' 
										) 
								); 
			
					$counter++;
				}
			
			endwhile; 
			
		wp_reset_query();

		echo '</ul>';
		
		echo $after_widget;
		
	}
	

}

?>