<article <?php hybrid_attr( 'post' ); ?>>

	<?php if ( is_singular( get_post_type() ) ) : // If viewing a single post. ?>

		<header class="entry-header">

			<h1 <?php hybrid_attr( 'entry-title' ); ?>><?php single_post_title(); ?></h1>

			<div class="entry-byline">	
				<span <?php hybrid_attr( 'entry-author' ); ?>><?php _e( 'by ', 'swt' ); the_author_posts_link(); ?></span>				
				<time <?php hybrid_attr( 'entry-published' ); ?>>
					<?php the_time( 'l, jS F, Y' ); ?>
				</time>									
			</div><!-- .entry-byline -->

		</header><!-- .entry-header -->

		<div <?php hybrid_attr( 'entry-content' ); ?>>
			<?php the_content(); ?>
			<?php wp_link_pages(); ?>
		</div><!-- .entry-content -->

		<footer class="entry-footer">
			<?php hybrid_post_terms( array( 'taxonomy' => 'post_tag', 'text' => __( 'Tagged: %s', 'swt' ), 'before' => '<br />' ) ); ?>
		</footer><!-- .entry-footer -->

	<?php else : // If not viewing a single post. ?>

		<header class="entry-header">			
		
			<?php hybrid_post_terms( array( 'taxonomy' => 'category' ) ); ?>						
		
			<?php the_title( '<h2 ' . hybrid_get_attr( 'entry-title' ) . '><a href="' . get_permalink() . '" rel="bookmark" itemprop="url">', '</a></h2>' ); ?>

			<div class="entry-byline">	
				<span <?php hybrid_attr( 'entry-author' ); ?>><?php _e( 'by ', 'swt' ); the_author_posts_link(); ?></span>				
				<time <?php hybrid_attr( 'entry-published' ); ?>>
					<?php the_time( 'l, jS F, Y' ); ?>
				</time>									
			</div><!-- .entry-byline -->

		</header><!-- .entry-header -->

		<?php get_the_image( array( 'size' => 'swt-full', 'image_class' => 'featured-image', 'order' => array( 'featured', 'attachment' ) ) ); ?>		
		
		<div <?php hybrid_attr( 'entry-summary' ); ?>>
			<?php the_excerpt(); ?>
		</div><!-- .entry-summary -->
		
		<footer class="entry-footer">
			<a class="more-link" href="<?php the_permalink(); ?>"><?php _e( 'Read More', 'swt' ); ?> <span>>></span></a>
		</footer>
		
	<?php endif; // End single post check. ?>

</article><!-- .entry -->