<?php 
function swt_mailchimp_widget() {
	$swt_mailchimp = of_get_option( 'swt_mailchimp', 0 );

	if ( !$swt_mailchimp )
		return;
	else {

	$mailchimp_api_key = of_get_option( 'mailchimp_api_key' ); 
	$mailchimp_list_id = of_get_option( 'mailchimp_list_id' ); 
	?>

	<div class="wrap" id="mailchimp-wrap">
	
		<div class="mailchimp-inner">
		
			<a href="#container" id="scroll-to-top" class="fa fa-arrow-circle-o-up"></a>
	
			<form id="signup" action="<?php echo esc_url( $_SERVER['PHP_SELF'] ); ?>" method="get">
				
				<span class="newsletter-text"><?php echo of_get_option( 'mailchimp_text' ); ?></span>
				<input type="text" name="email" id="email"  class="newsletter-email" value="<?php esc_attr_e( 'your email address...', 'swt' ); ?>" onfocus="if(this.value==this.defaultValue)this.value='';" onblur="if(this.value=='')this.value=this.defaultValue;"" />
				<input type="hidden" name="_mailchimp_key" id="_mailchimp_key" value="<?php echo $mailchimp_api_key ?>" />
				<input type="hidden" name="_mailchimp_list" id="_mailchimp_list" value="<?php echo $mailchimp_list_id ?>" />
				<input type="submit" name="submit" value="<?php _e( 'Submit', 'swt' ); ?>" class="newsletter-submit" />
				
				<input type="text" style="display: none" value="<?php echo get_template_directory_uri() . '/inc/mailchimp/store-address.php' ?>" name="hidden_path" class="hidden_path" />

				<label for="email" id="address-label">
					<span id="response">
						<?php require_once('mailchimp/store-address.php');
						if ( isset( $_GET['submit'] ) ) {
							echo storeAddress();
						} ?>
					</span>
				</label>                            
			</form>
		
		</div>
		
	</div>
<?php 
	}
} ?>