<?php

class swt_social_links extends WP_Widget {

	function __construct() {
		
		$widget_options = array( 'classname' => 'swt_social_links', 'description' => __( 'Displays your social profiles.', 'swt' ) );
		
		parent::WP_Widget( 'swt_social_links', __( 'SWT - Social Profiles', 'swt' ), $widget_options );
				
	}
		
	function form( $instance ) {
 
		/* Defaults */
		$defaults = array( 
			'title' => '', 
			'codepen' => '', 
			'digg' => '', 
			'dribbble' => '', 
			'dropbox' => '', 
			'facebook' => '',
			'flickr' => '',			
			'google' => '',			
			'github' => '',			
			'instagram' => '',			
			'linkedin' => '',			
			'pinterest' => '',			
			'reddit' => '',			
			'skype' => '',			
			'stumbleupon' => '',			
			'tumblr' => '',			
			'twitter' => '',			
			'vimeo' => '',			
			'wordpress' => '',			
			'youtube' => ''
		);
		
		/* Merge $defaults with saved options */
		$instance = wp_parse_args( (array) $instance, $defaults );
		
		$title 					= 	$instance['title'];
		$codepen 				= 	$instance['codepen'];
		$digg 					= 	$instance['digg'];
		$dribbble 				= 	$instance['dribbble'];
		$dropbox 				= 	$instance['dropbox'];
		$facebook 				= 	$instance['facebook'];
		$flickr 				= 	$instance['flickr'];
		$google 				= 	$instance['google'];
		$github 				= 	$instance['github'];
		$instagram 				= 	$instance['instagram'];
		$linkedin 				= 	$instance['linkedin'];
		$pinterest 				= 	$instance['pinterest'];
		$reddit 				= 	$instance['reddit'];
		$skype 					= 	$instance['skype'];
		$stumbleupon 			= 	$instance['stumbleupon'];
		$tumblr 				= 	$instance['tumblr'];
		$twitter 				= 	$instance['twitter'];
		$vimeo 					= 	$instance['vimeo'];
		$wordpress 				= 	$instance['wordpress'];
		$youtube 				= 	$instance['youtube'];
 		
  
 		?>
 	
		<p>
			<label for="<?php echo $this->get_field_id( 'title' ); ?>"><?php _e( 'Title:', 'swt' ); ?></label>
			<input type="text" class="widefat" id="<?php echo $this->get_field_id( 'title' ); ?>" name="<?php echo $this->get_field_name( 'title' ); ?>" value="<?php echo esc_attr( $title ); ?>" />
		</p>	

		<p>
			<label for="<?php echo $this->get_field_id( 'codepen' ); ?>"><?php _e( 'Codepen:', 'swt' ); ?></label>
			<input type="text" class="widefat" id="<?php echo $this->get_field_id( 'codepen' ); ?>" name="<?php echo $this->get_field_name( 'codepen' ); ?>" value="<?php echo esc_attr( $codepen ); ?>" />
		</p>		

		<p>
			<label for="<?php echo $this->get_field_id( 'digg' ); ?>"><?php _e( 'Digg:', 'swt' ); ?></label>
			<input type="text" class="widefat" id="<?php echo $this->get_field_id( 'digg' ); ?>" name="<?php echo $this->get_field_name( 'digg' ); ?>" value="<?php echo esc_attr( $digg ); ?>" />
		</p>	

		<p>
			<label for="<?php echo $this->get_field_id( 'dribbble' ); ?>"><?php _e( 'Dribbble:', 'swt' ); ?></label>
			<input type="text" class="widefat" id="<?php echo $this->get_field_id( 'dribbble' ); ?>" name="<?php echo $this->get_field_name( 'dribbble' ); ?>" value="<?php echo esc_attr( $dribbble ); ?>" />
		</p>			
 	 
		<p>
			<label for="<?php echo $this->get_field_id( 'dropbox' ); ?>"><?php _e( 'Dropbox:', 'swt' ); ?></label>
			<input type="text" class="widefat" id="<?php echo $this->get_field_id( 'dropbox' ); ?>" name="<?php echo $this->get_field_name( 'dropbox' ); ?>" value="<?php echo esc_attr( $dropbox ); ?>" />
		</p>	

		<p>
			<label for="<?php echo $this->get_field_id( 'facebook' ); ?>"><?php _e( 'Facebook:', 'swt' ); ?></label>
			<input type="text" class="widefat" id="<?php echo $this->get_field_id( 'facebook' ); ?>" name="<?php echo $this->get_field_name( 'facebook' ); ?>" value="<?php echo esc_attr( $facebook ); ?>" />
		</p>	
		
		<p>
			<label for="<?php echo $this->get_field_id( 'flickr' ); ?>"><?php _e( 'Flickr:', 'swt' ); ?></label>
			<input type="text" class="widefat" id="<?php echo $this->get_field_id( 'flickr' ); ?>" name="<?php echo $this->get_field_name( 'flickr' ); ?>" value="<?php echo esc_attr( $flickr ); ?>" />
		</p>	

		<p>
			<label for="<?php echo $this->get_field_id( 'google' ); ?>"><?php _e( 'Google:', 'swt' ); ?></label>
			<input type="text" class="widefat" id="<?php echo $this->get_field_id( 'google' ); ?>" name="<?php echo $this->get_field_name( 'google' ); ?>" value="<?php echo esc_attr( $google ); ?>" />
		</p>	
		
		<p>
			<label for="<?php echo $this->get_field_id( 'github' ); ?>"><?php _e( 'Github:', 'swt' ); ?></label>
			<input type="text" class="widefat" id="<?php echo $this->get_field_id( 'github' ); ?>" name="<?php echo $this->get_field_name( 'github' ); ?>" value="<?php echo esc_attr( $github ); ?>" />
		</p>	
		
		<p>
			<label for="<?php echo $this->get_field_id( 'instagram' ); ?>"><?php _e( 'Instagram:', 'swt' ); ?></label>
			<input type="text" class="widefat" id="<?php echo $this->get_field_id( 'instagram' ); ?>" name="<?php echo $this->get_field_name( 'instagram' ); ?>" value="<?php echo esc_attr( $instagram ); ?>" />
		</p>	

		<p>
			<label for="<?php echo $this->get_field_id( 'linkedin' ); ?>"><?php _e( 'Linkedin:', 'swt' ); ?></label>
			<input type="text" class="widefat" id="<?php echo $this->get_field_id( 'linkedin' ); ?>" name="<?php echo $this->get_field_name( 'linkedin' ); ?>" value="<?php echo esc_attr( $linkedin ); ?>" />
		</p>	
		
		<p>
			<label for="<?php echo $this->get_field_id( 'pinterest' ); ?>"><?php _e( 'Pinterest:', 'swt' ); ?></label>
			<input type="text" class="widefat" id="<?php echo $this->get_field_id( 'pinterest' ); ?>" name="<?php echo $this->get_field_name( 'pinterest' ); ?>" value="<?php echo esc_attr( $pinterest ); ?>" />
		</p>	

		<p>
			<label for="<?php echo $this->get_field_id( 'reddit' ); ?>"><?php _e( 'Reddit:', 'swt' ); ?></label>
			<input type="text" class="widefat" id="<?php echo $this->get_field_id( 'reddit' ); ?>" name="<?php echo $this->get_field_name( 'reddit' ); ?>" value="<?php echo esc_attr( $reddit ); ?>" />
		</p>	
		
		<p>
			<label for="<?php echo $this->get_field_id( 'skype' ); ?>"><?php _e( 'Skype:', 'swt' ); ?></label>
			<input type="text" class="widefat" id="<?php echo $this->get_field_id( 'skype' ); ?>" name="<?php echo $this->get_field_name( 'skype' ); ?>" value="<?php echo esc_attr( $skype ); ?>" />
		</p>	
		
		<p>
			<label for="<?php echo $this->get_field_id( 'stumbleupon' ); ?>"><?php _e( 'Stumbleupon:', 'swt' ); ?></label>
			<input type="text" class="widefat" id="<?php echo $this->get_field_id( 'stumbleupon' ); ?>" name="<?php echo $this->get_field_name( 'stumbleupon' ); ?>" value="<?php echo esc_attr( $stumbleupon ); ?>" />
		</p>	

		<p>
			<label for="<?php echo $this->get_field_id( 'tumblr' ); ?>"><?php _e( 'Tumblr:', 'swt' ); ?></label>
			<input type="text" class="widefat" id="<?php echo $this->get_field_id( 'tumblr' ); ?>" name="<?php echo $this->get_field_name( 'tumblr' ); ?>" value="<?php echo esc_attr( $tumblr ); ?>" />
		</p>	

		<p>
			<label for="<?php echo $this->get_field_id( 'twitter' ); ?>"><?php _e( 'Twitter:', 'swt' ); ?></label>
			<input type="text" class="widefat" id="<?php echo $this->get_field_id( 'twitter' ); ?>" name="<?php echo $this->get_field_name( 'twitter' ); ?>" value="<?php echo esc_attr( $twitter ); ?>" />
		</p>	
		
		<p>
			<label for="<?php echo $this->get_field_id( 'vimeo' ); ?>"><?php _e( 'Vimeo:', 'swt' ); ?></label>
			<input type="text" class="widefat" id="<?php echo $this->get_field_id( 'vimeo' ); ?>" name="<?php echo $this->get_field_name( 'vimeo' ); ?>" value="<?php echo esc_attr( $vimeo ); ?>" />
		</p>	
		
 		<p>
			<label for="<?php echo $this->get_field_id( 'wordpress' ); ?>"><?php _e( 'Wordpress:', 'swt' ); ?></label>
			<input type="text" class="widefat" id="<?php echo $this->get_field_id( 'wordpress' ); ?>" name="<?php echo $this->get_field_name( 'wordpress' ); ?>" value="<?php echo esc_attr( $wordpress ); ?>" />
		</p>	

		<p>
			<label for="<?php echo $this->get_field_id( 'youtube' ); ?>"><?php _e( 'Youtube:', 'swt' ); ?></label>
			<input type="text" class="widefat" id="<?php echo $this->get_field_id( 'youtube' ); ?>" name="<?php echo $this->get_field_name( 'youtube' ); ?>" value="<?php echo esc_attr( $youtube ); ?>" />
		</p>	
		
	 
		<?php
		
	}
	
	function update( $new_instance, $old_instance ) {
 
		$instance = $old_instance; 
 
		$instance['title'] 					= strip_tags( $new_instance['title'] );
		$instance['codepen'] 				= strip_tags( $new_instance['codepen'] );
		$instance['digg']					= strip_tags( $new_instance['digg'] );
		$instance['dribbble'] 				= strip_tags( $new_instance['dribbble'] );
		$instance['dropbox'] 				= strip_tags( $new_instance['dropbox'] );
		$instance['facebook'] 				= strip_tags( $new_instance['facebook'] );
		$instance['flickr'] 				= strip_tags( $new_instance['flickr'] );
		$instance['google'] 				= strip_tags( $new_instance['google'] );
		$instance['github'] 				= strip_tags( $new_instance['github'] );
		$instance['instagram'] 				= strip_tags( $new_instance['instagram'] );
		$instance['linkedin'] 				= strip_tags( $new_instance['linkedin'] );
		$instance['pinterest'] 				= strip_tags( $new_instance['pinterest'] );
		$instance['reddit'] 				= strip_tags( $new_instance['reddit'] );
		$instance['skype'] 					= strip_tags( $new_instance['skype'] );
		$instance['stumbleupon'] 			= strip_tags( $new_instance['stumbleupon'] );
		$instance['tumblr'] 				= strip_tags( $new_instance['tumblr'] );
		$instance['twitter'] 				= strip_tags( $new_instance['twitter'] );
		$instance['vimeo'] 					= strip_tags( $new_instance['vimeo'] );
		$instance['wordpress'] 				= strip_tags( $new_instance['wordpress'] );
		$instance['youtube'] 				= strip_tags( $new_instance['youtube'] );
 		
 	
	    return $instance;
	}
	
	function widget( $args, $instance ) {
	
		extract( $args );
		
		$title 					= 	$instance['title'];
		
		$codepen 				= 	$instance['codepen'];
		$digg 					= 	$instance['digg'];
		$dribbble 				= 	$instance['dribbble'];
		$dropbox 				= 	$instance['dropbox'];
		$facebook 				= 	$instance['facebook'];
		$flickr 				= 	$instance['flickr'];
		$google 				= 	$instance['google'];
		$github 				= 	$instance['github'];
		$instagram 				= 	$instance['instagram'];
		$linkedin 				= 	$instance['linkedin'];
		$pinterest 				= 	$instance['pinterest'];
		$reddit 				= 	$instance['reddit'];
		$skype 					= 	$instance['skype'];
		$stumbleupon 			= 	$instance['stumbleupon'];
		$tumblr 				= 	$instance['tumblr'];
		$twitter 				= 	$instance['twitter'];
		$vimeo 					= 	$instance['vimeo'];
		$wordpress 				= 	$instance['wordpress'];
		$youtube 				= 	$instance['youtube'];
 		
 			
		echo $before_widget;
 
		if ( !empty( $title ) )
			echo $before_title . apply_filters( 'widget_title', $title ) . $after_title;			
		
		
		$output = '<ul id="swt-social-profiles">';
		
		if ( ! empty( $codepen ) )
			$output .= '<li><a href="'.$codepen.'">'. __( 'Codepen', 'swt' ) .'</a>';	

		if ( ! empty( $digg ) )
			$output .= '<li><a href="'.$digg.'">'. __( 'Digg', 'swt' ) .'</a>';	

		if ( ! empty( $dribbble ) )
			$output .= '<li><a href="'.$dribbble.'">'. __( 'Dribbble', 'swt' ) .'</a>';	

		if ( ! empty( $dropbox ) )
			$output .= '<li><a href="'.$dropbox.'">'. __( 'Dropbox', 'swt' ) .'</a>';	

		if ( ! empty( $facebook ) )
			$output .= '<li><a href="'.$facebook.'">'. __( 'Facebook', 'swt' ) .'</a>';	

		if ( ! empty( $flickr ) )
			$output .= '<li><a href="'.$flickr.'">'. __( 'Flickr', 'swt' ) .'</a>';	

		if ( ! empty( $google ) )
			$output .= '<li><a href="'.$google.'">'. __( 'Google', 'swt' ) .'</a>';	

		if ( ! empty( $github ) )
			$output .= '<li><a href="'.$github.'">'. __( 'Github', 'swt' ) .'</a>';	
			
		if ( ! empty( $instagram ) )
			$output .= '<li><a href="'.$instagram.'">'. __( 'Instagram', 'swt' ) .'</a>';	

		if ( ! empty( $linkedin ) )
			$output .= '<li><a href="'.$linkedin.'">'. __( 'Linkedin', 'swt' ) .'</a>';	

		if ( ! empty( $pinterest ) )
			$output .= '<li><a href="'.$pinterest.'">'. __( 'Pinterest', 'swt' ) .'</a>';	

		if ( ! empty( $reddit ) )
			$output .= '<li><a href="'.$reddit.'">'. __( 'Reddit', 'swt' ) .'</a>';	

		if ( ! empty( $skype ) )
			$output .= '<li><a href="'.$skype.'">'. __( 'Skype', 'swt' ) .'</a>';	

		if ( ! empty( $stumbleupon ) )
			$output .= '<li><a href="'.$stumbleupon.'">'. __( 'Stumbleupon', 'swt' ) .'</a>';	

		if ( ! empty( $tumblr ) )
			$output .= '<li><a href="'.$tumblr.'">'. __( 'Tumblr', 'swt' ) .'</a>';	

		if ( ! empty( $twitter ) )
			$output .= '<li><a href="'.$twitter.'">'. __( 'Twitter', 'swt' ) .'</a>';		

		if ( ! empty( $vimeo ) )
			$output .= '<li><a href="'.$vimeo.'">'. __( 'Vimeo', 'swt' ) .'</a>';	

		if ( ! empty( $wordpress ) )
			$output .= '<li><a href="'.$wordpress.'">'. __( 'Wordpress', 'swt' ) .'</a>';	

		if ( ! empty( $youtube ) )
			$output .= '<li><a href="'.$youtube.'">'. __( 'Youtube', 'swt' ) .'</a>';					
 
		$output .= '</ul>';

		echo $output; 
		
		
		echo $after_widget;		
	}

}

?>