<?php
	
/* Get the sticky posts. */
$sticky = get_option( 'sticky_posts' );

$swt_featured_posts = of_get_option( 'swt_featured_posts', 0 ); 

if (  $swt_featured_posts == 1 && ! empty( $sticky ) && ( is_home() || is_front_page() ) ) :

	/* Grab all sticky posts */
	$args = array( 'post__in' => $sticky );
	
	$swt_fp = new WP_Query( $args );
	
	if ( $swt_fp->have_posts() ) : ?>

		<section id="swt-featured-posts">
			
			<ul>
			
				<?php $count = 1; while ( $swt_fp->have_posts() ) : $swt_fp->the_post(); ?>	

				<li class="featured-post<?php if ( $count % 3 == 0 ) echo ' third-fp'; ?>">
				
					<article>
						
						<h3 class="featured-post-title"><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h3>
						
						<?php if ( current_theme_supports( 'get-the-image' ) ) { 
							get_the_image( array( 'default_image' => trailingslashit( get_template_directory_uri() ) . 'images/slider-default.gif',
												  'size' => 'swt-featured-image', 
												  'image_class' => 'swt-featured-image'
												  ) ); } ?>
 
						<div class="featured-byline">
							<span <?php hybrid_attr( 'entry-author' ); ?>><?php _e( 'by ', 'swt' ); the_author_posts_link(); ?></span>				
							<time <?php hybrid_attr( 'entry-published' ); ?>>
								<?php the_time( 'd.m.Y' ); ?>
							</time>							
						</div><!--.featured-byline-->
							
					</article> <!-- .slide -->
					
				</li>
				
				<?php $count++; endwhile; ?>
				
				<?php wp_reset_postdata(); // Restores the $post global to the current post in the main query.  ?>
				    			
			</ul>
			
		</section><!-- #slider -->

	<?php endif; ?>
		
<?php endif; ?>