<?php

class SWTTabber extends WP_Widget {

	function __construct() {

		$widget_options = array( 'classname' => 'swt_tabber', 'description' => __( 'Displays recent comments, recent posts and tags', 'swt' ) );
		
		parent::WP_Widget( 'SWTTabber', __( 'SWT - Tabber Widget', 'swt' ), $widget_options );		
		
	}
	
	function form( $instance ) {
	
		/* Set defaults */
		$defaults = array(
			'comments_number' => 2,
			'posts_number' => 2,
			'tags_number' => 10						
		);
		
		$instance = wp_parse_args( (array) $instance, $defaults );
		
		?>
		
		<p>
			<label for="<?php echo $this->get_field_id( 'comments_number' ); ?>"><?php _e( 'Number of comments to show:', 'swt' ); ?></label>
			<input type="text" class="smallfat" id="<?php echo $this->get_field_id( 'comments_number' ); ?>" name="<?php echo $this->get_field_name( 'comments_number' ); ?>" value="<?php echo esc_attr( $instance['comments_number'] ); ?>" />
		</p>
		
		<p>
			<label for="<?php echo $this->get_field_id( 'posts_number' ); ?>"><?php _e( 'Number of popular posts to show:', 'swt' ); ?></label>
			<input type="text" class="smallfat" id="<?php echo $this->get_field_id( 'posts_number' ); ?>" name="<?php echo $this->get_field_name( 'posts_number' ); ?>" value="<?php echo esc_attr( $instance['posts_number'] ); ?>" />
		</p>		
		
		<p>
			<label for="<?php echo $this->get_field_id( 'tags_number' ); ?>"><?php _e( 'Number of tags to show:', 'swt' ); ?></label>
			<input type="text" class="smallfat" id="<?php echo $this->get_field_id( 'tags_number' ); ?>" name="<?php echo $this->get_field_name( 'tags_number' ); ?>" value="<?php echo esc_attr( $instance['tags_number'] ); ?>" />
		</p>		
		
		<?php 
		
	}
	
	function update( $new_instance, $old_instance ) {
		
		$instance = $old_instance; 
 
		$instance['comments_number'] 	= 	empty( $new_instance['comments_number'] ) ? 1 : absint( $new_instance['comments_number'] );
		$instance['posts_number'] 		= 	empty( $new_instance['posts_number'] ) ? 1 : absint( $new_instance['posts_number'] );
		$instance['tags_number'] 		= 	empty( $new_instance['tags_number'] ) ? 1 : absint( $new_instance['tags_number'] );
		
		
		return $instance;
		
	}
	
	function widget( $args, $instance ) { 
		 
		extract( $args, EXTR_SKIP );
 
		$comments_number = $instance['comments_number'];
		$posts_number = $instance['posts_number'];
		$tags_number = $instance['tags_number'];
		
		echo $before_widget; ?>

		<ul class="tabs">
			<li class="active"><a href="#tab1"><?php _e( 'Recent Comments', 'swt'); ?></a></li>
			<li><a href="#tab2"><?php _e( 'Popular Posts', 'swt' ); ?></a></li>
			<li><a href="#tab3"><?php _e( 'Tags', 'swt' ); ?></a></li>
		</ul>

		<div class="tab_container">

			<div id="tab1" class="tab_content">			
				<?php swt_recent_comments( $comments_number ); ?>
			</div>

			<div id="tab2" class="tab_content">
				<?php swt_recent_posts( $posts_number ); ?>
			</div>

			<div id="tab3" class="tab_content">
				<p class="post_tag-cloud"><?php wp_tag_cloud("number={$tags_number}"); ?></p>
			</div>

		</div>
 
		<?php

		echo $after_widget; 
		
	}
	
}


function swt_recent_posts( $posts_number ) {

	$args = array(
		'posts_per_page' 		=> $posts_number,
		'ignore_sticky_posts' 	=> true,
		'orderby' 				=> 'comment_count'
	);
	
	$query = new WP_Query( $args );
	
	$counter = 1; 
	
	if ( $query->have_posts() ) : 
		
		while( $query->have_posts() ) : $query->the_post(); ?>
			
			<div class="swt-recent-holder">
								
				<span class="swt-recent-holder-num"><?php echo $counter++; ?>.</span>
				
				<?php if ( has_post_thumbnail() ) { ?>
				
					<div class="swt-recent-holder-img">
						<a href="<?php the_permalink(); ?>" title="<?php the_title_attribute(); ?>">
							<?php the_post_thumbnail(); ?>
						</a>
					</div>
					
				<?php } ?>
				
				<div class="swt-recent-holder-content">
					<h4 class="swt-recent-holder-title">
						<a href="<?php the_permalink(); ?>"><?php the_title(); ?></a>
					</h4>		
					
					<p>
						<?php echo substr( get_the_excerpt(), 0, 90 ); ?>...
						<a class="more-link" href="<?php the_permalink(); ?>"><?php _e( 'read more', 'swt' ); ?></a>
					</p>
				</div>
				
			</div>
			
		<?php endwhile; ?>
		
		<?php wp_reset_postdata(); ?>
		
	<?php endif; ?>
 
<?php }

function swt_recent_comments( $comments_number ) {
	
	$args = array( 'number' => $comments_number, 'status' => 'approve', 'post_status' => 'publish', 'type' => 'comment' );
	
	$comments = get_comments( $args );
	
	if ( $comments ) {
	
		$comment_counter = 1; 
		
		foreach( $comments as $comm ) { ?>		
			
			<?php global $comment; ?>
			
			<div class="swt-recent-holder">
			
				<span class="swt-recent-holder-num">
					<?php echo $comment_counter++; ?>
				</span>
							
				<div class="swt-recent-holder-img"> 
					<?php echo get_avatar( $comm->comment_author_email ); ?>
				</div>
						
				<div class="swt-recent-holder-content">
					<a href="<?php echo $comm->comment_author_url; ?>"><?php echo $comm->comment_author .' '. __( 'said', 'swt' ); ?></a>
					<?php echo human_time_diff( get_comment_date( 'U', $comm->comment_ID ), current_time( 'timestamp' ) ) .' '. __( 'ago:', 'swt' ); ?>
					<?php echo mb_substr( strip_tags( $comm->comment_content ), 0, 90 ); ?>...					
					<a href="<?php echo esc_url( get_comment_link( $comm->comment_ID ) ); ?>"><?php _e( 'read more', 'swt' ); ?></a>
				</div>
			
			</div>
		
		<?php }
	}
}
	 
?>