jQuery(document).ready(function() {
		
	/*==== RESPONSIVE PRIMARY MENU SETUP ====*/
	if ( jQuery( '#menu-primary-items' ).length ) {
		var nav = responsiveNav("#menu-primary-items", { 
			animate: true, 
			transition: 300, 
			insert: "before", 
			customToggle: "#toggle-primary-menu", 
			closeOnNavClick: false, 
			openPos: "relative", 
			navClass: "nav-collapse", 
			navActiveClass: "js-nav-active", 
			jsClass: "js" 
		}); 
	}
 
	/*==== RESPONSIVE SECONDARY MENU SETUP ====*/
	if ( jQuery( '#menu-secondary-items' ).length ) {	
		var nav = responsiveNav("#menu-secondary-items", { 
			animate: true, 
			transition: 300,
			insert: "before", 
			customToggle: "#toggle-secondary-menu", 
			closeOnNavClick: false, 
			openPos: "relative", 
			navClass: "nav-collapse", 
			navActiveClass: "js-nav-active", 
			jsClass: "js" 
		}); 
	}	
	/* ===== FITVIDS ===== */
	jQuery("#content").fitVids();	 
 
	/* ===== SCROLL TO TOP ===== */
	jQuery(".scroll-to-top").click(function(){
			  jQuery('html, body').animate({ scrollTop: 0 }, 750 );
			  return false;
	});	
 
	/* ===== CONTENT SLIDER ===== */	
	if ( typeof Params !== "undefined" ) {
		jQuery('.bxslider').bxSlider({
			mode: Params.mode,
			auto: Params.auto,
			pause: Params.pause,
			autoHover: true,
			slideWidth: 0,
			preloadImages: 'all',
			adaptiveHeight: false,
			prevText: '<i class="fa fa-angle-left"></i>',
			nextText: '<i class="fa fa-angle-right"></i>',
			pager: false
		});						
	}
	
	/*==== TICKER SETUP ====*/	
	
	jQuery('.ticker').bxSlider({
		  ticker: true,
		  minSlides: 1,
		  maxSlides: 3,
		  slideWidth: 215,
		  slideMargin: 25,
		  speed: 20000
	});	
	
	/*==== SEARCH IN TICKER ====*/
	jQuery('#ticker .fa-search').toggle( function() {
		jQuery( this ).addClass( 'expand' );
		jQuery( '#ticker .search-text' ).show();		
	}, function(){				
		jQuery( this ).removeClass( 'expand' );
		jQuery( '#ticker .search-text' ).hide();				
	});

});