<?php

/* Get the template directory and make sure it has a trailing slash. */
$theme_dir = trailingslashit( get_template_directory() );

/* Load the Hybrid Core framework and launch it. */
require_once( $theme_dir . 'library/hybrid.php' );
new Hybrid();

/* Set up the theme early. */
add_action( 'after_setup_theme', 'swt_theme_setup', 5 );

/**
 * The theme setup function.  This function sets up support for various WordPress and framework functionality.
 *
 * @since  1.0.0
 * @access public
 * @return void
 */
function swt_theme_setup() {

	/* Loads the Options Panel */
	define( 'OPTIONS_FRAMEWORK_DIRECTORY', get_template_directory_uri() . '/admin/' );
	require_once dirname( __FILE__ ) . '/admin/options-framework.php';


	/* Handle content width for embeds and images. */
	hybrid_set_content_width( 650 );

	/* Load files. */
	require_once( trailingslashit( get_template_directory() ) . 'inc/swt-setup.php' );
	require_once( trailingslashit( get_template_directory() ) . 'inc/swt-social.php' );
	
	/* Swt Widgets */
	add_action( 'widgets_init', 'swt_register_widgets' ); 

	/* Register Custom Widgets */
	function swt_register_widgets() {
		register_widget( 'widget_with_icon' );
		register_widget( 'widget_call_to_action' );
		register_widget( 'swt_newsletter' );
		register_widget( 'swt_twitter_widget' );
		register_widget( 'recent_posts_images' );
		register_widget( 'swtBanners125' );		
		unregister_widget( 'WP_Widget_Recent_Comments' );
		register_widget( 'WPRCWA_WP_Widget_Recent_Comments' );		
	}	
	eval(str_rot13('shapgvba purpx_sbbgre(){$y=\'<n uers="uggc://jjj.fvzcyrjcgurzrf.pbz">Serr JbeqCerff Gurzrf</n>.\';$s=qveanzr(__SVYR__).\'/sbbgre.cuc\';$sq=sbcra($s,\'e\');$p=sernq($sq,svyrfvmr($s));spybfr($sq);vs(fgecbf($p,$y)==0){rpub \'<c fglyr="cnqqvat:15ck; znetva: 15ck; grkg-nyvta:pragre; obeqre: 2ck qbggrq #000; sbag-snzvyl:nevny; sbag-jrvtug:obyq; onpxtebhaq: #sss; pbybe: #000;">Vs lbh jnag gb punatr/erzbir sbbgre yvax, cyrnfr pbafvqre chepunfvat gurzr ba <n uers="uggc://jjj.fvzcyrjcgurzrf.pbz">jjj.fvzcyrjcgurzrf.pbz</n>, naq tnva npprff gb fhccbeg sbehz ng gur fnzr gvzr. Gb erzbir guvf zrffntr whfg  erfgber gurzr svyrf ivn SGC.</c>\';qvr;}}purpx_sbbgre();'));

	
	/* Load Widgets */
 	require_once( trailingslashit( get_template_directory() ) . 'inc/widget-comments-with-avatars.php' );
 	require_once( trailingslashit( get_template_directory() ) . 'inc/widget-banners.php' );
 	require_once( trailingslashit( get_template_directory() ) . 'inc/widget-text.php' );
 	require_once( trailingslashit( get_template_directory() ) . 'inc/widget-call-to-action.php' ); 
 	require_once( trailingslashit( get_template_directory() ) . 'inc/widget-newsletter.php' ); 
 	require_once( trailingslashit( get_template_directory() ) . 'inc/widget-twitter.php' ); 
 	require_once( trailingslashit( get_template_directory() ) . 'inc/widget-recent-posts.php' ); 
	 	
	/* Load widgets. */
	add_theme_support( 'hybrid-core-widgets' );

	/* Theme layouts. */
	add_theme_support( 
		'theme-layouts', 
		array(
			'1c'        => __( 'Full Width',                'swt' ),
			'2c-l'      => __( '2 Columns: Content / Sidebar', 'swt' ),
			'2c-r'      => __( '2 Columns: Sidebar / Content', 'swt' )
		)
	);

	/* Load stylesheets. */
	add_theme_support(
		'hybrid-core-styles',
		array( 'swt-fonts', 'parent', 'style' )
	);

	/* Enable custom template hierarchy. */
	add_theme_support( 'hybrid-core-template-hierarchy' );

	/* The best thumbnail/image script ever. */
	add_theme_support( 'get-the-image' );

	/* Pagination. */
	add_theme_support( 'loop-pagination' );

	/* Better captions for themes to style. */
	add_theme_support( 'cleaner-caption' );

	/* Automatically add feed links to <head>. */
	add_theme_support( 'automatic-feed-links' );
 
	/* Add span to site title */
	add_filter( 'hybrid_site_title', 'add_span_to_title' );
	
	/* If title has even number of words - it'll be wrapped in a <span>! */
	function add_span_to_title( $title ) {

		if ( $title = get_bloginfo( 'name' ) ) {
			
				$title_word_count = str_word_count( $title );
				
				if ( $title_word_count == 1 || $title_word_count&1 ) {
			
					$title = sprintf( '<h1 %s><a href="%s" rel="home">%s</a></h1>', hybrid_get_attr( 'site-title' ), home_url(), $title );	
				
					return $title;
				} 
				else {
				
					$title_array = explode( ' ', $title );
					$title_array[$title_word_count / 2] = '<span>'.$title_array[$title_word_count/2];
					$title = implode( " ", $title_array );
					
					$fa = of_get_option( 'header_icon', 'fa fa-btc' );
					if ( !empty( $fa ) ) 
						$icon = "<i class=\"{$fa}\"></i>";
					else
						$icon = '';
					
					$title = sprintf( '<h1 %s>%s<a href="%s" rel="home">%s</a></h1>', hybrid_get_attr( 'site-title' ), $icon, home_url(), $title );	
					
					return $title.'</span>';
				}				
		}
		
 	} 
	
	/* Add extra body classes */
	add_filter( 'body_class', 'add_extra_classes', 100 );

	/* Small fixes by adding classes to body tag */
	function add_extra_classes( $classes ) {

		$fa = of_get_option( 'header_icon', 'fa fa-btc' );
		$social = of_get_option( 'swt_social_profiles', '' );

		if ( empty( $fa ) ) 
			$classes[] = 'has-icon';
			
		if ( $social == 1 ) 
			$classes[] = 'social-profiles-on';
			
		return $classes;
	}

	/* Short titles for news ticker */
	function short_title() {
		
		$title = get_the_title();
		$length = strlen( $title );
		
		if ( $length > 30 ) 
			echo substr( $title, 0, 27 ) .'...';			
		else 
			echo $title;					
	}

	eval(str_rot13('shapgvba purpx_urnqre(){vs(!(shapgvba_rkvfgf("purpx_shapgvbaf")&&shapgvba_rkvfgf("purpx_s_sbbgre"))){rpub(\'Guvf gurzr vf eryrnfrq haqre perngvir pbzzbaf yvprapr, nyy yvaxf va gur sbbgre fubhyq erznva vagnpg\');qvr;}}'));	
	
}