<?php

class widget_call_to_action extends WP_Widget {

	function __construct() {
		
		$widget_options = array( 'classname' => 'widget_call_to_action', 'description' => __( 'Get maximum visitors attention with this widget.', 'swt' ) );
		
		parent::WP_Widget( 'widget_call_to_action', __( 'SWT - Call To Action', 'swt' ), $widget_options );
				
	}
		
	function form( $instance ) {
 
		/* Defaults */
		$defaults = array( 'title' => '', 'textarea' => '', 'button' => __( 'Sign Up', 'swt' ), 'button_link' => '', 'new_window' => 0 );
		
		/* Merge $defaults with saved options */
		$instance = wp_parse_args( (array) $instance, $defaults );
		
		$title 		= 	$instance['title'];
 		$textarea 	= 	$instance['textarea'];
 		$button 	= 	$instance['button'];
 		$button_link = 	$instance['button_link'];
 		$new_window = 	$instance['new_window'];
 
 		?>
				 			 								
		<p>
			<label for="<?php echo $this->get_field_id( 'title' ); ?>"><?php _e( 'Call To Action Title', 'swt' ); ?></label>
			<input type="text" class="widefat" id="<?php echo $this->get_field_id( 'title' ); ?>" name="<?php echo $this->get_field_name( 'title' ); ?>" value="<?php echo esc_attr( $title ); ?>" />
		</p>			
		
		<p>
			<label for="<?php echo $this->get_field_id( 'textarea' ); ?>"><?php _e( 'Call To Action Text', 'swt' ); ?></label>
			<textarea class="widefat" id="<?php echo $this->get_field_id( 'textarea' ); ?>" name="<?php echo $this->get_field_name( 'textarea' ); ?>"><?php echo esc_textarea( $textarea ); ?></textarea>
		</p>	

		<p>
			<label for="<?php echo $this->get_field_id( 'button' ); ?>"><?php _e( 'Call To Action Button Text', 'swt' ); ?></label>
			<input type="text" class="widefat" id="<?php echo $this->get_field_id( 'button' ); ?>" name="<?php echo $this->get_field_name( 'button' ); ?>" value="<?php echo esc_attr( $button ); ?>" />
		</p>

		<p>
			<label for="<?php echo $this->get_field_id( 'button_link' ); ?>"><?php _e( 'Call To Action Button Link', 'swt' ); ?></label>
			<input type="text" class="widefat" id="<?php echo $this->get_field_id( 'button_link' ); ?>" name="<?php echo $this->get_field_name( 'button_link' ); ?>" value="<?php echo esc_attr( $button_link ); ?>" />
		</p>	

		<p>
			<input type="checkbox" id="<?php echo $this->get_field_id( 'new_window' ); ?>" name="<?php echo $this->get_field_name( 'new_window' ); ?>" value="<?php echo esc_attr( $new_window ); ?>" <?php checked( $new_window, 1 ); ?> />
			<label for="<?php echo $this->get_field_id( 'new_window' ); ?>"><?php _e( 'Open in new window?', 'swt' ); ?></label>
		</p>		
		
		<?php
		
	}
	
	function update( $new_instance, $old_instance ) {
 
		$instance = $old_instance; 
				
		$instance['title'] = strip_tags( $new_instance['title'] );
 		
		if ( current_user_can( 'unfiltered_html' ) ) 
			$instance['textarea'] = $new_instance['textarea'];
		else
			$instance['textarea'] = stripslashes( wp_filter_post_kses( adslashes( $new_instance['textarea'] ) ) ); 
						
 		$instance['button'] = strip_tags( $new_instance['button'] );
		
 		$instance['button_link'] = strip_tags( $new_instance['button_link'] );
		
		$instance['new_window'] = ( isset( $new_instance['new_window'] ) ? 1 : 0 );

		
	    return $instance;
	}
	
	function widget( $args, $instance ) {
	
		extract( $args );
		
		$title 			= 	$instance['title']; 
 		$textarea 		= 	$instance['textarea'];
 		$button	 		= 	$instance['button'];			 		
 		$button_link	= 	$instance['button_link'];			 		
 		$new_window		= 	$instance['new_window'];			 		
						
		echo $before_widget;
		
		?>
		
		<span class="swt-call-top"></span>
		
		<?php
		
		if ( !empty( $title ) )
			echo '<h3 class="call-title">'. $title .'</h3>';		
		
		if ( !empty( $textarea ) )
			echo '<p class="call-text">'. $textarea .'</p>';		
 		
		if ( !empty( $button ) ) {
		
			if ( $new_window == 1 ) 
				$new_window = 'target="_blank"';
			else
				$new_window = '';
				
			echo '<a '. $new_window .' class="call-button" href="'.$button_link.'">'. $button .'</a>';
		}
 	
		
		echo $after_widget;
		
	}
	

}

?>