<article <?php hybrid_attr( 'post' ); ?>>

	<?php if ( is_singular( get_post_type() ) ) : // If viewing a single post. ?>

		<header class="entry-header">

			<h1 <?php hybrid_attr( 'entry-title' ); ?>><?php single_post_title(); ?></h1>

		</header><!-- .entry-header -->

		<div <?php hybrid_attr( 'entry-content' ); ?>>
			<?php the_content(); ?>
			<?php wp_link_pages(); ?>
		</div><!-- .entry-content -->

		<?php if ( !is_page() ) : ?>
		
			<footer class="entry-footer">
				<time <?php hybrid_attr( 'entry-published' ); ?>><i class="fa fa-calendar-o"></i> <?php echo get_the_date('F d'); ?></time>			
				<span <?php hybrid_attr( 'entry-author' ); ?>><i class="fa fa-user"></i><?php _e( 'by', 'swt' ); ?> <?php the_author_posts_link(); ?></span>
				
					<span itemprop="articleSection" class="entry-terms category fa fa-file-text-o"><?php the_category(', '); ?></span>
				<?php hybrid_post_terms( array( 'taxonomy' => 'post_tag', 'text' => __( '<i class="fa fa-tags"></i> Tagged: %s', 'swt' ), 'before' => '<br />' ) ); ?>			
			</footer><!-- .entry-footer -->
		
		<?php endif; ?>
		
		<?php 
			if ( shortcode_exists( 'rrssb' ) )
				echo do_shortcode( '[rrssb]' ); 
		?>
		
		<div class="loop-nav">
			<?php previous_post_link( '<div class="prev">' . __( '%link', 'swt' ) . '</div>', 'Previous Post' ); ?>
			<?php next_post_link( '<div class="next">' . __( '%link',     'swt' ) . '</div>', 'Next Post' ); ?>
		</div><!-- .loop-nav -->

		
	<?php else : // If not viewing a single post. ?>

	
		<header class="entry-header">

			<?php the_title( '<h2 ' . hybrid_get_attr( 'entry-title' ) . '><a href="' . get_permalink() . '" rel="bookmark" itemprop="url">', '</a></h2>' ); ?>
			
			<?php comments_popup_link( __( '0', 'swt' ), __( '1', 'swt' ), __( '%', 'swt' ), 'comments-link', __( 'Off', 'swt' ) ); ?>
			
		</header><!-- .entry-header -->
	
		
		<div <?php hybrid_attr( 'entry-summary' ); ?>>
			
			<?php 
			if ( has_post_thumbnail() ) {
				echo '<figure class="alignleft swt-featured">';
					get_the_image( array( 'size' => 'swt-medium', 'order' => array( 'featured', 'attachment' ) ) );
				echo '</figure>'; 				
			}
				
			?>	
			<?php the_excerpt(''); ?>
			
		</div><!-- .entry-summary -->
		
		<footer class="entry-footer">
					
			<a class="more-link" href="<?php the_permalink(); ?>"><?php _e( 'Read More', 'swt' ); ?></a>									
			
			<time <?php hybrid_attr( 'entry-published' ); ?>><i class="fa fa-calendar-o"></i> <?php echo get_the_date('F d'); ?></time>			
			<span <?php hybrid_attr( 'entry-author' ); ?>><i class="fa fa-user"></i><?php _e( 'by', 'swt' ); ?> <?php the_author_posts_link(); ?></span>			
			<span itemprop="articleSection" class="entry-terms category fa fa-file-text-o"><?php the_category(', '); ?></span>
					
												
 		</footer><!-- .entry-footer -->
		
	<?php endif; // End single post check. ?>

</article><!-- .entry -->