<?php

add_action( 'widgets_init', 'swt_register_info_widget' );

function swt_register_info_widget() {
	register_widget( 'swt_about_widget' ); 
}

class swt_about_widget extends WP_Widget {

	function swt_about_widget() {
		
		$widget_options = array( 'classname' => 'swt_info', 'description' => __( 'Displays informations about your blog.', 'swt' ) );
		parent::WP_Widget( 'swt_about_widget', __( 'About/Info Widget', 'swt' ), $widget_options );
	}
	
	function form( $instance ) {
		
		$def_img = trailingslashit( get_template_directory_uri() ).'images/foody.png';
		
		$defaults = array( 'swt_info_image' => $def_img, 
							'swt_info_title' => 'Foody', 
							'swt_info_text' => 'wordpress theme',
						);
						
		$instance = wp_parse_args( (array) $instance, $defaults );
		
		$swt_info_image 	= $instance['swt_info_image'];
		$swt_info_title 	= $instance['swt_info_title'];
		$swt_info_text 		= $instance['swt_info_text'];
		
 
		?>
		
		<p>
			<label for="<?php echo $this->get_field_id( 'swt_info_image' ); ?>"><?php _e( 'Your image:', 'swt' ); ?></label>
			<input type="text" class="widefat" name="<?php echo $this->get_field_name( 'swt_info_image' ); ?>" value="<?php echo esc_attr( $swt_info_image ); ?>" id="<?php echo $this->get_field_id( 'swt_info_image' ); ?>" />
		</p>
		
		<p>
			<label for="<?php echo $this->get_field_id( 'swt_info_title' ); ?>"><?php _e( 'Title:', 'swt' ); ?></label>
			<input type="text" class="widefat" name="<?php echo $this->get_field_name( 'swt_info_title' ); ?>" value="<?php echo esc_attr( $swt_info_title ); ?>" id="<?php echo $this->get_field_id( 'swt_info_title' ); ?>" />
		</p>

		<p>
			<label for="<?php echo $this->get_field_id( 'swt_info_text' ); ?>"><?php _e( 'Description:', 'swt' ); ?></label>
			<input type="text" class="widefat" name="<?php echo $this->get_field_name( 'swt_info_text' ); ?>" value="<?php echo esc_attr( $swt_info_text ); ?>" id="<?php echo $this->get_field_id( 'swt_info_text' ); ?>" />
		</p>		
 
		
		<?php
		
	}
	
	function update( $new_instance, $old_instance ) {
		
		$instance = $old_instance; 
		
		$instance['swt_info_image'] 	= strip_tags( $new_instance['swt_info_image'] );
		$instance['swt_info_title'] 	= strip_tags( $new_instance['swt_info_title'] );
		$instance['swt_info_text'] 		= strip_tags( $new_instance['swt_info_text'] );
		
 		
		return $instance;
	}
	
	function widget( $args, $instance ) {
		
		extract( $args, EXTR_SKIP );
		
		$swt_info_image 		= $instance['swt_info_image'];
		$swt_info_title 		= $instance['swt_info_title'];
		$swt_info_text 			= $instance['swt_info_text'];
 
		echo $before_widget;		
		?>
		
		<img src="<?php echo $swt_info_image; ?>" alt="<?php echo $swt_info_title; ?>" />
		<h4 class="about-title"><?php echo $swt_info_title; ?></h4>
		<p><?php echo $swt_info_text; ?></p>
		
		<?php
		echo $after_widget;
		
	}

}

?>