<?php

add_action( 'widgets_init', 'swt_register_featured_widget' );

function swt_register_featured_widget() {
	register_widget( 'swt_featured_widget' ); 
}

class swt_featured_widget extends WP_Widget {

	function swt_featured_widget() {
		
		$widget_options = array( 'classname' => 'swt_featured', 'description' => __( 'Displays posts with specific tag.', 'swt' ) );
		parent::WP_Widget( 'swt_featured_widget', __( 'Tagged Posts', 'swt' ), $widget_options );
	}
	
	function form( $instance ) {
		
		$defaults = array( 'tag' => '', 'number_of_items' => 1 );
							
		$instance = wp_parse_args( (array) $instance, $defaults );
		
		$tagged 			= 	$instance['tag'];
		$number_of_items 	= 	$instance['number_of_items'];
		
		?>
		<p>
			<?php _e( 'This widget will display posts tagged with specific tag.', 'swt' ); ?>		
		</p>
		<p>
			<label for="<?php echo $this->get_field_id( 'tag' ); ?>"><?php _e( 'Select the tag:', 'swt' ); ?></label>		
			<select id="<?php echo $this->get_field_id( 'tag' ); ?>" class="widefat" name="<?php echo $this->get_field_name( 'tag' ); ?>">
				<?php
				$tags = get_tags();
				foreach( $tags as $tag ) { ?>
					<option value="<?php echo esc_attr( $tag->name ); ?>" <?php selected( $tagged, $tag->name ); ?>><?php echo $tag->name; ?></option>
				<?php } ?>
			</select>
		</p>	

		<p>
			<label for="<?php echo $this->get_field_id( 'number_of_items' ); ?>"><?php _e( 'Set the number of posts you want to show:', 'swt' ); ?></label>
			<input type="text" class="widefat" id="<?php echo $this->get_field_id( 'number_of_items' ); ?>" name="<?php echo $this->get_field_name( 'number_of_items' ); ?>" value="<?php echo esc_attr( $number_of_items ); ?>" />
		</p>		
		
		<?php
		
	}
	
	function update( $new_instance, $old_instance ) {
		
		$instance = $old_instance; 
		
		$instance['tag'] 				= 	strip_tags( $new_instance['tag'] );
		$instance['number_of_items'] 	= 	absint( $new_instance['number_of_items'] );
		
						
		return $instance;
	}
	
	function widget( $args, $instance ) {
		
		extract( $args, EXTR_SKIP );
			
		$tag 				= 	$instance['tag']; 		
		$number_of_items 	= 	$instance['number_of_items']; 		
		
		echo $before_widget;		
		
		
		$query = new WP_Query( "tag={$tag}&showposts={$number_of_items}" );
		
		if ( $query->have_posts() ) {
 			while ( $query->have_posts() ) {
				$query->the_post();				
			?>

			<div class="featured-image-wrap">
				<?php if ( current_theme_supports( 'get-the-image' ) ) { 
					get_the_image( array( 'default_image' => trailingslashit( get_template_directory_uri() ) . 'images/slider-default.gif',
									  'size' => 'swt-featured-image', 
									  'image_class' => 'swt-featured-image'								  
									) ); 
				} ?>	
				<span class="featured-cat-name">				
					<?php 
					$category = get_the_category(); 
					if ( $category[0] ){
						echo '<a href="'.get_category_link($category[0]->term_id ).'">'.$category[0]->cat_name.'</a>';
					}
					?>				
				</span>
				<h4 class="featured-title">
					<a href="<?php the_permalink(); ?>"><?php the_title(); ?></a>
				</h4>
			</div><!--.featured-image-wrap-->
		
			<?php
			}
 		} 
	 		
		wp_reset_postdata();		

		echo $after_widget;
		
	}

}

?>