<?php

class SWTTabber extends WP_Widget {

function SWTTabber() {
		$widget_ops = array(
		'classname' => 'SWTTabber',
		'description' => 'Simple jQuery Tabber Widget'
);
$this->WP_Widget(
		'SWTTabber',
		'SWT Tabber Widget',
		$widget_ops
);
}
function widget($args, $instance) { // widget sidebar output
 
extract($args, EXTR_SKIP);
// pre-widget code from theme
echo $before_widget; 

?>

<ul class="tabs">
	<li class="active"><a href="#tab1"><?php _e( 'Popular', 'swt'); ?></a></li>
	<li><a href="#tab2"><?php _e( 'Comments', 'swt' ); ?></a></li>
	<li><a href="#tab3"><?php _e( 'Tags', 'swt' ); ?></a></li>
</ul>

<div class="tab_container">

<div id="tab1" class="tab_content">

<?php
		/* Set up the query */
		$widget_popular_posts = array(
			'posts_per_page'        => 5,
			'orderby'             	=> $orderby,
			'ignore_sticky_posts'  => true,
			'tax_query'           	=> array(
					array(
						// Exclude posts with the Aside, Link, Quote, and Status format
						'taxonomy' => 'post_format',
						'terms'    => array( 'post-format-aside', 'post-format-link', 'post-format-quote', 'post-format-status' ),
						'field'    => 'slug',
						'operator' => 'NOT IN',
					)
				),
		);			
			
		if ( ! empty( $widget_popular_posts ) ) {

			$swt_query_posts = new WP_Query( $widget_popular_posts );
			
			echo '<ul class="popular-posts">';
			
			if ( $swt_query_posts->have_posts() ) while ( $swt_query_posts->have_posts() ) : $swt_query_posts->the_post(); ?>
				
				<li>					
					<h4 class="popular-title"><a href="<?php the_permalink() ?>" title="<?php the_title_attribute(); ?>"><?php the_title(); ?></a></h4>					
				</li>	
	
			<?php endwhile;
	
			wp_reset_query();
			
			echo '</ul>';
		}
?>

</div>

<div id="tab2" class="tab_content">
<?php 

function dp_recent_comments($no_comments = 10, $comment_len = 150) {
    global $wpdb;
    $request = "SELECT * FROM $wpdb->comments";
    $request .= " JOIN $wpdb->posts ON ID = comment_post_ID";
    $request .= " WHERE comment_approved = '1' AND post_status = 'publish' AND post_password =''";
    $request .= " ORDER BY comment_date DESC LIMIT $no_comments";
    $comments = $wpdb->get_results($request);
    if ($comments) {
        foreach ($comments as $comment) {
            ob_start();
            ?>
                <li>
                <!-- Who commented + link to the comment -->
                    <a href="<?php echo get_permalink( $comment->comment_post_ID ) . '#comment-' . $comment->comment_ID; ?>"><?php echo dp_get_author($comment); ?> <?php _e('said', 'swt'); ?> </a>
                <!-- When -->
                    <?php echo human_time_diff(get_comment_date('U',$comment->comment_ID), current_time('timestamp')), __(' ago', 'swt'); ?>:    
                <!-- Comment content -->
                    <?php echo strip_tags(substr(apply_filters('get_comment_text', $comment->comment_content), 0, $comment_len)); ?>...
                <!-- On which post -->
                    <a href="<?php echo get_permalink( $comment->comment_post_ID ); ?>">&raquo; <?php echo get_the_title($comment->comment_post_ID); ?></a>                                      
                </li>
            <?php
            ob_end_flush();
        }
    } else {
        echo '<li>'.__('No comments yet', 'swt').'';
    }
}

// Get author for comment
function dp_get_author($comment) {
    $author = "";
    if ( empty($comment->comment_author) )
        $author = __('Anonymous', 'swt');
    else
        $author = $comment->comment_author;
    return $author;
}
 
?>
<ul><?php dp_recent_comments(5); ?></ul>
</div>

<div id="tab3" class="tab_content">
	<p class="post_tag-cloud"><?php wp_tag_cloud(); ?></p>
</div>

</div>

<div class="clear"></div>


<?php

echo $after_widget; 
}
}

// registering and loading widget
add_action(
'widgets_init',
create_function('','return register_widget("SWTTabber");')
);
?>
