<?php
/**
 * A unique identifier is defined to store the options in the database and reference them from the theme.
 * By default it uses the theme name, in lowercase and without spaces, but this can be changed if needed.
 * If the identifier changes, it'll appear as if the options have been reset.
 */

function optionsframework_option_name() {

	// This gets the theme name from the stylesheet
	$themename = wp_get_theme();
	$themename = preg_replace("/\W/", "_", strtolower($themename) );

	$optionsframework_settings = get_option( 'optionsframework' );
	$optionsframework_settings['id'] = $themename;
	update_option( 'optionsframework', $optionsframework_settings );
}

/**
 * Defines an array of options that will be used to generate the settings page and be saved in the database.
 * When creating the 'id' fields, make sure to use all lowercase and no spaces.
 *
 * If you are making your theme translatable, you should replace 'swt'
 * with the actual text domain for your theme.  Read more:
 * http://codex.wordpress.org/Function_Reference/load_theme_textdomain
 */

function optionsframework_options() {

	// Pull all the categories into an array
	$options_categories = array();
	$options_categories_obj = get_categories();
	foreach ($options_categories_obj as $category) {
		$options_categories[$category->cat_ID] = $category->cat_name;
	}


	/* set some defaults */
	$theme_dir = get_bloginfo( 'template_directory' );
	$header_banner = '<a target="_blank" href="http://www.advertthemes.com"><img src="'.$theme_dir.'/images/banners/header.jpg" alt="Adsense Themes" /></a>';

	$sidebar_banners = '
	<a target="_blank" href="http://www.advertthemes.com"><img src="'.$theme_dir.'/images/banners/banner.jpg" alt="Adsense Themes" /></a>
	<a target="_blank" href="http://www.advertthemes.com"><img src="'.$theme_dir.'/images/banners/banner.jpg" alt="Adsense Themes" /></a>
	<a target="_blank" href="http://www.advertthemes.com"><img src="'.$theme_dir.'/images/banners/banner.jpg" alt="Adsense Themes" /></a>
	<a target="_blank" href="http://www.advertthemes.com"><img src="'.$theme_dir.'/images/banners/banner.jpg" alt="Adsense Themes" /></a>
	';
		
	$slider_mode = array(
		'fade' => __('Fade', 'swt'),
		'horizontal' => __('Horizontal', 'swt'),
		'vertical' => __('Vertical', 'swt')
	);	

	$slider_auto = array(
		'true' => __('Yes', 'swt'),
		'false' => __('No', 'swt')
	);	

	$slider_autohover = array(
		'true' => __('Yes', 'swt'),
		'false' => __('No', 'swt')
	);	
		
	// If using image radio buttons, define a directory path
	$imagepath =  get_template_directory_uri() . '/admin/images/';

	$options = array();

$options[] = array( "name" => __( "General", "swt" ),
					"type" => "heading" );

$options[] = array( "name" => __( "Default Site Layout", "swt" ),
					"desc" => "",
					"id" => "site_layout",
					"std" => "layout-2c-l",
					"type" => "images",
					"options" => array(
								'layout-1c'    => $imagepath . '1col.png',
								'layout-2c-l'  => $imagepath . '2cl.png',
								)
					);					
					
$options[] = array( "name" => __( "Header Scripts", "swt" ),
					"desc" => __( "Add scripts before &lt;/head&gt; tag", "swt" ),
					"id" => "header_scripts",					
					"type" => "textarea",
					"std" => "");

$options[] = array( "name" => __( "Footer Scripts", "swt" ),
					"desc" => __( "Add scripts before &lt;/body&gt; tag", "swt" ),
					"id" => "footer_scripts",					
					"type" => "textarea",
					"std" => "");

$options[] = array( "name" => __( "Custom CSS", "swt" ),
					"desc" => __( "Add your own CSS", "swt" ),
					"id" => "custom_css",
					"type" => "textarea",
					"std" => "");    							

$options[] = array( "name" => __( "Upload Favicon (16x16px)", "swt" ),
					"desc" => __( "A favicon (short for Favorite icon), is also known as a shortcut icon, Web site icon, URL icon or bookmark icon, most commonly 16x16 pixels, associated with a particular Web site or Web page. For example, you can genearate your 16x16px favicon <a href='http://www.favicongenerator.com/'>here</a>.", "swt" ),
					"id" => "favicon",					
					"type" => "upload",
					"std" => "");	
									
						
$options[] = array( 'name' => __( "Social Profiles", "swt" ),
					'type' => 'heading');	

$options[] = array( 'name' => __( "Enable / Disable Social Profiles", "swt" ),
					'desc' => __( "If enabled, social icons will appear in menu or in sidebar of theme.", "swt" ),
					'id' => 'swt_social_profiles',
					'std' => '0',
					'type' => 'checkbox' );		

$options[] = array( "name" => __( "Youtube URL", "swt" ),
					"id" => "social_youtube",
					"desc" => "",
					"type" => "text",
					"std" => "");						
					
$options[] = array( "name" => __( "Twitter URL", "swt" ),
					"id" => "social_twitter",
					"desc" => "",
					"type" => "text",
					"std" => "");						

$options[] = array( "name" => __( "Facebook URL", "swt" ),
					"id" => "social_facebook",
					"desc" => "",
					"type" => "text",
					"std" => "");				
					
$options[] = array( "name" => __( "Google Plus URL", "swt" ),
					"id" => "social_gplus",
					"desc" => "",
					"type" => "text",
					"std" => "");		
					
$options[] = array( "name" => __( "RSS URL", "swt" ),
					"id" => "social_rss",
					"desc" => "",
					"type" => "text",
					"std" => "");		
													

$options[] = array( 'name' => __('Ads', 'swt'),
					'type' => 'heading');	

$options[] = array( "name" => __( "Header Ad", "swt" ),
					"desc" => __( "Add banner to header area", "swt" ),
					"id" => "header_ad",
					"type" => "textarea",
					"std" => $header_banner);								
					
$options[] = array( "name" => __( "Sidebar Ads", "swt" ),
					"desc" => __( "Add banners to sidebar", "swt" ),
					"id" => "sidebar_ads",
					"type" => "textarea",
					"std" => $sidebar_banners);								


$options[] = array( 'name' => __( "Slider", "swt" ),
					'type' => 'heading');	

$options[] = array( 'name' => __( "How to add posts to content slider?", "swt" ),
					'desc' => __( "First thing - you need to enable content slider by checking \"Enable content slider\" below. Make a new post, and set a featured image for it. Save it, and click on \"All posts\". Find the  post you just made, and click on \"Quick Edit\". Now just click on \"Make this post sticky\" and click \"Update\". Make at least one more post this way, or slider will slide to the same post again and  again.", "swt" ),
					'type' => 'info');    		
	
$options[] = array( 'name' => __( "Content Slider", "swt" ),
					"desc" => __( "Enable content slider (checked - enabled)", "swt" ),
					'id' => 'swt_slider',
					'std' => '0',
					'type' => 'checkbox');		

$options[] = array( 'name' => __( "Type of transition between slides", "swt" ),
					'id' => 'slider_mode',
					'std' => 'fade',
					'type' => 'radio',
					'options' => $slider_mode);							
	
$options[] = array(	'name' => __( "Slides automatically", "swt" ),
					'id' => 'slider_auto',
					'std' => 'true',
					'type' => 'radio',
					'options' => $slider_auto);				
						
						
$options[] = array( "name" => __( "The amount of time (in ms) between each slide", "swt" ),
					"id" => "slider_pause",
					"class" => "mini",							
					"type" => "text",
					"std" => "4000");		
 			
					
$options[] = array( 'name' => __('News Ticker', 'swt'),
					'type' => 'heading');	
				
$options[] = array( 'name' => __('Ticker', 'swt'),
					'id' => 'swt_ticker',
					"desc" => __('Enable news ticker (checked - enabled)', 'swt'),
					'std' => '0',
					'type' => 'checkbox');	
					
$options[] = array( "name" => __( "The speed of the reveal", "swt" ),
					"id" => "ticker_reveal",
					"class" => "mini",							
					"type" => "text",
					"std" => "0.10");		

$options[] = array( "name" => __( "Ticker Text", "swt" ),
					"id" => "ticker_text",
					"class" => "mini",							
					"type" => "text",
					"std" => __( "Latest News", "swt" ) );							
					
if ( $options_categories ) {
				$options[] = array(
					'name' => __('Select a Category', 'swt'),
					'desc' => __('Choose which category should be displayed in the ticker', 'swt'),
					'id' => 'ticker_cat',
					'type' => 'select',
					'options' => $options_categories);
}

					
return $options;
	
}