<?php
	
/* Get the sticky posts. */
global $sticky, $sticky_slider;

if (  $sticky_slider == 1 && ! empty( $sticky ) && ( is_home() || is_front_page() ) ) :
 
	/* Grab all sticky posts */
	$args = array( 'post__in' => $sticky );
	
	$swt_slider = new WP_Query( $args );
	
	if ( $swt_slider->have_posts() ) : ?>

		<section id="slider">
			
			<ul class="bxslider">
			
				<?php while ( $swt_slider->have_posts() ) : $swt_slider->the_post(); ?>	

				<li>
				
					<article class="slide">
					
						<?php if ( current_theme_supports( 'get-the-image' ) ) { 
							get_the_image( array( 'default_image' => trailingslashit( get_template_directory_uri() ) . 'images/slider-default.gif',
												  'size' => 'swt-slider-image', 
												  'image_class' => 'swt-slider-image'
												  ) ); } ?>
																								
						<div class="bx-caption">
							<div class="bx-caption-wrap">
								<h2 class="slider-title"><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h2>
								<p><?php truncate_post( 145, true ); ?></p>
							</div><!--.bx-caption-wrap-->
						</div>
										
					</article> <!-- .slide -->
					
				</li>
				
				<?php endwhile; ?>
				
				<?php wp_reset_postdata(); // Restores the $post global to the current post in the main query.  ?>
				    			
			</ul><!-- .bxslider -->
			
		</section><!-- #slider -->

	<?php endif; ?>
		
<?php endif; ?>