<?php
/**
 * Archive Template
 *
 * The archive template is the default template used for archives pages without a more specific template. 
 *
 * @package swt
 * @subpackage Template
 */

get_header(); // Loads the header.php template. ?>

	<div id="content">

		<div class="hfeed">

			<?php get_template_part( 'loop-meta' ); // Loads the loop-meta.php template. ?>

			<?php if ( have_posts() ) : ?>

				<?php while ( have_posts() ) : the_post(); ?>
				
				<div id="post-<?php the_ID(); ?>" class="<?php hybrid_entry_class(); ?>">
				
					<?php echo apply_atomic_shortcode( 'entry_title', '[entry-title]' ); ?>
				
					<?php echo apply_atomic_shortcode( 'byline', '<div class="byline">' . __( '[entry-author before="By "] [entry-comments-link] [entry-published format="m.d.Y"] [entry-edit-link]', hybrid_get_parent_textdomain() ) . '</div>' ); ?>        
					
					<div class="entry-content">
						<?php the_content('',FALSE,''); ?>
						<?php wp_link_pages( array( 'before' => '<p class="page-links">' . __( 'Pages:', hybrid_get_parent_textdomain() ), 'after' => '</p>' ) ); ?>
					</div><!-- .entry-content -->
					
					<?php echo apply_atomic_shortcode( 'entry_meta', '<div class="entry-meta">' . __( '[read_more text="Read More"]', hybrid_get_parent_textdomain() ) . '</div>' ); ?>	
				
				</div><!-- .hentry -->

				<?php endwhile; ?>

			<?php else : ?>

				<?php get_template_part( 'loop-error' ); // Loads the loop-error.php template. ?>

			<?php endif; ?>

		</div><!-- .hfeed -->

		<?php get_template_part( 'loop-nav' ); // Loads the loop-nav.php template. ?>

	</div><!-- #content -->

<?php get_footer(); // Loads the footer.php template. ?>