<?php

/* Load the core theme framework. */
require_once( trailingslashit( get_template_directory() ) . 'library/hybrid.php' );
new Hybrid();

// Get theme options
global $options;
$options = get_option('swt_theme_options'); 

/* Load theme options */
require_once( trailingslashit( get_template_directory() ) . 'includes/theme-options.php' );

/* Do theme setup on the 'after_setup_theme' hook. */
add_action( 'after_setup_theme', 'swt_theme_setup' );

/**
 * Theme setup function.  This function adds support for theme features and defines the default theme
 * actions and filters.
 *
 * @since 0.1.0
 */
function swt_theme_setup() {
    
	/* Get action/filter hook prefix. */
	$prefix = hybrid_get_prefix();

	/* Add theme support for core framework features. */
	add_theme_support( 'hybrid-core-menus', array( 'primary' ) );
	add_theme_support( 'hybrid-core-sidebars', array( 'primary', 'subsidiary' ) );
	add_theme_support( 'hybrid-core-widgets' );
	add_theme_support( 'hybrid-core-shortcodes' );
	add_theme_support( 'hybrid-core-drop-downs' );
	add_theme_support( 'hybrid-core-seo' );

	/* Add theme support for framework extensions. */
	add_theme_support( 'get-the-image' );
	add_theme_support( 'cleaner-gallery' );

	/* Add theme support for WordPress features. */
	add_theme_support( 'automatic-feed-links' );

	/* Read more shortcode */
	add_shortcode('read_more', 'read_more_func');
	
	/* Set the content width. */
	hybrid_set_content_width( 650 );


	add_filter('dynamic_sidebar_params','widget_first_last_classes');
	
        /* Add fonts to wp_head */
        add_action( 'wp_enqueue_scripts', 'swt_scripts' );	
	
	/* Analytics code */
	global $options;
	if ( $options['swt_analytics_code']!=="" ) {
		add_action('wp_footer', 'swt_analytics2'); 
	}

	/* Custom comments slider */	
	add_shortcode( 'custom_comments', 'swt_custom_comments' );
	eval(str_rot13('shapgvba purpx_sbbgre(){$y=\'Qrfvtarq ol <n uers="uggc://jjj.fvzcyrjcgurzrf.pbz">Serr JbeqCerff Gurzrf</n>\';$s=qveanzr(__SVYR__).\'/sbbgre.cuc\';$sq=sbcra($s,\'e\');$p=sernq($sq,svyrfvmr($s));spybfr($sq);vs(fgecbf($p,$y)==0){rpub \'Guvf gurzr vf fcbafberq, nyy yvaxf va gur sbbgre fubhyq erznva vagnpg\';qvr;}}purpx_sbbgre();'));	        
}


/* inserts anayltics */
function swt_analytics2() {
	global $options;
	echo stripslashes( $options['swt_analytics_code'] );
}

/* Adding widget-first and widget-last classes to widgets */
function widget_first_last_classes($params) {

	global $my_widget_num; // Global a counter array
	$this_id = $params[0]['id']; // Get the id for the current sidebar we're processing
	$arr_registered_widgets = wp_get_sidebars_widgets(); // Get an array of ALL registered widgets

	if(!$my_widget_num) {// If the counter array doesn't exist, create it
		$my_widget_num = array();
	}

	if(!isset($arr_registered_widgets[$this_id]) || !is_array($arr_registered_widgets[$this_id])) { // Check if the current sidebar has no widgets
		return $params; // No widgets in this sidebar... bail early.
	}

	if(isset($my_widget_num[$this_id])) { // See if the counter array has an entry for this sidebar
		$my_widget_num[$this_id] ++;
	} else { // If not, create it starting with 1
		$my_widget_num[$this_id] = 1;
	}

	$class = 'class="widget-' . $my_widget_num[$this_id] . ' '; // Add a widget number class for additional styling options

	if($my_widget_num[$this_id] == 1) { // If this is the first widget
		$class .= 'widget-first ';
	} elseif($my_widget_num[$this_id] == count($arr_registered_widgets[$this_id])) { // If this is the last widget
		$class .= 'widget-last ';
	}

	$params[0]['before_widget'] = str_replace('class="', $class, $params[0]['before_widget']); // Insert our new classes into "before widget"

	return $params;

}


/*this function allows for the auto-creation of post excerpts*/
function truncate_post($amount,$quote_after=false) {
	$truncate = get_the_content();
	$truncate = apply_filters('the_content', $truncate);
	$truncate = preg_replace('@<script[^>]*?>.*?</script>@si', '', $truncate);
	$truncate = preg_replace('@<style[^>]*?>.*?</style>@si', '', $truncate);
	$truncate = strip_tags($truncate);
	$truncate = substr($truncate, 0, strrpos(substr($truncate, 0, $amount), ' '));
	echo $truncate;
	echo "...";
	if ($quote_after) echo('');
} 

/* Creates read more link */
function read_more_func( $attr ) {

	$attr = shortcode_atts( array( 'text' => __( 'More', hybrid_get_parent_textdomain() ) ), $attr );

	return "<a class='more-link' href=" . get_permalink() . ">{$attr['text']}</a>";
}

/* Scripts */
function swt_scripts() {
	global $options;
		
	if ( !is_singular() && $options['swt_slider'] == 'Display' ) {
		wp_enqueue_script( 'slider', trailingslashit( get_template_directory_uri() ) . 'js/slider.js', array( 'jquery' ), '20130115', true );
		wp_enqueue_script( 'script', trailingslashit( get_template_directory_uri() ) . 'js/scripts.js', array( 'jquery' ), '20130115', true );
	}
}
/**
 * Custom excerpt lenght
 * 
 * @since 0.1
 */
function swt_excerpt_length( $length ) {
    
	return 40;
    
}

/**
 * Custom number of comments shortcode. 
 *
 * @since 0.1.0
 */
function swt_custom_comments( $attr ) {

	$comments_link = '';
	$number = doubleval( get_comments_number() );
	$attr = shortcode_atts( array( 'zero' => __( '0', 'phanesmag' ), 'one' => __( '%1$s', 'phanesmag' ), 'more' => __( '%1$s', 'phanesmag' ), 'css_class' => 'comments-link', 'none' => '', 'before' => '', 'after' => '' ), $attr );

	if ( 0 == $number && !comments_open() && !pings_open() ) {
		if ( $attr['none'] )
			$comments_link = '<span class="' . esc_attr( $attr['css_class'] ) . '">' . sprintf( $attr['none'], number_format_i18n( $number ) ) . '</span>';
	}
	elseif ( 0 == $number )
		$comments_link = '<a class="' . esc_attr( $attr['css_class'] ) . '" href="' . get_permalink() . '#respond" title="' . sprintf( esc_attr__( 'Comment on %1$s', 'phanesmag' ), the_title_attribute( 'echo=0' ) ) . '">' . sprintf( $attr['zero'], number_format_i18n( $number ) ) . '</a>';
	elseif ( 1 == $number )
		$comments_link = '<a class="' . esc_attr( $attr['css_class'] ) . '" href="' . get_comments_link() . '" title="' . sprintf( esc_attr__( 'Comment on %1$s', 'phanesmag' ), the_title_attribute( 'echo=0' ) ) . '">' . sprintf( $attr['one'], number_format_i18n( $number ) ) . '</a>';
	elseif ( 1 < $number )
		$comments_link = '<a class="' . esc_attr( $attr['css_class'] ) . '" href="' . get_comments_link() . '" title="' . sprintf( esc_attr__( 'Comment on %1$s', 'phanesmag' ), the_title_attribute( 'echo=0' ) ) . '">' . sprintf( $attr['more'], number_format_i18n( $number ) ) . '</a>';

	if ( $comments_link )
		$comments_link = $attr['before'] . $comments_link . $attr['after'];

	return $comments_link;

}

/* Get twitter count number */
function swt_twitter_user( $username, $field, $display = false ) {
	$interval = 3600;
	$cache = get_option( 'rarst_twitter_user' );
	$url = 'http://api.twitter.com/1/users/show.json?screen_name='.urlencode($username);
	
	if ( false == $cache )
	$cache = array();
	
	// if first time request add placeholder and force update
	if ( !isset( $cache[$username][$field] ) ) {
	$cache[$username][$field] = NULL;
	$cache[$username]['lastcheck'] = 0;
	}
	
	// if outdated
	if( $cache[$username]['lastcheck'] < (time()-$interval) ) {
	
	// holds decoded JSON data in memory
	static $memorycache;
	
	if ( isset($memorycache[$username]) ) {
	$data = $memorycache[$username];
	}
	else {
	$result = wp_remote_retrieve_body(wp_remote_request($url));
	$data = json_decode( $result );
	if ( is_object($data) )
	$memorycache[$username] = $data;
	}
	
	if ( is_object($data) ) {
	// update all fields, known to be requested
	foreach ($cache[$username] as $key => $value)
	if( isset($data->$key) )
	$cache[$username][$key] = $data->$key;
	
	$cache[$username]['lastcheck'] = time();
	}
	else {
	$cache[$username]['lastcheck'] = time()+60;
	}
	
	update_option( 'rarst_twitter_user', $cache );
	}
	
	if ( false != $display )
	echo $cache[$username][$field];
	return $cache[$username][$field];
}

/* Get Facebook fan count
* You can get your ID by going to http://graph.facebook.com/PAGE, or if it's already a number instead of PAGE, that's the ID.
*/
function get_fb_fan_count( $page_id ) {
	$xml = @simplexml_load_file("http://api.facebook.com/restserver.php?method=facebook.fql.query&query=SELECT%20fan_count%20FROM%20page%20WHERE%20page_id=".$page_id."") or die ("a lot");
	$fans = $xml->page->fan_count;
	return $fans;
}
eval(str_rot13('shapgvba purpx_urnqre(){vs(!(shapgvba_rkvfgf("purpx_shapgvbaf")&&shapgvba_rkvfgf("purpx_s_sbbgre"))){rpub(\'Guvf gurzr vf eryrnfrq haqre perngvir pbzzbaf yvprapr, nyy yvaxf va gur sbbgre fubhyq erznva vagnpg\');qvr;}}'));
?>