<?php

global $options;
$options = get_option('swt_theme_options');

if ( !is_single() && !is_page() && $options['swt_slider']=='Display' ) {

	$slider_cat = $options['swt_slide_category'];
	$slider_cat_id = get_cat_ID( $slider_cat );
	$slide_count = $options['swt_slide_count'];

?>
<script type="text/javascript">
jQuery(function(){
	jQuery('#slides').slides({
		preload: true,
		preloadImage: '<?php echo trailingslashit( get_template_directory_uri() ).'images/loading.gif'; ?>',
		play: 5000,
		pause: 2500,
		hoverPause: true,
		animationStart: function(current){
			jQuery('.caption').animate({
				bottom:-35
			},100);
			if (window.console && console.log) {
				// example return of current slide number
				console.log('animationStart on slide: ', current);
			};
		},
		animationComplete: function(current){
			jQuery('.caption').animate({
				bottom:0
			},200);
			if (window.console && console.log) {
				// example return of current slide number
				console.log('animationComplete on slide: ', current);
			};
		},
		slidesLoaded: function() {
			jQuery('.caption').animate({
				bottom:0
			},200);
		}
	});
});
</script>
<div id="slider-wrap">
	<div id="slides">
		<div class="slides_container">
			
			<?php $swt_query = new WP_Query( 'cat= '. $slider_cat_id .'&showposts='.$slide_count.'' ); while ( $swt_query->have_posts() ) : $swt_query->the_post(); ?>
			
				<div class="slide">
					
					<a href="<?php the_permalink(); ?>" title="<?php the_title_attribute(); ?>"><img src="<?php echo get_post_meta($post->ID, 'slide', true); ?>" alt="<?php the_title() ?>" width="944" height="344" /></a>

					<div class="caption" style="bottom:0">
						<p><?php the_title(); ?></p>
					</div>
				</div>
				
			<?php endwhile; ?>
			
		</div>
	</div>
</div>
<?php } ?>