jQuery(document).ready(function($) {
	// Image preloading and display an icon when mouse hover lightbox images
    $('.post img, .feat-cat-entry img, #slider img').each( function() {

		$(this).wrap("<div class='image-holder' />");

		var imagePath = $(this).attr('src');

		$(this).removeAttr('src');
		$(this)
			.css("opacity", "0.0")
            .load( function() {
				$(this)
					.css("opacity", "0.0")
					.animate({opacity: 0.0}, 500)
					.animate({opacity: 1.0}, 1000, function(){
					    $(this).parent().replaceWith($(this));


						var $lightbox = $(this).parent("a[rel^='prettyPhoto']");

						if ($lightbox.length > 0) {
							$(this).css("position", "relative");

							var $class = '';

							if($lightbox.attr('href').match(/(jpg|gif|jpeg|png|tif)/)) {
								$class = 'lightbox-image';
							} else {
								$class = 'lightbox-video';
							}

							if ($(this).length > 0)	{
								var $span = $("<span class='" + $class + " ie6fix'></span>").appendTo($lightbox);

								$(this).bind('mouseenter', function(){
									$height = $(this).height();
									$width = $(this).width();
									$pos =  $(this).position();
									$span.css({
										height:$height,
										width:$width,
										top:$pos.top,
										left:$pos.left
									});
								});
							}
						}

					});
			}).attr('src', imagePath);
    });


	// Reduce opacity when mouse hover lightbox images
	$(".post img, .feat-cat-entry img").hover(function(){
		$(this).stop().fadeTo("normal", 0.6); // This sets the opacity to 60% on hover
	},function(){
		$(this).stop().fadeTo("normal", 1.0); // This sets the opacity back to 100% on mouseout
	});


});