<?php get_header(); ?>

<div id="contentwrap">

	<?php if (have_posts()) : ?>

		<?php while (have_posts()) : the_post(); ?>

			<div <?php post_class() ?> id="post-<?php the_ID(); ?>">
				<h2 class="title"><a href="<?php the_permalink() ?>" rel="bookmark" title="Permanent Link to <?php the_title_attribute(); ?>"><?php the_title(); ?></a></h2>

				<div class="entry">
                <?php if ( function_exists( 'get_the_image' ) ) {
            get_the_image( array( 'custom_key' => array( 'post_thumbnail' ), 'default_size' => 'full', 'image_class' => 'aligncenter', 'width' => '580', 'height' => '210' ) ); }
            ?>
					<?php the_content(''); ?>
				</div>

                <div class="meta">
                <div class="mleft">
                 Posted on <span class="red"><?php the_time('F d, Y'); ?></span>
                 in <?php the_category(', ') ?>
                 by <span class="red"><?php the_author(); ?></span>
                 </div>
                 <?php comments_popup_link('No Comments &#187;', '1 Comment &#187;', '% Comments &#187;', 'comm'); ?>
                </div>
			</div>

		<?php endwhile; ?>

		<div class="navigation">
        <?php
            include('includes/wp-pagenavi.php');
            if(function_exists('wp_pagenavi')) { wp_pagenavi(); }
        ?>
		</div>

	<?php else : ?>

		<h2 class="center">Not Found</h2>
		<p class="center">Sorry, but you are looking for something that isn't here.</p>
		<?php get_search_form(); ?>

	<?php endif; ?>
</div>
<?php get_sidebar(); ?>
<?php get_footer(); ?>
