<?php get_header(); ?>

<div id="contentwrap">

	<?php if (have_posts()) : ?>

		<?php while (have_posts()) : the_post(); ?>


           <span class="date"><?php the_time('F d, Y'); ?></span>


			<div <?php post_class() ?> id="post-<?php the_ID(); ?>">
				<h2 class="title"><a href="<?php the_permalink() ?>" rel="bookmark" title="Permanent Link to <?php the_title_attribute(); ?>"><?php the_title(); ?></a></h2>
                <div class="meta">
                 written by: <span><?php the_author(); ?></span>
                  <?php the_tags('<span class="tags">Tags: ', ', ', '</span>'); ?>
                 <?php comments_popup_link('0 <span>Comments</span>', '1 <span>Comment</span>', '% <span>Comments</span>', 'comm'); ?>
                </div>
           
				<div class="entry">
                <?php if ( function_exists( 'get_the_image' ) ) {
                get_the_image( array( 'custom_key' => array( 'post_thumbnail' ), 'default_size' => 'full', 'image_class' => 'alignleft', 'width' => '200', 'height' => '150' ) ); }?>
					<?php the_content(''); ?>
				</div>

            	<p class="postmetadata"><a class="more-link" href="<?php the_permalink() ?>#more">Continue Reading</a></p>
			</div>

		<?php endwhile; ?>

		<div class="navigation">
        <?php
            include('includes/wp-pagenavi.php');
            if(function_exists('wp_pagenavi')) { wp_pagenavi(); }
        ?>
		</div>

	<?php else : ?>

		<h2 class="center">Not Found</h2>
		<p class="center">Sorry, but you are looking for something that isn't here.</p>
		<?php get_search_form(); ?>

	<?php endif; ?>
</div>
<?php get_sidebar(); ?>
<?php get_footer(); ?>
