/*!
 * The following copyright notice may not be removed under any circumstances.
 * 
 * Copyright:
 * Digitized data copyright  1997 The Monotype Corporation, Inc. All rights
 * reserved. Gill Sans is a trademark of The Monotype Corporation, Inc. which may
 * be registered in certain jurisdictions.
 * 
 * Trademark:
 * Gill Sans is a trademark of The Monotype Corporation, Inc. which may be
 * registered in certain jurisdictions.
 * 
 * Description:
 * Monotype Type Drawing Office 1928. Gill studied under the renowned
 * calligrapher, Edward Johnston, the designer of the London Underground sans serif
 * typeface. This influenced Gill who later experimented with sans serif designs,
 * and in due course produced a set of capital letters. These became Monotype
 * series 231, produced in 1923, and the forerunner of the extensive Gill Sans
 * range now available. A twentieth century sans serif that has a simplicity of
 * form which does not reject traditional forms and proportions, and gives the face
 * a humanist feel. The lighter weights are highly readable in text and suitable
 * for magazine and book work, whereas the heavier weights are best used for
 * display in advertising, packaging, and labels.
 * 
 * Manufacturer:
 * Monotype Typography
 * 
 * Designer:
 * Eric Gill
 * 
 * Vendor URL:
 * http://www.monotype.com/html/mtname/ms_welcome.html
 */
Cufon.registerFont({"w":127,"face":{"font-family":"Gill Sans MT Condensed","font-weight":400,"font-stretch":"condensed","units-per-em":"360","panose-1":"2 11 5 6 2 1 4 2 2 3","ascent":"288","descent":"-72","x-height":"4","bbox":"-42 -330 362 97","underline-thickness":"17.9297","underline-position":"-18.1055","unicode-range":"U+0020-U+F002"},"glyphs":{" ":{"w":119,"k":{"\u2018":36,"\u201c":36,"Y":36,"W":36,"V":36,"A":14}},"!":{"d":"32,-69v-10,-8,-18,-105,-18,-130v0,-29,6,-44,18,-44v12,0,18,15,18,44v1,26,-7,121,-18,130xm52,-17v1,10,-10,20,-20,20v-10,0,-21,-10,-20,-20v0,-10,10,-19,20,-19v10,0,20,9,20,19","w":63},"\"":{"d":"75,-258r36,0v2,35,-3,64,-8,92r-20,0v-5,-28,-10,-57,-8,-92xm17,-258r36,0v2,35,-3,64,-8,92r-20,0v-5,-28,-10,-57,-8,-92"},"#":{"d":"25,-186r53,0r15,-76r27,0r-16,76r55,0r16,-76r26,0r-15,76r30,0r0,26r-36,0r-12,62r48,0r0,26r-53,0r-16,76r-26,0r15,-76r-55,0r-15,76r-27,0r16,-76r-30,0r0,-26r35,0r12,-62r-47,0r0,-26xm99,-160r-13,62r56,0r12,-62r-55,0","w":240},"$":{"d":"78,-136v59,34,65,118,0,137r0,36r-21,0r0,-34v-19,-2,-35,-6,-48,-13r0,-31v17,10,33,15,48,15r0,-85v-25,-21,-47,-34,-47,-70v0,-28,20,-50,47,-53r0,-12r21,0r0,10v13,0,27,4,42,12r0,30v-15,-9,-29,-14,-42,-14r0,72xm57,-153r0,-52v-28,11,-23,36,0,52xm78,-94r0,64v28,-12,23,-47,0,-64","w":135},"%":{"d":"35,11r123,-255r23,0r-123,255r-23,0xm39,-115v-22,0,-33,-21,-33,-64v0,-42,11,-64,33,-64v22,0,33,21,33,63v0,43,-11,65,-33,65xm39,-224v-15,3,-10,88,0,89v7,0,10,-14,10,-43v0,-25,3,-40,-10,-46xm178,2v-22,0,-33,-21,-33,-63v0,-43,11,-64,33,-64v22,0,33,21,33,63v0,43,-11,64,-33,64xm178,-106v-17,2,-12,88,0,89v9,-3,19,-88,0,-89","w":217},"&":{"d":"77,-243v55,8,51,75,5,106v9,18,15,39,25,55v4,-15,6,-28,7,-39r28,0v-2,25,-9,50,-20,74r23,50r-34,0r-9,-21v-36,47,-92,6,-92,-49v0,-28,12,-54,36,-75v-26,-44,-15,-96,31,-101xm76,-219v-23,6,-17,37,-6,57v18,-12,33,-49,6,-57xm59,-114v-24,18,-27,86,7,86v8,0,17,-6,24,-18","w":150},"'":{"d":"17,-258r36,0v2,35,-3,64,-9,92r-19,0v-5,-28,-10,-57,-8,-92","w":68},"(":{"d":"63,89v-63,-83,-64,-249,0,-332r17,0v-49,73,-48,259,0,332r-17,0","w":82},")":{"d":"19,-243v64,84,64,248,0,332r-16,0v49,-73,48,-259,0,-332r16,0","w":82},"*":{"d":"71,-193v21,-17,38,-31,46,-8v5,13,-29,16,-45,13v0,2,0,4,-2,6v17,11,27,13,31,29v1,6,-7,11,-12,11v-10,0,-18,-12,-22,-38v-4,2,-3,1,-7,0v-5,26,-12,38,-21,38v-7,0,-12,-4,-12,-11v0,-7,10,-17,30,-29v-2,-13,-53,1,-46,-19v8,-23,26,-9,46,8v1,-2,3,-4,5,-4v-6,-15,-10,-25,-10,-32v0,-7,5,-15,12,-14v20,7,11,24,2,46v2,0,4,2,5,4"},"+":{"d":"35,-142r70,0r0,-70r30,0r0,70r70,0r0,30r-70,0r0,70r-30,0r0,-70r-70,0r0,-30","w":240},",":{"d":"27,-37v40,10,24,75,-14,84v5,-15,12,-27,10,-44v-23,-3,-18,-41,4,-40","w":63,"k":{"\u2019":22,"\u201d":22," ":36}},"-":{"d":"10,-66r0,-30r66,0r0,30r-66,0","w":86},".":{"d":"32,3v-10,0,-21,-10,-20,-20v0,-10,10,-19,20,-19v10,0,20,9,20,19v1,10,-10,20,-20,20","w":63,"k":{"\u2019":22,"\u201d":22," ":36}},"\/":{"d":"4,3r68,-243r26,0r-69,243r-25,0","w":101},"0":{"d":"65,-243v72,2,58,162,40,217v-7,21,-21,30,-40,30v-48,0,-52,-59,-52,-123v0,-82,17,-124,52,-124xm66,-215v-26,12,-21,41,-21,96v0,63,7,95,21,95v14,0,20,-32,20,-95v0,-37,-2,-63,-5,-76v-3,-13,-8,-20,-15,-20","w":131},"1":{"d":"50,0r0,-240r31,0r0,240r-31,0","w":131},"2":{"d":"107,-176v-3,61,-24,88,-51,145r56,0r0,31r-100,0r0,-5v42,-70,64,-125,64,-165v1,-35,-29,-50,-59,-32r0,-32v46,-25,94,5,90,58","w":131},"3":{"d":"67,-128v63,16,45,135,-20,132v-8,0,-18,-2,-30,-7r0,-30v30,18,58,-1,58,-36v0,-25,-10,-40,-31,-43r0,-31v19,-3,28,-14,28,-35v0,-30,-26,-44,-50,-29r0,-30v40,-20,82,11,82,54v0,24,-13,43,-37,55","w":131},"4":{"d":"73,0r0,-66r-63,0r0,-28r65,-149r29,0r0,155r13,0r0,22r-13,0r0,66r-31,0xm73,-88r-1,-96r-41,96r42,0","w":131},"5":{"d":"111,-73v0,51,-41,94,-92,71r0,-29v34,15,61,-5,61,-41v0,-31,-21,-48,-53,-42r0,-126r77,0r0,28r-46,0r0,71v36,5,53,27,53,68","w":131},"6":{"d":"67,4v-67,0,-53,-119,-27,-172r35,-72r31,0r-46,94v41,-10,58,31,58,72v1,37,-19,78,-51,78xm67,-117v-12,0,-18,15,-18,45v0,31,7,46,19,46v12,0,18,-17,18,-51v0,-27,-7,-40,-19,-40","w":131},"7":{"d":"35,-2r43,-210r-61,0r0,-28r98,0r-50,244","w":131},"8":{"d":"66,-243v50,0,66,92,24,118v45,24,34,129,-24,129v-59,0,-70,-107,-24,-129v-43,-26,-27,-118,24,-118xm65,-138v26,0,20,-79,0,-75v-11,0,-16,14,-16,40v0,18,3,35,16,35xm66,-26v28,0,26,-82,0,-82v-13,0,-20,13,-20,40v-1,20,4,42,20,42","w":131},"9":{"d":"68,-243v68,0,54,119,28,172r-34,71r-31,0r45,-93v-42,11,-58,-31,-58,-72v0,-38,18,-78,50,-78xm68,-121v12,0,18,-16,18,-46v0,-30,-6,-46,-18,-46v-12,0,-19,17,-19,51v0,27,7,41,19,41","w":131},":":{"d":"32,-125v-10,1,-20,-9,-20,-19v0,-10,10,-20,20,-20v10,0,20,10,20,20v0,10,-10,20,-20,19xm32,3v-10,0,-21,-10,-20,-20v0,-10,10,-19,20,-19v10,0,20,9,20,19v1,10,-10,20,-20,20","w":63,"k":{" ":36}},";":{"d":"32,-125v-10,1,-20,-9,-20,-19v0,-10,10,-20,20,-20v10,0,20,10,20,20v0,10,-10,20,-20,19xm27,-37v40,10,24,75,-14,84v5,-15,12,-27,10,-44v-23,-3,-18,-41,4,-40","w":63,"k":{" ":36}},"<":{"d":"35,-113r0,-29r170,-72r0,32r-135,55r135,55r0,31","w":240},"=":{"d":"35,-181r170,0r0,30r-170,0r0,-30xm35,-103r170,0r0,30r-170,0r0,-30","w":240},">":{"d":"205,-113r-170,72r0,-31r135,-55r-135,-55r0,-32r170,72r0,29","w":240},"?":{"d":"51,-188v2,-19,-20,-30,-37,-18v-2,-11,15,-25,20,-37v59,4,58,70,26,113v-19,26,-23,38,-25,68v-48,-29,13,-92,16,-126xm60,-17v0,10,-9,20,-19,20v-10,1,-21,-10,-20,-20v0,-10,10,-19,20,-19v9,0,19,10,19,19","w":90},"@":{"d":"152,4v-96,0,-59,-188,18,-188v16,0,30,9,42,26r3,-20r34,0r-22,145v0,5,2,8,6,8v28,-4,53,-45,53,-87v0,-61,-39,-100,-98,-100v-69,0,-116,56,-116,128v0,114,128,159,205,90r39,0v-25,34,-75,61,-129,62v-82,1,-146,-69,-146,-152v0,-86,58,-158,147,-158v76,0,128,56,128,130v0,60,-46,114,-94,116v-14,0,-24,-7,-28,-21v-14,14,-28,21,-42,21xm158,-23v32,0,41,-57,42,-98v0,-22,-9,-33,-24,-33v-30,0,-43,53,-42,92v0,21,5,39,24,39","w":365},"A":{"d":"2,0r46,-242r32,0r45,242r-30,0r-9,-53r-44,0r-10,53r-30,0xm46,-82r35,0r-18,-101","k":{"w":-9,"Y":9,"W":5,"V":5,"T":9}},"B":{"d":"127,-69v0,54,-44,75,-106,69r0,-240v56,-6,99,12,100,59v0,22,-10,39,-31,52v24,11,37,32,37,60xm90,-176v0,-23,-14,-37,-38,-36r0,73v25,2,38,-14,38,-37xm96,-68v0,-26,-16,-45,-44,-42r0,81v28,2,44,-13,44,-39","w":138},"C":{"d":"44,-120v0,70,22,123,69,77r0,33v-65,42,-101,-29,-101,-109v0,-77,33,-155,98,-112r0,31v-50,-41,-66,13,-66,80","w":119,"k":{".":-9,",":-9}},"D":{"d":"136,-121v1,85,-28,132,-116,121r0,-240v83,-7,114,23,116,119xm105,-119v0,-59,-2,-92,-54,-93r0,183v48,0,54,-35,54,-90","w":150,"k":{"Y":13,"W":9,"V":9,"A":7}},"E":{"d":"21,0r0,-240r86,0r0,28r-55,0r0,72r50,0r0,29r-50,0r0,82r58,0r0,29r-89,0","w":130},"F":{"d":"21,0r0,-240r75,0r0,28r-44,0r0,72r41,0r0,29r-41,0r0,111r-31,0","w":117,"k":{"r":11,"o":14,"i":7,"e":14,"a":11,"A":14,".":29,",":29}},"G":{"d":"91,3v-108,1,-106,-245,-3,-247v14,0,29,7,46,18r0,33v-51,-49,-93,-23,-91,73v1,68,17,102,60,93r0,-73r-21,0r0,-29r52,0r0,118v-15,9,-29,14,-43,14","w":150,"k":{".":-7,",":-9}},"H":{"d":"21,0r0,-240r31,0r0,105r46,0r0,-105r31,0r0,240r-31,0r0,-106r-46,0r0,106r-31,0","w":150},"I":{"d":"20,0r0,-240r31,0r0,240r-31,0","w":71},"J":{"d":"-12,43v26,3,35,-1,35,-30r0,-253r31,0r0,248v0,49,-22,72,-63,63","w":74},"K":{"d":"22,0r0,-240r31,0r0,240r-31,0xm97,0r-43,-122r34,-118r31,0r-38,114r47,126r-31,0"},"L":{"d":"21,0r0,-240r31,0r0,211r60,0r0,29r-91,0","w":112,"k":{"\u2019":22,"y":9,"W":11}},"M":{"d":"82,-152r36,-88r27,0r0,240r-31,0r1,-175r-30,80r-5,0r-31,-79r1,174r-30,0r0,-240r27,0","w":164},"N":{"d":"21,0r0,-240r25,0r54,148r0,-148r29,0r0,240r-25,0r-54,-150r0,150r-29,0","w":150,"k":{".":-5,",":-5}},"O":{"d":"77,-244v89,9,88,239,0,247v-88,-7,-88,-238,0,-247xm77,-25v43,-8,36,-124,24,-165v-5,-16,-14,-25,-24,-25v-30,0,-31,52,-32,95v0,46,4,87,32,95","w":153,"k":{"Y":11,"X":14,"W":11,"V":9,"T":13,"A":5}},"P":{"d":"127,-174v0,44,-28,71,-74,69r0,105r-31,0r0,-240v60,-5,106,11,105,66xm53,-134v29,2,44,-12,44,-42v0,-25,-15,-37,-44,-36r0,78","w":135,"k":{"o":14,"e":14,"a":5,"A":9,".":36,",":36}},"Q":{"d":"77,-244v84,0,83,211,22,241v17,19,24,29,42,16r6,4r-21,31v-22,-2,-42,-18,-62,-47v-68,-17,-75,-245,13,-245xm77,-25v43,-8,36,-124,24,-165v-5,-16,-14,-25,-24,-25v-30,0,-31,53,-32,95v0,46,4,87,32,95","w":153},"R":{"d":"21,-240v82,-19,118,75,65,118v21,11,34,84,44,122r-33,0v-12,-39,-12,-104,-45,-108r0,108r-31,0r0,-240xm52,-212v2,24,-4,56,2,76v17,0,26,-13,26,-37v0,-26,-10,-39,-28,-39","w":131,"k":{"Y":9,"W":7,"T":5}},"S":{"d":"92,-52v0,43,-44,70,-80,46r0,-32v16,21,50,15,50,-10v0,-46,-52,-91,-52,-141v0,-40,38,-68,75,-48r0,29v-18,-13,-46,-11,-45,15v3,46,52,91,52,141","w":101,"k":{".":-5,",":-5}},"T":{"d":"41,0r0,-212r-37,0r0,-28r105,0r0,28r-37,0r0,212r-31,0","w":112,"k":{"y":14,"w":14,"u":14,"r":14,"o":18,"e":18,"a":18,"O":13,"A":9,"-":14}},"U":{"d":"73,3v-32,1,-53,-28,-53,-62r0,-181r30,0r0,180v0,23,8,35,23,35v16,-1,22,-16,23,-33r0,-182r31,0r0,178v2,38,-22,64,-54,65","w":146},"V":{"d":"47,3r-44,-243r33,0r22,162r23,-162r32,0r-44,243r-22,0","w":116,"k":{"u":9,"o":14,"e":14,"a":7,"O":9,"A":7,"-":11}},"W":{"d":"55,3r-51,-243r32,0r29,161r33,-161r22,0r31,165r30,-165r33,0r-52,243r-21,0r-33,-161r-32,161r-21,0","w":217,"k":{"y":11,"u":14,"o":14,"e":14,"a":13,"O":11,"A":7,".":14,"-":11,",":14}},"X":{"d":"3,0r42,-128r-36,-112r33,0r22,79r21,-79r33,0r-36,112r43,128r-34,0r-28,-89r-27,89r-33,0"},"Y":{"d":"40,0r0,-110r-38,-130r32,0r22,94r22,-94r32,0r-39,130r0,110r-31,0","w":112,"k":{"u":14,"o":14,"e":14,"a":11,"O":11,"A":9,"-":22}},"Z":{"d":"6,0r55,-212r-49,0r0,-28r87,0r-55,211r55,0r0,29r-93,0","w":105},"[":{"d":"29,85r0,-325r62,0r0,26r-34,0r0,272r34,0r0,27r-62,0","w":93},"\\":{"d":"98,3r-26,0r-68,-243r25,0","w":101},"]":{"d":"65,85r-63,0r0,-27r35,0r0,-272r-35,0r0,-26r63,0r0,325","w":93},"^":{"d":"9,-121r63,-141r25,0r62,141r-32,0r-43,-105r-42,105r-33,0","w":168},"_":{"d":"-2,27r184,0r0,18r-184,0r0,-18","w":180},"`":{"d":"72,-185r-16,0r-26,-53r35,0","w":119},"a":{"d":"15,-143v28,-34,84,-25,85,22r0,90v2,14,7,9,16,1r0,22v-18,18,-36,16,-43,-9v-20,37,-63,19,-61,-19v2,-39,26,-43,60,-65v1,-18,0,-36,-16,-36v-11,0,-26,9,-41,26r0,-32xm53,-22v22,0,20,-33,19,-60v-22,13,-33,28,-33,42v-1,10,6,18,14,18","w":119,"k":{"y":9,"w":4,"v":7}},"b":{"d":"70,-164v63,3,61,164,-1,166v-9,0,-17,-3,-24,-11r0,9r-28,0r0,-240r28,0r0,89v5,-8,14,-13,25,-13xm62,-137v-31,5,-12,63,-17,97v5,10,11,16,19,16v15,0,22,-20,22,-58v0,-27,-3,-53,-24,-55","k":{"y":9,"v":7}},"c":{"d":"74,-137v-47,2,-44,115,3,115v6,0,14,-3,21,-9r0,27v-48,28,-85,-22,-85,-74v0,-52,31,-104,82,-80r0,29v-8,-5,-15,-8,-21,-8","w":101,"k":{".":-9,",":-9}},"d":{"d":"57,2v-62,-5,-60,-161,1,-166v9,0,18,4,25,13r0,-89r28,0r0,240r-28,0v-1,-4,2,-10,-1,-12v-7,10,-15,14,-25,14xm40,-78v-3,53,28,66,43,37v-4,-32,12,-92,-18,-96v-21,3,-23,30,-25,59","k":{"v":5}},"e":{"d":"63,4v-69,2,-69,-168,-6,-168v29,0,43,31,42,91r-59,0v-3,52,32,65,56,36r0,27v-10,9,-21,14,-33,14xm40,-94r31,0v0,-30,-5,-45,-16,-45v-10,0,-15,15,-15,45","w":112,"k":{"y":9,"x":5,"g":5,".":-7,",":-7}},"f":{"d":"77,-220v-31,-2,-28,30,-28,61r15,0r0,24r-15,0r0,135r-28,0r0,-135r-13,0r0,-24r13,0v-4,-50,9,-87,56,-85r0,24","w":67,"k":{"\u2019":-29,"\u201d":-29,".":-9,",":-9}},"g":{"d":"39,-44v-38,-22,-33,-118,23,-115r54,0r0,24r-21,0v19,36,8,97,-36,98v-14,0,-20,12,-11,20v8,7,54,10,58,25v24,35,-2,80,-46,80v-51,0,-74,-65,-25,-83v-25,-11,-24,-40,4,-49xm59,-59v27,-2,26,-77,0,-79v-27,2,-26,76,0,79xm90,40v0,-15,-16,-25,-31,-25v-15,0,-26,11,-26,25v0,16,12,25,28,25v14,0,29,-11,29,-25","w":119},"h":{"d":"83,-115v3,-38,-33,-21,-37,-5r0,120r-28,0r0,-240r28,0r1,96v19,-37,65,-18,65,25r0,119r-29,0r0,-115","k":{"y":7}},"i":{"d":"48,-227v0,20,-32,20,-32,0v0,-9,8,-17,16,-17v8,0,16,8,16,17xm18,0r0,-159r28,0r0,159r-28,0","w":63},"j":{"d":"45,-227v0,8,-8,16,-16,16v-8,0,-16,-7,-16,-16v0,-10,7,-17,16,-17v8,0,16,8,16,17xm-2,59v15,-3,18,-14,18,-36r0,-182r28,0r0,171v2,48,-9,67,-46,74r0,-27","w":60},"k":{"d":"17,0r0,-240r28,0r0,240r-28,0xm92,0r-44,-82r40,-77r30,0r-43,75r48,84r-31,0","w":123,"k":{"e":5}},"l":{"d":"16,0r0,-240r28,0r0,240r-28,0","w":60},"m":{"d":"108,-138v15,-38,68,-27,68,23r0,115r-28,0r0,-113v0,-34,-27,-28,-37,-5r0,118r-28,0r0,-113v-1,-33,-26,-30,-38,-5r0,118r-28,0r0,-159r28,0v1,5,-2,14,1,17v16,-28,49,-26,62,4","w":191,"k":{"y":7}},"n":{"d":"83,-114v2,-37,-37,-21,-37,-4r0,118r-28,0r0,-159r28,0r0,17v19,-37,65,-18,65,27r0,115r-28,0r0,-114","k":{"y":7,"v":5}},"o":{"d":"62,-164v68,2,68,166,0,168v-69,0,-68,-168,0,-168xm62,-137v-14,0,-21,19,-21,57v0,38,7,58,21,58v14,0,21,-20,21,-58v0,-38,-7,-57,-21,-57","w":123,"k":{"y":7,"x":9,"w":5,"v":7,"g":5}},"p":{"d":"70,-162v61,5,64,162,0,166v-9,0,-17,-5,-24,-14r0,96r-28,0r0,-245r28,0r0,11v6,-9,14,-14,24,-14xm88,-78v0,-53,-26,-72,-42,-43r0,84v6,10,12,15,19,15v15,0,23,-19,23,-56","k":{"y":7}},"q":{"d":"58,4v-61,-2,-64,-162,-1,-166v11,-1,18,6,26,14r0,-11r28,0r0,245r-28,0r-1,-95v-6,9,-14,13,-24,13xm65,-22v31,-5,14,-63,18,-97v-5,-11,-12,-16,-20,-16v-15,0,-23,19,-23,57v1,26,4,53,25,56"},"r":{"d":"77,-133v-36,12,-32,83,-31,133r-28,0r0,-159r28,0v1,14,-2,31,1,43v10,-31,14,-55,44,-41r-2,29v-4,-3,-8,-5,-12,-5","w":90,"k":{"y":-7,"v":-9,"u":-4,"t":-9,"n":-5,"l":-5,"g":5,";":-20,":":-20}},"s":{"d":"80,-37v0,37,-43,55,-70,28r0,-31v10,11,20,18,28,18v7,1,15,-7,14,-14v-1,-25,-40,-61,-40,-90v0,-33,36,-50,61,-28r0,27v-12,-10,-33,-19,-35,1v3,26,42,58,42,89","w":90,"k":{".":-7,",":-7}},"t":{"d":"52,-44v-2,21,11,27,26,17r0,25v-27,13,-54,6,-54,-29r0,-104v-6,-1,-16,3,-18,-2v14,-15,26,-42,46,-64r0,42r26,0r0,24r-26,0r0,91","w":82},"u":{"d":"44,-45v-2,35,33,20,37,4r0,-118r28,0r0,159r-28,0v-1,-5,2,-14,-1,-17v-19,37,-65,15,-65,-26r0,-116r29,0r0,114"},"v":{"d":"50,4r-48,-163r29,0r24,91r23,-91r28,0r-48,163r-8,0","w":108},"w":{"d":"45,4r-43,-163r29,0r21,85r23,-85r11,0r25,85r20,-85r28,0r-43,163r-8,0r-28,-96r-27,96r-8,0","w":161,"k":{"o":5,"e":5}},"x":{"d":"5,0r37,-81r-37,-78r30,0r22,50r21,-50r29,0r-35,78r39,81r-30,0r-24,-55r-22,55r-30,0","w":116,"k":{"e":7}},"y":{"d":"13,88r32,-116r-42,-131r29,0r27,83r23,-83r28,0r-69,247r-28,0","w":112,"k":{"e":4}},"z":{"d":"5,0r50,-135r-45,0r0,-24r84,0r-51,135r52,0r0,24r-90,0","w":101},"{":{"d":"47,21v0,-43,4,-86,-37,-84r0,-29v40,1,37,-41,37,-85v0,-51,14,-73,65,-70r0,27v-41,-6,-35,26,-35,63v0,46,-8,65,-37,79v36,12,38,53,37,105v-1,32,5,38,35,38r0,26v-51,3,-65,-19,-65,-70","w":120},"|":{"d":"81,-240r28,0r0,337r-28,0r0,-337","w":189},"}":{"d":"74,-177v0,0,-4,86,36,85r0,29v-41,-2,-36,41,-36,84v0,51,-14,73,-66,70r0,-26v40,5,36,-26,36,-63v-1,-47,7,-67,37,-80v-37,-11,-38,-52,-37,-105v0,-31,-6,-38,-36,-37r0,-27v51,-3,67,19,66,70","w":120},"~":{"d":"75,-152v20,0,70,28,87,28v15,0,32,-8,51,-25r0,26v-18,15,-35,22,-50,22v-19,0,-73,-29,-88,-28v-15,0,-33,8,-52,24r0,-25v19,-15,36,-22,52,-22","w":236},"\u00c4":{"d":"2,0r46,-242r32,0r45,242r-30,0r-9,-53r-44,0r-10,53r-30,0xm46,-82r35,0r-18,-101xm86,-267v-9,0,-16,-8,-16,-17v0,-9,7,-16,16,-16v8,0,17,7,16,16v1,9,-7,17,-16,17xm42,-267v-22,0,-19,-33,0,-33v8,0,17,8,17,16v0,9,-8,17,-17,17"},"\u00c5":{"d":"2,0r46,-242r32,0r45,242r-30,0r-9,-53r-44,0r-10,53r-30,0xm46,-82r35,0r-18,-101xm64,-257v-15,1,-28,-13,-28,-28v0,-16,14,-27,28,-27v16,0,28,11,28,27v0,16,-12,27,-28,28xm64,-267v10,0,17,-8,17,-18v0,-10,-7,-17,-17,-17v-10,0,-17,7,-17,17v0,10,7,18,17,18"},"\u00c7":{"d":"44,-120v0,70,22,123,69,77r0,33v-11,9,-22,13,-33,13r-7,16v27,7,25,45,3,58v-12,8,-28,11,-50,11r0,-20v41,5,55,-33,18,-37r13,-31v-74,-22,-59,-309,53,-231r0,31v-50,-41,-66,13,-66,80","w":119},"\u00c9":{"d":"21,0r0,-240r86,0r0,28r-55,0r0,72r50,0r0,29r-50,0r0,82r58,0r0,29r-89,0xm54,-257r7,-53r35,0r-26,53r-16,0","w":130},"\u00d1":{"d":"21,0r0,-240r25,0r54,148r0,-148r29,0r0,240r-25,0r-54,-150r0,150r-29,0xm126,-303v9,44,-42,40,-69,28v-8,0,-13,3,-16,10r-16,0v-7,-48,44,-38,73,-28v6,0,11,-4,13,-10r15,0","w":150},"\u00d6":{"d":"77,-244v89,9,88,239,0,247v-88,-7,-88,-238,0,-247xm77,-25v43,-8,36,-124,24,-165v-5,-16,-14,-25,-24,-25v-30,0,-31,52,-32,95v0,46,4,87,32,95xm99,-267v-9,0,-16,-8,-16,-17v0,-9,7,-16,16,-16v8,0,17,7,16,16v1,9,-7,17,-16,17xm55,-267v-22,0,-19,-33,0,-33v8,0,17,8,17,16v0,9,-8,17,-17,17","w":153},"\u00dc":{"d":"73,3v-32,1,-53,-28,-53,-62r0,-181r30,0r0,180v0,23,8,35,23,35v16,-1,22,-16,23,-33r0,-182r31,0r0,178v2,38,-22,64,-54,65xm95,-267v-9,0,-16,-8,-16,-17v0,-9,7,-16,16,-16v8,0,17,7,16,16v1,9,-7,17,-16,17xm51,-267v-22,0,-19,-33,0,-33v8,0,17,8,17,16v0,9,-8,17,-17,17","w":146},"\u00e1":{"d":"15,-143v28,-34,84,-25,85,22r0,90v2,14,7,9,16,1r0,22v-18,18,-36,16,-43,-9v-20,37,-63,19,-61,-19v2,-39,26,-43,60,-65v1,-18,0,-36,-16,-36v-11,0,-26,9,-41,26r0,-32xm53,-22v22,0,20,-33,19,-60v-22,13,-33,28,-33,42v-1,10,6,18,14,18xm48,-185r7,-53r35,0r-26,53r-16,0","w":119},"\u00e0":{"d":"15,-143v28,-34,84,-25,85,22r0,90v2,14,7,9,16,1r0,22v-18,18,-36,16,-43,-9v-20,37,-63,19,-61,-19v2,-39,26,-43,60,-65v1,-18,0,-36,-16,-36v-11,0,-26,9,-41,26r0,-32xm53,-22v22,0,20,-33,19,-60v-22,13,-33,28,-33,42v-1,10,6,18,14,18xm72,-185r-16,0r-26,-53r35,0","w":119},"\u00e2":{"d":"15,-143v28,-34,84,-25,85,22r0,90v2,14,7,9,16,1r0,22v-18,18,-36,16,-43,-9v-20,37,-63,19,-61,-19v2,-39,26,-43,60,-65v1,-18,0,-36,-16,-36v-11,0,-26,9,-41,26r0,-32xm53,-22v22,0,20,-33,19,-60v-22,13,-33,28,-33,42v-1,10,6,18,14,18xm23,-185r20,-54r34,0r20,54r-16,0r-21,-35r-21,35r-16,0","w":119},"\u00e4":{"d":"15,-143v28,-34,84,-25,85,22r0,90v2,14,7,9,16,1r0,22v-18,18,-36,16,-43,-9v-20,37,-63,19,-61,-19v2,-39,26,-43,60,-65v1,-18,0,-36,-16,-36v-11,0,-26,9,-41,26r0,-32xm53,-22v22,0,20,-33,19,-60v-22,13,-33,28,-33,42v-1,10,6,18,14,18xm82,-195v-9,0,-16,-8,-16,-17v0,-9,7,-16,16,-16v8,0,17,7,16,16v1,9,-7,17,-16,17xm38,-195v-22,0,-19,-33,0,-33v8,0,17,8,17,16v0,9,-8,17,-17,17","w":119},"\u00e3":{"d":"17,-143v28,-34,84,-25,85,22r0,90v2,14,7,9,16,1r0,22v-18,18,-36,16,-43,-9v-20,37,-63,19,-61,-19v2,-39,26,-43,60,-65v1,-18,0,-36,-16,-36v-11,0,-26,9,-41,26r0,-32xm55,-22v22,0,20,-33,19,-60v-22,13,-33,28,-33,42v-1,10,6,18,14,18xm112,-231v9,44,-42,40,-69,28v-8,0,-13,3,-16,10r-16,0v-7,-48,44,-38,73,-28v6,0,11,-4,13,-10r15,0","w":119},"\u00e5":{"d":"15,-143v28,-34,84,-25,85,22r0,90v2,14,7,9,16,1r0,22v-18,18,-36,16,-43,-9v-20,37,-63,19,-61,-19v2,-39,26,-43,60,-65v1,-18,0,-36,-16,-36v-11,0,-26,9,-41,26r0,-32xm53,-22v22,0,20,-33,19,-60v-22,13,-33,28,-33,42v-1,10,6,18,14,18xm60,-185v-15,1,-28,-13,-28,-28v0,-16,14,-27,28,-27v16,0,28,11,28,27v0,16,-12,27,-28,28xm60,-195v10,0,17,-8,17,-18v0,-10,-7,-17,-17,-17v-10,0,-17,7,-17,17v0,10,7,18,17,18","w":119},"\u00e7":{"d":"74,-137v-47,2,-44,115,3,115v6,0,14,-3,21,-9r0,27v-8,5,-16,8,-24,8r-7,15v28,7,26,44,3,58v-12,7,-28,11,-50,11r0,-20v41,5,55,-33,18,-37r13,-31v-66,-25,-42,-201,44,-158r0,29v-8,-5,-15,-8,-21,-8","w":101},"\u00e9":{"d":"67,4v-69,2,-69,-168,-6,-168v29,0,43,31,42,91r-59,0v-3,52,32,65,56,36r0,27v-10,9,-21,14,-33,14xm44,-94r31,0v0,-30,-5,-45,-16,-45v-10,0,-15,15,-15,45xm48,-185r7,-53r35,0r-26,53r-16,0","w":112},"\u00e8":{"d":"67,4v-69,2,-69,-168,-6,-168v29,0,43,31,42,91r-59,0v-3,52,32,65,56,36r0,27v-10,9,-21,14,-33,14xm44,-94r31,0v0,-30,-5,-45,-16,-45v-10,0,-15,15,-15,45xm72,-185r-16,0r-26,-53r35,0","w":112},"\u00ea":{"d":"67,4v-69,2,-69,-168,-6,-168v29,0,43,31,42,91r-59,0v-3,52,32,65,56,36r0,27v-10,9,-21,14,-33,14xm44,-94r31,0v0,-30,-5,-45,-16,-45v-10,0,-15,15,-15,45xm23,-185r20,-54r34,0r20,54r-16,0r-21,-35r-21,35r-16,0","w":112},"\u00eb":{"d":"67,4v-69,2,-69,-168,-6,-168v29,0,43,31,42,91r-59,0v-3,52,32,65,56,36r0,27v-10,9,-21,14,-33,14xm44,-94r31,0v0,-30,-5,-45,-16,-45v-10,0,-15,15,-15,45xm82,-195v-9,0,-16,-8,-16,-17v0,-9,7,-16,16,-16v8,0,17,7,16,16v1,9,-7,17,-16,17xm38,-195v-22,0,-19,-33,0,-33v8,0,17,8,17,16v0,9,-8,17,-17,17","w":112},"\u00ed":{"d":"18,0r0,-159r28,0r0,159r-28,0xm20,-185r7,-53r35,0r-26,53r-16,0","w":63},"\u00ec":{"d":"18,0r0,-159r28,0r0,159r-28,0xm44,-185r-16,0r-26,-53r35,0","w":63},"\u00ee":{"d":"18,0r0,-159r28,0r0,159r-28,0xm-5,-185r20,-54r34,0r20,54r-16,0r-21,-35r-21,35r-16,0","w":63},"\u00ef":{"d":"18,0r0,-159r28,0r0,159r-28,0xm54,-195v-9,0,-16,-8,-16,-17v0,-9,7,-16,16,-16v8,0,17,7,16,16v1,9,-7,17,-16,17xm10,-195v-22,0,-19,-33,0,-33v8,0,17,8,17,16v0,9,-8,17,-17,17","w":63},"\u00f1":{"d":"83,-114v2,-37,-37,-21,-37,-4r0,118r-28,0r0,-159r28,0r0,17v19,-37,65,-18,65,27r0,115r-28,0r0,-114xm114,-231v9,44,-42,40,-69,28v-8,0,-13,3,-16,10r-16,0v-7,-48,44,-38,73,-28v6,0,11,-4,13,-10r15,0"},"\u00f3":{"d":"62,-164v68,2,68,166,0,168v-69,0,-68,-168,0,-168xm62,-137v-14,0,-21,19,-21,57v0,38,7,58,21,58v14,0,21,-20,21,-58v0,-38,-7,-57,-21,-57xm50,-185r7,-53r35,0r-26,53r-16,0","w":123},"\u00f2":{"d":"62,-164v68,2,68,166,0,168v-69,0,-68,-168,0,-168xm62,-137v-14,0,-21,19,-21,57v0,38,7,58,21,58v14,0,21,-20,21,-58v0,-38,-7,-57,-21,-57xm74,-185r-16,0r-26,-53r35,0","w":123},"\u00f4":{"d":"62,-164v68,2,68,166,0,168v-69,0,-68,-168,0,-168xm62,-137v-14,0,-21,19,-21,57v0,38,7,58,21,58v14,0,21,-20,21,-58v0,-38,-7,-57,-21,-57xm25,-185r20,-54r34,0r20,54r-16,0r-21,-35r-21,35r-16,0","w":123},"\u00f6":{"d":"62,-164v68,2,68,166,0,168v-69,0,-68,-168,0,-168xm62,-137v-14,0,-21,19,-21,57v0,38,7,58,21,58v14,0,21,-20,21,-58v0,-38,-7,-57,-21,-57xm84,-195v-9,0,-16,-8,-16,-17v0,-9,7,-16,16,-16v8,0,17,7,16,16v1,9,-7,17,-16,17xm40,-195v-22,0,-19,-33,0,-33v8,0,17,8,17,16v0,9,-8,17,-17,17","w":123},"\u00f5":{"d":"62,-164v68,2,68,166,0,168v-69,0,-68,-168,0,-168xm62,-137v-14,0,-21,19,-21,57v0,38,7,58,21,58v14,0,21,-20,21,-58v0,-38,-7,-57,-21,-57xm113,-231v9,44,-42,40,-69,28v-8,0,-13,3,-16,10r-16,0v-7,-48,44,-38,73,-28v6,0,11,-4,13,-10r15,0","w":123},"\u00fa":{"d":"44,-45v-2,35,33,20,37,4r0,-118r28,0r0,159r-28,0v-1,-5,2,-14,-1,-17v-19,37,-65,15,-65,-26r0,-116r29,0r0,114xm52,-185r7,-53r35,0r-26,53r-16,0"},"\u00f9":{"d":"44,-45v-2,35,33,20,37,4r0,-118r28,0r0,159r-28,0v-1,-5,2,-14,-1,-17v-19,37,-65,15,-65,-26r0,-116r29,0r0,114xm76,-185r-16,0r-26,-53r35,0"},"\u00fb":{"d":"44,-45v-2,35,33,20,37,4r0,-118r28,0r0,159r-28,0v-1,-5,2,-14,-1,-17v-19,37,-65,15,-65,-26r0,-116r29,0r0,114xm27,-185r20,-54r34,0r20,54r-16,0r-21,-35r-21,35r-16,0"},"\u00fc":{"d":"44,-45v-2,35,33,20,37,4r0,-118r28,0r0,159r-28,0v-1,-5,2,-14,-1,-17v-19,37,-65,15,-65,-26r0,-116r29,0r0,114xm86,-195v-9,0,-16,-8,-16,-17v0,-9,7,-16,16,-16v8,0,17,7,16,16v1,9,-7,17,-16,17xm42,-195v-22,0,-19,-33,0,-33v8,0,17,8,17,16v0,9,-8,17,-17,17"},"\u2020":{"d":"64,89v-22,-7,-15,-37,-17,-74v-2,-48,12,-111,11,-153v-17,6,-28,8,-34,8v-7,0,-16,-5,-15,-13v3,-21,28,-13,49,-6v-6,-25,-9,-46,-9,-63v0,-21,5,-32,15,-32v10,0,15,11,15,32v0,16,-3,37,-10,63v15,-5,27,-7,34,-7v11,0,16,4,16,13v-8,20,-23,14,-50,5v0,35,14,114,12,153v-2,37,3,64,-17,74"},"\u00b0":{"d":"72,-165v-25,0,-49,-23,-49,-48v0,-27,23,-49,49,-49v27,0,49,23,49,49v0,24,-23,48,-49,48xm72,-184v16,0,30,-14,30,-29v0,-15,-15,-30,-30,-30v-15,0,-29,14,-29,30v0,16,13,29,29,29","w":143},"\u00a2":{"d":"73,-137v-45,2,-45,114,3,114v7,0,14,-3,21,-8r0,27v-6,4,-13,6,-19,7r0,36r-21,0r0,-36v-60,-14,-59,-151,0,-165r0,-28r21,0r0,27v6,1,12,3,16,5r0,29v-8,-5,-15,-8,-21,-8","w":101},"\u00a3":{"d":"125,-1v-33,16,-71,-16,-102,5r13,-108r-15,0r0,-28r18,0v13,-68,13,-107,76,-112r8,28v-48,1,-42,31,-53,84r21,0r0,28r-25,0r-9,75v24,-3,45,14,68,1r0,27","w":131},"\u00a7":{"d":"44,-190v-1,51,69,76,69,127v0,18,-7,34,-20,50v27,41,6,100,-39,101v-20,1,-40,-13,-39,-33v0,-9,7,-18,17,-18v13,0,20,12,15,24v0,4,3,6,9,6v12,-1,24,-17,24,-31v-1,-50,-70,-77,-70,-128v0,-19,7,-37,20,-50v-29,-40,-7,-100,38,-101v19,0,39,14,40,32v1,22,-34,26,-34,4v0,-7,5,-15,-6,-14v-14,0,-25,15,-24,31xm44,-121v-29,35,21,67,35,88v30,-36,-22,-66,-35,-88","w":123},"\u2022":{"d":"63,-82v-23,0,-44,-21,-44,-44v0,-23,21,-45,44,-45v24,0,45,21,45,45v0,23,-22,44,-45,44","w":126},"\u00b6":{"d":"-1,-184v0,-43,32,-75,76,-74r119,0r0,31r-26,0r0,299r-29,0r0,-299r-39,0r0,299r-30,0r0,-184v-42,-2,-70,-29,-71,-72","w":193},"\u00df":{"d":"87,-77v0,-30,-3,-45,-27,-47r0,-26v14,-1,21,-12,21,-36v0,-41,-36,-49,-36,-10r0,196r-28,0r0,-175v-2,-44,9,-66,44,-69v51,-4,63,83,24,104v21,7,31,30,31,69v0,46,-18,81,-57,70r0,-24v26,4,28,-22,28,-52"},"\u00ae":{"d":"133,3v-72,0,-133,-61,-133,-133v0,-71,62,-132,133,-132v71,0,132,61,132,132v0,71,-62,133,-132,133xm133,-19v59,0,111,-53,111,-111v0,-58,-52,-110,-111,-110v-59,0,-111,52,-111,110v0,58,52,111,111,111xm185,-160v0,22,-18,40,-41,40v14,1,39,45,50,64r-28,0v-19,-27,-21,-67,-68,-61r0,61r-23,0r0,-143v48,0,110,-8,110,39xm98,-136v27,0,62,4,62,-22v0,-26,-36,-21,-62,-21r0,43","w":265},"\u00a9":{"d":"133,3v-72,0,-133,-61,-133,-133v0,-71,62,-132,133,-132v71,0,132,61,132,132v0,71,-62,133,-132,133xm133,-19v59,0,111,-53,111,-111v0,-58,-52,-110,-111,-110v-59,0,-111,52,-111,110v0,58,52,111,111,111xm87,-128v-8,58,78,74,88,20r22,6v-19,80,-142,54,-134,-27v-11,-79,112,-104,131,-33r-21,5v-17,-49,-94,-25,-86,29","w":265},"\u2122":{"d":"86,-114r0,-123r-46,0r0,-21r117,0r0,21r-47,0r0,123r-24,0xm173,-114r0,-144r35,0r35,115r36,-115r35,0r0,144r-22,0r-1,-121r-38,121r-20,0r-39,-121r0,121r-21,0","w":360},"\u00b4":{"d":"48,-185r7,-53r35,0r-26,53r-16,0","w":119},"\u00a8":{"d":"82,-195v-9,0,-16,-8,-16,-17v0,-9,7,-16,16,-16v8,0,17,7,16,16v1,9,-7,17,-16,17xm38,-195v-22,0,-19,-33,0,-33v8,0,17,8,17,16v0,9,-8,17,-17,17","w":119},"\u2260":{"d":"194,-49r-109,0r-32,58r-18,-10r27,-48r-57,0r0,-20r68,0r28,-50r-96,0r0,-20r107,0r33,-59r17,10r-27,49r59,0r0,20r-70,0r-28,50r98,0r0,20","w":197},"\u00c6":{"d":"2,0r51,-240r116,0r0,28r-55,0r0,72r51,0r0,28r-51,0r0,83r58,0r0,29r-89,0r0,-95r-33,0r-20,95r-28,0xm55,-124r28,0r0,-102r-7,0","w":180},"\u00d8":{"d":"128,-199v27,62,18,198,-51,202v-16,0,-30,-8,-41,-24r-13,24r-17,-9r19,-37v-23,-61,-18,-198,52,-201v16,0,30,8,41,24r12,-24r17,9xm77,-215v-37,0,-34,85,-30,131r54,-104v-5,-18,-13,-27,-24,-27xm77,-25v37,0,34,-89,30,-133r-54,105v5,19,13,28,24,28","w":153},"\u221e":{"d":"27,-126v0,-53,67,-62,94,-17v21,-24,29,-41,59,-41v27,0,50,22,50,57v0,37,-17,59,-50,59v-31,0,-39,-17,-59,-41v-27,45,-94,37,-94,-17xm211,-125v0,-29,-25,-49,-49,-34v-7,5,-16,16,-29,33v16,22,21,36,46,38v19,2,32,-16,32,-37xm47,-126v4,38,43,33,62,0v-14,-17,-20,-25,-39,-27v-14,-2,-24,12,-23,27","w":256},"\u00b1":{"d":"35,-146r70,0r0,-70r30,0r0,70r70,0r0,30r-70,0r0,70r-30,0r0,-70r-70,0r0,-30xm35,-30r170,0r0,30r-170,0r0,-30","w":240},"\u2264":{"d":"189,-42r-179,-83r0,-22r179,-83r0,22r-156,72r156,71r0,23xm189,0r-179,0r0,-20r179,0r0,20","w":197},"\u2265":{"d":"189,-125r-179,83r0,-23r156,-71r-156,-72r0,-22r179,83r0,22xm189,0r-179,0r0,-20r179,0r0,20","w":197},"\u00a5":{"d":"41,-53r-44,0r0,-20r44,0r0,-25r-44,0r0,-21r41,0r-35,-121r32,0r22,94r21,-94r32,0r-35,121r41,0r0,21r-44,0r0,25r44,0r0,20r-44,0r0,53r-31,0r0,-53","w":112},"\u00b5":{"d":"118,-14v-2,23,-34,21,-36,0r0,74r-28,0r0,-219r28,0r0,105v0,17,6,26,18,26v12,0,18,-9,18,-26r0,-105r29,0r0,159r-29,0r0,-14","w":200},"\u2202":{"d":"114,-240v-22,3,-31,18,-40,40r-24,-11v13,-29,32,-51,64,-51v47,0,56,49,56,99v0,85,-31,163,-107,167v-34,2,-55,-26,-54,-61v3,-72,57,-105,141,-105v-1,-42,-3,-72,-36,-78xm41,-53v-3,31,34,42,58,24v29,-21,45,-61,50,-111v-70,1,-103,28,-108,87","w":177},"\u2211":{"d":"24,-262r218,0r0,29r-174,0r107,136r-114,144r183,0r0,29r-223,0r0,-33r109,-139r-106,-135r0,-31","w":256},"\u220f":{"d":"28,-262r240,0r0,338r-34,0r0,-308r-172,0r0,308r-34,0r0,-338","w":296},"\u03c0":{"d":"138,-60v-4,32,38,45,44,14r1,-8r8,0v-1,30,-17,58,-43,60v-50,-8,-33,-100,-27,-150r-41,0v-7,73,-13,116,-17,130v-7,27,-41,27,-42,1v0,-11,27,-36,26,-49r11,-82v-25,-3,-42,5,-48,22r-6,0v10,-28,20,-53,50,-53r134,0r0,31r-45,0","w":197},"\u222b":{"d":"54,-306v6,-26,52,-34,52,-3v0,21,-29,15,-37,6v-5,0,-6,5,-6,11r6,142v0,87,0,130,-19,174v-8,19,-49,19,-48,-7v1,-23,28,-14,35,-4v9,-4,9,-16,9,-35r-2,-133v1,-81,0,-109,10,-151","w":98},"\u00aa":{"d":"7,-230v20,-22,57,-17,59,14v1,18,-3,41,2,56v2,0,4,-2,7,-7r0,19v-12,11,-23,11,-30,-2v-15,20,-42,6,-41,-16v1,-24,18,-29,39,-40v0,-9,1,-18,-8,-17v-7,0,-17,6,-28,19r0,-26xm33,-160v8,1,12,-17,10,-29v-14,8,-25,23,-10,29","w":74},"\u00ba":{"d":"40,-244v44,1,45,105,-1,104v-46,-1,-46,-104,1,-104xm40,-223v-8,0,-12,11,-12,31v0,21,3,32,11,32v8,0,12,-11,12,-32v0,-20,-3,-31,-11,-31","w":78},"\u2126":{"d":"64,-137v0,51,24,89,60,105r0,32r-102,0r0,-30r65,2v-39,-23,-61,-57,-61,-113v0,-73,42,-122,116,-123v68,-1,116,52,114,123v-1,56,-24,89,-61,113r64,-1r0,29r-101,0r0,-31v38,-20,61,-52,61,-106v0,-51,-23,-100,-78,-99v-53,1,-77,46,-77,99","w":276},"\u00e6":{"d":"12,-36v1,-40,32,-43,61,-65v3,-18,-1,-36,-17,-36v-13,0,-26,8,-40,24r0,-31v21,-22,56,-29,75,-4v16,-25,49,-19,61,8v7,16,11,38,10,67r-60,0v-6,52,30,66,57,38r0,26v-24,22,-61,16,-77,-12v-21,39,-71,30,-70,-15xm134,-94v-1,-23,0,-45,-17,-45v-12,0,-16,15,-15,45r32,0xm74,-82v-20,13,-36,17,-36,41v0,26,26,26,36,6r0,-47","w":172},"\u00f8":{"d":"103,-133v18,47,12,136,-41,137v-13,0,-23,-5,-31,-15r-8,13r-14,-9r12,-20v-18,-50,-12,-135,41,-137v12,0,22,5,30,15r8,-13r15,8xm77,-123v-4,-9,-8,-14,-15,-14v-18,-5,-22,41,-21,75xm83,-99v-14,19,-24,42,-37,62v4,10,9,15,16,15v18,5,22,-43,21,-77","w":123},"\u00bf":{"d":"49,-164v10,-1,20,10,20,20v0,10,-10,20,-20,19v-10,1,-19,-10,-19,-19v0,-10,9,-20,19,-20xm39,28v0,18,21,28,37,17v2,11,-15,25,-20,37v-59,-4,-58,-70,-26,-113v19,-25,24,-38,25,-68v48,30,-16,92,-16,127","w":90},"\u00a1":{"d":"32,-164v10,0,20,10,20,20v0,10,-10,20,-20,19v-10,1,-20,-9,-20,-19v0,-10,10,-20,20,-20xm32,-92v11,8,19,105,18,130v0,29,-6,44,-18,44v-12,0,-19,-15,-19,-44v-1,-26,9,-120,19,-130","w":63},"\u00ac":{"d":"35,-181r170,0r0,108r-30,0r0,-78r-140,0r0,-30","w":240},"\u221a":{"d":"185,-328r-54,342r-87,-181r-35,17r-5,-12r52,-26r71,145r46,-287","w":197},"\u0192":{"d":"131,-159r30,0r-4,24r-30,0r-31,178v-2,41,-41,55,-78,40r6,-27v20,9,37,10,41,-16r30,-175r-29,0r3,-24r30,0v7,-39,6,-87,52,-85v9,0,20,3,32,7r-6,27v-39,-20,-41,20,-46,51","w":200},"\u2248":{"d":"57,-155v38,-2,108,73,123,1r9,0v-3,31,-20,55,-50,57v-28,2,-111,-76,-122,-2r-8,0v3,-31,19,-55,48,-56xm57,-87v38,-1,108,72,123,1r9,0v-3,31,-20,56,-50,57v-35,1,-109,-75,-122,-2r-8,0v3,-31,19,-55,48,-56","w":197},"\u2206":{"d":"117,-248r102,248r-217,0xm104,-186r-78,168r148,0","w":220},"\u00ab":{"d":"92,-80r28,84r-25,0r-28,-84r28,-83r25,0xm37,-80r27,84r-25,0r-28,-84r28,-83r25,0","w":131},"\u00bb":{"d":"95,-80r-28,-83r25,0r28,83r-28,84r-25,0xm39,-80r-27,-83r25,0r28,83r-28,84r-25,0","w":131},"\u2026":{"d":"300,3v-10,0,-21,-10,-20,-20v0,-10,10,-19,20,-19v10,0,20,9,20,19v1,10,-10,20,-20,20xm180,3v-10,0,-21,-10,-20,-20v0,-10,10,-19,20,-19v10,0,20,9,20,19v1,10,-10,20,-20,20xm60,3v-10,0,-20,-10,-19,-20v-1,-10,10,-19,19,-19v10,0,20,9,20,19v1,10,-10,20,-20,20","w":360},"\u00a0":{"w":119},"\u00c0":{"d":"2,0r46,-242r32,0r45,242r-30,0r-9,-53r-44,0r-10,53r-30,0xm46,-82r35,0r-18,-101xm76,-257r-16,0r-26,-53r35,0"},"\u00c3":{"d":"2,0r46,-242r32,0r45,242r-30,0r-9,-53r-44,0r-10,53r-30,0xm46,-82r35,0r-18,-101xm114,-303v9,44,-42,40,-69,28v-8,0,-13,3,-16,10r-16,0v-7,-48,44,-38,73,-28v6,0,11,-4,13,-10r15,0"},"\u00d5":{"d":"77,-244v89,9,88,239,0,247v-88,-7,-88,-238,0,-247xm77,-25v43,-8,36,-124,24,-165v-5,-16,-14,-25,-24,-25v-30,0,-31,52,-32,95v0,46,4,87,32,95xm127,-303v9,44,-42,40,-69,28v-8,0,-13,3,-16,10r-16,0v-7,-48,44,-38,73,-28v6,0,11,-4,13,-10r15,0","w":153},"\u0152":{"d":"94,0v-59,-1,-82,-51,-82,-116v0,-83,28,-124,84,-124r83,0r0,28r-50,0r0,72r47,0r0,28r-47,0r0,83r52,0r0,29r-87,0xm98,-28r0,-184v-38,-1,-55,30,-55,93v0,51,12,88,55,91","w":187},"\u0153":{"d":"63,4v-70,-1,-69,-167,0,-168v14,0,26,7,35,20v8,-13,18,-20,32,-20v30,0,45,31,45,91r-61,0v-3,52,32,65,57,36r0,27v-22,21,-57,18,-72,-8v-10,15,-21,22,-36,22xm147,-94v4,-32,-13,-59,-30,-36v-2,6,-3,19,-3,36r33,0xm63,-137v-15,0,-22,19,-22,57v0,39,7,58,22,58v14,0,22,-19,22,-57v0,-39,-7,-58,-22,-58","w":187},"\u2013":{"d":"182,-90r0,17r-184,0r0,-17r184,0","w":180},"\u2014":{"d":"362,-90r0,17r-364,0r0,-17r364,0","w":360},"\u201c":{"d":"89,-160v-40,-10,-24,-75,14,-84v-4,16,-13,27,-10,44v23,4,18,40,-4,40xm32,-160v-40,-10,-24,-75,14,-84v-4,16,-13,27,-10,44v24,4,19,41,-4,40","w":116,"k":{"\u2018":-14}},"\u201d":{"d":"84,-244v40,7,24,75,-14,84v5,-15,12,-27,10,-44v-23,-4,-18,-44,4,-40xm28,-244v39,11,24,75,-14,84v1,-13,13,-28,9,-44v-23,-4,-17,-41,5,-40","w":116,"k":{" ":36}},"\u2018":{"d":"35,-160v-40,-10,-24,-75,14,-84v-4,16,-13,27,-10,44v23,4,18,40,-4,40","w":63,"k":{"\u2018":4}},"\u2019":{"d":"29,-244v40,7,24,75,-14,84v5,-15,12,-27,10,-44v-23,-4,-18,-44,4,-40","w":63,"k":{"\u2019":4,"\u201d":-14,"t":16,"s":22,"r":29,"d":29," ":36}},"\u00f7":{"d":"120,-176v-10,1,-17,-9,-17,-18v0,-10,8,-18,17,-18v9,0,18,8,18,18v0,10,-9,19,-18,18xm35,-142r170,0r0,30r-170,0r0,-30xm120,-42v-10,0,-17,-9,-17,-18v0,-10,7,-18,17,-18v9,0,18,7,18,18v0,9,-9,18,-18,18","w":240},"\u25ca":{"d":"169,-134r-70,134r-21,0r-70,-134r70,-134r21,0xm147,-134r-58,-115r-59,115r59,114","w":177},"\u00ff":{"d":"17,88r32,-116r-42,-131r29,0r27,83r23,-83r28,0r-69,247r-28,0xm82,-195v-9,0,-16,-8,-16,-17v0,-9,7,-16,16,-16v8,0,17,7,16,16v1,9,-7,17,-16,17xm38,-195v-22,0,-19,-33,0,-33v8,0,17,8,17,16v0,9,-8,17,-17,17","w":112},"\u0178":{"d":"44,0r0,-110r-38,-130r32,0r22,94r22,-94r32,0r-39,130r0,110r-31,0xm82,-267v-9,0,-16,-8,-16,-17v0,-9,7,-16,16,-16v8,0,17,7,16,16v1,9,-7,17,-16,17xm38,-267v-22,0,-19,-33,0,-33v8,0,17,8,17,16v0,9,-8,17,-17,17","w":112},"\u2044":{"d":"-42,11r124,-255r22,0r-123,255r-23,0","w":63},"\u2215":{"d":"-42,11r124,-255r22,0r-123,255r-23,0","w":63},"\u20ac":{"d":"125,-6v-58,32,-115,-15,-112,-84r-15,0r3,-21r11,0r0,-16r-14,0r3,-21r12,0v1,-67,48,-116,110,-85r-5,29v-37,-26,-71,-5,-73,56r66,0r-4,21r-64,0r0,16r61,0r-4,21r-56,0v3,65,43,81,81,52r0,32","w":131},"\u2039":{"d":"25,-80r28,84r-25,0r-28,-84r28,-83r25,0","w":52},"\u203a":{"d":"27,-80r-27,-83r25,0r28,83r-28,84r-25,0","w":52},"\uf001":{"d":"76,-220v-32,-3,-28,30,-28,61r23,0r0,24r-23,0r0,135r-28,0r0,-135r-16,0r0,-24r16,0v-4,-51,10,-87,56,-85r0,24xm100,-198v-9,0,-17,-6,-17,-16v0,-22,33,-19,33,0v0,9,-6,16,-16,16xm86,0r0,-159r28,0r0,159r-28,0","w":131},"\ufb01":{"d":"76,-220v-32,-3,-28,30,-28,61r23,0r0,24r-23,0r0,135r-28,0r0,-135r-16,0r0,-24r16,0v-4,-51,10,-87,56,-85r0,24xm100,-198v-9,0,-17,-6,-17,-16v0,-22,33,-19,33,0v0,9,-6,16,-16,16xm86,0r0,-159r28,0r0,159r-28,0","w":131},"\uf002":{"d":"76,-220v-32,-3,-28,30,-28,61r23,0r0,24r-23,0r0,135r-28,0r0,-135r-16,0r0,-24r16,0v-4,-51,10,-87,56,-85r0,24xm86,0r0,-240r28,0r0,240r-28,0","w":131},"\ufb02":{"d":"76,-220v-32,-3,-28,30,-28,61r23,0r0,24r-23,0r0,135r-28,0r0,-135r-16,0r0,-24r16,0v-4,-51,10,-87,56,-85r0,24xm86,0r0,-240r28,0r0,240r-28,0","w":131},"\u2021":{"d":"69,-18v25,-9,42,-15,50,5v-1,23,-36,12,-50,6v7,26,10,48,10,64v0,21,-5,32,-15,32v-10,0,-15,-11,-15,-32v0,-17,3,-39,9,-64v-21,7,-45,16,-49,-6v6,-20,25,-13,49,-5v-2,-38,-4,-83,0,-119v-17,6,-28,8,-34,8v-8,1,-16,-6,-15,-14v4,-21,27,-13,49,-6v-6,-25,-9,-46,-9,-63v0,-21,5,-32,15,-32v10,0,15,11,15,32v0,16,-3,37,-10,63v15,-5,26,-7,34,-7v11,0,16,4,16,13v-7,21,-23,15,-50,6v3,32,4,86,0,119"},"\u00b7":{"d":"32,-100v-10,0,-20,-10,-20,-20v0,-10,10,-20,20,-19v10,-1,20,9,20,19v0,10,-10,20,-20,20","w":63},"\u2219":{"d":"32,-100v-10,0,-20,-10,-20,-20v0,-10,10,-20,20,-19v10,-1,20,9,20,19v0,10,-10,20,-20,20","w":63},"\u201a":{"d":"27,-37v40,10,24,75,-14,84v5,-15,12,-27,10,-44v-23,-3,-18,-41,4,-40","w":63},"\u201e":{"d":"84,-37v40,8,24,75,-14,84v5,-15,12,-27,10,-44v-23,-3,-18,-44,4,-40xm28,-37v39,11,24,75,-14,84v1,-13,13,-28,9,-44v-23,-3,-17,-41,5,-40","w":116},"\u2030":{"d":"15,11r123,-255r22,0r-122,255r-23,0xm39,-115v-22,0,-33,-21,-33,-64v0,-42,11,-64,33,-64v22,0,33,21,33,63v0,43,-11,65,-33,65xm39,-224v-15,3,-10,88,0,89v7,0,10,-14,10,-43v0,-25,3,-40,-10,-46xm216,2v-22,0,-34,-21,-34,-63v0,-43,12,-64,34,-64v22,0,33,21,33,63v0,43,-11,64,-33,64xm216,-106v-17,2,-12,88,0,89v9,-4,17,-87,0,-89xm138,2v-22,0,-33,-21,-33,-63v0,-43,11,-64,33,-64v22,0,33,21,33,63v0,43,-11,64,-33,64xm138,-106v-17,2,-11,88,0,89v7,0,10,-14,10,-43v0,-25,3,-40,-10,-46","w":254},"\u00c2":{"d":"2,0r46,-242r32,0r45,242r-30,0r-9,-53r-44,0r-10,53r-30,0xm46,-82r35,0r-18,-101xm27,-257r20,-54r34,0r20,54r-16,0r-21,-35r-21,35r-16,0"},"\u00ca":{"d":"21,0r0,-240r86,0r0,28r-55,0r0,72r50,0r0,29r-50,0r0,82r58,0r0,29r-89,0xm29,-257r20,-54r34,0r20,54r-16,0r-21,-35r-21,35r-16,0","w":130},"\u00c1":{"d":"2,0r46,-242r32,0r45,242r-30,0r-9,-53r-44,0r-10,53r-30,0xm46,-82r35,0r-18,-101xm52,-257r7,-53r35,0r-26,53r-16,0"},"\u00cb":{"d":"21,0r0,-240r86,0r0,28r-55,0r0,72r50,0r0,29r-50,0r0,82r58,0r0,29r-89,0xm88,-267v-9,0,-16,-8,-16,-17v0,-9,7,-16,16,-16v8,0,17,7,16,16v1,9,-7,17,-16,17xm44,-267v-22,0,-19,-33,0,-33v8,0,17,8,17,16v0,9,-8,17,-17,17","w":130},"\u00c8":{"d":"21,0r0,-240r86,0r0,28r-55,0r0,72r50,0r0,29r-50,0r0,82r58,0r0,29r-89,0xm78,-257r-16,0r-26,-53r35,0","w":130},"\u00cd":{"d":"20,0r0,-240r31,0r0,240r-31,0xm24,-257r7,-53r35,0r-26,53r-16,0","w":71},"\u00ce":{"d":"20,0r0,-240r31,0r0,240r-31,0xm-1,-257r20,-54r34,0r20,54r-16,0r-21,-35r-21,35r-16,0","w":71},"\u00cf":{"d":"20,0r0,-240r31,0r0,240r-31,0xm58,-267v-9,0,-16,-8,-16,-17v0,-9,7,-16,16,-16v8,0,17,7,16,16v1,9,-7,17,-16,17xm14,-267v-22,0,-19,-33,0,-33v8,0,17,8,17,16v0,9,-8,17,-17,17","w":71},"\u00cc":{"d":"20,0r0,-240r31,0r0,240r-31,0xm48,-257r-16,0r-26,-53r35,0","w":71},"\u00d3":{"d":"77,-244v89,9,88,239,0,247v-88,-7,-88,-238,0,-247xm77,-25v43,-8,36,-124,24,-165v-5,-16,-14,-25,-24,-25v-30,0,-31,52,-32,95v0,46,4,87,32,95xm65,-257r7,-53r35,0r-26,53r-16,0","w":153},"\u00d4":{"d":"77,-244v89,9,88,239,0,247v-88,-7,-88,-238,0,-247xm77,-25v43,-8,36,-124,24,-165v-5,-16,-14,-25,-24,-25v-30,0,-31,52,-32,95v0,46,4,87,32,95xm40,-257r20,-54r34,0r20,54r-16,0r-21,-35r-21,35r-16,0","w":153},"\u00d2":{"d":"77,-244v89,9,88,239,0,247v-88,-7,-88,-238,0,-247xm77,-25v43,-8,36,-124,24,-165v-5,-16,-14,-25,-24,-25v-30,0,-31,52,-32,95v0,46,4,87,32,95xm89,-257r-16,0r-26,-53r35,0","w":153},"\u00da":{"d":"73,3v-32,1,-53,-28,-53,-62r0,-181r30,0r0,180v0,23,8,35,23,35v16,-1,22,-16,23,-33r0,-182r31,0r0,178v2,38,-22,64,-54,65xm61,-257r7,-53r35,0r-26,53r-16,0","w":146},"\u00db":{"d":"73,3v-32,1,-53,-28,-53,-62r0,-181r30,0r0,180v0,23,8,35,23,35v16,-1,22,-16,23,-33r0,-182r31,0r0,178v2,38,-22,64,-54,65xm36,-257r20,-54r34,0r20,54r-16,0r-21,-35r-21,35r-16,0","w":146},"\u00d9":{"d":"73,3v-32,1,-53,-28,-53,-62r0,-181r30,0r0,180v0,23,8,35,23,35v16,-1,22,-16,23,-33r0,-182r31,0r0,178v2,38,-22,64,-54,65xm85,-257r-16,0r-26,-53r35,0","w":146},"\u0131":{"d":"18,0r0,-159r28,0r0,159r-28,0","w":63},"\u02c6":{"d":"23,-185r20,-54r34,0r20,54r-16,0r-21,-35r-21,35r-16,0","w":119},"\u02dc":{"d":"112,-231v9,44,-42,40,-69,28v-8,0,-13,3,-16,10r-16,0v-7,-48,44,-38,73,-28v6,0,11,-4,13,-10r15,0","w":119},"\u02c9":{"d":"25,-201r0,-23r69,0r0,23r-69,0","w":119},"\u02d8":{"d":"98,-235v5,39,-41,63,-65,34v-7,-8,-10,-19,-10,-34r18,0v1,18,7,27,19,27v11,0,18,-9,19,-27r19,0","w":119},"\u02d9":{"d":"60,-195v-22,0,-19,-33,0,-33v8,0,17,7,16,16v1,9,-7,17,-16,17","w":119},"\u02da":{"d":"60,-185v-15,1,-28,-13,-28,-28v0,-16,14,-27,28,-27v16,0,28,11,28,27v0,16,-12,27,-28,28xm60,-195v10,0,17,-8,17,-18v0,-10,-7,-17,-17,-17v-10,0,-17,7,-17,17v0,10,7,18,17,18","w":119},"\u00b8":{"d":"30,88r0,-20v41,5,53,-33,17,-37r14,-32r24,0r-8,20v28,7,24,45,2,58v-12,7,-27,11,-49,11","w":119},"\u02dd":{"d":"81,-178r8,-53r34,0r-26,53r-16,0xm32,-178r8,-53r34,0r-25,53r-17,0","w":119},"\u02db":{"d":"95,72v-47,30,-73,-23,-53,-77r22,0v-9,31,1,69,31,49r0,28","w":119},"\u02c7":{"d":"23,-239r16,0r21,35r21,-35r16,0r-20,54r-34,0","w":119},"\u0141":{"d":"21,0r0,-97r-21,30r0,-29r21,-29r0,-115r31,0r0,80r26,-36r0,29r-26,35r0,103r60,0r0,29r-91,0","w":112},"\u0142":{"d":"85,-163r-24,30r0,133r-28,0r0,-103r-25,30r0,-26r25,-31r0,-110r28,0r0,81r24,-31r0,27","w":93},"\u0160":{"d":"92,-52v0,43,-44,70,-80,46r0,-32v16,21,50,15,50,-10v0,-46,-52,-91,-52,-141v0,-40,38,-68,75,-48r0,29v-18,-13,-46,-11,-45,15v3,46,52,91,52,141xm14,-311r16,0r21,35r21,-35r16,0r-20,54r-34,0","w":101},"\u0161":{"d":"80,-37v0,37,-43,55,-70,28r0,-31v10,11,20,18,28,18v7,1,15,-7,14,-14v-1,-25,-40,-61,-40,-90v0,-33,36,-50,61,-28r0,27v-12,-10,-33,-19,-35,1v3,26,42,58,42,89xm8,-239r16,0r21,35r21,-35r16,0r-20,54r-34,0","w":90},"\u017d":{"d":"6,0r55,-212r-49,0r0,-28r87,0r-55,211r55,0r0,29r-93,0xm16,-311r16,0r21,35r21,-35r16,0r-20,54r-34,0","w":105},"\u017e":{"d":"5,0r50,-135r-45,0r0,-24r84,0r-51,135r52,0r0,24r-90,0xm14,-239r16,0r21,35r21,-35r16,0r-20,54r-34,0","w":101},"\u00a6":{"d":"81,-240r28,0r0,138r-28,0r0,-138xm81,-42r28,0r0,139r-28,0r0,-139","w":189},"\u00ad":{"d":"10,-66r0,-30r66,0r0,30r-66,0","w":108},"\u00af":{"d":"-2,-287r184,0r0,18r-184,0r0,-18","w":180},"\u00d0":{"d":"136,-121v1,85,-28,132,-116,121r0,-110r-20,0r0,-21r20,0r0,-109v83,-7,114,23,116,119xm105,-119v0,-59,-2,-92,-54,-93r0,81r30,0r0,21r-30,0r0,81v48,0,54,-35,54,-90","w":150},"\u00f0":{"d":"57,4v-68,0,-66,-162,-4,-168v9,-1,16,7,22,8v-3,-12,-7,-24,-15,-35r-26,10r-8,-12r26,-10v-6,-8,-14,-16,-21,-23v21,0,27,-2,37,14r28,-11r8,12r-27,11v34,39,55,204,-20,204xm57,-137v-14,0,-21,19,-21,57v0,39,8,58,22,58v14,0,20,-19,20,-58v0,-38,-7,-57,-21,-57","w":115},"\u00dd":{"d":"40,0r0,-110r-38,-130r32,0r22,94r22,-94r32,0r-39,130r0,110r-31,0xm44,-257r7,-53r35,0r-26,53r-16,0","w":112},"\u00fd":{"d":"13,88r32,-116r-42,-131r29,0r27,83r23,-83r28,0r-69,247r-28,0xm44,-185r7,-53r35,0r-26,53r-16,0","w":112},"\u00de":{"d":"127,-121v0,44,-27,71,-74,68r0,53r-31,0r0,-240r31,0v2,16,-4,40,2,52v43,0,73,24,72,67xm53,-81v29,2,44,-12,44,-42v0,-25,-15,-37,-44,-36r0,78","w":135},"\u00fe":{"d":"70,-162v61,5,64,162,0,166v-9,0,-17,-5,-24,-14r0,96r-28,0r0,-324r28,0r0,90v6,-9,14,-14,24,-14xm88,-78v0,-53,-26,-72,-42,-43r0,84v6,10,12,15,19,15v15,0,23,-19,23,-56"},"\u00d7":{"d":"45,-185r18,-18r57,57r57,-57r18,18r-56,57r56,57r-18,18r-57,-57r-57,57r-18,-18r57,-57","w":240},"\u00b9":{"d":"28,-118r0,-124r23,0r0,124r-23,0","w":78},"\u00b2":{"d":"27,-243v57,6,30,76,7,105r31,0r0,20r-63,0r0,-5v25,-34,37,-61,37,-81v0,-21,-17,-21,-34,-13r0,-21v9,-3,16,-5,22,-5","w":78},"\u00b3":{"d":"44,-184v34,15,17,70,-18,69v-6,0,-12,-2,-20,-5r0,-20v17,7,34,6,34,-15v0,-12,-6,-17,-18,-18r0,-20v21,1,21,-32,2,-31v-4,0,-9,2,-15,5r0,-20v39,-21,74,34,35,55","w":78},"\u00bd":{"d":"27,11r123,-255r22,0r-123,255r-22,0xm38,-118r0,-124r23,0r0,124r-23,0xm156,-125v57,7,30,76,7,105r31,0r0,20r-63,0r0,-5v25,-34,37,-61,37,-81v0,-21,-17,-21,-34,-13r0,-21v9,-3,16,-5,22,-5","w":217},"\u00bc":{"d":"35,11r124,-255r22,0r-123,255r-23,0xm37,-118r0,-124r22,0r0,124r-22,0xm170,0r0,-33r-36,0r0,-16r38,-76r21,0r0,77r8,0r0,15r-8,0r0,33r-23,0xm170,-48r0,-37r-18,37r18,0","w":217},"\u00be":{"d":"35,11r124,-255r22,0r-123,255r-23,0xm54,-184v34,15,17,71,-18,69v-6,0,-12,-2,-20,-5r0,-20v17,7,34,6,34,-15v0,-12,-6,-17,-18,-18r0,-20v22,1,22,-32,2,-31v-4,0,-9,2,-15,5r0,-20v39,-21,74,34,35,55xm170,0r0,-33r-37,0r0,-16r39,-76r21,0r0,77r8,0r0,15r-8,0r0,33r-23,0xm170,-48r0,-37r-18,37r18,0","w":217},"\u0102":{"d":"2,0r46,-242r32,0r45,242r-30,0r-9,-53r-44,0r-10,53r-30,0xm46,-82r35,0r-18,-101xm102,-304v5,39,-41,63,-65,34v-7,-8,-10,-19,-10,-34r18,0v1,18,7,27,19,27v11,0,18,-9,19,-27r19,0"},"\u0103":{"d":"15,-143v28,-34,84,-25,85,22r0,90v2,14,7,9,16,1r0,22v-18,18,-36,16,-43,-9v-20,37,-63,19,-61,-19v2,-39,26,-43,60,-65v1,-18,0,-36,-16,-36v-11,0,-26,9,-41,26r0,-32xm53,-22v22,0,20,-33,19,-60v-22,13,-33,28,-33,42v-1,10,6,18,14,18xm97,-235v5,39,-41,63,-65,34v-7,-8,-10,-19,-10,-34r18,0v1,18,7,27,19,27v11,0,18,-9,19,-27r19,0","w":119},"\u0104":{"d":"150,72v-45,30,-73,-21,-55,-72r-9,-53r-44,0r-10,53r-30,0r46,-242r32,0r45,242r-8,0v-8,29,4,63,33,44r0,28xm81,-82r-18,-101r-17,101r35,0"},"\u0105":{"d":"15,-143v28,-34,84,-25,85,22r0,90v2,14,7,9,16,1r0,22v-5,5,-10,8,-15,10v-6,30,5,60,33,42r0,28v-46,30,-74,-23,-54,-75v-3,-3,-6,-8,-7,-14v-20,37,-63,19,-61,-19v3,-37,31,-45,60,-65v1,-18,0,-36,-16,-36v-11,0,-26,9,-41,26r0,-32xm53,-22v22,-3,20,-33,19,-60v-22,13,-33,28,-33,42v0,10,7,17,14,18","w":119},"\u0106":{"d":"44,-120v0,70,22,123,69,77r0,33v-65,42,-101,-29,-101,-109v0,-77,33,-155,98,-112r0,31v-50,-41,-66,13,-66,80xm59,-257r7,-53r35,0r-26,53r-16,0","w":119},"\u0107":{"d":"74,-137v-47,2,-44,115,3,115v6,0,14,-3,21,-9r0,27v-48,28,-85,-22,-85,-74v0,-52,31,-104,82,-80r0,29v-8,-5,-15,-8,-21,-8xm48,-185r7,-53r35,0r-26,53r-16,0","w":101},"\u010c":{"d":"44,-120v0,70,22,123,69,77r0,33v-65,42,-101,-29,-101,-109v0,-77,33,-155,98,-112r0,31v-50,-41,-66,13,-66,80xm33,-312r16,0r21,35r21,-35r16,0r-20,54r-34,0","w":119},"\u010d":{"d":"74,-137v-47,2,-44,115,3,115v6,0,14,-3,21,-9r0,27v-48,28,-85,-22,-85,-74v0,-52,31,-104,82,-80r0,29v-8,-5,-15,-8,-21,-8xm25,-239r16,0r21,35r21,-35r16,0r-20,54r-34,0","w":101},"\u010e":{"d":"136,-121v1,85,-28,132,-116,121r0,-240v83,-7,114,23,116,119xm105,-119v0,-59,-2,-92,-54,-93r0,183v48,0,54,-35,54,-90xm35,-312r16,0r21,35r21,-35r16,0r-20,54r-34,0","w":150},"\u010f":{"d":"144,-240v34,6,21,64,-12,71v5,-14,9,-18,8,-38v-21,-3,-14,-36,4,-33xm57,2v-62,-5,-60,-161,1,-166v9,0,18,4,25,13r0,-89r28,0r0,240r-28,0v-1,-4,2,-10,-1,-12v-7,10,-15,14,-25,14xm40,-78v-3,53,28,66,43,37v-4,-32,12,-92,-18,-96v-21,3,-23,30,-25,59","w":171},"\u0110":{"d":"136,-121v1,85,-28,132,-116,121r0,-110r-20,0r0,-21r20,0r0,-109v83,-7,114,23,116,119xm105,-119v0,-59,-2,-92,-54,-93r0,81r30,0r0,21r-30,0r0,81v48,0,54,-35,54,-90","w":150},"\u0111":{"d":"57,2v-62,-5,-61,-161,1,-166v9,0,18,4,25,13r0,-39r-37,0r0,-22r37,0r0,-28r28,0r0,28r16,0r0,22r-16,0r0,190r-28,0v-1,-4,2,-10,-1,-12v-7,10,-15,14,-25,14xm40,-78v-3,53,28,66,43,37v-4,-32,13,-92,-18,-96v-21,3,-23,30,-25,59"},"\u0118":{"d":"135,72v-44,29,-74,-20,-55,-72r-59,0r0,-240r86,0r0,28r-55,0r0,72r50,0r0,29r-50,0r0,82r58,0r0,29r-7,0v-7,28,3,64,32,44r0,28","w":130},"\u0119":{"d":"44,0v-42,-16,-49,-164,13,-164v38,0,41,40,42,91r-59,0v-3,52,32,65,56,36r0,27v-9,9,-19,13,-30,14v-6,30,6,57,33,40r0,28v-44,30,-74,-21,-55,-72xm71,-94v0,-30,-5,-45,-16,-45v-10,0,-15,15,-15,45r31,0","w":112},"\u011a":{"d":"21,0r0,-240r86,0r0,28r-55,0r0,72r50,0r0,29r-50,0r0,82r58,0r0,29r-89,0xm27,-312r16,0r21,35r21,-35r16,0r-20,54r-34,0","w":130},"\u011b":{"d":"63,4v-69,2,-69,-168,-6,-168v29,0,43,31,42,91r-59,0v-3,52,32,65,56,36r0,27v-10,9,-21,14,-33,14xm40,-94r31,0v0,-30,-5,-45,-16,-45v-10,0,-15,15,-15,45xm20,-239r16,0r21,35r21,-35r16,0r-20,54r-34,0","w":112},"\u0139":{"d":"21,0r0,-240r31,0r0,211r60,0r0,29r-91,0xm65,-257r7,-53r35,0r-26,53r-16,0","w":112},"\u013a":{"d":"16,0r0,-240r28,0r0,240r-28,0xm14,-257r7,-53r35,0r-26,53r-16,0","w":60},"\u013d":{"d":"21,0r0,-240r31,0r0,211r60,0r0,29r-91,0xm30,-312r16,0r21,35r21,-35r16,0r-20,54r-34,0","w":112},"\u013e":{"d":"77,-240v33,6,20,64,-12,71v1,-12,10,-19,8,-38v-21,-3,-14,-36,4,-33xm16,0r0,-240r28,0r0,240r-28,0","w":104},"\u0143":{"d":"21,0r0,-240r25,0r54,148r0,-148r29,0r0,240r-25,0r-54,-150r0,150r-29,0xm62,-257r7,-53r35,0r-26,53r-16,0","w":150},"\u0144":{"d":"83,-114v2,-37,-37,-21,-37,-4r0,118r-28,0r0,-159r28,0r0,17v19,-37,65,-18,65,27r0,115r-28,0r0,-114xm52,-185r7,-53r35,0r-26,53r-16,0"},"\u0147":{"d":"21,0r0,-240r25,0r54,148r0,-148r29,0r0,240r-25,0r-54,-150r0,150r-29,0xm38,-312r16,0r21,35r21,-35r16,0r-20,54r-34,0","w":150},"\u0148":{"d":"83,-114v2,-37,-37,-21,-37,-4r0,118r-28,0r0,-159r28,0r0,17v19,-37,65,-18,65,27r0,115r-28,0r0,-114xm29,-239r16,0r21,35r21,-35r16,0r-20,54r-34,0"},"\u0150":{"d":"77,-244v89,9,88,239,0,247v-88,-7,-88,-238,0,-247xm77,-25v43,-8,36,-124,24,-165v-5,-16,-14,-25,-24,-25v-30,0,-31,52,-32,95v0,46,4,87,32,95xm89,-257r8,-53r34,0r-26,53r-16,0xm40,-257r8,-53r34,0r-25,53r-17,0","w":153},"\u0151":{"d":"62,-164v68,2,68,166,0,168v-69,0,-68,-168,0,-168xm62,-137v-14,0,-21,19,-21,57v0,38,7,58,21,58v14,0,21,-20,21,-58v0,-38,-7,-57,-21,-57xm74,-178r8,-53r34,0r-26,53r-16,0xm25,-178r8,-53r34,0r-25,53r-17,0","w":123},"\u0154":{"d":"21,-240v82,-19,118,75,65,118v21,11,34,84,44,122r-33,0v-12,-39,-12,-104,-45,-108r0,108r-31,0r0,-240xm52,-212v2,24,-4,56,2,76v17,0,26,-13,26,-37v0,-26,-10,-39,-28,-39xm55,-257r7,-53r35,0r-26,53r-16,0","w":131},"\u0155":{"d":"77,-133v-36,12,-32,83,-31,133r-28,0r0,-159r28,0v1,14,-2,31,1,43v10,-31,14,-55,44,-41r-2,29v-4,-3,-8,-5,-12,-5xm42,-185r7,-53r35,0r-26,53r-16,0","w":90},"\u0158":{"d":"21,-240v82,-19,118,75,65,118v21,11,34,84,44,122r-33,0v-12,-39,-12,-104,-45,-108r0,108r-31,0r0,-240xm52,-212v2,24,-4,56,2,76v17,0,26,-13,26,-37v0,-26,-10,-39,-28,-39xm28,-312r16,0r21,35r21,-35r16,0r-20,54r-34,0","w":131},"\u0159":{"d":"77,-133v-36,12,-32,83,-31,133r-28,0r0,-159r28,0v1,14,-2,31,1,43v10,-31,14,-55,44,-41r-2,29v-4,-3,-8,-5,-12,-5xm18,-239r16,0r21,35r21,-35r16,0r-20,54r-34,0","w":90},"\u015a":{"d":"92,-52v0,43,-44,70,-80,46r0,-32v16,21,50,15,50,-10v0,-46,-52,-91,-52,-141v0,-40,38,-68,75,-48r0,29v-18,-13,-46,-11,-45,15v3,46,52,91,52,141xm36,-257r7,-53r35,0r-26,53r-16,0","w":101},"\u015b":{"d":"80,-37v0,37,-43,55,-70,28r0,-31v10,11,20,18,28,18v7,1,15,-7,14,-14v-1,-25,-40,-61,-40,-90v0,-33,36,-50,61,-28r0,27v-12,-10,-33,-19,-35,1v3,26,42,58,42,89xm31,-185r7,-53r35,0r-26,53r-16,0","w":90},"\u015e":{"d":"48,18v34,6,21,64,-12,71v5,-14,8,-18,8,-37v-21,-2,-14,-37,4,-34xm92,-52v0,43,-44,70,-80,46r0,-32v16,21,50,15,50,-10v0,-46,-52,-91,-52,-141v0,-40,38,-68,75,-48r0,29v-18,-13,-46,-11,-45,15v3,46,52,91,52,141","w":101},"\u015f":{"d":"43,18v33,6,20,64,-12,71v2,-12,10,-18,8,-37v-21,-2,-14,-37,4,-34xm80,-37v0,37,-43,55,-70,28r0,-31v10,11,20,18,28,18v7,1,15,-7,14,-14v-1,-25,-40,-61,-40,-90v0,-33,36,-50,61,-28r0,27v-12,-10,-33,-19,-35,1v3,26,42,58,42,89","w":90},"\u0162":{"d":"55,18v33,6,20,64,-12,71v2,-12,10,-18,8,-37v-21,-2,-14,-37,4,-34xm41,0r0,-212r-37,0r0,-28r105,0r0,28r-37,0r0,212r-31,0","w":112},"\u0163":{"d":"50,18v34,8,21,64,-12,71v5,-14,10,-18,9,-37v-20,-2,-15,-34,3,-34xm52,-44v-2,21,11,27,26,17r0,25v-27,13,-54,6,-54,-29r0,-104v-6,-1,-16,3,-18,-2v14,-15,26,-42,46,-64r0,42r26,0r0,24r-26,0r0,91","w":82},"\u0164":{"d":"41,0r0,-212r-37,0r0,-28r105,0r0,28r-37,0r0,212r-31,0xm19,-312r16,0r21,35r21,-35r16,0r-20,54r-34,0","w":112},"\u0165":{"d":"99,-211v35,5,21,64,-12,71v5,-14,9,-18,8,-38v-21,-3,-14,-36,4,-33xm52,-44v-2,21,11,27,26,17r0,25v-27,13,-54,6,-54,-29r0,-104v-6,-1,-16,3,-18,-2v14,-15,26,-42,46,-64r0,42r26,0r0,24r-26,0r0,91","w":126},"\u016e":{"d":"73,3v-32,1,-53,-28,-53,-62r0,-181r30,0r0,180v0,23,8,35,23,35v16,-1,22,-16,23,-33r0,-182r31,0r0,178v2,38,-22,64,-54,65xm73,-257v-15,1,-28,-13,-28,-28v0,-16,14,-27,28,-27v16,0,28,11,28,27v0,16,-12,27,-28,28xm73,-267v10,0,17,-8,17,-18v0,-10,-7,-17,-17,-17v-10,0,-17,7,-17,17v0,10,7,18,17,18","w":146},"\u016f":{"d":"44,-45v-2,35,33,20,37,4r0,-118r28,0r0,159r-28,0v-1,-5,2,-14,-1,-17v-19,37,-65,15,-65,-26r0,-116r29,0r0,114xm62,-185v-15,1,-28,-13,-28,-28v0,-16,14,-27,28,-27v16,0,28,11,28,27v0,16,-12,27,-28,28xm62,-195v10,0,17,-8,17,-18v0,-10,-7,-17,-17,-17v-10,0,-17,7,-17,17v0,10,7,18,17,18"},"\u0170":{"d":"73,3v-32,1,-53,-28,-53,-62r0,-181r30,0r0,180v0,23,8,35,23,35v16,-1,22,-16,23,-33r0,-182r31,0r0,178v2,38,-22,64,-54,65xm85,-257r8,-53r34,0r-26,53r-16,0xm36,-257r8,-53r34,0r-25,53r-17,0","w":146},"\u0171":{"d":"44,-45v-2,35,33,20,37,4r0,-118r28,0r0,159r-28,0v-1,-5,2,-14,-1,-17v-19,37,-65,15,-65,-26r0,-116r29,0r0,114xm74,-178r8,-53r34,0r-26,53r-16,0xm25,-178r8,-53r34,0r-25,53r-17,0"},"\u0179":{"d":"6,0r55,-212r-49,0r0,-28r87,0r-55,211r55,0r0,29r-93,0xm43,-257r7,-53r35,0r-26,53r-16,0","w":105},"\u017a":{"d":"5,0r50,-135r-45,0r0,-24r84,0r-51,135r52,0r0,24r-90,0xm40,-185r7,-53r35,0r-26,53r-16,0","w":101},"\u017b":{"d":"6,0r55,-212r-49,0r0,-28r87,0r-55,211r55,0r0,29r-93,0xm53,-267v-22,0,-19,-33,0,-33v8,0,17,7,16,16v1,9,-7,17,-16,17","w":105},"\u017c":{"d":"5,0r50,-135r-45,0r0,-24r84,0r-51,135r52,0r0,24r-90,0xm51,-195v-22,0,-19,-33,0,-33v8,0,17,7,16,16v1,9,-7,17,-16,17","w":101},"\u00a4":{"d":"73,-180v29,-21,67,-21,95,0r22,-23r16,16r-22,23v22,25,21,70,0,95r22,22r-16,16r-23,-22v-24,22,-69,21,-94,0r-23,22r-16,-16r23,-22v-22,-25,-21,-69,0,-95r-23,-23r16,-16xm120,-59v31,1,59,-27,58,-58v0,-31,-27,-57,-58,-57v-31,0,-57,26,-57,57v0,31,26,58,57,58","w":240}}});
