/*!
 * The following copyright notice may not be removed under any circumstances.
 * 
 * Copyright:
 * Digitized data copyright The Monotype Corporation 1991-1997. All rights
 * reserved. Twentieth Century is a trademark of The Monotype Corporation which may
 * be registered in certain jurisdictions.
 * 
 * Trademark:
 * Twentieth Century is a trademark of The Monotype Corporation which may be
 * registered in certain jurisdictions.
 * 
 * Description:
 * 20th Century was designed and drawn by Sol Hess in the Lanston Monotype drawing
 * office between 1936 and 1947. The first weights were added to the Monotype
 * typeface library in 1959. This is a face based on geometric shapes which
 * originated in Germany in the early 1920's and became an integral part of the
 * Bauhaus movement of that time. Form and function became the key words,
 * unnecessary decoration was scorned. This clean cut, sans serif with geometric
 * shapes was most appropriate. The lighter weights can be used for text setting,
 * the bold and condensed fonts are suitable for display in headlines and
 * advertising.
 * 
 * Manufacturer:
 * Monotype Typography
 * 
 * Designer:
 * Sol Hess
 * 
 * Vendor URL:
 * http://www.monotype.com/html/mtname/ms_welcome.html
 */
Cufon.registerFont({"w":131,"face":{"font-family":"Tw Cen MT Condensed","font-weight":400,"font-stretch":"normal","units-per-em":"360","panose-1":"2 11 6 6 2 1 4 2 2 3","ascent":"288","descent":"-72","x-height":"2","bbox":"-63 -330 364 87","underline-thickness":"21.0938","underline-position":"-16.5234","unicode-range":"U+0020-U+F002"},"glyphs":{" ":{"w":65},"!":{"d":"52,-53r-30,0r0,-172r30,0r0,172xm21,-15v0,-9,7,-17,16,-17v10,0,17,7,17,17v0,10,-7,16,-17,16v-10,1,-16,-6,-16,-16","w":67},"\"":{"d":"111,-258v2,35,-3,64,-8,92r-20,0v-5,-28,-10,-57,-8,-92r36,0xm53,-258v2,35,-3,64,-8,92r-20,0v-5,-28,-10,-57,-8,-92r36,0","w":127},"#":{"d":"225,-63r-57,0r-15,71r-22,0r16,-71r-75,0r-15,71r-21,0r14,-71r-34,0r0,-21r39,0r14,-65r-53,0r0,-22r57,0r15,-71r22,0r-16,71r74,0r15,-71r22,0r-15,71r35,0r0,22r-40,0r-13,65r53,0r0,21xm164,-149r-74,0r-14,64r75,0","w":240},"$":{"d":"61,-101v-28,-18,-47,-32,-47,-70v0,-34,16,-52,47,-56r0,-16r12,0r0,16v25,0,41,11,48,33r-26,13v-4,-13,-11,-19,-21,-20r0,71v32,23,47,29,49,70v2,35,-17,60,-49,62r0,20r-13,0r0,-20v-28,0,-36,-12,-45,-34r24,-12v4,11,11,19,21,20r0,-77xm61,-139r0,-62v-25,7,-23,52,0,62xm74,-25v25,-8,26,-56,0,-67r0,67"},"%":{"d":"199,-230r-123,243r-17,0r122,-243r18,0xm25,-158v0,-45,5,-66,34,-71v32,4,35,26,35,74v0,44,-6,67,-36,71v-31,-5,-33,-28,-33,-74xm60,-210v-19,8,-13,42,-13,68v0,21,-1,36,11,39v15,-4,14,-25,14,-49v0,-32,3,-50,-12,-58xm196,11v-46,0,-38,-116,-21,-133v35,-34,57,8,57,63v0,47,-12,70,-36,70xm197,-9v20,-8,7,-41,13,-67v-2,-21,3,-36,-11,-39v-15,4,-14,23,-14,47v0,35,-5,51,12,59","w":247},"&":{"d":"78,-208v59,0,52,67,10,100r30,50v7,-9,13,-17,17,-25r19,12v-8,15,-16,26,-22,34r23,36r-34,0r-9,-14v-38,34,-94,13,-94,-36v0,-18,12,-37,35,-59v-30,-39,-27,-98,25,-98xm78,-185v-26,6,-20,33,-4,54v13,-16,20,-29,20,-38v0,-10,-7,-16,-16,-16xm67,-86v-26,19,-23,62,6,62v8,0,17,-4,26,-12","w":164},"'":{"d":"53,-258v2,35,-3,64,-9,92r-20,0v-5,-28,-10,-57,-8,-92r37,0","w":68},"(":{"d":"65,-222v-44,92,-42,196,0,278r-22,12v-45,-77,-47,-220,-1,-301","w":67},")":{"d":"8,55v41,-78,41,-198,0,-276r22,-12v44,77,45,223,-1,300","w":67},"*":{"d":"66,-184v10,4,37,-46,44,-13v5,21,-34,8,-39,23v10,6,40,2,39,19v0,7,-6,12,-12,12v-12,1,-22,-29,-33,-25v1,14,23,43,-3,45v-24,-3,3,-35,-4,-47v-8,7,-38,47,-43,14v-3,-19,35,-5,39,-22v-11,-6,-39,-1,-39,-19v0,-6,7,-11,13,-11v11,-3,23,32,32,24v0,-12,-21,-45,2,-45v25,0,3,30,4,45","w":118},"+":{"d":"216,-105r-85,0r0,84r-23,0r0,-84r-84,0r0,-23r84,0r0,-84r23,0r0,84r85,0r0,23","w":240},",":{"d":"62,-32r-34,79r-14,-4r25,-84","w":67,"k":{"\u2019":8,"\u201d":18}},"-":{"d":"73,-67r-58,0r0,-22r58,0r0,22","w":82},".":{"d":"19,-17v0,-10,7,-17,17,-17v10,0,19,6,19,17v-1,9,-8,18,-18,18v-10,0,-19,-9,-18,-18","w":67,"k":{"\u2019":21,"\u201d":27}},"\/":{"d":"92,-232r-67,300r-15,0r68,-300r14,0","w":97},"0":{"d":"68,-228v49,6,52,47,52,115v0,69,1,108,-52,115v-53,-8,-50,-53,-50,-121v0,-63,1,-101,50,-109xm49,-138v0,46,-10,105,19,114v13,-1,18,-11,18,-27v0,-51,19,-134,-18,-150v-21,5,-19,31,-19,63"},"1":{"d":"83,0r-29,0r0,-200r-19,0r0,-24r48,0r0,224"},"2":{"d":"68,-201v-22,2,-19,23,-21,49r-29,0v0,-55,9,-75,52,-75v74,0,42,94,19,142r-28,58r50,0r0,27r-98,0r46,-90v15,-33,25,-49,27,-84v0,-15,-4,-27,-18,-27"},"3":{"d":"70,-228v58,-7,63,94,25,110v39,19,33,133,-30,120v-38,0,-47,-21,-47,-60r28,0v0,23,7,34,20,34v18,-1,21,-15,21,-37v0,-34,-4,-42,-33,-44r0,-26v27,-1,32,-8,33,-36v0,-20,-2,-34,-18,-34v-17,0,-16,13,-17,33r-29,0v-1,-41,11,-56,47,-60"},"4":{"d":"119,-62r-13,0r0,62r-29,0r0,-62r-59,0r0,-28r60,-137r28,0r0,138r13,0r0,27xm77,-89v-1,-26,2,-56,-1,-80r-35,80r36,0"},"5":{"d":"85,-76v0,-34,-24,-52,-59,-41r16,-107r74,0r0,27r-50,0r-8,51v38,4,58,26,58,68v0,57,-50,103,-102,70r9,-27v29,23,62,-2,62,-41"},"6":{"d":"67,2v-79,0,-47,-138,-21,-184r21,-42r34,0r-28,54r-14,34v40,-15,62,13,60,64v-2,48,-9,74,-52,74xm69,-113v-20,0,-19,21,-19,44v1,26,0,43,19,45v17,3,18,-29,18,-54v0,-23,-2,-35,-18,-35"},"7":{"d":"126,-224r-65,224r-29,0r56,-196r-60,0r0,-28r98,0"},"8":{"d":"66,-227v58,-11,61,91,23,106v44,16,42,123,-22,123v-33,0,-49,-21,-49,-64v0,-32,8,-49,29,-59v-38,-12,-34,-115,19,-106xm52,-168v0,21,-1,35,15,35v17,0,17,-15,17,-36v0,-19,-1,-32,-16,-32v-16,0,-16,13,-16,33xm68,-107v-28,1,-26,85,1,83v11,0,17,-12,17,-36v0,-26,1,-44,-18,-47"},"9":{"d":"69,-227v61,-5,53,85,43,134v-6,28,-29,66,-42,93r-33,0v17,-32,39,-82,41,-88v-41,16,-60,-13,-60,-62v0,-49,8,-74,51,-77xm68,-111v23,0,19,-22,19,-49v0,-27,-6,-42,-20,-41v-15,1,-18,16,-17,36v1,31,-4,54,18,54"},":":{"d":"37,-118v10,0,18,9,18,19v0,10,-8,17,-18,17v-11,0,-18,-7,-18,-18v0,-9,8,-18,18,-18xm37,-35v10,0,18,9,18,18v0,9,-7,19,-18,18v-10,0,-17,-7,-17,-17v0,-9,7,-19,17,-19","w":67},";":{"d":"44,-120v9,0,19,8,18,17v1,10,-8,20,-18,19v-10,1,-17,-9,-18,-18v0,-9,9,-18,18,-18xm58,-33r-33,79r-14,-5r24,-83","w":67},"<":{"d":"215,-26r-190,-80r0,-21r190,-80r0,25r-159,65r159,66r0,25","w":240},"=":{"d":"216,-147r-192,0r0,-23r192,0r0,23xm216,-65r-192,0r0,-23r192,0r0,23","w":240},">":{"d":"215,-106r-191,80r0,-25r160,-65r-160,-66r0,-25r191,80r0,21","w":240},"?":{"d":"62,-205v-16,0,-15,12,-16,32r-26,0v-2,-39,9,-55,38,-55v38,0,45,15,45,55v-1,40,1,68,-33,73r0,47r-25,0r0,-64v33,1,34,-21,33,-56v-1,-19,0,-32,-16,-32xm57,-31v10,-1,17,7,17,16v0,20,-34,21,-33,1v0,-9,8,-17,16,-17","w":116},"@":{"d":"199,50v54,0,104,-23,123,-53r31,0v-23,44,-81,79,-155,79v-104,0,-179,-57,-177,-158v2,-105,65,-180,173,-180v84,0,149,61,151,134v2,62,-51,128,-105,129v-25,0,-32,-9,-35,-30v-42,58,-117,21,-117,-50v0,-78,93,-156,144,-79r6,-27r31,0r-30,145v0,7,5,12,12,12v35,-8,68,-52,68,-98v0,-65,-59,-111,-126,-111v-83,0,-147,68,-147,152v0,89,62,135,153,135xm180,-165v-42,0,-83,85,-49,125v38,45,91,-22,91,-73v0,-29,-15,-52,-42,-52","w":365},"A":{"d":"139,0r-29,0r-8,-44r-47,0r-9,44r-28,0r48,-224r25,0xm98,-67r-20,-106r-19,106r39,0","w":150,"k":{"\u2019":27,"\u201d":33,"y":18,"w":18,"v":18,"u":3,"p":6,"Y":18,"W":15,"V":21,"U":12,"T":15,"Q":9,"O":12,"G":9,"C":9}},"B":{"d":"119,-56v0,52,-40,61,-94,56r0,-224v54,-3,91,3,91,58v0,28,-10,46,-32,54v24,5,35,24,35,56xm55,-123v37,6,40,-48,26,-69v-4,-7,-13,-9,-26,-9r0,78xm55,-23v40,8,38,-49,25,-69v-4,-6,-13,-9,-25,-9r0,78","k":{"\u00dc":9,"\u00c5":9,"\u00c4":9,"U":9,"A":9,".":12,",":24}},"C":{"d":"56,-113v0,57,11,102,61,82r0,27v-64,20,-93,-22,-93,-102v0,-84,21,-133,93,-118r0,27v-49,-14,-61,24,-61,84","k":{".":6,",":15}},"D":{"d":"136,-113v0,88,-21,121,-110,113r0,-224v84,-7,110,22,110,111xm104,-113v0,-56,0,-87,-48,-88r0,178v49,-1,48,-36,48,-90","w":150,"k":{"\u00c5":15,"\u00c4":15,"Y":15,"W":6,"V":3,"A":15,".":21,",":27}},"E":{"d":"106,0r-81,0r0,-224r79,0r0,26r-49,0r0,71r46,0r0,25r-46,0r0,77r51,0r0,25","w":116},"F":{"d":"106,-198r-52,0r0,70r46,0r0,26r-46,0r0,102r-30,0r0,-224r82,0r0,26","w":116,"k":{"\u00f6":6,"\u00e5":6,"\u00e4":6,"\u00c5":18,"\u00c4":18,"r":6,"o":6,"e":12,"a":6,"A":18,".":33,",":45}},"G":{"d":"54,-131v0,48,-8,130,45,102v11,-15,10,-30,10,-62r-27,0r0,-26r57,0v2,62,1,122,-60,119v-53,-3,-56,-39,-56,-107v0,-55,-1,-127,60,-123v28,2,53,19,54,47r-29,10v-2,-22,-11,-32,-25,-32v-30,0,-29,33,-29,72","w":150,"k":{".":12,",":24}},"H":{"d":"25,-224r30,0r0,87r47,0r0,-87r30,0r0,224r-30,0r0,-111r-47,0r0,111r-30,0r0,-224","w":150},"I":{"d":"29,-224r30,0r0,224r-30,0r0,-224","w":82},"J":{"d":"9,-28v22,10,42,8,42,-17r0,-179r30,0r0,184v1,41,-32,50,-72,39r0,-27","w":97,"k":{"\u00fc":3,"\u00f6":3,"\u00e5":6,"\u00e4":6,"\u00c5":6,"\u00c4":6,"y":3,"u":3,"o":3,"e":6,"a":6,"A":6,";":12,":":6,".":9,",":18}},"K":{"d":"140,0r-35,0r-49,-114r0,114r-31,0r0,-224r31,0r1,111r52,-111r30,0r-54,109","w":150,"k":{"\u00fc":12,"\u00f6":12,"\u00e5":12,"\u00e4":12,"\u00d6":15,"y":21,"w":27,"v":27,"u":12,"o":12,"e":12,"a":12,"O":15,"G":15,"C":18}},"L":{"d":"105,0r-81,0r0,-224r30,0r0,199r51,0r0,25","w":116,"k":{"\u2019":21,"\u201d":24,"\u00dc":15,"\u00d6":15,"y":9,"w":12,"Y":18,"W":15,"V":12,"U":15,"T":15,"O":15,"G":15,"C":15}},"M":{"d":"175,0r-28,0r-12,-143r-30,143r-19,0r-30,-143r-12,143r-28,0r22,-224r26,0r32,157r32,-157r26,0","w":183},"N":{"d":"131,0r-24,0r-58,-154r0,154r-27,0r0,-224r24,0r58,154r0,-154r27,0r0,224","w":150,"k":{"\u00c5":3,"\u00c4":3,"A":3,".":9,",":21}},"O":{"d":"85,1v-62,0,-62,-42,-62,-114v0,-80,2,-116,62,-116v61,0,62,39,62,111v0,75,1,119,-62,119xm85,-22v32,-5,30,-37,30,-89v0,-62,5,-85,-30,-94v-35,3,-30,46,-30,91v0,49,-5,86,30,92","w":164,"k":{"\u00c5":12,"\u00c4":12,"Y":12,"X":9,"W":6,"V":6,"T":6,"A":12,".":18,",":30}},"P":{"d":"121,-160v-2,45,-18,65,-68,62r0,98r-30,0r0,-224v59,-3,100,-1,98,64xm53,-122v42,10,42,-48,29,-70v-4,-7,-15,-9,-29,-9r0,79","k":{"\u00e5":9,"\u00c5":27,"\u00c4":27,"o":9,"e":15,"a":9,"A":27,".":45,",":57}},"Q":{"d":"87,-229v58,0,61,40,61,117v0,51,-6,84,-17,97r16,23r-16,12r-17,-22v-72,17,-94,-22,-91,-101v3,-76,-2,-126,64,-126xm55,-125v0,74,-10,104,43,101r-21,-28r17,-13r16,22v4,-8,5,-29,5,-66v0,-62,6,-86,-29,-95v-32,5,-31,35,-31,79","w":164,"k":{"Y":3,"W":6,"V":3,"U":6,"T":9,"A":6,".":9,",":9}},"R":{"d":"117,-167v0,34,-8,51,-32,59r38,108r-31,0r-35,-105r-3,0r0,105r-30,0r0,-224v54,-3,93,1,93,57xm88,-163v0,-25,-9,-38,-34,-38r0,75v26,-1,33,-10,34,-37","k":{"\u00fc":3,"\u00f6":9,"\u00e5":6,"\u00e4":6,"\u00dc":3,"\u00d6":3,"y":3,"w":3,"v":3,"u":3,"o":9,"e":9,"a":6,"Y":3,"W":3,"V":3,"U":3,"T":3,"Q":6,"O":3,"G":6,"C":6}},"S":{"d":"38,-118v-37,-31,-28,-112,28,-109v11,0,21,2,32,7r0,25v-24,-16,-57,-7,-55,21v4,46,63,66,63,120v0,46,-43,69,-87,49v1,-8,-2,-21,1,-27v17,16,60,12,58,-21v-2,-29,-27,-44,-40,-65","w":116,"k":{".":9,",":24}},"T":{"d":"110,-198r-34,0r0,198r-30,0r0,-198r-34,0r0,-26r98,0r0,26","w":116,"k":{"\u00e5":15,"\u00d6":9,"\u00c5":12,"\u00c4":12,"z":12,"y":15,"w":24,"u":15,"s":24,"r":15,"o":15,"m":18,"l":6,"h":6,"e":21,"c":18,"a":15,"Q":12,"O":9,"G":9,"C":12,"A":12,";":18,":":15,".":24,"-":15,",":33}},"U":{"d":"79,-20v25,0,22,-19,22,-47r0,-157r30,0r0,171v0,37,-16,56,-50,56v-37,0,-56,-19,-56,-56r0,-171r30,0r0,159v2,28,0,45,24,45","w":150,"k":{"\u00c5":9,"\u00c4":9,"A":9,".":15,",":27}},"V":{"d":"10,-224r30,0r28,170r30,-170r29,0r-47,224r-24,0","k":{"\u00e5":18,"\u00d6":9,"\u00c5":18,"\u00c4":18,"y":6,"u":9,"r":6,"o":12,"i":6,"e":21,"a":18,"Q":9,"O":9,"G":9,"C":9,"A":18,";":24,":":12,".":27,"-":18,",":39}},"W":{"d":"192,-224r-39,224r-24,0r-28,-158r-26,158r-24,0r-37,-224r26,0r26,155r26,-155r21,0r26,154r26,-154r27,0","w":198,"k":{"\u00e5":12,"\u00d6":9,"\u00c5":15,"\u00c4":15,"y":6,"u":6,"r":3,"o":9,"e":15,"d":12,"a":12,"O":9,"G":9,"C":6,"A":15,";":24,":":18,".":27,"-":9,",":33}},"X":{"d":"126,0r-29,0r-29,-77r-30,77r-29,0r44,-115r-41,-109r29,0r27,70r27,-70r29,0r-42,109","k":{"\u00d6":9,"O":9,"G":9,"C":12}},"Y":{"d":"127,-224r-44,129r0,95r-30,0r0,-94r-43,-130r30,0r29,101r28,-101r30,0","k":{"\u00e5":18,"\u00d6":9,"\u00c5":15,"\u00c4":15,"v":6,"u":9,"q":15,"p":15,"o":18,"i":4,"e":24,"d":15,"a":18,"S":-3,"O":9,"G":6,"C":9,"A":15,";":21,":":18,".":27,"-":21,",":36}},"Z":{"d":"122,-224r-71,199r64,0r0,25r-101,0r71,-198r-62,0r0,-26r99,0"},"[":{"d":"77,63r-52,0r0,-290r52,0r0,20r-29,0r0,250r29,0r0,20","w":82},"\\":{"d":"86,68r-13,0r-68,-300r14,0","w":97},"]":{"d":"64,64r-52,0r0,-21r28,0r0,-250r-28,0r0,-20r52,0r0,291","w":82},"^":{"d":"159,-121r-32,0r-43,-105r-42,105r-33,0r63,-141r25,0","w":168},"_":{"d":"182,45r-184,0r0,-18r184,0r0,18","w":180},"`":{"d":"82,-173r-26,0r-41,-49r43,0","w":119},"a":{"d":"57,-156v16,0,21,8,29,19r0,-17r29,0r0,154r-29,0r0,-19v-7,14,-17,21,-29,21v-32,0,-38,-28,-38,-77v0,-46,2,-81,38,-81xm69,-131v-30,-3,-18,73,-16,94v1,9,7,14,15,14v22,0,18,-27,18,-58v0,-28,3,-48,-17,-50","k":{"w":6,"v":9,"g":5}},"b":{"d":"119,-83v0,54,0,80,-38,85v-13,1,-21,-10,-30,-23r0,21r-29,0r0,-232r29,0r1,99v5,-15,15,-23,30,-23v31,0,37,29,37,73xm70,-23v19,-2,18,-23,18,-48v0,-33,2,-56,-19,-61v-18,2,-18,22,-18,47v0,33,-2,57,19,62","k":{"y":6,"w":9,"v":6,".":9,",":24}},"c":{"d":"89,-126v-32,-17,-41,15,-40,51v1,45,11,61,41,47r0,23v-49,23,-72,-15,-72,-73v0,-56,22,-90,71,-73r0,25","w":97,"k":{".":3,",":12}},"d":{"d":"20,-72v0,-49,-1,-79,38,-84v13,-1,20,8,29,20r0,-96r29,0r0,232r-28,0v-1,-6,2,-16,-1,-21v-7,15,-17,23,-30,23v-35,0,-37,-31,-37,-74xm69,-22v19,-5,19,-28,19,-57v0,-29,2,-49,-19,-52v-20,3,-19,24,-19,53v0,31,-1,51,19,56","k":{"y":3,"w":6,"v":6}},"e":{"d":"70,-156v39,0,47,33,46,84r-65,0v2,27,-2,48,20,51v16,-1,16,-13,17,-31r26,0v-1,36,-16,54,-46,54v-32,0,-47,-25,-47,-75v0,-55,16,-83,49,-83xm87,-94v5,-32,-16,-58,-32,-32v-2,7,-4,17,-4,32r36,0","k":{"y":6,"x":9,"w":12,"v":9,"p":6,"g":6,"b":4,".":18,",":24}},"f":{"d":"78,-204v-13,-6,-24,1,-24,20r0,30r24,0r0,22r-24,0r0,132r-28,0r0,-132r-16,0r0,-22r16,0v-4,-46,5,-93,52,-75r0,25","w":82,"k":{"\u2019":-21,"\u201d":-21,"e":3,"?":-9,".":12,",":21,"!":-9," ":-27}},"g":{"d":"56,-156v19,-2,20,9,30,18r0,-16r29,0r0,174v8,48,-58,55,-84,35v-8,-6,-11,-18,-11,-36r28,0v-3,30,38,34,38,6v-1,-15,2,-33,-1,-46v-6,15,-15,23,-29,23v-34,0,-36,-29,-36,-82v0,-49,2,-72,36,-76xm69,-133v-28,0,-17,74,-15,95v1,9,7,14,15,14v20,0,17,-21,17,-48v0,-36,5,-55,-17,-61","k":{"\u00f6":6,"\u00e5":6,"\u00e4":6,"o":6,"e":6,"a":6,".":6,",":6}},"h":{"d":"115,0r-28,0r0,-112v0,-15,-6,-22,-18,-22v-12,0,-18,9,-18,25r0,109r-29,0r0,-232r29,0r0,91v21,-24,64,-21,64,20r0,121","k":{"y":4}},"i":{"d":"37,-185v-9,0,-16,-8,-16,-16v0,-8,8,-15,16,-15v8,0,16,7,16,15v0,8,-7,16,-16,16xm23,-154r28,0r0,154r-28,0r0,-154","w":67,"k":{"v":4}},"j":{"d":"36,-185v-9,1,-16,-8,-16,-16v0,-8,8,-15,16,-15v9,0,17,6,16,15v1,9,-7,17,-16,16xm22,-154r29,0r0,222r-29,0r0,-222","w":67},"k":{"d":"125,0r-30,0r-44,-82r0,82r-29,0r0,-232r29,0r1,144r38,-66r30,0r-39,70","k":{"\u00f6":9,"y":3,"o":9,"e":9}},"l":{"d":"52,0r-29,0r0,-232r29,0r0,232","w":67,"k":{"w":3}},"m":{"d":"88,-114v0,-11,-7,-20,-17,-20v-13,0,-19,8,-19,24r0,110r-29,0r0,-154r29,0r0,14v16,-22,51,-22,62,3v19,-29,67,-27,67,18r0,119r-29,0r0,-112v0,-15,-6,-22,-17,-22v-12,0,-19,8,-19,26r0,108r-28,0r0,-114","w":198},"n":{"d":"68,-134v-12,0,-18,10,-18,22r0,112r-29,0r0,-154r29,0v1,5,-2,12,1,15v15,-28,63,-22,63,19r0,120r-28,0r0,-112v0,-15,-6,-22,-18,-22","k":{"\u2019":9,"v":6}},"o":{"d":"68,-156v40,0,49,29,49,81v0,48,-11,77,-48,77v-40,0,-50,-33,-50,-78v0,-52,10,-80,49,-80xm68,-21v20,-3,18,-20,18,-47v0,-38,5,-59,-18,-65v-18,2,-18,20,-18,44v0,44,-5,60,18,68","k":{"z":9,"y":6,"x":12,"w":12,"v":9,"g":6,".":15,",":18}},"p":{"d":"52,-137v9,-11,14,-19,29,-19v36,0,38,32,38,78v0,49,-2,76,-37,80v-18,2,-18,-9,-30,-19r0,85r-29,0r0,-222r29,0r0,17xm69,-131v-27,1,-16,73,-14,95v1,9,6,14,14,14v20,0,20,-24,20,-51v0,-32,1,-54,-20,-58","k":{"z":3,"y":3,"w":6,".":9,",":21}},"q":{"d":"20,-72v0,-38,1,-84,38,-84v13,-1,21,9,30,21r0,-19r28,0r0,222r-29,0r-1,-86v-7,14,-16,20,-28,20v-33,0,-38,-26,-38,-74xm69,-131v-18,2,-18,23,-18,48v0,33,-4,56,18,61v18,-3,19,-24,19,-49v0,-33,3,-55,-19,-60"},"r":{"d":"87,-131v-60,-4,-30,82,-37,131r-29,0r0,-154r29,0v1,7,-2,18,1,23v9,-18,20,-25,36,-25r0,25","w":97,"k":{"\u00f6":9,"\u00e5":6,"\u00e4":6,"s":15,"q":4,"p":4,"o":9,"n":6,"m":15,"k":3,"j":3,"g":9,"e":9,"d":9,"c":9,"a":6,";":15,":":12,".":27,"-":18,",":42}},"s":{"d":"25,-114v0,-35,35,-54,70,-37r0,24v-18,-9,-41,-9,-43,11v5,30,50,39,50,76v0,36,-39,52,-72,35r0,-23v20,8,43,12,45,-10v-4,-28,-50,-43,-50,-76","w":113,"k":{"w":6,".":3,",":18}},"t":{"d":"77,-131r-19,0r0,131r-29,0r0,-131r-18,0r0,-23r18,0r0,-41r29,0r0,41r19,0r0,23","w":82},"u":{"d":"68,-21v14,0,18,-10,18,-28r0,-105r28,0v-7,61,25,156,-46,156v-71,0,-39,-95,-46,-156r28,0r0,107v0,17,6,26,18,26"},"v":{"d":"16,-154r29,0r23,109r24,-109r28,0r-42,154r-19,0","k":{"\u00f6":9,"\u00e5":12,"\u00e4":12,"q":9,"o":9,"e":9,"d":9,"c":9,"a":12,".":33,",":39}},"w":{"d":"173,-154r-38,154r-20,0r-20,-94r-19,94r-19,0r-38,-154r27,0r22,103r21,-103r14,0r23,103r20,-103r27,0","w":183,"k":{"\u00f6":9,"\u00e5":9,"\u00e4":9,"q":9,"o":9,"h":4,"e":12,"d":9,"c":9,"a":9,".":24,",":36}},"x":{"d":"124,0r-29,0r-27,-51r-27,51r-29,0r41,-78r-39,-76r29,0r25,47r24,-47r30,0r-40,75","k":{"\u00f6":6,"o":6,"e":9,"d":6,"c":9}},"y":{"d":"125,-154r-72,222r-25,0r25,-82r-41,-140r28,0r26,106r32,-106r27,0","k":{"\u00f6":6,"\u00e5":6,"\u00e4":6,"o":6,"g":6,"e":6,"d":6,"c":6,"a":6,".":24,",":36}},"z":{"d":"108,-154r-55,132r50,0r0,22r-88,0r53,-131r-51,0r0,-23r91,0","w":116,"k":{"\u00f6":6,"o":6,"e":6,"d":6,"c":4}},"{":{"d":"76,-2v1,35,-6,67,36,61r0,28v-57,-1,-65,-15,-65,-78v0,-51,0,-70,-37,-77r0,-29v38,-5,36,-27,37,-77v0,-45,0,-49,18,-68v6,-8,27,-10,47,-9r0,27v-41,-6,-36,26,-36,63v-1,46,-6,64,-36,79v29,13,36,33,36,80","w":120},"|":{"d":"107,49r-24,0r0,-299r24,0r0,299","w":189},"}":{"d":"74,-173v0,50,-1,71,36,76r0,29v-36,6,-36,26,-36,77v0,63,-8,77,-66,78r0,-28v40,6,36,-25,36,-61v-1,-47,7,-67,37,-80v-37,-14,-38,-53,-37,-105v0,-31,-6,-38,-36,-37r0,-27v57,1,67,16,66,78","w":120},"~":{"d":"75,-152v29,0,60,27,87,28v15,0,32,-8,51,-25r0,26v-44,46,-92,4,-139,-6v-15,0,-32,8,-51,24r0,-25v18,-15,36,-22,52,-22","w":236},"\u00c4":{"d":"139,0r-29,0r-8,-44r-47,0r-9,44r-28,0r48,-224r25,0xm98,-67r-20,-106r-19,106r39,0xm95,-262v-1,-10,9,-19,18,-19v9,0,20,9,19,19v1,10,-9,19,-19,18v-9,1,-19,-9,-18,-18xm24,-262v-1,-10,9,-19,18,-19v9,0,19,10,19,19v0,9,-9,19,-19,18v-9,1,-19,-9,-18,-18","w":150,"k":{"\u2019":27,"\u201d":33,"y":18,"w":18,"v":18,"u":3,"Y":18,"W":15,"V":21,"U":12,"T":15,"Q":9,"O":12,"G":9,"C":9}},"\u00c5":{"d":"139,0r-29,0r-8,-44r-47,0r-9,44r-28,0r48,-224r25,0xm98,-67r-20,-106r-19,106r39,0xm43,-266v0,-16,15,-32,32,-32v17,0,32,14,32,32v0,18,-14,33,-32,33v-17,0,-32,-16,-32,-33xm57,-266v-1,11,8,19,18,19v10,0,20,-9,19,-19v1,-10,-10,-19,-19,-19v-9,0,-19,9,-18,19","w":150,"k":{"\u2019":27,"\u201d":33,"y":18,"w":18,"v":18,"Y":18,"W":15,"V":21,"U":12,"T":15,"Q":9,"O":12,"G":9,"C":9}},"\u00c7":{"d":"56,-113v0,57,11,102,61,82r0,27v-64,20,-93,-22,-93,-102v0,-84,21,-133,93,-118r0,27v-49,-14,-61,24,-61,84xm118,41v0,31,-41,37,-76,31r2,-20v19,1,48,-1,45,-13v1,-9,-11,-13,-28,-12r9,-31r23,0r-5,19v16,2,30,11,30,26"},"\u00c9":{"d":"106,0r-81,0r0,-224r79,0r0,26r-49,0r0,71r46,0r0,25r-46,0r0,77r51,0r0,25xm102,-290r-39,49r-26,0r24,-49r41,0","w":116},"\u00d1":{"d":"131,0r-24,0r-58,-154r0,154r-27,0r0,-224r24,0r58,154r0,-154r27,0r0,224xm52,-285v15,0,57,33,59,-1r23,0v0,23,-12,38,-34,40v-20,1,-57,-36,-61,0v-7,-1,-20,3,-23,-2v-1,-21,16,-37,36,-37","w":150},"\u00d6":{"d":"85,1v-62,0,-62,-42,-62,-114v0,-80,2,-116,62,-116v61,0,62,39,62,111v0,75,1,119,-62,119xm85,-22v32,-5,30,-37,30,-89v0,-62,5,-85,-30,-94v-35,3,-30,46,-30,91v0,49,-5,86,30,92xm102,-262v-1,-10,9,-19,18,-19v9,0,20,9,19,19v1,10,-9,19,-19,18v-9,1,-19,-9,-18,-18xm31,-262v-1,-10,9,-19,18,-19v9,0,19,10,19,19v0,9,-9,19,-19,18v-9,1,-19,-9,-18,-18","w":164,"k":{"Y":12,"X":9,"W":6,"V":6,"T":6,"A":12}},"\u00dc":{"d":"79,-20v25,0,22,-19,22,-47r0,-157r30,0r0,171v0,37,-16,56,-50,56v-37,0,-56,-19,-56,-56r0,-171r30,0r0,159v2,28,0,45,24,45xm96,-262v-1,-10,9,-19,18,-19v9,0,20,9,19,19v1,10,-9,19,-19,18v-9,1,-19,-9,-18,-18xm25,-262v-1,-10,9,-19,18,-19v9,0,19,10,19,19v0,9,-9,19,-19,18v-9,1,-19,-9,-18,-18","w":150,"k":{"A":9}},"\u00e1":{"d":"57,-156v16,0,21,8,29,19r0,-17r29,0r0,154r-29,0r0,-19v-7,14,-17,21,-29,21v-32,0,-38,-28,-38,-77v0,-46,2,-81,38,-81xm69,-131v-30,-3,-18,73,-16,94v1,9,7,14,15,14v22,0,18,-27,18,-58v0,-28,3,-48,-17,-50xm110,-222r-39,49r-26,0r24,-49r41,0"},"\u00e0":{"d":"57,-156v16,0,21,8,29,19r0,-17r29,0r0,154r-29,0r0,-19v-7,14,-17,21,-29,21v-32,0,-38,-28,-38,-77v0,-46,2,-81,38,-81xm69,-131v-30,-3,-18,73,-16,94v1,9,7,14,15,14v22,0,18,-27,18,-58v0,-28,3,-48,-17,-50xm97,-173r-26,0r-41,-49r43,0"},"\u00e2":{"d":"57,-156v16,0,21,8,29,19r0,-17r29,0r0,154r-29,0r0,-19v-7,14,-17,21,-29,21v-32,0,-38,-28,-38,-77v0,-46,2,-81,38,-81xm69,-131v-30,-3,-18,73,-16,94v1,9,7,14,15,14v22,0,18,-27,18,-58v0,-28,3,-48,-17,-50xm126,-173r-35,0r-20,-30r-20,30r-36,0r39,-49r33,0"},"\u00e4":{"d":"57,-156v16,0,21,8,29,19r0,-17r29,0r0,154r-29,0r0,-19v-7,14,-17,21,-29,21v-32,0,-38,-28,-38,-77v0,-46,2,-81,38,-81xm69,-131v-30,-3,-18,73,-16,94v1,9,7,14,15,14v22,0,18,-27,18,-58v0,-28,3,-48,-17,-50xm86,-194v-1,-10,9,-19,18,-19v9,0,20,9,19,19v1,10,-9,19,-19,18v-9,1,-19,-9,-18,-18xm15,-194v-1,-10,9,-19,18,-19v9,0,19,10,19,19v0,9,-9,19,-19,18v-9,1,-19,-9,-18,-18","k":{"w":6,"v":9}},"\u00e3":{"d":"57,-156v16,0,21,8,29,19r0,-17r29,0r0,154r-29,0r0,-19v-7,14,-17,21,-29,21v-32,0,-38,-28,-38,-77v0,-46,2,-81,38,-81xm69,-131v-30,-3,-18,73,-16,94v1,9,7,14,15,14v22,0,18,-27,18,-58v0,-28,3,-48,-17,-50xm48,-217v15,0,57,33,59,-1r23,0v0,23,-12,38,-34,40v-20,1,-57,-36,-61,0v-7,-1,-20,3,-23,-2v-1,-21,16,-37,36,-37"},"\u00e5":{"d":"57,-156v16,0,21,8,29,19r0,-17r29,0r0,154r-29,0r0,-19v-7,14,-17,21,-29,21v-32,0,-38,-28,-38,-77v0,-46,2,-81,38,-81xm69,-131v-30,-3,-18,73,-16,94v1,9,7,14,15,14v22,0,18,-27,18,-58v0,-28,3,-48,-17,-50xm34,-198v0,-16,15,-32,32,-32v17,0,32,14,32,32v0,18,-14,33,-32,33v-17,0,-32,-16,-32,-33xm48,-198v-1,11,8,19,18,19v10,0,20,-9,19,-19v1,-10,-10,-19,-19,-19v-9,0,-19,9,-18,19","k":{"w":6,"v":9}},"\u00e7":{"d":"89,-126v-32,-17,-41,15,-40,51v1,45,11,61,41,47r0,23v-49,23,-72,-15,-72,-73v0,-56,22,-90,71,-73r0,25xm93,41v0,31,-41,37,-76,31r2,-20v19,1,48,-1,45,-13v1,-9,-11,-13,-28,-12r9,-31r23,0r-5,19v16,2,30,11,30,26","w":97},"\u00e9":{"d":"70,-156v39,0,47,33,46,84r-65,0v2,27,-2,48,20,51v16,-1,16,-13,17,-31r26,0v-1,36,-16,54,-46,54v-32,0,-47,-25,-47,-75v0,-55,16,-83,49,-83xm87,-94v5,-32,-16,-58,-32,-32v-2,7,-4,17,-4,32r36,0xm110,-222r-39,49r-26,0r24,-49r41,0"},"\u00e8":{"d":"70,-156v39,0,47,33,46,84r-65,0v2,27,-2,48,20,51v16,-1,16,-13,17,-31r26,0v-1,36,-16,54,-46,54v-32,0,-47,-25,-47,-75v0,-55,16,-83,49,-83xm87,-94v5,-32,-16,-58,-32,-32v-2,7,-4,17,-4,32r36,0xm88,-173r-26,0r-41,-49r43,0"},"\u00ea":{"d":"70,-156v39,0,47,33,46,84r-65,0v2,27,-2,48,20,51v16,-1,16,-13,17,-31r26,0v-1,36,-16,54,-46,54v-32,0,-47,-25,-47,-75v0,-55,16,-83,49,-83xm87,-94v5,-32,-16,-58,-32,-32v-2,7,-4,17,-4,32r36,0xm121,-173r-35,0r-20,-30r-20,30r-36,0r39,-49r33,0"},"\u00eb":{"d":"70,-156v39,0,47,33,46,84r-65,0v2,27,-2,48,20,51v16,-1,16,-13,17,-31r26,0v-1,36,-16,54,-46,54v-32,0,-47,-25,-47,-75v0,-55,16,-83,49,-83xm87,-94v5,-32,-16,-58,-32,-32v-2,7,-4,17,-4,32r36,0xm83,-194v-1,-10,9,-19,18,-19v9,0,20,9,19,19v1,10,-9,19,-19,18v-9,1,-19,-9,-18,-18xm12,-194v-1,-10,9,-19,18,-19v9,0,19,10,19,19v0,9,-9,19,-19,18v-9,1,-19,-9,-18,-18"},"\u00ed":{"d":"23,-153r29,0r0,153r-29,0r0,-153xm78,-222r-39,49r-26,0r24,-49r41,0","w":67},"\u00ec":{"d":"23,-153r29,0r0,153r-29,0r0,-153xm56,-173r-26,0r-41,-49r43,0","w":67},"\u00ee":{"d":"23,-153r29,0r0,153r-29,0r0,-153xm89,-173r-35,0r-20,-30r-20,30r-36,0r39,-49r33,0","w":67},"\u00ef":{"d":"23,-153r29,0r0,153r-29,0r0,-153xm51,-194v-1,-10,9,-19,18,-19v9,0,20,9,19,19v1,10,-9,19,-19,18v-9,1,-19,-9,-18,-18xm-20,-194v-1,-10,9,-19,18,-19v9,0,19,10,19,19v0,9,-9,19,-19,18v-9,1,-19,-9,-18,-18","w":67},"\u00f1":{"d":"68,-134v-12,0,-18,10,-18,22r0,112r-29,0r0,-154r29,0v1,5,-2,12,1,15v15,-28,63,-22,63,19r0,120r-28,0r0,-112v0,-15,-6,-22,-18,-22xm43,-217v15,0,57,33,59,-1r23,0v0,23,-12,38,-34,40v-20,1,-57,-36,-61,0v-7,-1,-20,3,-23,-2v-1,-21,16,-37,36,-37"},"\u00f3":{"d":"68,-156v40,0,49,29,49,81v0,48,-11,77,-48,77v-40,0,-50,-33,-50,-78v0,-52,10,-80,49,-80xm68,-21v20,-3,18,-20,18,-47v0,-38,5,-59,-18,-65v-18,2,-18,20,-18,44v0,44,-5,60,18,68xm110,-222r-39,49r-26,0r24,-49r41,0"},"\u00f2":{"d":"68,-156v40,0,49,29,49,81v0,48,-11,77,-48,77v-40,0,-50,-33,-50,-78v0,-52,10,-80,49,-80xm68,-21v20,-3,18,-20,18,-47v0,-38,5,-59,-18,-65v-18,2,-18,20,-18,44v0,44,-5,60,18,68xm88,-173r-26,0r-41,-49r43,0"},"\u00f4":{"d":"68,-156v40,0,49,29,49,81v0,48,-11,77,-48,77v-40,0,-50,-33,-50,-78v0,-52,10,-80,49,-80xm68,-21v20,-3,18,-20,18,-47v0,-38,5,-59,-18,-65v-18,2,-18,20,-18,44v0,44,-5,60,18,68xm121,-173r-35,0r-20,-30r-20,30r-36,0r39,-49r33,0"},"\u00f6":{"d":"68,-156v40,0,49,29,49,81v0,48,-11,77,-48,77v-40,0,-50,-33,-50,-78v0,-52,10,-80,49,-80xm68,-21v20,-3,18,-20,18,-47v0,-38,5,-59,-18,-65v-18,2,-18,20,-18,44v0,44,-5,60,18,68xm83,-194v-1,-10,9,-19,18,-19v9,0,20,9,19,19v1,10,-9,19,-19,18v-9,1,-19,-9,-18,-18xm12,-194v-1,-10,9,-19,18,-19v9,0,19,10,19,19v0,9,-9,19,-19,18v-9,1,-19,-9,-18,-18","k":{"z":9,"y":6,"x":12,"w":12,"v":9}},"\u00f5":{"d":"68,-156v40,0,49,29,49,81v0,48,-11,77,-48,77v-40,0,-50,-33,-50,-78v0,-52,10,-80,49,-80xm68,-21v20,-3,18,-20,18,-47v0,-38,5,-59,-18,-65v-18,2,-18,20,-18,44v0,44,-5,60,18,68xm47,-217v15,0,57,33,59,-1r23,0v0,23,-12,38,-34,40v-20,1,-57,-36,-61,0v-7,-1,-20,3,-23,-2v-1,-21,16,-37,36,-37"},"\u00fa":{"d":"68,-21v14,0,18,-10,18,-28r0,-105r28,0v-7,61,25,156,-46,156v-71,0,-39,-95,-46,-156r28,0r0,107v0,17,6,26,18,26xm110,-222r-39,49r-26,0r24,-49r41,0"},"\u00f9":{"d":"68,-21v14,0,18,-10,18,-28r0,-105r28,0v-7,61,25,156,-46,156v-71,0,-39,-95,-46,-156r28,0r0,107v0,17,6,26,18,26xm88,-173r-26,0r-41,-49r43,0"},"\u00fb":{"d":"68,-21v14,0,18,-10,18,-28r0,-105r28,0v-7,61,25,156,-46,156v-71,0,-39,-95,-46,-156r28,0r0,107v0,17,6,26,18,26xm121,-173r-35,0r-20,-30r-20,30r-36,0r39,-49r33,0"},"\u00fc":{"d":"68,-21v14,0,18,-10,18,-28r0,-105r28,0v-7,61,25,156,-46,156v-71,0,-39,-95,-46,-156r28,0r0,107v0,17,6,26,18,26xm83,-194v-1,-10,9,-19,18,-19v9,0,20,9,19,19v1,10,-9,19,-19,18v-9,1,-19,-9,-18,-18xm12,-194v-1,-10,9,-19,18,-19v9,0,19,10,19,19v0,9,-9,19,-19,18v-9,1,-19,-9,-18,-18"},"\u2020":{"d":"60,-234v33,10,-2,59,5,92v15,1,41,-16,43,6v-5,20,-26,4,-42,3v14,58,-1,132,0,199r-8,0v2,-75,-16,-136,-2,-198v-16,-1,-38,16,-42,-4v2,-23,27,-5,43,-5v1,-21,-10,-54,-10,-73v0,-13,5,-20,13,-20","w":116},"\u00b0":{"d":"23,-213v0,-25,22,-49,49,-49v27,0,49,23,49,49v0,24,-23,48,-49,48v-26,0,-49,-24,-49,-48xm43,-213v0,16,13,29,29,29v16,0,30,-14,30,-29v0,-15,-15,-30,-30,-30v-15,0,-29,14,-29,30","w":143},"\u00a2":{"d":"18,-75v0,-47,7,-68,38,-80r0,-29r17,0r0,28v6,1,10,4,16,6r0,24v-30,-15,-40,4,-40,50v0,45,12,62,40,46r0,24v-5,3,-11,5,-17,7r0,37r-17,0r0,-37v-29,-7,-37,-36,-37,-76","w":97},"\u00a3":{"d":"30,-122v-8,-42,-12,-106,42,-106v31,0,47,19,47,55r-28,0v-1,-19,-7,-29,-18,-29v-12,0,-18,9,-18,28v0,3,2,20,6,52r25,0r0,22r-23,0v3,21,2,53,-3,66v21,10,40,13,40,-17v8,1,21,-2,27,1v2,49,-38,66,-77,40v-9,16,-40,17,-40,-5v0,-15,13,-26,31,-23v0,-20,-2,-34,-8,-62r-23,0r0,-22r20,0"},"\u00a7":{"d":"54,-137v-26,-25,-32,-94,14,-94v24,0,37,21,38,48r-25,0v2,-26,-22,-28,-22,-8v0,38,50,62,50,106v0,24,-8,44,-25,59v27,24,32,93,-16,94v-23,0,-35,-16,-36,-48r25,0v-6,26,24,29,22,7v-3,-40,-52,-61,-51,-107v1,-27,11,-40,26,-57xm72,-41v18,-24,16,-63,-6,-82v-21,29,-13,60,6,82","w":124},"\u2022":{"d":"18,-126v0,-24,21,-45,45,-45v24,0,45,22,45,45v0,23,-22,44,-45,44v-23,0,-45,-21,-45,-44","w":126},"\u00b6":{"d":"-1,-185v0,-48,32,-73,83,-73r112,0r0,31r-26,0r0,299r-29,0r0,-299r-40,0r0,299r-29,0r0,-184v-43,-2,-71,-30,-71,-73","w":193},"\u00df":{"d":"68,-232v55,-4,57,77,22,97v46,16,39,161,-24,134r0,-23v23,-1,21,-19,21,-46v0,-30,0,-46,-21,-50r0,-25v15,-4,15,-14,16,-35v4,-37,-31,-35,-32,-7r0,187r-29,0r0,-189v0,-29,18,-41,47,-43"},"\u00ae":{"d":"0,-130v0,-70,62,-132,133,-132v70,0,132,62,132,132v0,70,-62,133,-132,133v-72,0,-133,-61,-133,-133xm22,-130v0,58,52,111,111,111v59,0,110,-52,110,-111v0,-58,-52,-110,-110,-110v-59,0,-111,52,-111,110xm123,-199v70,-16,81,75,21,79v15,3,38,45,50,64r-28,0v-19,-27,-21,-67,-68,-61r0,61r-23,0r0,-143r48,0xm160,-158v0,-28,-35,-19,-62,-21r0,43v27,-1,62,5,62,-22","w":265},"\u00a9":{"d":"0,-130v0,-70,62,-132,133,-132v70,0,132,62,132,132v0,70,-62,133,-132,133v-72,0,-133,-61,-133,-133xm22,-130v0,58,52,111,111,111v59,0,110,-52,110,-111v0,-58,-52,-110,-110,-110v-59,0,-111,52,-111,110xm87,-128v-8,60,78,72,88,20r22,6v-6,29,-31,48,-64,49v-45,0,-66,-33,-70,-78v-6,-75,111,-102,131,-31r-21,5v-17,-48,-94,-26,-86,29","w":265},"\u2122":{"d":"314,-114r-22,0r-1,-121r-36,121r-22,0r-38,-123r0,123r-22,0r0,-144r35,0r37,115r34,-115r35,0r0,144xm157,-237r-47,0r0,123r-24,0r0,-123r-46,0r0,-21r117,0r0,21","w":360},"\u00b4":{"d":"104,-222r-39,49r-26,0r24,-49r41,0","w":119},"\u00a8":{"d":"77,-194v-1,-10,9,-19,18,-19v9,0,20,9,19,19v1,10,-9,19,-19,18v-9,1,-19,-9,-18,-18xm6,-194v-1,-10,9,-19,18,-19v9,0,19,10,19,19v0,9,-9,19,-19,18v-9,1,-19,-9,-18,-18","w":119},"\u2260":{"d":"216,-65r-116,0r-28,51r-18,-10r23,-41r-53,0r0,-23r66,0r32,-59r-98,0r0,-23r112,0r28,-51r17,10r-22,41r57,0r0,23r-70,0r-33,59r103,0r0,23","w":240},"\u00c6":{"d":"176,0r-82,0r0,-45r-39,0r-11,45r-31,0r64,-224r98,0r0,25r-50,0r0,71r46,0r0,26r-46,0r0,77r51,0r0,25xm95,-67r-1,-131r-33,131r34,0","w":183},"\u00d8":{"d":"86,-227v21,0,26,3,38,11r6,-14r11,5r-8,19v10,13,14,43,14,91v-1,76,0,114,-61,118v-22,1,-28,-3,-41,-12r-7,16r-11,-6r9,-21v-10,-11,-14,-38,-14,-83v0,-65,-3,-124,64,-124xm85,-203v-45,4,-28,89,-28,140r52,-120v-5,-14,-12,-20,-24,-20xm85,-21v44,0,28,-90,28,-142r-53,122v5,13,13,20,25,20","w":164},"\u221e":{"d":"27,-127v0,-61,73,-62,93,-21v15,-23,26,-39,56,-40v33,-1,54,26,54,61v0,35,-21,61,-54,61v-30,-1,-41,-17,-56,-40v-11,16,-29,31,-51,31v-26,0,-42,-23,-42,-52xm205,-128v0,-27,-24,-43,-45,-28v-6,4,-14,14,-24,29v17,23,17,33,41,35v19,2,28,-17,28,-36xm51,-128v2,38,41,26,54,0v-12,-17,-23,-24,-34,-24v-12,0,-21,10,-20,24","w":256},"\u00b1":{"d":"216,-134r-85,0r0,84r-23,0r0,-84r-84,0r0,-23r84,0r0,-85r23,0r0,85r85,0r0,23xm216,8r-192,0r0,-23r192,0r0,23","w":240},"\u2264":{"d":"215,-26r-190,-80r0,-21r190,-80r0,25r-159,65r159,66r0,25xm216,8r-192,0r0,-23r192,0r0,23","w":240},"\u2265":{"d":"215,-106r-191,80r0,-25r160,-65r-160,-66r0,-25r191,80r0,21xm216,8r-192,0r0,-23r192,0r0,23","w":240},"\u00a5":{"d":"127,-94r-44,0r0,94r-29,0r0,-94r-44,0r0,-16r39,0r-17,-49r-22,0r0,-15r17,0r-17,-50r30,0r14,50r29,0r14,-50r30,0r-17,50r17,0r0,15r-22,0r-17,49r39,0r0,16xm78,-159r-20,0r10,36"},"\u00b5":{"d":"147,-22v-14,34,-75,33,-91,3r0,91r-32,0r0,-259r32,0v5,63,-20,161,42,163v67,2,41,-98,46,-163r31,0r0,187r-28,0r0,-22","w":200},"\u2202":{"d":"114,-240v-22,3,-31,18,-40,40r-24,-11v13,-29,32,-51,64,-51v47,0,56,49,56,99v0,85,-31,163,-107,167v-34,2,-55,-26,-54,-61v3,-72,57,-105,141,-105v-1,-42,-3,-72,-36,-78xm41,-53v-3,31,34,42,58,24v29,-21,45,-61,50,-111v-70,1,-103,28,-108,87","w":177},"\u2211":{"d":"24,-262r218,0r0,29r-174,0r107,136r-114,144r183,0r0,29r-223,0r0,-33r109,-139r-106,-135r0,-31","w":256},"\u220f":{"d":"28,-262r240,0r0,338r-34,0r0,-308r-172,0r0,308r-34,0r0,-338","w":296},"\u03c0":{"d":"214,-134r-40,0r0,134r-32,0r0,-134r-61,0r0,134r-32,0r0,-135v-15,0,-28,3,-40,9r0,-26v53,-22,137,-5,205,-10r0,28","w":221},"\u222b":{"d":"54,-306v6,-26,52,-34,52,-3v0,21,-29,15,-37,6v-5,0,-6,5,-6,11r6,142v0,87,0,130,-19,174v-8,19,-49,19,-48,-7v1,-23,28,-14,35,-4v9,-4,9,-16,9,-35r-2,-133v1,-81,0,-109,10,-151","w":98},"\u00aa":{"d":"13,-177v-4,-41,22,-67,44,-39r0,-11r19,0r0,100r-19,0v-1,-4,2,-11,-1,-13v-7,9,-7,14,-19,14v-22,0,-21,-23,-24,-51xm45,-213v-18,0,-11,49,-9,62v1,6,4,9,9,9v19,-6,17,-71,0,-71","w":86},"\u00ba":{"d":"45,-126v-26,0,-31,-22,-31,-53v0,-33,11,-50,32,-50v26,0,31,20,31,53v0,30,-6,50,-32,50xm45,-213v-19,1,-11,48,-10,62v1,7,5,10,10,10v20,-2,19,-73,0,-72","w":86},"\u2126":{"d":"64,-137v0,51,24,89,60,105r0,32r-102,0r0,-30r65,2v-39,-23,-61,-57,-61,-113v0,-73,42,-122,116,-123v68,-1,116,52,114,123v-1,56,-24,89,-61,113r64,-1r0,29r-101,0r0,-31v38,-20,61,-52,61,-106v0,-51,-23,-100,-78,-99v-53,1,-77,46,-77,99","w":276},"\u00e6":{"d":"19,-76v-5,-63,31,-102,68,-63r0,-15r27,0r0,10v45,-32,76,12,68,74r-65,0v1,27,-1,49,19,49v15,0,15,-14,16,-30r28,0v4,43,-39,71,-66,41r0,10r-27,0v-1,-5,2,-14,-1,-17v-7,13,-16,19,-29,19v-36,0,-34,-31,-38,-78xm152,-94v4,-29,-16,-57,-31,-32v-4,7,-4,17,-4,32r35,0xm69,-131v-17,3,-18,24,-18,48v0,33,-3,56,18,61v19,-3,18,-24,18,-51v0,-32,4,-54,-18,-58","w":198},"\u00f8":{"d":"38,-7v-36,-36,-30,-176,48,-146v0,-8,7,-5,13,-3r-3,9v39,36,31,175,-47,146v-1,8,-7,6,-13,3xm78,-128v-22,-14,-29,10,-28,40v1,14,-2,31,1,43xm57,-26v28,14,30,-15,29,-47v-1,-12,1,-27,-2,-37"},"\u00bf":{"d":"65,-163v-9,0,-16,-7,-16,-17v0,-9,7,-16,16,-16v9,0,16,7,16,16v0,8,-8,17,-16,17xm62,10v14,0,14,-15,14,-32r26,0v0,38,-6,54,-41,54v-35,0,-42,-16,-42,-54v0,-46,0,-65,33,-72r0,-47r26,0r0,63v-32,-1,-33,18,-33,53v0,23,-1,35,17,35","w":116},"\u00a1":{"d":"21,-179v0,-9,6,-16,15,-16v10,0,17,7,17,15v0,8,-8,17,-16,17v-9,0,-16,-6,-16,-16xm51,30r-29,0r0,-171r29,0r0,171","w":67},"\u00ac":{"d":"216,-63r-23,0r0,-85r-169,0r0,-23r192,0r0,108","w":240},"\u221a":{"d":"185,-328r-54,342r-87,-181r-35,17r-5,-12r52,-26r71,145r46,-287","w":197},"\u0192":{"d":"192,-256r-7,27v-39,-14,-51,7,-53,42r36,0r-5,25r-36,0r-33,192v-4,45,-39,53,-85,41r6,-27v29,8,44,6,49,-23r31,-183r-35,0r4,-25r36,0v5,-46,17,-87,71,-73","w":200},"\u2248":{"d":"23,-165v44,-45,94,-6,139,6v15,0,32,-8,51,-25r0,26v-44,46,-92,4,-139,-6v-15,0,-32,8,-51,24r0,-25xm23,-95v62,-66,131,51,190,-19r0,26v-44,46,-92,4,-139,-6v-15,0,-32,8,-51,24r0,-25","w":236},"\u2206":{"d":"117,-248r102,248r-217,0xm104,-186r-78,168r148,0","w":220},"\u00ab":{"d":"118,-180r-19,82r18,83r-29,0r-18,-82r18,-83r30,0xm65,-180r-18,82r18,83r-30,0r-18,-82r18,-83r30,0"},"\u00bb":{"d":"117,-98r-18,83r-30,0r19,-83r-19,-82r30,0xm65,-98r-19,83r-29,0r18,-83r-18,-82r29,0"},"\u2026":{"d":"180,-35v11,0,19,9,19,20v0,10,-10,19,-19,19v-11,0,-20,-9,-20,-20v0,-10,10,-19,20,-19xm280,-15v0,-10,10,-20,20,-20v10,0,20,10,19,20v1,10,-9,20,-19,19v-10,1,-20,-9,-20,-19xm40,-15v0,-10,9,-20,19,-20v11,0,21,8,20,20v1,10,-9,19,-19,19v-11,0,-20,-8,-20,-19","w":360},"\u00a0":{"w":65},"\u00c0":{"d":"139,0r-29,0r-8,-44r-47,0r-9,44r-28,0r48,-224r25,0xm98,-67r-20,-106r-19,106r39,0xm97,-241r-26,0r-41,-49r43,0","w":150},"\u00c3":{"d":"139,0r-29,0r-8,-44r-47,0r-9,44r-28,0r48,-224r25,0xm98,-67r-20,-106r-19,106r39,0xm52,-285v15,0,57,33,59,-1r23,0v0,23,-12,38,-34,40v-20,1,-57,-36,-61,0v-7,-1,-20,3,-23,-2v-1,-21,16,-37,36,-37","w":150},"\u00d5":{"d":"85,1v-62,0,-62,-42,-62,-114v0,-80,2,-116,62,-116v61,0,62,39,62,111v0,75,1,119,-62,119xm85,-22v32,-5,30,-37,30,-89v0,-62,5,-85,-30,-94v-35,3,-30,46,-30,91v0,49,-5,86,30,92xm60,-285v15,0,57,33,59,-1r23,0v0,23,-12,38,-34,40v-20,1,-57,-36,-61,0v-7,-1,-20,3,-23,-2v-1,-21,16,-37,36,-37","w":164},"\u0152":{"d":"20,-114v0,-83,15,-120,95,-110r74,0r0,25r-50,0r0,71r46,0r0,26r-46,0r0,77r52,0r0,25r-120,1v-47,-9,-51,-49,-51,-115xm56,-50v0,25,25,28,53,25r0,-174v-82,-18,-53,85,-53,149","w":198},"\u0153":{"d":"103,-143v44,-33,92,5,79,73r-64,0v1,27,-1,49,19,49v11,0,16,-10,16,-30r28,0v3,51,-47,68,-78,42v-47,31,-94,-3,-85,-71v-7,-65,42,-94,85,-63xm153,-94v4,-29,-15,-57,-31,-32v-4,6,-4,17,-4,32r35,0xm69,-132v-30,1,-19,75,-16,97v2,9,8,14,16,14v19,0,20,-22,20,-49v0,-34,3,-57,-20,-62","w":198},"\u2013":{"d":"184,-73r-183,0r0,-32r183,0r0,32","w":180},"\u2014":{"d":"364,-74r-364,0r0,-32r364,0r0,32","w":360},"\u201c":{"d":"102,-155r-31,0v-1,-33,-1,-45,17,-70r10,6v-8,11,-12,23,-13,34r17,0r0,30xm53,-155r-30,0v0,-32,-2,-47,16,-70r10,6v-8,12,-13,24,-13,34r17,0r0,30","w":116,"k":{"\u00c5":33,"\u00c4":33,"A":33}},"\u201d":{"d":"102,-225v2,29,-3,54,-17,70r-10,-5v8,-12,13,-23,13,-34r-18,0r0,-31r32,0xm53,-225v1,31,-1,50,-17,70r-10,-5v8,-13,13,-23,13,-34r-17,0r0,-31r31,0","w":116},"\u2018":{"d":"53,-155r-30,0v-2,-29,2,-53,16,-70r10,6v-9,12,-13,16,-13,34r17,0r0,30","w":67,"k":{"\u00c5":27,"\u00c4":27,"A":27}},"\u2019":{"d":"53,-225v1,31,-1,50,-17,70r-10,-5v9,-15,13,-24,13,-34r-17,0r0,-31r31,0","w":67,"k":{"v":6,"s":30,"r":6,"d":15}},"\u00f7":{"d":"105,-190v0,-8,7,-14,15,-14v7,0,14,7,14,14v0,8,-6,15,-14,15v-8,0,-15,-7,-15,-15xm216,-105r-192,0r0,-22r192,0r0,22xm105,-44v0,-8,7,-15,15,-15v8,0,15,7,15,14v0,7,-7,15,-15,15v-8,0,-15,-6,-15,-14","w":240},"\u25ca":{"d":"169,-134r-70,134r-21,0r-70,-134r70,-134r21,0xm147,-134r-58,-115r-59,115r59,114","w":177},"\u00ff":{"d":"125,-154r-72,222r-25,0r25,-82r-41,-140r28,0r26,106r32,-106r27,0xm83,-194v-1,-10,9,-19,18,-19v9,0,20,9,19,19v1,10,-9,19,-19,18v-9,1,-19,-9,-18,-18xm12,-194v-1,-10,9,-19,18,-19v9,0,19,10,19,19v0,9,-9,19,-19,18v-9,1,-19,-9,-18,-18"},"\u0178":{"d":"127,-224r-44,129r0,95r-30,0r0,-94r-43,-130r30,0r29,101r28,-101r30,0xm83,-262v-1,-10,9,-19,18,-19v9,0,20,9,19,19v1,10,-9,19,-19,18v-9,1,-19,-9,-18,-18xm12,-262v-1,-10,9,-19,18,-19v9,0,19,10,19,19v0,9,-9,19,-19,18v-9,1,-19,-9,-18,-18"},"\u2215":{"d":"117,-231r-157,247r-23,0r157,-247r23,0","w":48},"\u20ac":{"d":"117,-4v-54,21,-93,-16,-89,-77r-19,0r3,-22r15,0r0,-18r-17,0r3,-22r15,0v-3,-60,30,-98,89,-81r0,27v-39,-15,-61,12,-58,54r49,0r-3,22r-46,0r0,18r44,0r-3,22r-41,0v-4,47,22,66,58,50r0,27"},"\u2039":{"d":"65,-180r-18,82r17,83r-29,0r-18,-82r18,-83r30,0","w":78},"\u203a":{"d":"65,-98r-19,83r-29,0r18,-83r-18,-82r29,0","w":78},"\uf001":{"d":"78,-204v-13,-6,-24,0,-24,20r0,30r24,0r0,22r-24,0r0,132r-28,0r0,-132r-16,0r0,-22r16,0v-4,-46,5,-93,52,-75r0,25xm118,0r-30,0r0,-154r30,0r0,154"},"\ufb01":{"d":"78,-204v-13,-6,-24,0,-24,20r0,30r24,0r0,22r-24,0r0,132r-28,0r0,-132r-16,0r0,-22r16,0v-4,-46,5,-93,52,-75r0,25xm118,0r-30,0r0,-154r30,0r0,154"},"\uf002":{"d":"69,-232v30,0,48,17,48,48r0,184r-29,0r0,-182v0,-17,-6,-26,-18,-26v-23,0,-18,31,-18,54r24,0r0,22r-24,0r0,132r-29,0r0,-132r-16,0r0,-22r16,0v-3,-44,5,-79,46,-78"},"\ufb02":{"d":"69,-232v30,0,48,17,48,48r0,184r-29,0r0,-182v0,-17,-6,-26,-18,-26v-23,0,-18,31,-18,54r24,0r0,22r-24,0r0,132r-29,0r0,-132r-16,0r0,-22r16,0v-3,-44,5,-79,46,-78"},"\u2021":{"d":"73,-47v0,9,-10,29,-8,42v16,1,39,-18,43,5v-2,22,-28,3,-42,4v-4,24,25,59,-6,63v-27,-5,-2,-43,-4,-63v-17,-1,-39,18,-43,-4v2,-24,27,-2,44,-4v1,-16,-9,-33,-10,-44v-1,-11,9,-25,9,-36v0,-10,-10,-24,-9,-34v1,-14,10,-24,9,-43v-15,-3,-40,19,-43,-4v3,-22,27,-3,42,-4v4,-22,-25,-60,5,-64v29,4,2,43,5,64v0,0,41,-20,43,4v-3,20,-28,5,-43,4v-2,14,8,33,8,44v-9,20,-8,49,0,70","w":116},"\u00b7":{"d":"37,-118v-1,-9,9,-19,18,-18v10,-1,20,8,19,18v1,10,-9,20,-19,19v-10,1,-19,-9,-18,-19","w":105},"\u2219":{"d":"37,-118v-1,-9,9,-19,18,-18v10,-1,20,8,19,18v1,10,-9,20,-19,19v-10,1,-19,-9,-18,-19","w":105},"\u201a":{"d":"62,-32r-34,79r-14,-4r25,-84","w":67,"k":{"\u201a":15}},"\u201e":{"d":"102,-31v1,32,-1,47,-17,70r-10,-6v7,-10,12,-20,13,-33r-17,0r0,-31r31,0xm53,-31v1,31,-1,50,-17,70r-9,-6v8,-12,12,-22,12,-33r-16,0r0,-31r30,0","w":116},"\u2030":{"d":"172,-229r-123,242r-17,0r123,-242r17,0xm47,-229v32,3,35,30,35,71v0,47,-5,68,-36,74v-30,-3,-32,-32,-33,-71v0,-48,5,-68,34,-74xm48,-209v-20,7,-13,42,-13,68v0,21,-2,34,11,38v15,-4,13,-23,13,-48v0,-34,5,-50,-11,-58xm205,-61v0,-47,4,-69,35,-74v31,3,33,30,34,70v0,46,-5,70,-35,75v-29,-4,-34,-33,-34,-71xm240,-115v-19,5,-7,44,-13,68v2,19,-1,34,11,37v15,-4,14,-22,14,-47v0,-34,5,-51,-12,-58xm158,-131v31,3,35,29,35,70v0,47,-5,70,-36,75v-29,-4,-33,-32,-33,-71v0,-47,3,-68,34,-74xm159,-111v-19,7,-13,41,-13,67v0,21,-1,36,11,39v14,-5,13,-23,13,-48v0,-34,5,-50,-11,-58","w":296},"\u00c2":{"d":"139,0r-29,0r-8,-44r-47,0r-9,44r-28,0r48,-224r25,0xm98,-67r-20,-106r-19,106r39,0xm130,-241r-35,0r-20,-30r-20,30r-36,0r39,-49r33,0","w":150},"\u00ca":{"d":"106,0r-81,0r0,-224r79,0r0,26r-49,0r0,71r46,0r0,25r-46,0r0,77r51,0r0,25xm118,-241r-35,0r-20,-30r-20,30r-36,0r39,-49r33,0","w":116},"\u00c1":{"d":"139,0r-29,0r-8,-44r-47,0r-9,44r-28,0r48,-224r25,0xm98,-67r-20,-106r-19,106r39,0xm119,-290r-39,49r-26,0r24,-49r41,0","w":150},"\u00cb":{"d":"106,0r-81,0r0,-224r79,0r0,26r-49,0r0,71r46,0r0,25r-46,0r0,77r51,0r0,25xm81,-262v-1,-10,9,-19,18,-19v9,0,20,9,19,19v1,10,-9,19,-19,18v-9,1,-19,-9,-18,-18xm10,-262v-1,-10,9,-19,18,-19v9,0,19,10,19,19v0,9,-9,19,-19,18v-9,1,-19,-9,-18,-18","w":116},"\u00c8":{"d":"106,0r-81,0r0,-224r79,0r0,26r-49,0r0,71r46,0r0,25r-46,0r0,77r51,0r0,25xm90,-241r-26,0r-41,-49r43,0","w":116},"\u00cd":{"d":"29,-224r30,0r0,224r-30,0r0,-224xm85,-290r-39,49r-26,0r24,-49r41,0","w":82},"\u00ce":{"d":"29,-224r30,0r0,224r-30,0r0,-224xm96,-241r-35,0r-20,-30r-20,30r-36,0r39,-49r33,0","w":82},"\u00cf":{"d":"29,-224r30,0r0,224r-30,0r0,-224xm58,-262v-1,-10,9,-19,18,-19v9,0,20,9,19,19v1,10,-9,19,-19,18v-9,1,-19,-9,-18,-18xm-13,-262v-1,-10,9,-19,18,-19v9,0,19,10,19,19v0,9,-9,19,-19,18v-9,1,-19,-9,-18,-18","w":82},"\u00cc":{"d":"29,-224r30,0r0,224r-30,0r0,-224xm63,-241r-26,0r-41,-49r43,0","w":82},"\u00d3":{"d":"85,1v-62,0,-62,-42,-62,-114v0,-80,2,-116,62,-116v61,0,62,39,62,111v0,75,1,119,-62,119xm85,-22v32,-5,30,-37,30,-89v0,-62,5,-85,-30,-94v-35,3,-30,46,-30,91v0,49,-5,86,30,92xm127,-290r-39,49r-26,0r24,-49r41,0","w":164},"\u00d4":{"d":"85,1v-62,0,-62,-42,-62,-114v0,-80,2,-116,62,-116v61,0,62,39,62,111v0,75,1,119,-62,119xm85,-22v32,-5,30,-37,30,-89v0,-62,5,-85,-30,-94v-35,3,-30,46,-30,91v0,49,-5,86,30,92xm138,-241r-35,0r-20,-30r-20,30r-36,0r39,-49r33,0","w":164},"\u00d2":{"d":"85,1v-62,0,-62,-42,-62,-114v0,-80,2,-116,62,-116v61,0,62,39,62,111v0,75,1,119,-62,119xm85,-22v32,-5,30,-37,30,-89v0,-62,5,-85,-30,-94v-35,3,-30,46,-30,91v0,49,-5,86,30,92xm105,-241r-26,0r-41,-49r43,0","w":164},"\u00da":{"d":"79,-20v25,0,22,-19,22,-47r0,-157r30,0r0,171v0,37,-16,56,-50,56v-37,0,-56,-19,-56,-56r0,-171r30,0r0,159v2,28,0,45,24,45xm119,-290r-39,49r-26,0r24,-49r41,0","w":150},"\u00db":{"d":"79,-20v25,0,22,-19,22,-47r0,-157r30,0r0,171v0,37,-16,56,-50,56v-37,0,-56,-19,-56,-56r0,-171r30,0r0,159v2,28,0,45,24,45xm130,-241r-35,0r-20,-30r-20,30r-36,0r39,-49r33,0","w":150},"\u00d9":{"d":"79,-20v25,0,22,-19,22,-47r0,-157r30,0r0,171v0,37,-16,56,-50,56v-37,0,-56,-19,-56,-56r0,-171r30,0r0,159v2,28,0,45,24,45xm97,-241r-26,0r-41,-49r43,0","w":150},"\u0131":{"d":"23,-153r29,0r0,153r-29,0r0,-153","w":67},"\u02c6":{"d":"115,-173r-35,0r-20,-30r-20,30r-36,0r39,-49r33,0","w":119},"\u02dc":{"d":"37,-217v15,0,57,33,59,-1r23,0v0,23,-12,38,-34,40v-20,1,-57,-36,-61,0v-7,-1,-20,3,-23,-2v-1,-21,16,-37,36,-37","w":119},"\u02c9":{"d":"115,-179r-110,0r0,-26r110,0r0,26","w":119},"\u02d8":{"d":"112,-220v-3,28,-22,45,-52,45v-31,0,-48,-15,-52,-45r22,0v2,31,58,31,60,0r22,0","w":119},"\u02d9":{"d":"41,-191v0,-9,10,-19,19,-19v9,0,19,9,18,19v1,9,-9,19,-18,18v-10,1,-19,-9,-19,-18","w":119},"\u02da":{"d":"28,-198v0,-16,15,-32,32,-32v17,0,32,14,32,32v0,18,-14,33,-32,33v-17,0,-32,-16,-32,-33xm42,-198v-1,11,8,19,18,19v10,0,20,-9,19,-19v1,-10,-10,-19,-19,-19v-9,0,-19,9,-18,19","w":119},"\u00b8":{"d":"95,41v0,31,-41,37,-76,31r2,-20v19,1,48,-1,45,-13v1,-9,-11,-13,-28,-12r9,-31r23,0r-5,19v16,2,30,11,30,26","w":119},"\u02dd":{"d":"134,-222r-36,49r-27,0r23,-49r40,0xm73,-222r-37,49r-26,0r22,-49r41,0","w":119},"\u02db":{"d":"61,-4v-13,24,-7,54,19,56v9,0,18,-3,29,-9r0,21v-32,20,-77,13,-77,-28v0,-10,3,-23,8,-40r21,0","w":119},"\u02c7":{"d":"118,-222r-39,49r-34,0r-38,-49r36,0r20,29r19,-29r36,0","w":119},"\u0141":{"d":"105,0r-80,0r0,-88r-17,20v-3,-21,10,-26,17,-36r0,-120r30,0r0,86r19,-21v3,21,-12,26,-19,37r0,97r50,0r0,25","w":116},"\u0142":{"d":"69,-150v3,19,-10,21,-18,29r0,121r-28,0r0,-97r-20,16v-3,-19,12,-21,20,-30r0,-121r28,0r0,98","w":67},"\u0160":{"d":"38,-118v-37,-31,-28,-112,28,-109v11,0,21,2,32,7r0,25v-24,-16,-57,-7,-55,21v4,46,63,66,63,120v0,46,-43,69,-87,49v1,-8,-2,-21,1,-27v17,16,60,12,58,-21v-2,-29,-27,-44,-40,-65xm116,-290r-39,49r-34,0r-38,-49r36,0r20,29r19,-29r36,0","w":116},"\u0161":{"d":"25,-114v0,-35,35,-54,70,-37r0,24v-18,-9,-41,-9,-43,11v5,30,50,39,50,76v0,36,-39,52,-72,35r0,-23v20,8,43,12,45,-10v-4,-28,-50,-43,-50,-76xm112,-222r-39,49r-34,0r-38,-49r36,0r20,29r19,-29r36,0","w":113},"\u017d":{"d":"122,-224r-71,199r64,0r0,25r-101,0r71,-198r-62,0r0,-26r99,0xm124,-290r-39,49r-34,0r-38,-49r36,0r20,29r19,-29r36,0"},"\u017e":{"d":"108,-154r-55,132r50,0r0,22r-88,0r53,-131r-51,0r0,-23r91,0xm116,-222r-39,49r-34,0r-38,-49r36,0r20,29r19,-29r36,0","w":116},"\u00a6":{"d":"107,-123r-24,0r0,-127r24,0r0,127xm107,49r-24,0r0,-127r24,0r0,127","w":189},"\u00d0":{"d":"136,-113v0,88,-21,121,-109,113r0,-105r-18,0r0,-12r18,0r0,-107v84,-7,109,22,109,111xm104,-113v0,-56,0,-87,-48,-88r0,84r23,0r0,12r-23,0r0,82v49,-1,48,-36,48,-90","w":150},"\u00f0":{"d":"81,-209v27,27,36,81,36,137v0,49,-17,74,-49,74v-44,1,-48,-43,-48,-91v0,-41,19,-74,60,-64v-4,-17,-11,-31,-20,-43r-27,17r-7,-9r27,-17v-5,-5,-10,-8,-15,-11r16,-15v7,4,13,9,19,14v10,-4,23,-20,28,-4xm86,-56v0,-29,7,-74,-18,-77v-24,-3,-17,50,-18,77v0,23,7,35,19,35v11,0,17,-12,17,-35"},"\u00dd":{"d":"127,-224r-44,129r0,95r-30,0r0,-94r-43,-130r30,0r29,101r28,-101r30,0xm110,-290r-39,49r-26,0r24,-49r41,0"},"\u00fd":{"d":"125,-154r-72,222r-25,0r25,-82r-41,-140r28,0r26,106r32,-106r27,0xm110,-222r-39,49r-26,0r24,-49r41,0"},"\u00de":{"d":"120,-112v0,46,-19,65,-67,63r0,49r-30,0r0,-224r30,0r0,50v46,-4,67,12,67,62xm53,-72v25,1,36,-11,36,-37v-1,-32,-9,-46,-36,-43r0,80"},"\u00fe":{"d":"119,-76v5,68,-33,100,-67,59r0,85r-29,0r0,-300r29,0r0,96v7,-13,17,-20,30,-20v34,0,33,29,37,80xm69,-131v-25,4,-17,48,-17,76v0,16,5,31,17,33v18,-3,20,-23,20,-47v0,-34,2,-57,-20,-62"},"\u00d7":{"d":"208,-188r-71,72r71,71r-16,16r-72,-71r-71,71r-16,-16r71,-71r-72,-72r17,-16r71,71r72,-71","w":240},"\u00b9":{"d":"60,-85r-21,0r0,-124r-12,0r0,-18r33,0r0,142","w":93},"\u00b2":{"d":"48,-207v-13,1,-12,11,-12,27r-22,0v1,-28,7,-47,35,-47v20,0,33,12,33,31v0,22,-12,52,-36,92r32,0r0,19r-65,0v20,-35,50,-95,47,-107v0,-8,-4,-16,-12,-15","w":93},"\u00b3":{"d":"45,-228v41,0,45,57,19,70v29,14,17,79,-20,75v-25,-3,-33,-12,-33,-38r19,0v0,12,5,18,13,18v9,0,14,-8,14,-23v0,-18,-4,-22,-21,-22r0,-21v16,-1,21,-2,21,-19v0,-14,-4,-20,-12,-20v-10,0,-12,7,-12,19r-20,0v0,-26,12,-39,32,-39","w":93},"\u00bd":{"d":"64,-85r-21,0r0,-124r-12,0r0,-18r33,0r0,142xm210,-231r-157,247r-23,0r157,-247r23,0xm193,-110v-13,1,-12,11,-12,27r-22,0v1,-28,7,-47,35,-47v20,0,33,12,33,31v0,22,-12,52,-36,92r32,0r0,19r-65,0v20,-35,50,-95,47,-107v0,-8,-4,-16,-12,-15","w":236},"\u00bc":{"d":"226,-23r-9,0r0,35r-21,0r0,-35r-41,0v1,-48,27,-70,39,-107r23,0r0,87r9,0r0,20xm196,-43v-1,-16,2,-35,-1,-49r-21,49r22,0xm64,-85r-21,0r0,-124r-12,0r0,-18r33,0r0,142xm213,-231r-157,247r-23,0r157,-247r23,0","w":236},"\u00be":{"d":"226,-23r-9,0r0,35r-21,0r0,-35r-40,0v1,-48,27,-70,38,-107r23,0r0,87r9,0r0,20xm196,-43v-1,-16,2,-35,-1,-49r-21,49r22,0xm49,-228v41,0,45,57,19,70v29,14,17,79,-20,75v-25,-3,-33,-12,-33,-38r19,0v0,12,5,18,13,18v9,0,14,-8,14,-23v0,-18,-4,-22,-21,-22r0,-21v16,-1,21,-2,21,-19v0,-14,-4,-20,-12,-20v-10,0,-12,7,-12,19r-20,0v0,-26,12,-39,32,-39xm214,-231r-157,247r-23,0r157,-247r23,0","w":236},"\u00ad":{"d":"73,-67r-58,0r0,-22r58,0r0,22","w":82},"\u00af":{"d":"182,-250r-184,0r0,-19r184,0r0,19","w":180},"\u0102":{"d":"139,0r-29,0r-8,-44r-47,0r-9,44r-28,0r48,-224r25,0xm98,-67r-20,-106r-19,106r39,0xm129,-291v-3,28,-22,45,-52,45v-31,0,-48,-15,-52,-45r22,0v2,31,58,31,60,0r22,0","w":150},"\u0103":{"d":"57,-156v16,0,21,8,29,19r0,-17r29,0r0,154r-29,0r0,-19v-7,14,-17,21,-29,21v-32,0,-38,-28,-38,-77v0,-46,2,-81,38,-81xm69,-131v-30,-3,-18,73,-16,94v1,9,7,14,15,14v22,0,18,-27,18,-58v0,-28,3,-48,-17,-50xm121,-220v-3,28,-22,45,-52,45v-31,0,-48,-15,-52,-45r22,0v2,31,58,31,60,0r22,0"},"\u0104":{"d":"131,0v-10,22,-5,52,21,52v9,0,18,-3,29,-9r0,21v-46,31,-96,-7,-71,-64r-8,-44r-47,0r-9,44r-28,0r48,-224r25,0r48,224r-8,0xm98,-67r-20,-106r-19,106r39,0","w":150},"\u0105":{"d":"108,0v-19,38,16,68,49,43r0,21v-39,27,-91,2,-74,-48v3,-10,4,-22,3,-35v-7,14,-17,21,-29,21v-33,0,-39,-27,-38,-77v1,-46,2,-81,38,-81v11,0,21,6,29,19r0,-17r29,0r0,154r-7,0xm69,-131v-19,2,-19,22,-19,48v0,37,-4,55,18,60v20,-5,18,-25,18,-58v0,-28,4,-47,-17,-50"},"\u0106":{"d":"56,-113v0,57,11,102,61,82r0,27v-64,20,-93,-22,-93,-102v0,-84,21,-133,93,-118r0,27v-49,-14,-61,24,-61,84xm126,-290r-39,49r-26,0r24,-49r41,0"},"\u0107":{"d":"89,-126v-32,-17,-41,15,-40,51v1,45,11,61,41,47r0,23v-49,23,-72,-15,-72,-73v0,-56,22,-90,71,-73r0,25xm106,-222r-39,49r-26,0r24,-49r41,0","w":97},"\u010c":{"d":"56,-113v0,57,11,102,61,82r0,27v-64,20,-93,-22,-93,-102v0,-84,21,-133,93,-118r0,27v-49,-14,-61,24,-61,84xm138,-295r-39,49r-34,0r-38,-49r36,0r20,29r19,-29r36,0"},"\u010d":{"d":"89,-126v-32,-17,-41,15,-40,51v1,45,11,61,41,47r0,23v-49,23,-72,-15,-72,-73v0,-56,22,-90,71,-73r0,25xm115,-222r-39,49r-34,0r-38,-49r36,0r20,29r19,-29r36,0","w":97},"\u010e":{"d":"136,-113v0,88,-21,121,-110,113r0,-224v84,-7,110,22,110,111xm104,-113v0,-56,0,-87,-48,-88r0,178v49,-1,48,-36,48,-90xm133,-295r-39,49r-34,0r-38,-49r36,0r20,29r19,-29r36,0","w":150},"\u010f":{"d":"159,-232v1,30,0,47,-16,67r-9,-5v8,-12,12,-22,12,-32r-16,0r0,-30r29,0xm20,-72v0,-49,-1,-79,38,-84v13,-1,20,8,29,20r0,-96r29,0r0,232r-28,0v-1,-6,2,-16,-1,-21v-7,15,-17,23,-30,23v-35,0,-37,-31,-37,-74xm69,-22v19,-5,19,-28,19,-57v0,-29,2,-49,-19,-52v-20,3,-19,24,-19,53v0,31,-1,51,19,56","w":174},"\u0110":{"d":"136,-113v0,89,-21,121,-109,113r0,-105r-18,0r0,-12r18,0r0,-107v83,-7,109,23,109,111xm104,-113v0,-57,1,-87,-48,-88r0,84r23,0r0,12r-23,0r0,82v49,-2,48,-34,48,-90","w":150},"\u0111":{"d":"20,-72v1,-50,0,-79,38,-84v13,-2,20,8,29,20r0,-56r-29,0r0,-13r29,0r0,-27r29,0r0,27r17,0r0,13r-17,0r0,192r-28,0v-1,-6,2,-16,-1,-21v-7,15,-17,23,-30,23v-34,0,-37,-29,-37,-74xm69,-131v-29,1,-18,70,-15,95v2,9,8,14,15,14v19,-5,19,-26,19,-57v0,-31,1,-48,-19,-52"},"\u0118":{"d":"66,0v-19,38,17,68,50,43r0,21v-32,20,-78,13,-77,-28v0,-8,2,-20,6,-36r-20,0r0,-224r79,0r0,26r-49,0r0,71r46,0r0,25r-46,0r0,77r51,0r0,25r-40,0","w":116},"\u0119":{"d":"74,2v-19,36,18,66,50,41r0,21v-32,20,-77,12,-77,-28v0,-9,3,-21,7,-36v-22,-7,-33,-31,-33,-73v0,-55,16,-83,49,-83v39,0,48,34,46,84r-65,0v1,26,-3,51,20,51v16,0,16,-14,17,-31r26,0v-1,34,-14,52,-40,54xm87,-94v5,-33,-16,-56,-32,-33v-4,6,-4,17,-4,33r36,0"},"\u011a":{"d":"106,0r-81,0r0,-224r79,0r0,26r-49,0r0,71r46,0r0,25r-46,0r0,77r51,0r0,25xm121,-295r-39,49r-34,0r-38,-49r36,0r20,29r19,-29r36,0","w":116},"\u011b":{"d":"70,-156v39,0,47,33,46,84r-65,0v2,27,-2,48,20,51v16,-1,16,-13,17,-31r26,0v-1,36,-16,54,-46,54v-32,0,-47,-25,-47,-75v0,-55,16,-83,49,-83xm87,-94v5,-32,-16,-58,-32,-32v-2,7,-4,17,-4,32r36,0xm123,-222r-39,49r-34,0r-38,-49r36,0r20,29r19,-29r36,0"},"\u0139":{"d":"105,0r-81,0r0,-224r30,0r0,199r51,0r0,25xm104,-290r-39,49r-26,0r24,-49r41,0","w":116},"\u013a":{"d":"52,0r-29,0r0,-232r29,0r0,232xm85,-303r-39,49r-26,0r24,-49r41,0","w":67},"\u013d":{"d":"105,0r-81,0r0,-224r30,0r0,199r51,0r0,25xm114,-295r-39,49r-34,0r-38,-49r36,0r20,29r19,-29r36,0","w":116},"\u013e":{"d":"97,-231v1,30,0,47,-16,67r-9,-5v8,-12,11,-23,11,-33r-16,0r0,-29r30,0xm52,0r-29,0r0,-232r29,0r0,232","w":110},"\u0143":{"d":"131,0r-24,0r-58,-154r0,154r-27,0r0,-224r24,0r58,154r0,-154r27,0r0,224xm119,-290r-39,49r-26,0r24,-49r41,0","w":150},"\u0144":{"d":"68,-134v-12,0,-18,10,-18,22r0,112r-29,0r0,-154r29,0v1,5,-2,12,1,15v15,-28,63,-22,63,19r0,120r-28,0r0,-112v0,-15,-6,-22,-18,-22xm111,-222r-39,49r-26,0r24,-49r41,0"},"\u0147":{"d":"131,0r-24,0r-58,-154r0,154r-27,0r0,-224r24,0r58,154r0,-154r27,0r0,224xm134,-295r-39,49r-34,0r-38,-49r36,0r20,29r19,-29r36,0","w":150},"\u0148":{"d":"68,-134v-12,0,-18,10,-18,22r0,112r-29,0r0,-154r29,0v1,5,-2,12,1,15v15,-28,63,-22,63,19r0,120r-28,0r0,-112v0,-15,-6,-22,-18,-22xm122,-222r-39,49r-34,0r-38,-49r36,0r20,29r19,-29r36,0"},"\u0150":{"d":"85,1v-62,0,-62,-42,-62,-114v0,-80,2,-116,62,-116v61,0,62,39,62,111v0,75,1,119,-62,119xm85,-22v32,-5,30,-37,30,-89v0,-62,5,-85,-30,-94v-35,3,-30,46,-30,91v0,49,-5,86,30,92xm164,-290r-36,49r-27,0r23,-49r40,0xm103,-290r-37,49r-26,0r22,-49r41,0","w":164},"\u0151":{"d":"68,-156v40,0,49,29,49,81v0,48,-11,77,-48,77v-40,0,-50,-33,-50,-78v0,-52,10,-80,49,-80xm68,-21v20,-3,18,-20,18,-47v0,-38,5,-59,-18,-65v-18,2,-18,20,-18,44v0,44,-5,60,18,68xm144,-222r-36,49r-27,0r23,-49r40,0xm83,-222r-37,49r-26,0r22,-49r41,0"},"\u0154":{"d":"117,-167v0,34,-8,51,-32,59r38,108r-31,0r-35,-105r-3,0r0,105r-30,0r0,-224v54,-3,93,1,93,57xm88,-163v0,-25,-9,-38,-34,-38r0,75v26,-1,33,-10,34,-37xm116,-290r-39,49r-26,0r24,-49r41,0"},"\u0155":{"d":"87,-131v-60,-4,-30,82,-37,131r-29,0r0,-154r29,0v1,7,-2,18,1,23v9,-18,20,-25,36,-25r0,25xm97,-222r-39,49r-26,0r24,-49r41,0","w":97},"\u0158":{"d":"117,-167v0,34,-8,51,-32,59r38,108r-31,0r-35,-105r-3,0r0,105r-30,0r0,-224v54,-3,93,1,93,57xm88,-163v0,-25,-9,-38,-34,-38r0,75v26,-1,33,-10,34,-37xm123,-295r-39,49r-34,0r-38,-49r36,0r20,29r19,-29r36,0"},"\u0159":{"d":"87,-131v-60,-4,-30,82,-37,131r-29,0r0,-154r29,0v1,7,-2,18,1,23v9,-18,20,-25,36,-25r0,25xm106,-222r-39,49r-34,0r-38,-49r36,0r20,29r19,-29r36,0","w":97},"\u015a":{"d":"38,-118v-37,-31,-28,-112,28,-109v11,0,21,2,32,7r0,25v-24,-16,-57,-7,-55,21v4,46,63,66,63,120v0,46,-43,69,-87,49v1,-8,-2,-21,1,-27v17,16,60,12,58,-21v-2,-29,-27,-44,-40,-65xm109,-290r-39,49r-26,0r24,-49r41,0","w":116},"\u015b":{"d":"25,-114v0,-35,35,-54,70,-37r0,24v-18,-9,-41,-9,-43,11v5,30,50,39,50,76v0,36,-39,52,-72,35r0,-23v20,8,43,12,45,-10v-4,-28,-50,-43,-50,-76xm108,-222r-39,49r-26,0r24,-49r41,0","w":113},"\u015e":{"d":"75,15v1,30,0,47,-16,67r-9,-5v8,-12,12,-23,12,-33r-16,0r0,-29r29,0xm38,-118v-37,-31,-28,-112,28,-109v11,0,21,2,32,7r0,25v-24,-16,-57,-7,-55,21v4,46,63,66,63,120v0,46,-43,69,-87,49v1,-8,-2,-21,1,-27v17,16,60,12,58,-21v-2,-29,-27,-44,-40,-65","w":116},"\u015f":{"d":"81,15v1,30,0,47,-16,67r-9,-5v8,-12,12,-23,12,-33r-16,0r0,-29r29,0xm25,-114v0,-35,35,-54,70,-37r0,24v-18,-9,-41,-9,-43,11v5,30,50,39,50,76v0,36,-39,52,-72,35r0,-23v20,8,43,12,45,-10v-4,-28,-50,-43,-50,-76","w":113},"\u0162":{"d":"76,15v1,30,0,47,-16,67r-9,-5v8,-12,11,-23,11,-33r-16,0r0,-29r30,0xm110,-198r-34,0r0,198r-30,0r0,-198r-34,0r0,-26r98,0r0,26","w":116},"\u0163":{"d":"59,15v1,30,0,47,-16,67r-10,-5v8,-12,12,-23,12,-33r-16,0r0,-29r30,0xm77,-131r-19,0r0,131r-29,0r0,-131r-18,0r0,-23r18,0r0,-41r29,0r0,41r19,0r0,23","w":82},"\u0164":{"d":"110,-198r-34,0r0,198r-30,0r0,-198r-34,0r0,-26r98,0r0,26xm116,-295r-39,49r-34,0r-38,-49r36,0r20,29r19,-29r36,0","w":116},"\u0165":{"d":"112,-231v1,30,0,47,-16,67r-9,-5v8,-12,12,-23,12,-33r-16,0r0,-29r29,0xm77,-131r-19,0r0,131r-29,0r0,-131r-18,0r0,-23r18,0r0,-41r29,0r0,41r19,0r0,23","w":124},"\u016e":{"d":"79,-20v25,0,22,-19,22,-47r0,-157r30,0r0,171v0,37,-16,56,-50,56v-37,0,-56,-19,-56,-56r0,-171r30,0r0,159v2,28,0,45,24,45xm46,-271v0,-16,15,-32,32,-32v17,0,32,14,32,32v0,18,-14,33,-32,33v-17,0,-32,-16,-32,-33xm60,-271v-1,11,8,19,18,19v10,0,20,-9,19,-19v1,-10,-10,-19,-19,-19v-9,0,-19,9,-18,19","w":150},"\u016f":{"d":"68,-21v14,0,18,-10,18,-28r0,-105r28,0v-7,61,25,156,-46,156v-71,0,-39,-95,-46,-156r28,0r0,107v0,17,6,26,18,26xm36,-198v0,-16,15,-32,32,-32v17,0,32,14,32,32v0,18,-14,33,-32,33v-17,0,-32,-16,-32,-33xm50,-198v-1,11,8,19,18,19v10,0,20,-9,19,-19v1,-10,-10,-19,-19,-19v-9,0,-19,9,-18,19"},"\u0170":{"d":"79,-20v25,0,22,-19,22,-47r0,-157r30,0r0,171v0,37,-16,56,-50,56v-37,0,-56,-19,-56,-56r0,-171r30,0r0,159v2,28,0,45,24,45xm153,-290r-36,49r-27,0r23,-49r40,0xm92,-290r-37,49r-26,0r22,-49r41,0","w":150},"\u0171":{"d":"68,-21v14,0,18,-10,18,-28r0,-105r28,0v-7,61,25,156,-46,156v-71,0,-39,-95,-46,-156r28,0r0,107v0,17,6,26,18,26xm142,-222r-36,49r-27,0r23,-49r40,0xm81,-222r-37,49r-26,0r22,-49r41,0"},"\u0179":{"d":"122,-224r-71,199r64,0r0,25r-101,0r71,-198r-62,0r0,-26r99,0xm113,-290r-39,49r-26,0r24,-49r41,0"},"\u017a":{"d":"108,-154r-55,132r50,0r0,22r-88,0r53,-131r-51,0r0,-23r91,0xm102,-222r-39,49r-26,0r24,-49r41,0","w":116},"\u017b":{"d":"122,-224r-71,199r64,0r0,25r-101,0r71,-198r-62,0r0,-26r99,0xm53,-267v0,-9,10,-19,19,-19v9,0,19,9,18,19v1,9,-9,19,-18,18v-10,1,-19,-9,-19,-18"},"\u017c":{"d":"108,-154r-55,132r50,0r0,22r-88,0r53,-131r-51,0r0,-23r91,0xm44,-191v0,-9,10,-19,19,-19v9,0,19,9,18,19v1,9,-9,19,-18,18v-10,1,-19,-9,-19,-18","w":116},"\u00a4":{"d":"184,-164v21,22,21,73,0,95r22,23r-16,15r-22,-22v-23,21,-74,21,-96,0r-22,22r-16,-15r23,-23v-22,-21,-22,-75,0,-96r-23,-22r16,-15r22,22v23,-21,73,-21,96,0r22,-22r16,15xm63,-117v0,31,26,58,57,58v31,0,57,-27,57,-58v0,-31,-26,-56,-57,-56v-31,0,-57,26,-57,56","w":246}}});
