/*!
 * The following copyright notice may not be removed under any circumstances.
 * 
 * Copyright:
 * Copyright (c) 2010, Yanone (http://yanone.de/typedesign/). All rights reserved.
 * This Font Software is licensed under the SIL Open Font License, Version 1.1.
 * This license is available with a FAQ at: http://scripts.sil.org/OFL
 * 
 * Trademark:
 * Yanone Kaffeesatz is a trademark of Yanone
 * 
 * Description:
 * Yanone Kaffeesatz was first published in 2004 and is Yanone's first ever
 * finished typeface. Its Bold is reminiscent of 1920s coffee house typography,
 * while the rather thin fonts bridge the gap to present times. Lacking self
 * confidence and knowledge about the type scene Yanone decided to publish the
 * family for free under a Creative Commons License. A decision that should turn
 * out one of the best he ever made. It has been downloaded over 100,000 times to
 * date from this website alone, and you can witness Kaffeesatz use on German
 * fresh-water gyms, Dubai mall promos and New Zealand McDonald's ads. And of
 * course on coffee and foodstuff packaging and cafe design around the globe. In
 * 2009 he reworked much of the typeface and it got published in FontShop's
 * FontFont Library under the new name FF Kava. You can read more about it in an
 * extensive article by Yves Peters on the FontFeed.
 * 
 * Manufacturer:
 * Yanone
 * 
 * Designer:
 * Yanone
 * 
 * Vendor URL:
 * http://yanone.de/typedesign/
 * 
 * License information:
 * http://scripts.sil.org/OFL
 */
Cufon.registerFont({"w":150,"face":{"font-family":"Yanone Kaffeesatz Regular","font-weight":400,"font-stretch":"normal","units-per-em":"360","panose-1":"2 0 0 0 0 0 0 0 0 0","ascent":"288","descent":"-72","x-height":"4","bbox":"-39 -345 337 73.815","underline-thickness":"25.56","underline-position":"-1.44","unicode-range":"U+0020-U+FB04"},"glyphs":{" ":{"w":56},"#":{"d":"115,-68v-2,10,4,28,-8,29r-19,0r1,-29r-34,0v-2,10,4,28,-7,29r-20,0r2,-29r-20,0v1,-8,-4,-24,6,-23r15,0r2,-39r-23,0v1,-9,-4,-23,6,-23r18,0v2,-10,-4,-27,8,-27v4,0,10,-1,19,-1r-1,28r34,0v2,-9,-4,-26,7,-27v4,0,11,-1,20,-1r-1,28r20,0v-1,8,4,23,-5,23r-17,0r-2,39r24,0v-1,8,4,22,-5,23r-20,0xm57,-91r34,0r2,-39r-35,0"},"$":{"d":"110,-104v34,30,25,103,-25,105v-1,23,8,48,-26,43r0,-41v-31,1,-51,-16,-32,-40v18,17,76,18,71,-20v-8,-55,-79,-62,-79,-119v0,-28,19,-42,46,-45v1,-23,-8,-49,26,-44r0,43v29,0,48,12,30,33v-20,-13,-90,-11,-66,27v14,21,36,41,55,58"},"%":{"d":"65,-122v-40,1,-49,-25,-49,-67v0,-41,15,-65,51,-66v39,0,48,26,48,66v1,41,-14,66,-50,67xm67,-232v-22,0,-23,21,-23,44v0,23,0,43,22,43v30,-2,34,-87,1,-87xm183,3v-42,2,-49,-26,-49,-67v0,-41,15,-65,51,-66v39,0,48,26,48,66v1,41,-14,66,-50,67xm185,-106v-22,0,-23,20,-23,44v1,22,-1,45,21,43v19,-1,23,-18,23,-44v0,-23,0,-43,-21,-43xm187,-255v29,8,7,31,-6,53r-121,205v-7,-3,-16,-4,-18,-11","w":248},"&":{"d":"22,-204v-1,-35,24,-50,60,-50v33,0,69,9,47,38v-19,-15,-81,-24,-76,15v7,52,44,91,70,129v7,-41,1,-87,-19,-107v23,0,47,-3,70,-1v7,22,-9,25,-32,23v16,25,16,80,3,111v10,10,19,21,30,26v-1,12,-8,21,-19,24v-8,-4,-18,-14,-26,-23v-32,40,-129,26,-121,-42v4,-32,19,-55,41,-68v-13,-22,-27,-46,-28,-75xm40,-60v0,42,54,45,71,19r-48,-67v-14,9,-23,25,-23,48","w":180},"'":{"d":"40,-282v-7,23,11,75,-24,72v-1,-24,-6,-49,-4,-72v9,0,20,-2,28,0","w":50,"k":{"z":25,"y":26,"x":23,"Y":-7,"W":-6,"V":-6,"T":-5,"O":7,"w":25,"v":25,"u":26,"t":6,"s":33,"p":36,"o":33,"n":35,"g":39,"f":16,"e":37,"d":40,"c":34,"a":26,"]":-7,"[":28,"J":48,"G":13,"C":20,"A":43,")":-7,"(":28,"\ufb04":16,"\ufb03":16,"\ufb00":16,"\u20ac":44,"\u017e":25,"\u0178":-7,"\u0161":33,"\u0160":4,"\u0153":33,"\u0152":7,"\u00ff":26,"\u00fd":26,"\u00fc":26,"\u00fb":26,"\u00fa":26,"\u00f9":26,"\u00f8":33,"\u00f6":33,"\u00f5":33,"\u00f4":33,"\u00f3":33,"\u00f2":33,"\u00f1":35,"\u00ef":-19,"\u00ee":-15,"\u00ec":-19,"\u00eb":37,"\u00ea":37,"\u00e9":37,"\u00e8":37,"\u00e7":34,"\u00e6":26,"\u00e5":26,"\u00e4":26,"\u00e3":26,"\u00e2":26,"\u00e1":26,"\u00e0":26,"\u00dd":-7,"\u00dc":4,"\u00db":4,"\u00d8":7,"\u00d6":7,"\u00d5":7,"\u00d4":7,"\u00d3":7,"\u00d2":7,"\u00d1":3,"\u00cf":-7,"\u00ce":-15,"\u00cb":6,"\u00ca":2,"\u00c7":20,"\u00c6":43,"\u00c5":43,"\u00c4":43,"\u00c3":43,"\u00c2":43,"\u00c1":43,"\u00c0":43,"\u00bf":37,"\u00a2":20,"r":35,"q":40,"m":35,"\\":-13,"Q":7,"@":27,"?":-7,"9":17,"6":11,"4":36,"3":1,"2":7,"1":14,"0":15,"\/":44,"+":8}},"(":{"d":"98,-270v-61,66,-58,252,0,319v-3,11,-5,20,-17,21v-75,-64,-78,-296,0,-359v13,0,13,7,17,19","w":105,"k":{"\ufb00":9,"\u20ac":21,"\u2044":14,"\u2039":6,"\u2019":-7,"\u2018":-7,"\u2014":12,"\u2013":12,"\u017e":9,"\u0153":12,"\u0152":7,"\u00ff":-6,"\u00fd":-6,"\u00fc":11,"\u00fb":11,"\u00fa":11,"\u00f9":11,"\u00f8":12,"\u00f6":12,"\u00f5":12,"\u00f4":12,"\u00f3":12,"\u00f2":12,"\u00f1":10,"\u00ef":-5,"\u00ed":6,"\u00ec":-9,"\u00eb":11,"\u00ea":11,"\u00e9":11,"\u00e8":11,"\u00e7":11,"\u00e6":9,"\u00e4":9,"\u00e3":9,"\u00e2":9,"\u00e1":9,"\u00e0":9,"\u00d8":7,"\u00d6":7,"\u00d5":7,"\u00d4":7,"\u00d3":7,"\u00d2":7,"\u00cf":-4,"\u00ce":-21,"\u00c7":10,"\u00c6":9,"\u00c5":9,"\u00c4":9,"\u00c3":9,"\u00c2":9,"\u00c1":9,"\u00c0":9,"\u00a2":21,"r":10,"q":11,"m":10,"]":-19,"\\":-9,"[":18,"Q":7,"\/":6,"+":17,"*":8,"'":-7,"C":10,"G":7,"d":11,"t":5,"u":11,"v":13,"w":13,"y":-6,"c":11,"e":11,"o":12,"\"":-7,"-":12,"\u2212":12,"\u201c":-7,"\u201d":-7,"\u00ab":6,"O":7,"A":9,"x":8,"a":9,"\u00e5":9,"z":9,"Z":5,"\u017d":5,"n":10,"j":-44}},")":{"d":"8,49v56,-70,60,-250,0,-319v3,-12,3,-19,16,-19v79,63,74,294,0,359v-12,-1,-14,-10,-16,-21","w":105,"k":{"\u2019":27,"\u2018":27,"'":27,"\"":27,"\u201c":27,"\u201d":27}},"*":{"d":"71,-240v1,-13,21,-7,29,-4v-4,21,-3,46,-10,63v-2,1,-5,1,-10,0xm155,-207v7,4,13,25,3,30r-57,13v-5,-7,-6,-11,1,-14xm72,-175v1,7,-2,13,-9,10r-57,-16v1,-13,6,-26,19,-24xm118,-88v-9,-21,-23,-41,-29,-63v1,-1,4,-3,9,-5v13,19,35,32,42,55v-4,6,-13,11,-22,13xm67,-152v4,-4,9,-3,14,3r-32,56v-11,9,-21,-7,-25,-15","w":169,"k":{"\u0153":4,"\u0152":3,"\u00f8":4,"\u00f6":4,"\u00f5":4,"\u00f4":4,"\u00f3":4,"\u00f2":4,"\u00eb":7,"\u00ea":7,"\u00e9":7,"\u00e8":7,"\u00d8":3,"\u00d6":3,"\u00d5":3,"\u00d4":3,"\u00d3":3,"\u00d2":3,"o":4,"g":11,"e":7,"d":7,"c":7,"]":8,"Z":6,"X":3,"T":3,"Q":3,"O":3,"J":46,"A":17,")":8,"\u20ac":8,"\u017d":11,"\u00e7":10,"\u00c6":40,"\u00c5":17,"\u00c4":17,"\u00c3":17,"\u00c2":17,"\u00c1":17,"\u00c0":17,"q":4,"4":10,"\/":20}},"+":{"d":"88,-89r0,45v-1,9,-17,4,-25,5r0,-50r-51,0v2,-13,-2,-22,6,-25r45,0v3,-23,-14,-58,25,-51r0,51r50,0v-1,9,4,25,-6,25r-44,0","k":{"\"":8,"\u201d":8,"\u201c":8,"]":15,")":15,"\u2019":8,"\u2018":8,"'":8}},",":{"d":"25,37v-22,-4,1,-22,-1,-39v-15,-8,-9,-39,10,-37v40,4,11,69,-9,76","w":65,"k":{"\u00f8":7,"y":17,"w":12,"v":16,"u":9,"t":17,"o":7,"j":-17,"f":14,"e":7,"d":7,"c":3,"Y":22,"W":11,"V":17,"U":3,"T":32,"O":10,"G":5,"C":11,"\ufb04":14,"\ufb03":14,"\ufb00":14,"\u0178":22,"\u0153":7,"\u0152":10,"\u00ff":17,"\u00fd":17,"\u00fc":9,"\u00fb":9,"\u00fa":9,"\u00f9":9,"\u00f6":7,"\u00f5":7,"\u00f4":7,"\u00f3":7,"\u00f2":7,"\u00eb":7,"\u00ea":7,"\u00e9":7,"\u00e8":7,"\u00e7":3,"\u00dd":22,"\u00dc":3,"\u00db":3,"\u00da":3,"\u00d9":3,"\u00d8":10,"\u00d6":10,"\u00d5":10,"\u00d4":10,"\u00d3":10,"\u00d2":10,"\u00c7":11,"q":7,"\\":46,"Q":10,"\/":-3}},"-":{"d":"13,-89v2,-13,-2,-22,6,-25r68,0v-2,13,3,23,-6,25r-68,0","w":100,"k":{"\ufb04":11,"\ufb03":11,"\ufb00":11,"\u017e":22,"\u017d":17,"\u0178":23,"\u0160":33,"\u00ff":12,"\u00fd":12,"\u00dd":23,"\u00c6":12,"\u00c5":12,"\u00c4":12,"\u00c3":12,"\u00c2":12,"\u00c1":12,"\u00c0":12,"\\":30,"T":38,"V":13,"W":10,"Y":23,"f":11,"t":10,"v":9,"w":7,"y":12,")":11,"]":11,"A":12,"J":44,"X":23,"x":27,"S":33,"z":22,"\u00bb":11,"\u203a":11,"Z":17}},".":{"d":"33,2v-15,1,-20,-8,-20,-20v0,-11,8,-21,20,-21v14,0,21,8,21,21v0,11,-10,20,-21,20","w":65,"k":{"\ufb04":14,"\ufb03":14,"\ufb00":14,"\u0178":22,"\u0153":7,"\u0152":10,"\u00ff":17,"\u00fd":17,"\u00fc":9,"\u00fb":9,"\u00fa":9,"\u00f9":9,"\u00f6":7,"\u00f5":7,"\u00f4":7,"\u00f3":7,"\u00f2":7,"\u00eb":7,"\u00ea":7,"\u00e9":7,"\u00e8":7,"\u00e7":3,"\u00dd":22,"\u00dc":3,"\u00db":3,"\u00da":3,"\u00d9":3,"\u00d8":10,"\u00d6":10,"\u00d5":10,"\u00d4":10,"\u00d3":10,"\u00d2":10,"\u00c7":11,"q":7,"\\":46,"Q":10,"\/":-3,"C":11,"G":5,"T":32,"V":17,"W":11,"Y":22,"d":7,"f":14,"t":17,"u":9,"v":16,"w":12,"y":17,"c":3,"e":7,"o":7,"\u00f8":7,"O":10,"U":3}},"\/":{"d":"85,-267v0,-13,20,-7,32,-8r-81,275v-2,10,-20,6,-32,7","w":120,"k":{"\"":-12,"\u201e":63,"\u201d":-12,"\u201c":-12,"\u017f":7,"\u00ff":9,"\u00df":7,"\u00d3":8,"\u00bb":14,"\u00ab":22,"z":12,"y":9,"x":16,"w":7,"v":5,"u":14,"t":6,"s":21,"p":19,"o":22,"n":18,"j":4,"i":2,"g":21,"f":6,"e":24,"d":24,"c":25,"a":14,"Z":8,"Y":-5,"X":6,"W":-6,"V":-4,"T":-6,"O":8,"J":28,"G":9,"C":14,"A":22,":":22,".":60,")":-13,"\ufb00":5,"\u2212":12,"\u20ac":19,"\u203a":19,"\u2039":24,"\u2026":63,"\u2022":18,"\u201a":63,"\u2019":-14,"\u2018":-12,"\u2014":11,"\u2013":22,"\u017e":2,"\u017d":5,"\u0178":-8,"\u0161":12,"\u0160":5,"\u0153":21,"\u0152":9,"\u0131":23,"\u00fd":5,"\u00fc":15,"\u00fb":16,"\u00fa":16,"\u00f9":18,"\u00f8":26,"\u00f7":22,"\u00f6":16,"\u00f5":15,"\u00f4":14,"\u00f3":19,"\u00f2":15,"\u00f1":6,"\u00ef":-19,"\u00ee":-4,"\u00ed":5,"\u00ec":-16,"\u00eb":18,"\u00ea":19,"\u00e9":18,"\u00e8":20,"\u00e7":26,"\u00e6":19,"\u00e5":13,"\u00e4":9,"\u00e3":5,"\u00e2":13,"\u00e1":17,"\u00e0":13,"\u00dd":-5,"\u00dc":-1,"\u00d8":12,"\u00d7":22,"\u00d6":5,"\u00d5":10,"\u00d4":5,"\u00d2":6,"\u00d1":6,"\u00cf":-3,"\u00ce":-9,"\u00cb":3,"\u00ca":4,"\u00c7":12,"\u00c6":56,"\u00c5":22,"\u00c4":20,"\u00c3":22,"\u00c2":20,"\u00c1":27,"\u00c0":18,"\u00bf":18,"\u00b7":21,"\u00a2":31,"\u00a1":13,"r":18,"q":26,"m":18,"_":51,"]":-4,"\\":-5,"[":16,"Q":4,"B":2,"@":14,"?":-11,"=":23,";":21,"9":14,"8":8,"7":4,"6":13,"5":8,"4":31,"3":15,"2":15,"1":15,"0":18,"\/":48,",":60,"'":-12,"%":10}},"0":{"d":"74,3v-57,0,-64,-51,-64,-110v0,-61,12,-109,66,-109v53,0,64,42,64,101v0,62,-6,118,-66,118xm77,-190v-34,3,-35,43,-35,86v0,40,-1,77,33,81v34,-5,34,-45,34,-93v0,-41,0,-70,-32,-74","k":{"\"":16,"\u201d":16,"\u201c":16,"\u0178":14,"\u00dd":14,"Y":14,"X":11,"W":8,"V":8,"T":22,"J":11,"\u2019":16,"\u2018":16,"_":23,"]":24,"\\":13,"'":16}},"1":{"d":"66,-186v-14,2,-29,2,-41,7v-2,-6,-5,-11,-4,-19v16,-9,53,-21,76,-16r-4,186v16,-1,33,1,47,-1v-2,14,3,26,-6,29r-123,0v-10,-32,23,-26,51,-28","k":{"\"":32,"\u201d":32,"\u201c":32,"\u2019":32,"\u2018":32,"\/":-1,"*":21,"'":32}},"2":{"d":"102,-163v3,-39,-61,-24,-81,-12v-16,-36,28,-39,60,-41v73,-5,57,83,24,117v-21,22,-39,44,-56,71r91,-2v-2,15,3,27,-6,30r-122,0v0,-73,84,-93,90,-163","k":{"\"":8,"\u201d":8,"\u201c":8,"\u2019":8,"\u2018":8,"\/":-3,"'":8}},"3":{"d":"15,-197v18,-27,119,-33,112,24v-4,33,-20,50,-39,65v30,3,48,20,48,53v0,57,-28,88,-82,91v-31,2,-46,-14,-34,-39v36,28,84,0,84,-51v0,-32,-26,-37,-57,-37r-1,-19v24,-11,47,-27,48,-55v1,-37,-58,-21,-75,-10v-4,-6,-3,-14,-4,-22","k":{"\"":10,"\u201d":10,"\u201c":10,"\u2019":10,"\u2018":10,"_":10,"\/":-2,"'":10}},"4":{"d":"10,-73v22,-55,42,-148,105,-141r-1,140v11,2,28,-8,28,9v0,16,-10,20,-28,18v-2,24,11,55,-29,47r0,-47r-66,0v-7,-6,-8,-16,-9,-26xm85,-74r4,-104v-22,27,-43,66,-54,104r50,0","k":{"\"":10,"\u201d":10,"\u201c":10,"\u2019":10,"\u2018":10,"*":10,"'":10}},"5":{"d":"105,-64v4,-51,-46,-56,-90,-46r11,-106r110,0v6,42,-47,22,-86,25r-5,54v53,-8,91,11,91,67v0,63,-23,104,-83,106v-27,1,-50,-9,-38,-39v8,7,20,12,35,12v41,0,52,-33,55,-73","k":{"_":11}},"6":{"d":"129,-220v-62,-21,-91,25,-90,88v26,-47,109,-27,102,44v-5,55,-18,90,-69,91v-60,1,-61,-55,-61,-114v0,-81,15,-141,96,-141v20,0,32,13,22,32xm74,-23v46,3,54,-108,6,-108v-16,0,-33,9,-41,29v0,45,3,77,35,79","k":{"\"":-1,"\u201d":-1,"\u201c":-1,"\u2019":-1,"\u2018":-1,"_":13,"'":-1}},"7":{"d":"145,-216v-36,76,-74,150,-86,248v-16,-1,-27,1,-30,-8v11,-81,43,-156,76,-215r-81,1v-8,-1,-8,-15,-8,-26r129,0","k":{"\u00c6":27,"q":22,"g":22,"e":17,"d":22,"a":13,"]":8,"X":9,"J":37,"A":27,";":17,":":17,")":8,"\u017e":13,"\u017d":27,"\u0161":13,"\u0160":27,"\u00ff":13,"\u00fc":13,"\u00fb":13,"\u00f6":13,"\u00f5":13,"\u00f4":13,"\u00f1":13,"\u00ef":13,"\u00ee":13,"\u00eb":17,"\u00ea":17,"\u00e9":17,"\u00e8":17,"\u00e6":13,"\u00e5":13,"\u00e4":13,"\u00e3":13,"\u00e2":13,"\u00e1":13,"\u00e0":13,"\u00dc":27,"\u00db":27,"\u00d6":27,"\u00d5":27,"\u00d4":27,"\u00d1":27,"\u00cb":27,"\u00ca":27,"\u00c5":27,"\u00c4":27,"\u00c3":27,"\u00c2":27,"\u00c1":27,"\u00c0":27,"_":59,"@":11,"\/":21}},"8":{"d":"14,-192v0,-39,22,-61,61,-62v40,-1,64,17,64,58v0,33,-19,50,-39,63v21,15,41,33,41,67v0,41,-21,69,-63,69v-44,0,-66,-25,-67,-69v0,-33,20,-56,41,-69v-19,-13,-38,-28,-38,-57xm76,-25v41,0,46,-59,20,-78v-7,-6,-12,-11,-20,-16v-18,9,-38,25,-37,51v0,24,13,43,37,43xm112,-195v-1,-20,-11,-31,-33,-31v-36,0,-47,43,-22,61v5,6,15,12,22,17v15,-10,34,-24,33,-47","k":{"_":8}},"9":{"d":"50,37v-25,1,-40,-7,-30,-31v63,15,90,-27,91,-88v-11,16,-23,25,-49,25v-38,-1,-51,-32,-52,-72v-1,-56,18,-89,68,-90v61,-1,62,51,62,112v0,84,-16,140,-90,144xm39,-132v0,56,56,60,73,23v-1,-40,4,-84,-34,-84v-29,0,-39,26,-39,61","k":{"\"":8,"\u201d":8,"\u201c":8,"\u2019":8,"\u2018":8,"_":9,"'":8}},":":{"d":"33,-118v-15,0,-19,-9,-20,-21v0,-11,9,-21,20,-21v14,0,21,8,21,21v0,12,-9,21,-21,21xm33,2v-15,1,-19,-8,-20,-20v0,-11,9,-21,20,-21v14,0,21,8,21,21v0,11,-10,20,-21,20","w":65,"k":{"\/":-3,"T":19,"V":2}},";":{"d":"33,-118v-15,0,-20,-8,-20,-21v-1,-12,8,-21,20,-21v14,0,19,9,20,21v1,12,-8,21,-20,21xm24,37v-23,-4,0,-22,-2,-39v-14,-8,-8,-38,10,-37v39,5,11,68,-8,76","w":65,"k":{"j":-23,"T":19,"\/":-4,"V":2}},"=":{"d":"12,-122v2,-13,-2,-23,6,-26r120,0v-1,9,4,26,-6,26r-120,0xm12,-55v2,-13,-2,-23,6,-26r120,0v-1,9,4,26,-6,26r-120,0","k":{"\/":-2}},"?":{"d":"47,2v-15,1,-20,-7,-20,-20v-1,-12,8,-21,20,-21v14,0,19,9,20,21v1,12,-9,20,-20,20xm7,-240v25,-29,103,-18,95,34v3,52,-40,62,-44,104v5,21,2,31,-25,27v-20,-54,32,-75,38,-123v4,-33,-44,-33,-60,-19v-2,-7,-5,-14,-4,-23","w":106,"k":{"\"":-8,"\u201d":-8,"\u201c":-8,"\u00c6":19,"J":9,"A":19,"\u2019":-8,"\u2018":-8,"\u017d":19,"\u0160":19,"\u00dc":19,"\u00db":19,"\u00d6":19,"\u00d5":19,"\u00d4":19,"\u00d1":19,"\u00cb":19,"\u00ca":19,"\u00c5":19,"\u00c4":19,"\u00c3":19,"\u00c2":19,"\u00c1":19,"\u00c0":19,"'":-8}},"@":{"d":"177,-28v43,7,41,-50,42,-94v2,-62,-16,-99,-78,-98v-74,1,-94,51,-94,129v0,77,11,132,85,131v37,1,60,-5,84,-16v4,5,8,13,8,21v-13,23,-53,21,-89,23v-99,4,-118,-62,-118,-163v0,-93,36,-151,125,-151v75,0,108,39,107,117v-1,63,-3,121,-57,128v-10,1,-17,-4,-22,-8v-8,5,-24,9,-40,9v-35,1,-44,-21,-45,-56v-1,-43,25,-68,67,-55v2,-21,3,-44,-21,-42v-17,1,-24,2,-36,9v-13,-27,17,-34,46,-34v64,0,32,89,36,150xm113,-55v-8,35,35,45,37,14r2,-52v-28,-5,-40,10,-39,38","w":265,"k":{"\"":14,"\u201d":14,"\u201c":14,"\u0178":6,"\u00dd":6,"x":3,"j":-18,"Y":6,"X":4,"V":5,"T":10,"J":8,"\u2019":14,"\u2018":14,"7":4,"\/":-2,"'":14}},"A":{"d":"155,-5v1,9,-19,5,-30,5r-15,-64r-62,0r-14,59v-2,9,-21,6,-32,5r64,-248v1,-6,19,-6,25,-4xm54,-91r50,0r-25,-120","w":157,"k":{"\ufb04":8,"\ufb03":8,"\ufb00":8,"\u2122":8,"\u2039":4,"\u2019":38,"\u2018":38,"\u2014":14,"\u2013":14,"\u0178":28,"\u0161":2,"\u0153":8,"\u0152":6,"\u00ff":17,"\u00fd":17,"\u00fc":5,"\u00fb":5,"\u00fa":5,"\u00f9":5,"\u00f6":8,"\u00f5":8,"\u00f4":8,"\u00f3":8,"\u00f2":8,"\u00eb":5,"\u00ea":5,"\u00e9":5,"\u00e8":5,"\u00e7":2,"\u00e6":2,"\u00dd":28,"\u00d8":6,"\u00d6":6,"\u00d5":6,"\u00d4":6,"\u00d3":6,"\u00d2":6,"\u00c7":9,"q":6,"\\":25,"Q":4,"7":7,"\/":-9,"*":21,"'":38}},"B":{"d":"129,-86v0,70,-40,93,-114,86r0,-245v3,-14,31,-7,46,-7v38,0,61,16,60,56v0,31,-10,52,-34,58v28,2,42,20,42,52xm89,-190v0,-29,-13,-40,-44,-36r0,77v32,4,44,-10,44,-41xm95,-83v2,-35,-15,-44,-50,-41r0,98v40,5,48,-21,50,-57","w":135,"k":{"\u2026":8,"\u201a":8,"\u2019":5,"\u2018":5,"\u017e":4,"\u017d":6,"\u0178":6,"\u0160":6,"\u00ff":6,"\u00fd":6,"\u00f6":3,"\u00f5":3,"\u00f4":3,"\u00f3":3,"\u00f2":3,"\u00e7":2,"\u00dd":6,"\u00dc":6,"\u00db":6,"\u00d6":6,"\u00d5":6,"\u00d4":6,"\u00d1":6,"\u00cb":6,"\u00ca":6,"\u00c6":6,"\u00c5":6,"\u00c4":6,"\u00c3":6,"\u00c2":6,"\u00c1":6,"\u00c0":6,"_":14,",":8,"'":5,"T":6,"V":3,"Y":6,"t":6,"v":6,"w":3,"y":6,"\"":5,"\u201c":5,"\u201d":5,")":3,"]":3,"A":6,".":8,"J":7,"X":11,"x":11,"\u201e":8}},"C":{"d":"28,-16v-28,-68,-36,-237,54,-240v27,-1,41,16,29,38v-53,-31,-74,39,-69,101v2,42,-2,85,36,88v13,0,27,-5,33,-11v20,34,-29,53,-64,41v-7,-3,-15,-8,-19,-17","w":122,"k":{"\ufb04":9,"\ufb03":9,"\ufb00":9,"\u2039":8,"\u2026":-2,"\u201a":-2,"\u2019":-2,"\u2018":-2,"\u2014":30,"\u2013":30,"\u017e":1,"\u0161":4,"\u0160":2,"\u0153":5,"\u0152":8,"\u00ff":23,"\u00fd":23,"\u00fc":7,"\u00fb":7,"\u00fa":7,"\u00f9":7,"\u00f6":5,"\u00f5":5,"\u00f4":5,"\u00f3":5,"\u00f2":5,"\u00f1":4,"\u00ef":4,"\u00ee":4,"\u00eb":6,"\u00ea":6,"\u00e9":6,"\u00e8":6,"\u00e7":4,"\u00e6":4,"\u00e5":4,"\u00e4":4,"\u00e3":4,"\u00e2":4,"\u00e1":4,"\u00e0":4,"\u00d8":8,"\u00d6":8,"\u00d5":8,"\u00d4":8,"\u00d3":8,"\u00d2":8,"\u00c7":4,"q":4,"Q":8,"@":2,"0":9,"\/":-6,",":-2,"*":4,"'":-2,"C":4,"G":5,"d":4,"f":9,"t":7,"u":7,"v":21,"w":19,"y":23,"c":4,"e":6,"o":5,"\u00f8":5,"\"":-2,"-":30,"\u2212":30,"\u201c":-2,"\u201d":-2,"\u00ab":8,"O":8,".":-2,"x":5,"\u201e":-2,"S":2,"a":4,"z":1}},"D":{"d":"16,-245v3,-14,30,-6,44,-7v62,-3,72,49,71,113v-1,70,-4,136,-70,139r-45,0r0,-245xm45,-28v62,4,53,-58,53,-114v0,-47,1,-89,-53,-83r0,197","w":141,"k":{"\u2026":13,"\u201a":13,"\u2019":12,"\u2018":12,"\u017e":2,"\u017d":13,"\u0178":10,"\u0161":2,"\u0160":13,"\u0153":2,"\u00ff":2,"\u00fc":2,"\u00fb":2,"\u00f6":2,"\u00f5":2,"\u00f4":2,"\u00f3":2,"\u00f2":2,"\u00f1":2,"\u00ef":2,"\u00ee":2,"\u00eb":2,"\u00ea":2,"\u00e6":2,"\u00e5":2,"\u00e4":2,"\u00e3":2,"\u00e2":2,"\u00e1":2,"\u00e0":2,"\u00dd":10,"\u00dc":13,"\u00db":13,"\u00d6":13,"\u00d5":13,"\u00d4":13,"\u00d1":13,"\u00cb":13,"\u00ca":13,"\u00c6":13,"\u00c5":13,"\u00c4":13,"\u00c3":13,"\u00c2":13,"\u00c1":13,"\u00c0":13,"q":2,"_":26,",":13,"'":12,"T":9,"V":5,"W":7,"Y":10,"o":2,"\u00f8":2,"\"":12,"\u201c":12,"\u201d":12,")":7,"]":7,"A":13,".":13,"J":18,"x":3,"\u201e":13,"a":2}},"E":{"d":"99,-150v-1,10,3,25,-5,27r-49,0r0,97r62,0v-2,9,4,26,-6,26r-85,0r1,-249v23,-8,62,-1,91,-3v-2,8,4,26,-5,26r-58,0r0,76r54,0","w":115,"k":{"\u2019":-4,"\u2018":-4,"\u2014":10,"\u2013":10,"\u017e":1,"\u0161":4,"\u0153":7,"\u00ff":5,"\u00fd":5,"\u00fc":3,"\u00fb":3,"\u00fa":3,"\u00f9":3,"\u00f6":7,"\u00f5":7,"\u00f4":7,"\u00f3":7,"\u00f2":7,"\u00f1":4,"\u00ef":4,"\u00ee":4,"\u00eb":5,"\u00ea":5,"\u00e9":5,"\u00e8":5,"\u00e7":2,"\u00e6":4,"\u00e5":4,"\u00e4":4,"\u00e3":4,"\u00e2":4,"\u00e1":4,"\u00e0":4,"r":3,"q":6,"0":2,"\/":-3,"'":-4,"d":6,"u":3,"w":5,"y":5,"c":2,"e":5,"o":7,"\u00f8":7,"\"":-4,"-":10,"\u2212":10,"\u201c":-4,"\u201d":-4,"x":3,"a":4,"z":1}},"F":{"d":"16,-246v1,-3,3,-6,6,-6r86,0v-2,8,4,25,-5,25r-58,0r0,77r54,0v-1,9,4,26,-5,26r-49,0r0,121v-5,6,-19,2,-29,3r0,-246","w":112,"k":{"\u2039":10,"\u2026":44,"\u201a":44,"\u2019":-4,"\u2018":-4,"\u2014":10,"\u2013":10,"\u017e":5,"\u017d":24,"\u0161":6,"\u0160":24,"\u0153":10,"\u00ff":7,"\u00fd":7,"\u00fc":7,"\u00fb":7,"\u00fa":7,"\u00f9":7,"\u00f8":10,"\u00f6":10,"\u00f5":10,"\u00f4":10,"\u00f3":10,"\u00f2":10,"\u00f1":6,"\u00ef":6,"\u00ee":6,"\u00eb":10,"\u00ea":10,"\u00e9":10,"\u00e8":10,"\u00e7":8,"\u00e6":6,"\u00e5":6,"\u00e4":6,"\u00e3":6,"\u00e2":6,"\u00e1":6,"\u00e0":6,"\u00dc":24,"\u00db":24,"\u00d6":24,"\u00d5":24,"\u00d4":24,"\u00d1":24,"\u00cb":24,"\u00ca":24,"\u00c6":24,"\u00c5":24,"\u00c4":24,"\u00c3":24,"\u00c2":24,"\u00c1":24,"\u00c0":24,"r":6,"q":10,"_":48,"@":4,"0":6,"\/":17,",":44,"'":-4,"d":10,"t":3,"u":7,"v":5,"w":5,"y":7,"c":8,"e":10,"o":10,"\"":-4,"-":10,"\u2212":10,"\u201c":-4,"\u201d":-4,"\u00ab":10,"A":24,".":44,"J":36,"x":16,"\u201e":44,"a":6,"z":5,"g":6,"\u00bb":8,"\u203a":8}},"G":{"d":"10,-120v0,-75,6,-133,77,-135v27,-1,47,12,34,36v-6,-5,-17,-9,-28,-9v-50,2,-52,51,-52,106v0,46,-5,94,37,97v10,1,18,-4,21,-9r0,-89r-26,0v1,-10,-5,-25,7,-25r47,0r-1,135v-10,10,-28,16,-49,16v-66,1,-67,-56,-67,-123","w":138,"k":{"\u0178":3,"\u00ff":6,"\u00fd":6,"\u00dd":3,"\/":-2,"Y":3,"v":4,"y":6,")":1,"]":1,"x":3}},"H":{"d":"102,-122r-57,0r0,120v-5,3,-19,2,-29,2r0,-249v4,-5,19,-2,29,-3r0,103r57,0r1,-100v4,-5,18,-2,28,-3r0,250v-5,3,-19,2,-29,2r0,-122","w":147,"k":{"\/":-2}},"I":{"d":"15,-239v-2,-16,16,-13,30,-13r-1,250v-5,3,-19,2,-29,2r0,-239","w":60,"k":{"\/":-4}},"J":{"d":"12,-35v11,16,52,19,52,-12r1,-199v3,-8,19,-6,30,-6r0,193v0,38,-12,62,-50,62v-27,0,-48,-14,-33,-38","w":110,"k":{"\u2026":5,"\u201a":5,"\u017d":8,"\u0160":8,"\u00dc":8,"\u00db":8,"\u00d6":8,"\u00d5":8,"\u00d4":8,"\u00d1":8,"\u00cb":8,"\u00ca":8,"\u00c6":8,"\u00c5":8,"\u00c4":8,"\u00c3":8,"\u00c2":8,"\u00c1":8,"\u00c0":8,"_":13,"\/":-2,",":5,")":1,"]":1,"A":8,".":5,"J":6,"x":4,"\u201e":5}},"K":{"d":"132,-6v0,12,-20,6,-32,6v-12,-55,-17,-100,-55,-124r-1,122v-5,3,-19,2,-29,2r1,-249v4,-5,19,-2,29,-3r0,109r57,-107v8,-3,37,-5,30,6r-57,101v34,27,57,76,57,137","w":141,"k":{"\ufb04":12,"\ufb03":12,"\ufb00":12,"\u2039":3,"\u2019":-1,"\u2018":-1,"\u2014":13,"\u2013":13,"\u017e":6,"\u0161":6,"\u0153":6,"\u0152":6,"\u00ff":13,"\u00fd":13,"\u00fc":6,"\u00fb":6,"\u00fa":6,"\u00f9":6,"\u00f6":6,"\u00f5":6,"\u00f4":6,"\u00f3":6,"\u00f2":6,"\u00f1":6,"\u00ef":6,"\u00ee":6,"\u00eb":8,"\u00ea":8,"\u00e9":8,"\u00e8":8,"\u00e7":5,"\u00e6":6,"\u00e5":6,"\u00e4":6,"\u00e3":6,"\u00e2":6,"\u00e1":6,"\u00e0":6,"\u00d8":6,"\u00d6":6,"\u00d5":6,"\u00d4":6,"\u00d3":6,"\u00d2":6,"\u00c7":8,"q":5,"Q":6,"\/":-5,"*":13,"'":-1,"C":8,"d":5,"f":12,"t":10,"u":6,"v":15,"w":11,"y":13,"c":5,"e":8,"o":6,"\u00f8":6,"\"":-1,"-":13,"\u2212":13,"\u201c":-1,"\u201d":-1,"\u00ab":3,"O":6,"J":4,"a":6}},"L":{"d":"107,-27v-1,10,4,27,-6,27r-86,0r1,-249v4,-5,19,-2,29,-3r0,225r62,0","w":114,"k":{"\ufb04":16,"\ufb03":16,"\ufb00":16,"\u2039":19,"\u2019":49,"\u2018":49,"\u2014":38,"\u2013":38,"\u017e":7,"\u0178":27,"\u0161":7,"\u0160":3,"\u0153":10,"\u0152":12,"\u00ff":19,"\u00fd":19,"\u00fc":6,"\u00fb":6,"\u00fa":6,"\u00f9":6,"\u00f6":10,"\u00f5":10,"\u00f4":10,"\u00f3":10,"\u00f2":10,"\u00f1":7,"\u00ef":7,"\u00ee":7,"\u00eb":9,"\u00ea":9,"\u00e9":9,"\u00e8":9,"\u00e7":8,"\u00e6":7,"\u00e5":7,"\u00e4":7,"\u00e3":7,"\u00e2":7,"\u00e1":7,"\u00e0":7,"\u00dd":27,"\u00d8":12,"\u00d6":12,"\u00d5":12,"\u00d4":12,"\u00d3":12,"\u00d2":12,"\u00c7":10,"r":9,"q":9,"Q":12,"?":12,"0":8,"\/":-3,"*":48,"'":49,"C":10,"G":10,"T":27,"V":27,"W":24,"Y":27,"d":9,"f":16,"t":9,"u":6,"v":12,"w":19,"y":19,"c":8,"e":9,"o":10,"\u00f8":10,"\"":49,"-":38,"\u2212":38,"\u201c":49,"\u201d":49,"\u00ab":19,"O":12,")":6,"]":6,"S":3,"a":7}},"M":{"d":"131,-246v0,-11,19,-4,29,-6r0,250v-9,2,-19,2,-30,2r8,-194r-23,81v-9,18,-10,44,-23,58r-13,0r-42,-139r7,105r0,87v-8,2,-18,2,-29,2r0,-246v1,-11,18,-4,28,-6r46,149","w":176},"N":{"d":"116,0r-75,-201r3,199v-5,3,-19,2,-29,2r0,-246v1,-10,19,-4,29,-6r74,198r-3,-195v4,-5,19,-2,29,-3r0,246v0,11,-18,4,-28,6","w":159},"O":{"d":"76,3v-65,0,-65,-61,-65,-130v0,-68,5,-128,69,-128v63,0,64,61,64,126v0,69,-3,132,-68,132xm79,-225v-40,6,-35,58,-35,105v0,43,-4,88,33,93v39,-5,35,-56,35,-101v0,-43,6,-92,-33,-97","w":154,"k":{"\u2026":12,"\u201a":12,"\u2019":4,"\u2018":4,"\u017d":8,"\u0178":8,"\u0160":8,"\u0152":1,"\u00e7":2,"\u00dd":8,"\u00dc":8,"\u00db":8,"\u00d8":1,"\u00d6":1,"\u00d5":1,"\u00d4":1,"\u00d3":1,"\u00d2":1,"\u00d1":8,"\u00cb":8,"\u00ca":8,"\u00c6":8,"\u00c5":8,"\u00c4":8,"\u00c3":8,"\u00c2":8,"\u00c1":8,"\u00c0":8,"_":19,",":12,"*":3,"'":4,"T":8,"V":4,"W":5,"Y":8,"c":2,"\"":4,"\u201c":4,"\u201d":4,"O":1,"Q":1,")":7,"]":7,"A":8,".":12,"J":12,"X":8,"x":7,"\u201e":12}},"P":{"d":"123,-181v0,54,-23,82,-78,79r-1,100v-5,3,-19,2,-29,2r0,-246v4,-12,29,-4,42,-6v47,1,66,22,66,71xm45,-129v38,3,45,-16,46,-55v1,-32,-11,-47,-46,-42r0,97","w":129,"k":{"\u2039":11,"\u2026":52,"\u201a":52,"\u2014":17,"\u2013":17,"\u017e":4,"\u017d":12,"\u0178":5,"\u0161":4,"\u0160":26,"\u0153":8,"\u00ff":4,"\u00fc":4,"\u00fb":4,"\u00f8":8,"\u00f6":8,"\u00f5":8,"\u00f4":8,"\u00f3":8,"\u00f2":8,"\u00f1":4,"\u00ef":4,"\u00ee":4,"\u00eb":8,"\u00ea":8,"\u00e9":8,"\u00e8":8,"\u00e7":8,"\u00e6":4,"\u00e5":4,"\u00e4":4,"\u00e3":4,"\u00e2":4,"\u00e1":4,"\u00e0":4,"\u00dd":5,"\u00dc":26,"\u00db":26,"\u00d6":26,"\u00d5":26,"\u00d4":26,"\u00d1":26,"\u00cb":26,"\u00ca":26,"\u00c6":26,"\u00c5":26,"\u00c4":26,"\u00c3":26,"\u00c2":26,"\u00c1":26,"\u00c0":26,"\u00b7":7,"q":8,"_":70,"@":8,"\/":9,",":52,"Y":5,"d":8,"c":8,"e":8,"o":8,"-":17,"\u2212":17,"\u00ab":11,")":11,"]":11,"A":26,".":52,"J":40,"X":16,"x":3,"\u201e":52,"a":4,"Z":12}},"Q":{"d":"102,-1v-1,27,24,31,41,20v13,16,-3,33,-28,30v-30,-3,-40,-18,-47,-46v-57,-6,-57,-65,-57,-130v0,-68,5,-128,69,-128v63,0,64,61,64,126v0,58,-4,109,-42,128xm79,-225v-40,6,-35,58,-35,105v0,43,-4,88,33,93v39,-5,35,-56,35,-101v0,-43,6,-92,-33,-97","w":154,"k":{"\"":4,"\u201e":11,"\u201d":4,"\u201c":4,"x":9,"]":3,"Y":11,"X":9,"V":3,"T":6,"J":12,"A":3,".":11,")":3,"\u2026":11,"\u201a":11,"\u2019":4,"\u2018":4,"\u017d":3,"\u0178":11,"\u0160":3,"\u00dd":11,"\u00dc":3,"\u00db":3,"\u00d6":3,"\u00d5":3,"\u00d4":3,"\u00d1":3,"\u00cb":3,"\u00ca":3,"\u00c6":19,"\u00c5":3,"\u00c4":3,"\u00c3":3,"\u00c2":3,"\u00c1":3,"\u00c0":3,"_":-9,",":11,"'":4}},"R":{"d":"94,0v-3,-43,-12,-78,-30,-103r-19,1r-1,100v-5,3,-19,2,-29,2r1,-249v50,-12,107,1,107,68v0,36,-11,59,-31,71v20,25,32,60,34,104v1,11,-20,6,-32,6xm45,-129v37,4,46,-15,46,-53v0,-33,-10,-49,-46,-44r0,97","w":134,"k":{"\u2014":9,"\u2013":9,"\u0178":8,"\u0153":5,"\u0152":2,"\u00ff":4,"\u00fd":4,"\u00f6":5,"\u00f5":5,"\u00f4":5,"\u00f3":5,"\u00f2":5,"\u00eb":5,"\u00ea":5,"\u00e9":5,"\u00e8":5,"\u00dd":8,"\u00d8":2,"\u00d6":2,"\u00d5":2,"\u00d4":2,"\u00d3":2,"\u00d2":2,"\u00c7":4,"\u00c6":31,"q":3,"C":4,"T":6,"V":4,"W":4,"Y":8,"d":3,"y":4,"e":5,"o":5,"\u00f8":5,"-":9,"\u2212":9,"O":2,"Q":2,"X":2,"x":3}},"S":{"d":"32,-152v-40,-36,-25,-104,39,-104v32,0,60,12,40,35v-17,-13,-74,-15,-70,16v8,62,80,69,80,141v0,42,-21,66,-65,68v-34,1,-60,-17,-39,-43v20,20,77,19,72,-24v-5,-42,-38,-61,-57,-89","w":128,"k":{"\ufb04":11,"\ufb03":11,"\ufb00":11,"\u2019":-6,"\u2018":-6,"\u00ff":12,"\u00fd":12,"\u00c6":16,"_":7,"'":-6,"f":11,"v":10,"w":12,"y":12,"\"":-6,"\u201c":-6,"\u201d":-6,"J":4,"x":9}},"T":{"d":"81,-225r-1,223v-5,3,-19,2,-28,2r0,-225r-49,0v1,-10,-5,-27,6,-27r122,0v-2,9,5,27,-6,27r-44,0","w":134,"k":{"\ufb04":16,"\ufb03":16,"\ufb00":16,"\u203a":34,"\u2039":25,"\u2026":34,"\u201a":34,"\u2019":-5,"\u2018":-5,"\u2014":38,"\u2013":38,"\u017e":33,"\u017d":24,"\u0161":33,"\u0160":24,"\u0153":36,"\u0152":8,"\u0131":6,"\u00ff":37,"\u00fd":37,"\u00fc":35,"\u00fb":35,"\u00fa":35,"\u00f9":35,"\u00f8":36,"\u00f6":36,"\u00f5":36,"\u00f4":36,"\u00f3":36,"\u00f2":36,"\u00f1":32,"\u00ef":6,"\u00ee":6,"\u00ed":6,"\u00ec":6,"\u00eb":36,"\u00ea":36,"\u00e9":36,"\u00e8":36,"\u00e7":33,"\u00e6":35,"\u00e5":35,"\u00e4":35,"\u00e3":35,"\u00e2":35,"\u00e1":35,"\u00e0":35,"\u00dc":24,"\u00db":24,"\u00d8":8,"\u00d6":8,"\u00d5":8,"\u00d4":8,"\u00d3":8,"\u00d2":8,"\u00d1":24,"\u00cb":24,"\u00ca":24,"\u00c7":15,"\u00c6":24,"\u00c5":24,"\u00c4":24,"\u00c3":24,"\u00c2":24,"\u00c1":24,"\u00c0":24,"r":32,"q":35,"m":32,"_":31,"Q":8,"@":17,";":25,"0":24,"\/":22,",":34,"*":3,"'":-5,"C":15,"G":13,"d":35,"f":16,"t":15,"u":35,"v":33,"w":32,"y":37,"c":33,"e":36,"o":36,"\"":-5,"-":38,"\u2212":38,"\u201c":-5,"\u201d":-5,"\u00ab":25,"O":8,"A":24,".":34,"J":31,"x":36,"\u201e":34,"a":35,"z":33,"g":35,"\u00bb":34,":":25,"n":32,"p":39,"s":33,"h":9,"k":9,"i":6,"j":6}},"U":{"d":"80,4v-48,0,-65,-28,-65,-77r1,-176v4,-5,20,-2,30,-3r0,179v0,29,5,50,34,50v11,0,26,-3,32,-7r0,-219v4,-5,19,-2,29,-3r0,243v-13,7,-39,13,-61,13","w":157},"V":{"d":"117,-243v-1,-15,21,-7,33,-9r-56,253v-20,4,-36,3,-41,-19r-51,-232v5,-4,22,-1,31,-2r44,227v10,-76,25,-147,40,-218","w":151,"k":{"\ufb04":4,"\ufb03":4,"\ufb00":4,"\u203a":8,"\u2039":12,"\u2026":17,"\u201a":17,"\u2019":-6,"\u2018":-6,"\u2014":18,"\u2013":18,"\u017e":11,"\u017d":24,"\u0161":13,"\u0160":24,"\u0153":15,"\u0152":4,"\u0131":5,"\u00ff":6,"\u00fd":6,"\u00fc":14,"\u00fb":14,"\u00fa":14,"\u00f9":14,"\u00f8":15,"\u00f6":15,"\u00f5":15,"\u00f4":15,"\u00f3":15,"\u00f2":15,"\u00f1":11,"\u00ef":5,"\u00ee":5,"\u00ed":5,"\u00ec":5,"\u00eb":18,"\u00ea":18,"\u00e9":18,"\u00e8":18,"\u00e7":17,"\u00e6":14,"\u00e5":14,"\u00e4":14,"\u00e3":14,"\u00e2":14,"\u00e1":14,"\u00e0":14,"\u00dc":24,"\u00db":24,"\u00d8":4,"\u00d6":4,"\u00d5":4,"\u00d4":4,"\u00d3":4,"\u00d2":4,"\u00d1":24,"\u00cb":24,"\u00ca":24,"\u00c7":8,"\u00c6":24,"\u00c5":24,"\u00c4":24,"\u00c3":24,"\u00c2":24,"\u00c1":24,"\u00c0":24,"r":11,"q":18,"m":11,"_":30,"Q":4,"@":10,"0":12,"\/":19,",":17,"'":-6,"C":8,"G":6,"d":18,"f":4,"t":4,"u":14,"v":10,"w":8,"y":6,"c":17,"e":18,"o":15,"\"":-6,"-":18,"\u2212":18,"\u201c":-6,"\u201d":-6,"\u00ab":12,"O":4,"A":24,".":17,"J":32,"x":9,"\u201e":17,"a":14,"z":11,"g":19,"\u00bb":8,":":10,";":10,"n":11,"p":14,"s":13,"i":5,"j":8}},"W":{"d":"202,-243v-1,-15,20,-7,32,-9r-47,253v-20,3,-36,4,-40,-19r-30,-162v-6,64,-18,123,-30,181v-22,3,-37,3,-42,-21r-42,-223v-4,-16,19,-7,30,-9r32,183v2,13,3,25,4,37r3,0v3,-73,20,-133,31,-199v-1,-14,17,-8,28,-9r26,127v6,29,6,54,10,81r3,0v7,-74,20,-142,32,-211","w":235,"k":{"\u203a":4,"\u2039":9,"\u2026":13,"\u201a":13,"\u2019":-7,"\u2018":-7,"\u2014":12,"\u2013":12,"\u017e":10,"\u017d":9,"\u0161":7,"\u0160":19,"\u0153":13,"\u0152":5,"\u00ff":8,"\u00fd":8,"\u00fc":10,"\u00fb":10,"\u00fa":10,"\u00f9":10,"\u00f8":13,"\u00f6":13,"\u00f5":13,"\u00f4":13,"\u00f3":13,"\u00f2":13,"\u00f1":14,"\u00ef":14,"\u00ee":14,"\u00ec":-22,"\u00eb":14,"\u00ea":14,"\u00e9":14,"\u00e8":14,"\u00e7":13,"\u00e6":14,"\u00e5":14,"\u00e4":14,"\u00e3":14,"\u00e2":14,"\u00e1":14,"\u00e0":14,"\u00dc":19,"\u00db":19,"\u00d8":5,"\u00d6":5,"\u00d5":5,"\u00d4":5,"\u00d3":5,"\u00d2":5,"\u00d1":19,"\u00cb":19,"\u00ca":19,"\u00c7":9,"\u00c6":19,"\u00c5":19,"\u00c4":19,"\u00c3":19,"\u00c2":19,"\u00c1":19,"\u00c0":19,"r":14,"q":13,"m":14,"_":25,"Q":5,"@":4,"0":6,"\/":15,",":13,"'":-7,"C":9,"G":6,"d":13,"u":10,"v":4,"w":7,"y":8,"c":13,"e":14,"o":13,"\"":-7,"-":12,"\u2212":12,"\u201c":-7,"\u201d":-7,"\u00ab":9,"O":5,"A":19,".":13,"J":29,"x":10,"\u201e":13,"a":14,"z":10,"g":12,"\u00bb":4,"Z":9,":":10,";":10,"n":14,"p":13,"s":7}},"X":{"d":"96,-132r52,127v2,3,1,5,-3,5r-32,0r-38,-101r-40,97v-5,7,-21,3,-32,4r55,-130r-45,-120v10,-2,22,-2,35,-2r32,95r32,-93v9,-2,20,-2,31,-2","w":152,"k":{"\ufb04":11,"\ufb03":11,"\ufb00":11,"\u2039":6,"\u2019":-4,"\u2018":-4,"\u2014":20,"\u2013":20,"\u017e":5,"\u0161":5,"\u0153":7,"\u0152":8,"\u00ff":21,"\u00fd":21,"\u00fc":12,"\u00fb":12,"\u00fa":12,"\u00f9":12,"\u00f6":7,"\u00f5":7,"\u00f4":7,"\u00f3":7,"\u00f2":7,"\u00f1":5,"\u00ef":5,"\u00ee":5,"\u00eb":9,"\u00ea":9,"\u00e9":9,"\u00e8":9,"\u00e7":6,"\u00e6":5,"\u00e5":5,"\u00e4":5,"\u00e3":5,"\u00e2":5,"\u00e1":5,"\u00e0":5,"\u00d8":8,"\u00d6":8,"\u00d5":8,"\u00d4":8,"\u00d3":8,"\u00d2":8,"\u00c7":8,"\u00c6":31,"q":9,"Q":8,"@":2,"0":9,"*":3,"'":-4,"C":8,"G":7,"d":9,"f":11,"t":9,"u":12,"v":16,"w":17,"y":21,"c":6,"e":9,"o":7,"\u00f8":7,"\"":-4,"-":20,"\u2212":20,"\u201c":-4,"\u201d":-4,"\u00ab":6,"O":8,"a":5,"p":8}},"Y":{"d":"52,-102r-50,-148v7,-3,23,-2,33,-2r32,125r32,-123v9,-2,20,-2,31,-2r-49,148r0,102v-5,3,-19,2,-29,2r0,-102","w":131,"k":{"\ufb04":10,"\ufb03":10,"\ufb00":10,"\u203a":16,"\u2039":21,"\u2026":22,"\u201a":22,"\u2019":-7,"\u2018":-7,"\u2014":23,"\u2013":23,"\u017e":18,"\u017d":28,"\u0161":24,"\u0160":3,"\u0153":25,"\u0152":8,"\u0131":5,"\u00ff":16,"\u00fd":16,"\u00fc":21,"\u00fb":21,"\u00fa":21,"\u00f9":21,"\u00f6":25,"\u00f5":25,"\u00f4":25,"\u00f3":25,"\u00f2":25,"\u00f1":23,"\u00ef":5,"\u00ee":5,"\u00ed":5,"\u00ec":5,"\u00eb":27,"\u00ea":27,"\u00e9":27,"\u00e8":27,"\u00e7":25,"\u00e6":22,"\u00e5":22,"\u00e4":22,"\u00e3":22,"\u00e2":22,"\u00e1":22,"\u00e0":22,"\u00dc":28,"\u00db":28,"\u00d8":8,"\u00d6":8,"\u00d5":8,"\u00d4":8,"\u00d3":8,"\u00d2":8,"\u00d1":28,"\u00cb":28,"\u00ca":28,"\u00c7":12,"\u00c5":28,"\u00c4":28,"\u00c3":28,"\u00c2":28,"\u00c1":28,"\u00c0":28,"r":23,"q":28,"m":23,"_":26,"Q":8,"@":5,"0":17,"\/":25,",":22,"'":-7,"C":12,"G":10,"d":28,"f":10,"t":12,"u":21,"v":14,"w":15,"y":16,"c":25,"e":27,"o":25,"\u00f8":25,"\"":-7,"-":23,"\u2212":23,"\u201c":-7,"\u201d":-7,"\u00ab":21,"O":8,"A":28,"\u00c6":28,".":22,"J":31,"x":16,"\u201e":22,"S":3,"a":22,"z":18,"g":24,"\u00bb":16,":":19,";":19,"n":23,"p":26,"s":24,"i":5,"j":10}},"Z":{"d":"10,0v-5,-6,-7,-15,-2,-24r91,-202r-83,1v1,-10,-5,-27,6,-27r108,0v4,5,2,17,0,23r-92,203v30,-2,65,2,91,-3v-2,11,5,29,-7,29r-112,0","w":138,"k":{"\ufb04":10,"\ufb03":10,"\ufb00":10,"\u2039":3,"\u2019":-5,"\u2018":-5,"\u2014":36,"\u2013":36,"\u017e":6,"\u0161":6,"\u0153":7,"\u00ff":13,"\u00fd":13,"\u00fc":10,"\u00fb":10,"\u00fa":10,"\u00f9":10,"\u00f6":7,"\u00f5":7,"\u00f4":7,"\u00f3":7,"\u00f2":7,"\u00f1":6,"\u00ef":6,"\u00ee":6,"\u00eb":10,"\u00ea":10,"\u00e9":10,"\u00e8":10,"\u00e7":7,"\u00e6":6,"\u00e5":6,"\u00e4":6,"\u00e3":6,"\u00e2":6,"\u00e1":6,"\u00e0":6,"r":10,"q":9,"0":4,"'":-5,"d":9,"f":10,"t":6,"u":10,"w":11,"y":13,"c":7,"e":10,"o":7,"\u00f8":7,"\"":-5,"-":36,"\u2212":36,"\u201c":-5,"\u201d":-5,"\u00ab":3,")":5,"]":5,"x":7,"a":6,"g":5,"p":5}},"[":{"d":"44,-287v-1,-12,10,-9,22,-9r69,0v-1,12,3,30,-9,27r-53,0r0,313r62,0v-1,12,3,28,-10,28r-81,0r0,-359","w":138,"k":{"j":-44,")":-16,"\ufb00":9,"\u20ac":21,"\u2044":14,"\u2039":6,"\u2019":-7,"\u2018":-7,"\u2014":12,"\u2013":12,"\u017e":9,"\u0153":12,"\u0152":7,"\u00ff":-6,"\u00fd":-6,"\u00fc":11,"\u00fb":11,"\u00fa":11,"\u00f9":11,"\u00f8":12,"\u00f6":12,"\u00f5":12,"\u00f4":12,"\u00f3":12,"\u00f2":12,"\u00f1":10,"\u00ef":-5,"\u00ed":6,"\u00ec":-9,"\u00eb":11,"\u00ea":11,"\u00e9":11,"\u00e8":11,"\u00e7":11,"\u00e6":9,"\u00e4":9,"\u00e3":9,"\u00e2":9,"\u00e1":9,"\u00e0":9,"\u00d8":7,"\u00d6":7,"\u00d5":7,"\u00d4":7,"\u00d3":7,"\u00d2":7,"\u00cf":-4,"\u00ce":-21,"\u00c7":10,"\u00c6":9,"\u00c5":9,"\u00c4":9,"\u00c3":9,"\u00c2":9,"\u00c1":9,"\u00c0":9,"\u00a2":21,"r":10,"q":11,"m":10,"]":-19,"\\":-9,"[":18,"Q":7,"0":24,"\/":14,"+":17,"*":8,"'":-7,"C":10,"G":7,"d":11,"t":5,"u":11,"v":13,"w":13,"y":-6,"c":11,"e":11,"o":12,"\"":-7,"-":12,"\u2212":12,"\u201c":-7,"\u201d":-7,"\u00ab":6,"O":7,"A":9,"x":8,"a":9,"\u00e5":9,"z":9,"Z":5,"\u017d":5,"n":10}},"\\":{"d":"4,-267v-3,-13,18,-7,29,-8r82,283v-5,5,-20,2,-30,3","w":118,"k":{"\"":46,"\u201e":-12,"\u201d":46,"\u201c":46,"\u00c6":-15,"]":6,"A":-15,".":-12,")":6,"\u2026":-12,"\u201a":-12,"\u2019":46,"\u2018":46,"\u017d":-15,"\u0160":-15,"\u00dc":-15,"\u00db":-15,"\u00d6":-15,"\u00d5":-15,"\u00d4":-15,"\u00d1":-15,"\u00cb":-15,"\u00ca":-15,"\u00c5":-15,"\u00c4":-15,"\u00c3":-15,"\u00c2":-15,"\u00c1":-15,"\u00c0":-15,"\/":-5,",":-12,"'":46}},"]":{"d":"95,63v2,12,-12,8,-23,9r-69,0v1,-12,-3,-27,10,-27r53,0r0,-314r-62,0v1,-11,-4,-28,9,-27r82,0r0,359","w":138,"k":{"]":15,")":15,"\u2019":27,"\u2018":27,"'":27,"\"":27,"\u201c":27,"\u201d":27}},"_":{"d":"5,39v1,-9,-3,-25,6,-25r120,0v-2,13,2,22,-6,25r-120,0","w":135,"k":{"\u0178":28,"\u0153":11,"\u0152":15,"\u00fc":11,"\u00fb":11,"\u00fa":11,"\u00f9":11,"\u00f8":11,"\u00f6":11,"\u00f5":11,"\u00f4":11,"\u00f3":11,"\u00f2":11,"\u00eb":8,"\u00ea":8,"\u00e9":8,"\u00e8":8,"\u00e7":13,"\u00dd":28,"\u00d8":15,"\u00d6":15,"\u00d5":15,"\u00d4":15,"\u00d3":15,"\u00d2":15,"\u00c7":19,"w":18,"v":24,"u":11,"t":21,"o":11,"j":-27,"g":-4,"f":10,"e":8,"d":6,"c":13,"Y":28,"W":22,"V":28,"T":26,"O":15,"G":7,"C":19,"q":13,"Q":9,"9":-5,"8":13,"6":13,"5":-4,"4":49,"0":17,"\/":-18}},"`":{"d":"0,-242v2,-10,9,-31,21,-17v14,10,30,26,41,37v-2,7,-4,15,-12,16v-17,-8,-38,-24,-50,-36","w":61},"a":{"d":"85,-134v2,-35,-53,-19,-70,-13v-17,-33,23,-36,54,-37v74,-4,37,100,43,175v-34,22,-111,19,-102,-42v-4,-47,33,-70,75,-54r0,-29xm41,-52v-5,29,23,39,43,25r1,-58v-26,-8,-48,2,-44,33","w":127,"k":{"\ufb04":3,"\ufb03":3,"\ufb00":3,"\u2019":30,"\u2018":30,"\u00ff":3,"\u00fd":3,"'":30,"f":3,"t":6,"y":3,"\"":30,"\u201c":30,"\u201d":30,")":9,"]":9,"x":3}},"b":{"d":"129,-113v0,66,-12,117,-70,117v-19,0,-33,-4,-42,-11r0,-244v-2,-17,14,-12,29,-14r0,94v10,-8,22,-13,39,-13v37,0,44,32,44,71xm96,-106v0,-45,-22,-64,-50,-41r0,120v42,18,50,-34,50,-79","w":137,"k":{"\u2026":7,"\u201a":7,"\u2019":28,"\u2018":28,"\u017e":1,"_":14,"\/":4,",":7,"'":28,"t":3,"w":1,"\"":28,"\u201c":28,"\u201d":28,")":10,"]":10,".":7,"\u201e":7,"z":1}},"c":{"d":"76,-184v20,0,37,12,27,33v-6,-4,-17,-7,-26,-7v-33,2,-35,34,-35,72v0,34,1,62,32,64v11,0,22,-5,28,-9v10,25,-11,36,-37,35v-49,0,-54,-39,-54,-90v0,-57,12,-97,65,-98","w":112,"k":{"\u2039":10,"\u2019":16,"\u2018":16,"\u2014":13,"\u2013":13,"\u0153":4,"\u00ff":-1,"\u00fd":-1,"\u00f6":4,"\u00f5":4,"\u00f4":4,"\u00f3":4,"\u00f2":4,"\u00eb":6,"\u00ea":6,"\u00e9":6,"\u00e8":6,"\u00e7":5,"q":6,"\/":-6,"'":16,"d":6,"t":-2,"w":-1,"y":-1,"c":5,"e":6,"o":4,"\u00f8":4,"\"":16,"-":13,"\u2212":13,"\u201c":16,"\u201d":16,"\u00ab":10,")":3,"]":3}},"d":{"d":"71,-23v8,0,17,-1,22,-5r0,-125v-36,-19,-52,24,-49,66v2,31,-2,63,27,64xm12,-84v0,-61,27,-120,81,-92r0,-75v-2,-17,14,-12,29,-14r0,258v-13,6,-32,10,-52,11v-49,0,-58,-36,-58,-88","w":138,"k":{"\u00ef":-5,"\u00ee":-5,"\u00ec":-5,"\/":-2}},"e":{"d":"11,-81v1,-58,10,-99,64,-103v47,-3,52,58,42,105v-25,2,-48,6,-76,6v1,28,5,49,34,48v16,0,30,-5,41,-11v12,31,-19,41,-47,40v-47,-1,-59,-34,-58,-85xm92,-112v11,-49,-40,-62,-47,-15v-2,8,-3,18,-3,30v20,-2,51,6,50,-15","w":129,"k":{"\u2019":22,"\u2018":22,"\u00eb":4,"\u00ea":4,"\u00e9":4,"\u00e8":4,"\/":-2,"'":22,"t":1,"w":1,"e":4,"\"":22,"\u201c":22,"\u201d":22,")":7,"]":7,"x":3}},"f":{"d":"58,-6v0,10,-19,5,-29,6r0,-155r-25,0v2,-9,-4,-25,8,-25r17,0v-3,-53,11,-86,61,-86v24,0,40,9,30,31v-27,-10,-67,-4,-62,31r0,24r33,0v-2,8,3,25,-6,25r-27,0r0,149","w":91,"k":{"!":-31,"\ufb04":14,"\ufb03":14,"\ufb00":14,"\u2122":-34,"\u2039":8,"\u2030":-16,"\u2026":17,"\u201a":17,"\u2019":-44,"\u2018":-44,"\u2014":17,"\u2013":17,"\u0153":6,"\u00fc":3,"\u00fb":3,"\u00fa":3,"\u00f9":3,"\u00f8":6,"\u00f6":6,"\u00f5":6,"\u00f4":6,"\u00f3":6,"\u00f2":6,"\u00eb":7,"\u00ea":7,"\u00e9":7,"\u00e8":7,"\u00e7":5,"\u00ae":-23,"\u00a9":-22,"r":3,"q":8,"m":1,"_":18,"]":-40,"\\":-36,"?":-40,"8":-7,",":17,"*":-12,"'":-44,"&":-13,"d":8,"u":3,"c":5,"e":7,"o":6,"\"":-44,"-":17,"\u2212":17,"\u201c":-44,"\u201d":-44,"\u00ab":8,"b":-1,")":-40,".":17,"\u201e":17,"g":7,"p":12,"h":-1,"k":-1}},"g":{"d":"36,-64v-45,-35,-19,-145,56,-117r43,0v7,13,1,32,-20,24v33,38,5,121,-61,100v-3,4,-15,17,-6,20v32,13,88,1,87,49v-1,40,-28,58,-69,59v-34,0,-58,-8,-58,-39v0,-21,13,-34,27,-44v-34,-5,-19,-40,1,-52xm99,-125v0,-22,-5,-38,-26,-37v-21,1,-28,18,-28,44v0,23,3,42,27,40v23,-1,27,-20,27,-47xm105,16v0,-24,-26,-21,-47,-24v-9,7,-20,19,-20,33v-1,17,14,19,30,19v20,0,36,-9,37,-28","w":141,"k":{"\u2019":15,"\u2018":15,"\u017e":-1,"\u0153":3,"\u00ff":-2,"\u00fd":-2,"\u00f8":3,"\u00f6":3,"\u00f5":3,"\u00f4":3,"\u00f3":3,"\u00f2":3,"\u00eb":2,"\u00ea":2,"\u00e9":2,"\u00e8":2,"\u00e7":3,"q":2,"\/":-3,"'":15,"d":2,"y":-2,"c":3,"e":2,"o":3,"\"":15,"\u201c":15,"\u201d":15,"x":3,"z":-1,"j":-33,"\u00df":3,"\u017f":3}},"h":{"d":"93,-128v5,-31,-31,-35,-48,-19r0,145v-5,3,-19,2,-29,2r0,-251v-2,-16,14,-12,29,-14r0,95v27,-24,78,-19,78,34r-1,134v-5,3,-19,2,-29,2r0,-128","w":136,"k":{"\"":32,"\u201d":32,"\u201c":32,"y":4,"w":1,"t":3,"\u2019":32,"\u2018":32,"\u00ff":4,"\u00fd":4,"\/":-5,"'":32,")":10,"]":10,"x":1}},"i":{"d":"17,-167v-2,-15,15,-13,29,-13r0,178v-8,2,-18,2,-29,2r0,-167xm32,-215v-11,-1,-15,-8,-15,-22v0,-12,5,-22,17,-22v13,1,13,7,14,21v0,13,-4,23,-16,23","w":63,"k":{"\/":-8}},"j":{"d":"19,-167v0,-14,15,-13,30,-13r0,193v0,36,-12,57,-48,58v-27,1,-47,-13,-33,-35v22,14,51,13,51,-28r0,-175xm34,-215v-11,-1,-15,-8,-15,-22v0,-12,5,-22,17,-22v13,1,13,7,14,21v0,13,-4,23,-16,23","w":66,"k":{"\/":-9,"j":-21}},"k":{"d":"94,0v6,-46,-9,-99,-48,-75r0,73v-5,3,-19,2,-29,2r0,-251v-2,-17,14,-12,29,-14r0,98v19,-19,77,-28,76,14v-1,26,-15,44,-30,56v27,12,42,53,34,95v-10,2,-20,2,-32,2xm46,-95v21,-8,43,-22,43,-48v0,-27,-36,-10,-43,3r0,45","w":137,"k":{"\u2019":27,"\u2018":27,"\u2014":7,"\u2013":7,"\u0153":3,"\u00ff":7,"\u00fd":7,"\u00f6":3,"\u00f5":3,"\u00f4":3,"\u00f3":3,"\u00f2":3,"\u00eb":3,"\u00ea":3,"\u00e9":3,"\u00e8":3,"\u00e7":3,"q":3,"\/":-5,"'":27,"w":4,"y":7,"c":3,"e":3,"o":3,"\u00f8":3,"\"":27,"-":7,"\u2212":7,"\u201c":27,"\u201d":27,")":3,"]":3,"p":3}},"l":{"d":"17,-251v-2,-17,14,-12,29,-14r-1,263v-6,3,-19,2,-28,2r0,-251","w":62},"m":{"d":"159,-133v4,-29,-26,-29,-42,-18r0,149v-5,3,-19,2,-29,2r0,-140v2,-24,-26,-20,-42,-12r-1,150v-5,3,-19,2,-28,2r0,-172v22,-10,69,-21,86,0v32,-20,85,-19,85,39r-1,131v-5,3,-19,2,-28,2r0,-133","w":202,"k":{"\"":32,"\u201d":32,"\u201c":32,"y":2,"x":1,"w":1,"f":1,"]":10,")":10,"\ufb04":1,"\ufb03":1,"\ufb00":1,"\u2019":32,"\u2018":32,"\u00ff":2,"\u00fd":2,"\/":-8,"'":32}},"n":{"d":"94,-127v6,-36,-27,-34,-49,-25r0,150v-8,2,-18,2,-29,2r0,-171v36,-17,108,-28,108,36r-1,133v-5,3,-19,2,-29,2r0,-127","w":137,"k":{"\u2019":32,"\u2018":32,"\/":-11,"'":32,"\"":32,"\u201c":32,"\u201d":32,")":10,"]":10,"x":1}},"o":{"d":"65,4v-51,0,-57,-39,-56,-94v0,-56,13,-94,59,-94v49,0,57,40,56,93v0,57,-13,95,-59,95xm67,-158v-28,4,-27,36,-27,69v0,33,-2,64,26,68v27,-5,27,-36,27,-70v0,-31,3,-65,-26,-67","w":132,"k":{"\ufb04":4,"\ufb03":4,"\ufb00":4,"\u2026":7,"\u201a":7,"\u2019":30,"\u2018":30,"\u017e":3,"\u0161":2,"\u00ff":7,"\u00fd":7,"\u00fc":2,"\u00fb":2,"\u00f6":2,"\u00f5":2,"\u00f4":2,"\u00f1":2,"\u00ef":2,"\u00ee":2,"\u00eb":2,"\u00ea":2,"\u00e6":2,"\u00e5":2,"\u00e4":2,"\u00e3":2,"\u00e2":2,"\u00e1":2,"\u00e0":2,"_":16,"\/":-6,",":7,"*":4,"'":30,"f":4,"t":5,"v":4,"w":4,"y":7,"\"":30,"\u201c":30,"\u201d":30,")":12,"]":12,".":7,"x":9,"\u201e":7,"z":3}},"p":{"d":"46,68v-11,4,-29,7,-29,-10r0,-227v47,-32,122,-12,111,60v5,68,-24,137,-82,103r0,74xm95,-105v0,-29,0,-52,-27,-53v-8,0,-16,2,-22,7r0,116v5,7,9,12,19,12v31,-6,30,-43,30,-82","w":137,"k":{"\ufb04":3,"\ufb03":3,"\ufb00":3,"\u2026":7,"\u201a":7,"\u2019":35,"\u2018":35,"\u017e":4,"\u0161":4,"\u00ff":8,"\u00fd":8,"\u00fc":4,"\u00fb":4,"\u00f6":4,"\u00f5":4,"\u00f4":4,"\u00f1":4,"\u00ef":4,"\u00ee":4,"\u00eb":4,"\u00ea":4,"\u00e6":3,"\u00e5":3,"\u00e4":3,"\u00e3":3,"\u00e2":3,"\u00e1":3,"\u00e0":3,"_":21,"?":2,"\/":-2,",":7,"*":4,"'":35,"f":3,"t":4,"v":4,"w":4,"y":8,"\"":35,"\u201c":35,"\u201d":35,")":12,"]":12,".":7,"x":5,"\u201e":7,"a":3,"z":4,"j":1}},"q":{"d":"11,-78v-5,-77,50,-129,112,-94r0,237v-2,9,-19,6,-29,5r0,-82v-7,11,-18,16,-34,16v-41,-2,-46,-36,-49,-82xm71,-22v12,0,19,-8,23,-18r0,-113v-41,-19,-53,30,-50,74v2,28,2,57,27,57","w":140,"k":{"\"":23,"\u201d":23,"\u201c":23,"\u2019":23,"\u2018":23,"\/":-6,"'":23}},"r":{"d":"87,-151v-13,-8,-32,-6,-41,4r-1,145v-5,3,-19,2,-29,2r0,-167v13,-9,29,-15,49,-17v23,-2,30,15,22,33","w":94,"k":{"\u2039":17,"\u2026":27,"\u201a":27,"\u2019":14,"\u2018":14,"\u2014":26,"\u2013":26,"\u0153":7,"\u00f8":7,"\u00f6":7,"\u00f5":7,"\u00f4":7,"\u00f3":7,"\u00f2":7,"\u00eb":8,"\u00ea":8,"\u00e9":8,"\u00e8":8,"\u00e7":7,"r":1,"q":8,"_":32,"\/":4,",":27,"'":14,"d":8,"c":7,"e":8,"o":7,"\"":14,"-":26,"\u2212":26,"\u201c":14,"\u201d":14,"\u00ab":17,")":9,"]":9,".":27,"x":5,"\u201e":27,"g":8,"p":3}},"s":{"d":"32,-103v-38,-30,-18,-81,38,-81v27,0,57,11,39,35v-19,-14,-78,-13,-61,18v16,30,66,38,66,85v1,33,-25,50,-59,50v-28,0,-55,-10,-39,-36v23,17,80,11,62,-27v-10,-18,-30,-32,-46,-44","w":124,"k":{"\u2019":20,"\u2018":20,"\u2014":12,"\u2013":12,"\u00ff":1,"\u00fd":1,"\/":-3,"'":20,"y":1,"\"":20,"-":12,"\u2212":12,"\u201c":20,"\u201d":20,")":3,"]":3,"x":3}},"t":{"d":"76,3v-72,0,-37,-95,-45,-158r-25,0v2,-9,-4,-24,7,-25r18,0v4,-28,-17,-74,29,-65r0,65r37,0v-2,8,4,25,-6,25r-31,0r1,116v-3,20,21,20,33,12v7,15,-2,30,-18,30","w":104,"k":{"\u2039":12,"\u2026":-2,"\u201a":-2,"\u2019":12,"\u2018":12,"\u2014":23,"\u2013":23,"\u0153":6,"\u00fc":3,"\u00fb":3,"\u00fa":3,"\u00f9":3,"\u00f6":6,"\u00f5":6,"\u00f4":6,"\u00f3":6,"\u00f2":6,"\u00eb":8,"\u00ea":8,"\u00e9":8,"\u00e8":8,"\u00e7":8,"q":6,"0":2,"\/":-5,",":-2,"'":12,"d":6,"t":19,"u":3,"c":8,"e":8,"o":6,"\u00f8":6,"\"":12,"-":23,"\u2212":23,"\u201c":12,"\u201d":12,"\u00ab":12,")":3,"]":3,".":-2,"\u201e":-2,"g":4}},"u":{"d":"46,-54v-6,34,27,38,48,26r1,-149v4,-5,18,-2,28,-3r0,171v-41,23,-107,20,-107,-47r0,-121v5,-5,20,-2,30,-3r0,126","w":140,"k":{"\u2019":23,"\u2018":23,"\/":-6,"'":23,"\"":23,"\u201c":23,"\u201d":23,")":11,"]":11}},"v":{"d":"48,-3v-20,-52,-27,-116,-42,-173v4,-6,21,-3,32,-4r26,149r24,-146v5,-5,20,-2,30,-3r-41,181v-11,-1,-25,5,-29,-4","w":123,"k":{"\u2039":6,"\u2026":18,"\u201a":18,"\u2019":21,"\u2018":21,"\u2014":9,"\u2013":9,"\u017e":4,"\u0161":4,"\u0153":7,"\u00ff":4,"\u00fc":5,"\u00fb":5,"\u00fa":5,"\u00f9":5,"\u00f6":7,"\u00f5":7,"\u00f4":7,"\u00f3":7,"\u00f2":7,"\u00f1":4,"\u00ef":4,"\u00ee":4,"\u00eb":9,"\u00ea":9,"\u00e9":9,"\u00e8":9,"\u00e7":6,"\u00e6":4,"\u00e5":4,"\u00e4":4,"\u00e3":4,"\u00e2":4,"\u00e1":4,"\u00e0":4,"r":7,"q":8,"m":5,"k":3,"_":27,"@":4,"0":3,"\/":8,",":18,"'":21,"d":8,"t":3,"u":5,"c":6,"e":9,"o":7,"\u00f8":7,"\"":21,"-":9,"\u2212":9,"\u201c":21,"\u201d":21,")":10,"]":10,".":18,"\u201e":18,"a":4,"g":9,":":2,";":2,"p":5,"s":4}},"w":{"d":"84,-169v1,-11,19,-4,29,-6v10,46,13,99,27,141r11,-87v5,-19,4,-44,14,-58r24,-1r-39,181v-56,7,-36,-77,-51,-131r-22,131v-18,1,-33,3,-37,-16r-34,-162v5,-5,20,-2,31,-3v10,47,12,102,26,146","w":194,"k":{"\u2039":6,"\u2026":14,"\u201a":14,"\u2019":23,"\u2018":23,"\u2014":7,"\u2013":7,"\u017e":5,"\u0161":4,"\u0153":7,"\u00ff":4,"\u00fc":5,"\u00fb":5,"\u00fa":5,"\u00f9":5,"\u00f8":7,"\u00f6":7,"\u00f5":7,"\u00f4":7,"\u00f3":7,"\u00f2":7,"\u00f1":4,"\u00ef":4,"\u00ee":4,"\u00eb":9,"\u00ea":9,"\u00e9":9,"\u00e8":9,"\u00e7":8,"\u00e6":4,"\u00e5":4,"\u00e4":4,"\u00e3":4,"\u00e2":4,"\u00e1":4,"\u00e0":4,"r":7,"q":6,"m":3,"k":5,"_":21,"@":2,"\/":2,",":14,"'":23,"d":6,"t":3,"u":5,"c":8,"e":9,"o":7,"\"":23,"-":7,"\u2212":7,"\u201c":23,"\u201d":23,")":13,"]":13,".":14,"x":4,"\u201e":14,"a":4,"z":5,"g":9,":":3,";":3,"p":5,"s":4}},"x":{"d":"93,-96r49,93v-5,5,-23,2,-34,3v-12,-24,-26,-46,-36,-72r-36,70v-9,2,-20,2,-31,2r51,-94r-44,-84v6,-3,21,-2,31,-2v14,21,23,45,33,66v10,-22,19,-45,32,-64v9,-2,20,-2,31,-2","w":147,"k":{"\ufb04":4,"\ufb03":4,"\ufb00":4,"\u2039":14,"\u2019":17,"\u2018":17,"\u2014":27,"\u2013":27,"\u017e":3,"\u0161":5,"\u0153":9,"\u00ff":4,"\u00fd":4,"\u00fc":3,"\u00fb":3,"\u00fa":3,"\u00f9":3,"\u00f8":9,"\u00f6":9,"\u00f5":9,"\u00f4":9,"\u00f3":9,"\u00f2":9,"\u00f1":4,"\u00ef":4,"\u00ee":4,"\u00eb":8,"\u00ea":8,"\u00e9":8,"\u00e8":8,"\u00e7":5,"\u00e6":4,"\u00e5":4,"\u00e4":4,"\u00e3":4,"\u00e2":4,"\u00e1":4,"\u00e0":4,"r":6,"q":9,"m":3,"k":5,"@":2,"0":2,"\/":-5,"'":17,"d":9,"f":4,"t":5,"u":3,"w":9,"y":4,"c":5,"e":8,"o":9,"\"":17,"-":27,"\u2212":27,"\u201c":17,"\u201d":17,")":7,"]":7,"x":3,"a":4,"z":3,"g":5,"p":4,"s":5}},"y":{"d":"-1,55v-3,-32,31,5,42,-19v5,-6,8,-15,11,-30r-44,-183v4,-5,19,-2,29,-3r29,149v6,-49,15,-95,25,-140v-1,-13,19,-8,31,-9r-44,190v-10,30,-12,59,-50,59v-18,0,-28,-2,-29,-14","w":128,"k":{"\u2039":5,"\u2026":20,"\u201a":20,"\u2019":22,"\u2018":22,"\u2014":10,"\u2013":10,"\u017e":3,"\u0161":4,"\u0153":7,"\u00ff":3,"\u00fc":5,"\u00fb":5,"\u00fa":5,"\u00f9":5,"\u00f8":7,"\u00f6":7,"\u00f5":7,"\u00f4":7,"\u00f3":7,"\u00f2":7,"\u00f1":3,"\u00ef":4,"\u00ee":4,"\u00eb":8,"\u00ea":8,"\u00e9":8,"\u00e8":8,"\u00e7":9,"\u00e6":4,"\u00e5":4,"\u00e4":4,"\u00e3":4,"\u00e2":4,"\u00e1":4,"\u00e0":4,"r":7,"q":6,"m":3,"k":5,"_":19,"\/":11,",":20,"'":22,"d":6,"t":3,"u":5,"c":9,"e":8,"o":7,"\"":22,"-":10,"\u2212":10,"\u201c":22,"\u201d":22,")":13,"]":13,".":20,"x":3,"\u201e":20,"a":4,"z":3,"g":9,":":3,";":3,"p":5,"s":4}},"z":{"d":"12,0v-5,-5,-7,-18,-2,-26r70,-129v-23,1,-50,-2,-70,2v-1,-10,-3,-27,8,-27v30,2,67,-4,93,2v3,7,1,14,-2,21r-67,130v24,0,53,2,69,-4v0,13,5,31,-11,31r-88,0","w":120,"k":{"\u2039":4,"\u2019":17,"\u2018":17,"\u2014":13,"\u2013":13,"\u017e":4,"\u0161":4,"\u0153":4,"\u00ff":3,"\u00fd":3,"\u00fc":5,"\u00fb":5,"\u00fa":5,"\u00f9":5,"\u00f8":4,"\u00f6":4,"\u00f5":4,"\u00f4":4,"\u00f3":4,"\u00f2":4,"\u00f1":4,"\u00ef":4,"\u00ee":4,"\u00eb":6,"\u00ea":6,"\u00e9":6,"\u00e8":6,"\u00e7":5,"\u00e6":4,"\u00e5":4,"\u00e4":4,"\u00e3":4,"\u00e2":4,"\u00e1":4,"\u00e0":4,"q":6,"'":17,"d":6,"t":3,"u":5,"w":3,"y":3,"c":5,"e":6,"o":4,"\"":17,"-":13,"\u2212":13,"\u201c":17,"\u201d":17,")":9,"]":9,"x":5,"g":4,"p":3}},"|":{"d":"73,-293r0,362v-4,5,-19,2,-29,3r0,-362v4,-5,19,-2,29,-3","w":116},"\u00a1":{"d":"37,-183v15,0,20,8,20,21v0,12,-8,21,-20,21v-14,0,-20,-8,-20,-21v0,-12,8,-21,20,-21xm22,-92v-1,-15,15,-13,29,-13r5,167v-2,14,-25,8,-40,9","w":70,"k":{"j":-33,"\/":-11}},"\u00a2":{"d":"30,-82v0,-50,9,-88,46,-99v1,-23,-7,-49,27,-44r0,42v18,1,27,15,18,33v-6,-4,-15,-5,-24,-6v-36,1,-38,33,-38,73v0,35,0,60,34,60v16,0,34,-21,30,10v-1,9,-17,15,-28,16v-1,24,8,50,-27,45r0,-46v-35,-6,-38,-40,-38,-84","k":{"\"":9,"\u201d":9,"\u201c":9,"]":11,")":11,"\u2019":9,"\u2018":9,"'":9}},"\u00a5":{"d":"136,-88v6,31,-20,25,-46,25v-1,20,1,43,-1,61v-5,3,-19,2,-29,2r0,-63r-46,0v-6,-31,20,-25,46,-25v1,-15,-4,-24,-7,-35r-39,0v-3,-24,8,-26,31,-24r-35,-103v10,-2,22,-2,34,-2r31,118v7,-41,22,-79,33,-116v9,-2,19,-2,30,-2r-34,105r32,0v5,28,-15,24,-40,24v-3,10,-7,20,-6,35r46,0","k":{"\/":5}},"\u00a8":{"d":"18,-212v-12,0,-18,-6,-18,-18v0,-9,7,-19,18,-18v12,0,18,6,18,18v0,11,-7,18,-18,18xm69,-212v-12,0,-18,-6,-18,-18v0,-9,7,-19,18,-18v12,0,18,6,18,18v0,11,-7,18,-18,18","w":86},"\u00a9":{"d":"57,-191v0,-36,19,-59,49,-44r-2,12v-20,-10,-31,7,-31,32v0,22,10,31,30,23v8,11,-4,20,-16,18v-26,1,-30,-14,-30,-41xm84,-115v-51,0,-71,-27,-71,-80v0,-52,24,-79,74,-79v50,0,71,27,70,79v-1,50,-24,80,-73,80xm87,-253v-36,0,-52,21,-52,58v0,38,13,59,49,59v34,0,52,-23,51,-60v0,-37,-13,-57,-48,-57","w":169,"k":{"\/":33}},"\u00ab":{"d":"34,-91v16,26,33,44,43,74v-2,8,-8,16,-17,17v-18,-31,-39,-58,-54,-91v15,-33,33,-61,53,-89v10,1,14,8,17,15v-9,32,-25,47,-42,74xm96,-90v17,22,31,40,42,65v-2,8,-8,14,-17,16v-17,-27,-40,-49,-53,-81v13,-31,34,-55,52,-82v9,1,14,7,17,14v-8,26,-25,46,-41,68","w":149,"k":{"T":23,"V":9,"W":10,"Y":14,"\u00dd":14,"\u0178":14}},"\u00ae":{"d":"84,-115v-51,0,-71,-27,-71,-80v0,-52,24,-79,74,-79v50,0,71,27,70,79v-1,50,-24,80,-73,80xm87,-253v-36,0,-52,21,-52,58v0,38,13,59,49,59v34,0,52,-23,51,-60v0,-37,-13,-57,-48,-57xm99,-150v-3,-20,-2,-36,-22,-36v-3,14,10,41,-14,36v2,-29,-3,-66,3,-91v25,-2,46,3,45,26v-1,11,-5,20,-12,25v8,7,13,20,14,37v0,5,-9,3,-14,3xm77,-198v14,2,19,-4,19,-18v0,-12,-7,-14,-19,-13r0,31","w":169,"k":{"\/":30}},"\u00b4":{"d":"62,-242v-13,13,-34,28,-51,37v-7,-2,-8,-9,-11,-16v13,-16,32,-32,48,-43v8,3,12,13,14,22","w":61},"\u00b7":{"d":"39,-76v-15,0,-20,-8,-20,-21v-1,-12,9,-21,20,-21v14,0,20,8,20,21v0,12,-8,21,-20,21","w":79},"\u00b8":{"d":"32,46v0,-15,-14,-11,-26,-10r7,-37r17,0r-5,22v16,-1,24,7,24,23v0,26,-26,36,-49,26v-2,-30,32,3,32,-24","w":48},"\u00bb":{"d":"115,-91v-17,-27,-32,-43,-42,-74v0,-10,10,-11,17,-15r53,89v-15,37,-33,59,-54,91v-7,-3,-16,-7,-17,-17v10,-30,27,-48,43,-74xm53,-90v-9,-24,-42,-44,-38,-75r13,-8r53,83v-13,32,-35,56,-54,82v-8,-3,-15,-7,-15,-17v9,-26,24,-43,41,-65","w":149,"k":{"\u2014":-4,"\u2013":-4,"T":23,"V":11,"W":11,"Y":20,"\u00dd":20,"\u0178":20,"v":3,"w":1,"y":1,"\u00fd":1,"\u00ff":1,"-":-4,"\u2212":-4,")":5,"]":5,"J":15,"X":10,"x":5,"z":9,"\u017e":9,"Z":3,"\u017d":3}},"\u00bf":{"d":"60,-182v15,-1,20,7,20,20v0,12,-7,21,-20,21v-14,0,-20,-8,-20,-21v0,-12,9,-20,20,-20xm100,55v-25,29,-104,17,-95,-35v-2,-51,38,-61,44,-103v-6,-21,0,-33,24,-27v23,51,-33,77,-36,123v-3,34,42,31,59,19v2,7,5,14,4,23","w":110,"k":{"\"":22,"\u201d":22,"\u201c":22,"\u00c6":4,"j":-39,"]":-1,"A":4,")":-1,"\u2019":22,"\u2018":22,"\u017d":4,"\u0160":4,"\u00dc":4,"\u00db":4,"\u00d6":4,"\u00d5":4,"\u00d4":4,"\u00d1":4,"\u00cb":4,"\u00ca":4,"\u00c5":4,"\u00c4":4,"\u00c3":4,"\u00c2":4,"\u00c1":4,"\u00c0":4,"'":22}},"\u00c0":{"d":"155,-5v1,9,-19,5,-30,5r-15,-64r-62,0r-14,59v-2,9,-21,6,-32,5r64,-248v1,-6,19,-6,25,-4xm54,-91r50,0r-25,-120xm36,-314v2,-10,9,-31,21,-17v14,10,30,26,41,37v-2,7,-4,15,-12,16v-17,-8,-38,-24,-50,-36","w":157,"k":{"\"":38,"\u2212":14,"\u201d":38,"\u201c":38,"\u00f8":5,"\u00ab":4,"y":17,"w":15,"v":18,"u":4,"t":14,"s":2,"o":5,"f":8,"e":5,"d":5,"c":2,"b":2,"]":7,"Y":28,"W":19,"V":24,"T":22,"O":6,"G":6,"C":9,"-":14,")":7,"\ufb04":8,"\ufb03":8,"\ufb00":8,"\u2122":8,"\u2039":4,"\u2019":38,"\u2018":38,"\u2014":14,"\u2013":14,"\u0178":28,"\u0161":2,"\u0153":8,"\u0152":6,"\u00ff":17,"\u00fd":17,"\u00fc":5,"\u00fb":5,"\u00fa":5,"\u00f9":5,"\u00f6":8,"\u00f5":8,"\u00f4":8,"\u00f3":8,"\u00f2":8,"\u00eb":5,"\u00ea":5,"\u00e9":5,"\u00e8":5,"\u00e7":2,"\u00e6":2,"\u00dd":28,"\u00d8":6,"\u00d6":6,"\u00d5":6,"\u00d4":6,"\u00d3":6,"\u00d2":6,"\u00c7":9,"q":6,"\\":25,"Q":4,"7":7,"\/":-6,"*":17,"'":38}},"\u00c1":{"d":"155,-5v1,9,-19,5,-30,5r-15,-64r-62,0r-14,59v-2,9,-21,6,-32,5r64,-248v1,-6,19,-6,25,-4xm54,-91r50,0r-25,-120xm124,-314v-13,13,-34,28,-51,37v-7,-2,-8,-9,-11,-16v13,-16,32,-32,48,-43v8,3,12,13,14,22","w":157,"k":{"\"":38,"\u2212":14,"\u201d":38,"\u201c":38,"\u00f8":5,"\u00ab":4,"y":17,"w":15,"v":18,"u":4,"t":14,"s":2,"o":5,"f":8,"e":5,"d":5,"c":2,"b":2,"]":7,"Y":28,"W":19,"V":24,"T":22,"O":6,"G":6,"C":9,"-":14,")":7,"\ufb04":8,"\ufb03":8,"\ufb00":8,"\u2122":8,"\u2039":4,"\u2019":38,"\u2018":38,"\u2014":14,"\u2013":14,"\u0178":28,"\u0161":2,"\u0153":8,"\u0152":6,"\u00ff":17,"\u00fd":17,"\u00fc":5,"\u00fb":5,"\u00fa":5,"\u00f9":5,"\u00f6":8,"\u00f5":8,"\u00f4":8,"\u00f3":8,"\u00f2":8,"\u00eb":5,"\u00ea":5,"\u00e9":5,"\u00e8":5,"\u00e7":2,"\u00e6":2,"\u00dd":28,"\u00d8":6,"\u00d6":6,"\u00d5":6,"\u00d4":6,"\u00d3":6,"\u00d2":6,"\u00c7":9,"q":6,"\\":25,"Q":4,"7":7,"\/":-4,"*":17,"'":38}},"\u00c2":{"d":"155,-5v1,9,-19,5,-30,5r-15,-64r-62,0r-14,59v-2,9,-21,6,-32,5r64,-248v1,-6,19,-6,25,-4xm54,-91r50,0r-25,-120xm74,-330v23,-4,37,31,50,44v-1,6,-13,9,-21,9v-8,-9,-18,-18,-24,-28v-10,15,-28,38,-46,19","w":157,"k":{"\"":38,"\u2212":14,"\u201d":38,"\u201c":38,"\u00f8":5,"\u00ab":4,"y":17,"w":15,"v":18,"u":4,"t":14,"s":2,"o":5,"f":8,"e":5,"d":5,"c":2,"b":2,"]":7,"Y":28,"W":19,"V":24,"T":22,"O":6,"G":6,"C":9,"-":14,")":7,"\ufb04":8,"\ufb03":8,"\ufb00":8,"\u2122":8,"\u2039":4,"\u2019":38,"\u2018":38,"\u2014":14,"\u2013":14,"\u0178":28,"\u0161":2,"\u0153":8,"\u0152":6,"\u00ff":17,"\u00fd":17,"\u00fc":5,"\u00fb":5,"\u00fa":5,"\u00f9":5,"\u00f6":8,"\u00f5":8,"\u00f4":8,"\u00f3":8,"\u00f2":8,"\u00eb":5,"\u00ea":5,"\u00e9":5,"\u00e8":5,"\u00e7":2,"\u00e6":2,"\u00dd":28,"\u00d8":6,"\u00d6":6,"\u00d5":6,"\u00d4":6,"\u00d3":6,"\u00d2":6,"\u00c7":9,"q":6,"\\":25,"Q":4,"7":7,"\/":-6,"*":17,"'":38}},"\u00c3":{"d":"155,-5v1,9,-19,5,-30,5r-15,-64r-62,0r-14,59v-2,9,-21,6,-32,5r64,-248v1,-6,19,-6,25,-4xm54,-91r50,0r-25,-120xm81,-281v-10,-18,-31,-16,-41,-1v-9,-1,-11,-8,-14,-15v11,-24,47,-38,63,-12v20,12,35,-29,43,5v-8,13,-27,31,-51,23","w":157,"k":{"\"":38,"\u2212":14,"\u201d":38,"\u201c":38,"\u00f8":5,"\u00ab":4,"y":17,"w":15,"v":18,"u":4,"t":14,"s":2,"o":5,"f":8,"e":5,"d":5,"c":2,"b":2,"]":7,"Y":28,"W":19,"V":24,"T":22,"O":6,"G":6,"C":9,"-":14,")":7,"\ufb04":8,"\ufb03":8,"\ufb00":8,"\u2122":8,"\u2039":4,"\u2019":38,"\u2018":38,"\u2014":14,"\u2013":14,"\u0178":28,"\u0161":2,"\u0153":8,"\u0152":6,"\u00ff":17,"\u00fd":17,"\u00fc":5,"\u00fb":5,"\u00fa":5,"\u00f9":5,"\u00f6":8,"\u00f5":8,"\u00f4":8,"\u00f3":8,"\u00f2":8,"\u00eb":5,"\u00ea":5,"\u00e9":5,"\u00e8":5,"\u00e7":2,"\u00e6":2,"\u00dd":28,"\u00d8":6,"\u00d6":6,"\u00d5":6,"\u00d4":6,"\u00d3":6,"\u00d2":6,"\u00c7":9,"q":6,"\\":25,"Q":4,"7":7,"\/":-9,"*":17,"'":38}},"\u00c4":{"d":"155,-5v1,9,-19,5,-30,5r-15,-64r-62,0r-14,59v-2,9,-21,6,-32,5r64,-248v1,-6,19,-6,25,-4xm54,-91r50,0r-25,-120xm54,-284v-12,0,-18,-6,-18,-18v0,-9,7,-19,18,-18v12,0,18,6,18,18v0,11,-7,18,-18,18xm105,-284v-12,0,-18,-6,-18,-18v0,-9,7,-19,18,-18v12,0,18,6,18,18v0,11,-7,18,-18,18","w":157,"k":{"\"":38,"\u2212":14,"\u201d":38,"\u201c":38,"\u00f8":5,"\u00ab":4,"y":17,"w":15,"v":18,"u":4,"t":14,"s":2,"o":5,"f":8,"e":5,"d":5,"c":2,"b":2,"]":7,"Y":28,"W":19,"V":24,"T":22,"O":6,"G":6,"C":9,"-":14,")":7,"\ufb04":8,"\ufb03":8,"\ufb00":8,"\u2122":8,"\u2039":4,"\u2019":38,"\u2018":38,"\u2014":14,"\u2013":14,"\u0178":28,"\u0161":2,"\u0153":8,"\u0152":6,"\u00ff":17,"\u00fd":17,"\u00fc":5,"\u00fb":5,"\u00fa":5,"\u00f9":5,"\u00f6":8,"\u00f5":8,"\u00f4":8,"\u00f3":8,"\u00f2":8,"\u00eb":5,"\u00ea":5,"\u00e9":5,"\u00e8":5,"\u00e7":2,"\u00e6":2,"\u00dd":28,"\u00d8":6,"\u00d6":6,"\u00d5":6,"\u00d4":6,"\u00d3":6,"\u00d2":6,"\u00c7":9,"q":6,"\\":25,"Q":4,"7":7,"\/":-4,"*":17,"'":38}},"\u00c5":{"d":"155,-5v1,9,-19,5,-30,5r-15,-64r-62,0r-14,59v-2,9,-21,6,-32,5r64,-248v1,-6,19,-6,25,-4xm54,-91r50,0r-25,-120xm77,-274v-23,-1,-34,-10,-34,-35v0,-23,13,-36,36,-36v25,1,32,10,33,35v0,24,-11,36,-35,36xm79,-324v-10,0,-15,4,-15,15v0,10,4,15,13,15v10,-1,15,-4,15,-16v0,-10,-5,-14,-13,-14","w":157,"k":{"\"":38,"\u2212":14,"\u201d":38,"\u201c":38,"\u00f8":5,"\u00ab":4,"y":17,"w":15,"v":18,"u":4,"t":14,"s":2,"o":5,"f":8,"e":5,"d":5,"c":2,"b":2,"]":7,"Y":28,"W":19,"V":24,"T":22,"O":6,"G":6,"C":9,"-":14,")":7,"\ufb04":8,"\ufb03":8,"\ufb00":8,"\u2122":8,"\u2039":4,"\u2019":38,"\u2018":38,"\u2014":14,"\u2013":14,"\u0178":28,"\u0161":2,"\u0153":8,"\u0152":6,"\u00ff":17,"\u00fd":17,"\u00fc":5,"\u00fb":5,"\u00fa":5,"\u00f9":5,"\u00f6":8,"\u00f5":8,"\u00f4":8,"\u00f3":8,"\u00f2":8,"\u00eb":5,"\u00ea":5,"\u00e9":5,"\u00e8":5,"\u00e7":2,"\u00e6":2,"\u00dd":28,"\u00d8":6,"\u00d6":6,"\u00d5":6,"\u00d4":6,"\u00d3":6,"\u00d2":6,"\u00c7":9,"q":6,"\\":25,"Q":4,"7":7,"\/":-6,"*":17,"'":38}},"\u00c6":{"d":"206,-150v-2,11,2,24,-6,27r-49,0r0,97r62,0v-2,9,4,26,-6,26r-85,0r0,-64r-59,0v-10,21,-17,44,-28,63v-6,3,-21,2,-29,1r106,-247v1,-3,4,-5,9,-5r93,0v-2,8,5,25,-5,26r-58,0r0,76r55,0xm74,-91r48,0r0,-130r-27,80","w":221,"k":{"\"":-4,"\u2212":10,"\u201d":-4,"\u201c":-4,"\u00f8":7,"z":1,"y":5,"x":3,"w":5,"u":3,"o":7,"g":5,"e":5,"d":6,"c":2,"a":4,"-":10,"\u2019":-4,"\u2018":-4,"\u2014":10,"\u2013":10,"\u017e":1,"\u0161":4,"\u0153":7,"\u00ff":5,"\u00fd":5,"\u00fc":3,"\u00fb":3,"\u00fa":3,"\u00f9":3,"\u00f6":7,"\u00f5":7,"\u00f4":7,"\u00f3":7,"\u00f2":7,"\u00f1":4,"\u00ef":4,"\u00ee":4,"\u00eb":5,"\u00ea":5,"\u00e9":5,"\u00e8":5,"\u00e7":2,"\u00e6":4,"\u00e5":4,"\u00e4":4,"\u00e3":4,"\u00e2":4,"\u00e1":4,"\u00e0":4,"r":3,"q":6,"0":2,"\/":-3,"'":-4}},"\u00c7":{"d":"11,-116v0,-74,8,-134,71,-141v27,-2,41,16,29,38v-53,-31,-73,40,-69,102v2,42,-1,85,36,89v13,0,27,-5,33,-11v14,23,-7,43,-32,43r-3,17v16,-1,23,6,23,23v0,26,-26,36,-49,26v2,-5,1,-12,5,-15v7,1,28,11,27,-9v2,-15,-13,-11,-25,-10r6,-32v-50,-7,-52,-60,-52,-120","w":122,"k":{"\"":-2,"\u2212":30,"\u201e":-2,"\u201d":-2,"\u201c":-2,"\u00f8":5,"z":1,"y":23,"x":5,"w":19,"v":21,"u":7,"t":7,"o":5,"f":9,"e":6,"d":4,"c":4,"a":4,"S":2,"O":8,"G":5,"C":4,".":-2,"-":30,"\ufb04":9,"\ufb03":9,"\ufb00":9,"\u2039":8,"\u2026":-2,"\u201a":-2,"\u2019":-2,"\u2018":-2,"\u2014":30,"\u2013":30,"\u017e":1,"\u0161":4,"\u0160":2,"\u0153":5,"\u0152":8,"\u00ff":23,"\u00fd":23,"\u00fc":7,"\u00fb":7,"\u00fa":7,"\u00f9":7,"\u00f6":5,"\u00f5":5,"\u00f4":5,"\u00f3":5,"\u00f2":5,"\u00f1":4,"\u00ef":4,"\u00ee":4,"\u00eb":6,"\u00ea":6,"\u00e9":6,"\u00e8":6,"\u00e7":4,"\u00e6":4,"\u00e5":4,"\u00e4":4,"\u00e3":4,"\u00e2":4,"\u00e1":4,"\u00e0":4,"\u00d8":8,"\u00d6":8,"\u00d5":8,"\u00d4":8,"\u00d3":8,"\u00d2":8,"\u00c7":4,"q":4,"Q":8,"@":2,"0":9,"\/":-6,",":-2,"*":4,"'":-2,"\u00ab":8}},"\u00c8":{"d":"99,-150v-1,10,3,25,-5,27r-49,0r0,97r62,0v-2,9,4,26,-6,26r-85,0r1,-249v23,-8,62,-1,91,-3v-2,8,4,26,-5,26r-58,0r0,76r54,0xm23,-314v2,-10,9,-31,21,-17v14,10,30,26,41,37v-2,7,-4,15,-12,16v-17,-8,-38,-24,-50,-36","w":115,"k":{"\"":-4,"\u2212":10,"\u201d":-4,"\u201c":-4,"\u00f8":7,"z":1,"y":5,"x":3,"w":5,"u":3,"o":7,"e":5,"d":6,"c":2,"a":4,"-":10,"\u2019":-4,"\u2018":-4,"\u2014":10,"\u2013":10,"\u017e":1,"\u0161":4,"\u0153":7,"\u00ff":5,"\u00fd":5,"\u00fc":3,"\u00fb":3,"\u00fa":3,"\u00f9":3,"\u00f6":7,"\u00f5":7,"\u00f4":7,"\u00f3":7,"\u00f2":7,"\u00f1":4,"\u00ef":4,"\u00ee":4,"\u00eb":5,"\u00ea":5,"\u00e9":5,"\u00e8":5,"\u00e7":2,"\u00e6":4,"\u00e5":4,"\u00e4":4,"\u00e3":4,"\u00e2":4,"\u00e1":4,"\u00e0":4,"r":3,"q":6,"0":2,"\/":-3,"'":-4}},"\u00c9":{"d":"99,-150v-1,10,3,25,-5,27r-49,0r0,97r62,0v-2,9,4,26,-6,26r-85,0r1,-249v23,-8,62,-1,91,-3v-2,8,4,26,-5,26r-58,0r0,76r54,0xm111,-314v-13,13,-34,28,-51,37v-7,-2,-8,-9,-11,-16v13,-16,32,-32,48,-43v8,3,12,13,14,22","w":115,"k":{"\"":-4,"\u2212":10,"\u201d":-4,"\u201c":-4,"\u00f8":7,"z":1,"y":5,"x":3,"w":5,"u":3,"o":7,"e":5,"d":6,"c":2,"a":4,"-":10,"\u2019":-4,"\u2018":-4,"\u2014":10,"\u2013":10,"\u017e":1,"\u0161":4,"\u0153":7,"\u00ff":5,"\u00fd":5,"\u00fc":3,"\u00fb":3,"\u00fa":3,"\u00f9":3,"\u00f6":7,"\u00f5":7,"\u00f4":7,"\u00f3":7,"\u00f2":7,"\u00f1":4,"\u00ef":4,"\u00ee":4,"\u00eb":5,"\u00ea":5,"\u00e9":5,"\u00e8":5,"\u00e7":2,"\u00e6":4,"\u00e5":4,"\u00e4":4,"\u00e3":4,"\u00e2":4,"\u00e1":4,"\u00e0":4,"r":3,"q":6,"0":2,"\/":-3,"'":-4}},"\u00ca":{"d":"99,-150v-1,10,3,25,-5,27r-49,0r0,97r62,0v-2,9,4,26,-6,26r-85,0r1,-249v23,-8,62,-1,91,-3v-2,8,4,26,-5,26r-58,0r0,76r54,0xm61,-330v23,-4,37,31,50,44v-1,6,-13,9,-21,9v-8,-9,-18,-18,-24,-28v-10,15,-28,38,-46,19","w":115,"k":{"\"":-4,"\u2212":10,"\u201d":-4,"\u201c":-4,"\u00f8":7,"\u00ab":4,"z":1,"y":5,"x":3,"w":5,"v":18,"u":3,"t":14,"s":2,"o":7,"f":8,"e":5,"d":6,"c":2,"b":2,"a":4,"Y":28,"W":19,"V":24,"T":22,"O":6,"G":6,"C":9,"-":10,"\ufb04":8,"\ufb03":8,"\ufb00":8,"\u2122":8,"\u2039":4,"\u2019":-4,"\u2018":-4,"\u2014":10,"\u2013":10,"\u017e":1,"\u0178":28,"\u0161":4,"\u0153":7,"\u0152":6,"\u00ff":5,"\u00fd":5,"\u00fc":3,"\u00fb":3,"\u00fa":3,"\u00f9":3,"\u00f6":7,"\u00f5":7,"\u00f4":7,"\u00f3":7,"\u00f2":7,"\u00f1":4,"\u00ef":4,"\u00ee":4,"\u00eb":5,"\u00ea":5,"\u00e9":5,"\u00e8":5,"\u00e7":2,"\u00e6":4,"\u00e5":4,"\u00e4":4,"\u00e3":4,"\u00e2":4,"\u00e1":4,"\u00e0":4,"\u00dd":28,"\u00d8":6,"\u00d6":6,"\u00d5":6,"\u00d4":6,"\u00d3":6,"\u00d2":6,"\u00c7":9,"r":3,"q":6,"\\":25,"Q":4,"7":7,"0":2,"\/":-8,"'":-4}},"\u00cb":{"d":"99,-150v-1,10,3,25,-5,27r-49,0r0,97r62,0v-2,9,4,26,-6,26r-85,0r1,-249v23,-8,62,-1,91,-3v-2,8,4,26,-5,26r-58,0r0,76r54,0xm41,-284v-12,0,-18,-6,-18,-18v0,-9,7,-19,18,-18v12,0,18,6,18,18v0,11,-7,18,-18,18xm92,-284v-12,0,-18,-6,-18,-18v0,-9,7,-19,18,-18v12,0,18,6,18,18v0,11,-7,18,-18,18","w":115,"k":{"\"":-4,"\u2212":10,"\u201d":-4,"\u201c":-4,"\u00f8":7,"\u00ab":4,"z":1,"y":5,"x":3,"w":5,"v":18,"u":3,"t":14,"s":2,"o":7,"f":8,"e":5,"d":6,"c":2,"b":2,"a":4,"Y":28,"W":19,"V":24,"T":22,"O":6,"G":6,"C":9,"-":10,"\ufb04":8,"\ufb03":8,"\ufb00":8,"\u2122":8,"\u2039":4,"\u2019":-4,"\u2018":-4,"\u2014":10,"\u2013":10,"\u017e":1,"\u0178":28,"\u0161":4,"\u0153":7,"\u0152":6,"\u00ff":5,"\u00fd":5,"\u00fc":3,"\u00fb":3,"\u00fa":3,"\u00f9":3,"\u00f6":7,"\u00f5":7,"\u00f4":7,"\u00f3":7,"\u00f2":7,"\u00f1":4,"\u00ef":4,"\u00ee":4,"\u00eb":5,"\u00ea":5,"\u00e9":5,"\u00e8":5,"\u00e7":2,"\u00e6":4,"\u00e5":4,"\u00e4":4,"\u00e3":4,"\u00e2":4,"\u00e1":4,"\u00e0":4,"\u00dd":28,"\u00d8":6,"\u00d6":6,"\u00d5":6,"\u00d4":6,"\u00d3":6,"\u00d2":6,"\u00c7":9,"r":3,"q":6,"\\":25,"Q":4,"7":7,"0":2,"\/":-13,"'":-4}},"\u00cc":{"d":"15,-239v-2,-16,16,-13,30,-13r-1,250v-5,3,-19,2,-29,2r0,-239xm-12,-314v2,-10,9,-31,21,-17v14,10,30,26,41,37v-2,7,-4,15,-12,16v-17,-8,-38,-24,-50,-36","w":60,"k":{"\/":-4}},"\u00cd":{"d":"15,-239v-2,-16,16,-13,30,-13r-1,250v-5,3,-19,2,-29,2r0,-239xm76,-314v-13,13,-34,28,-51,37v-7,-2,-8,-9,-11,-16v13,-16,32,-32,48,-43v8,3,12,13,14,22","w":60,"k":{"]":-1,")":-1,"\/":-4}},"\u00ce":{"d":"15,-239v-2,-16,16,-13,30,-13r-1,250v-5,3,-19,2,-29,2r0,-239xm26,-330v23,-4,37,31,50,44v-1,6,-13,9,-21,9v-8,-9,-18,-18,-24,-28v-10,15,-28,38,-46,19","w":60,"k":{"\"":-19,"\u201d":-19,"\u201c":-19,"]":-22,")":-22,"\u2019":-19,"\u2018":-19,"\/":-4,"'":-19}},"\u00cf":{"d":"15,-239v-2,-16,16,-13,30,-13r-1,250v-5,3,-19,2,-29,2r0,-239xm6,-284v-12,0,-18,-6,-18,-18v0,-9,7,-19,18,-18v12,0,18,6,18,18v0,11,-7,18,-18,18xm57,-284v-12,0,-18,-6,-18,-18v0,-9,7,-19,18,-18v12,0,18,6,18,18v0,11,-7,18,-18,18","w":60,"k":{"\"":-7,"\u201d":-7,"\u201c":-7,"]":-4,")":-4,"\u2019":-7,"\u2018":-7,"\/":-4,"'":-7}},"\u00d1":{"d":"116,0r-75,-201r3,199v-5,3,-19,2,-29,2r0,-246v1,-10,19,-4,29,-6r74,198r-3,-195v4,-5,19,-2,29,-3r0,246v0,11,-18,4,-28,6xm85,-281v-10,-18,-31,-16,-41,-1v-9,-1,-11,-8,-14,-15v11,-24,47,-38,63,-12v20,12,35,-29,43,5v-8,13,-27,31,-51,23","w":159,"k":{"\"":-1,"\u201d":-1,"\u201c":-1,"\u00f8":5,"\u00ab":4,"y":17,"w":15,"v":18,"u":4,"t":14,"s":2,"o":5,"f":8,"e":5,"d":5,"c":2,"b":2,"Y":28,"W":19,"V":24,"T":22,"O":6,"G":6,"C":9,"\ufb04":8,"\ufb03":8,"\ufb00":8,"\u2122":8,"\u2039":4,"\u2019":-1,"\u2018":-1,"\u2014":7,"\u2013":7,"\u0178":28,"\u0161":2,"\u0153":5,"\u0152":6,"\u00ff":17,"\u00fd":17,"\u00fc":4,"\u00fb":4,"\u00fa":4,"\u00f9":4,"\u00f6":5,"\u00f5":5,"\u00f4":5,"\u00f3":5,"\u00f2":5,"\u00eb":5,"\u00ea":5,"\u00e9":5,"\u00e8":5,"\u00e7":2,"\u00e6":2,"\u00dd":28,"\u00d8":6,"\u00d6":6,"\u00d5":6,"\u00d4":6,"\u00d3":6,"\u00d2":6,"\u00c7":9,"q":6,"\\":25,"Q":4,"7":7,"\/":-13,"'":-1}},"\u00d2":{"d":"76,3v-65,0,-65,-61,-65,-130v0,-68,5,-128,69,-128v63,0,64,61,64,126v0,69,-3,132,-68,132xm79,-225v-40,6,-35,58,-35,105v0,43,-4,88,33,93v39,-5,35,-56,35,-101v0,-43,6,-92,-33,-97xm37,-314v2,-10,9,-31,21,-17v14,10,30,26,41,37v-2,7,-4,15,-12,16v-17,-8,-38,-24,-50,-36","w":154,"k":{"\"":4,"\u201e":12,"\u201d":4,"\u201c":4,"x":7,"c":2,"]":7,"Y":8,"X":8,"W":5,"V":4,"T":8,"Q":1,"O":1,"J":12,"A":8,".":12,")":7,"\u2026":12,"\u201a":12,"\u2019":4,"\u2018":4,"\u017d":8,"\u0178":8,"\u0160":8,"\u0152":1,"\u00e7":2,"\u00dd":8,"\u00dc":8,"\u00db":8,"\u00d8":1,"\u00d6":1,"\u00d5":1,"\u00d4":1,"\u00d3":1,"\u00d2":1,"\u00d1":8,"\u00cb":8,"\u00ca":8,"\u00c6":8,"\u00c5":8,"\u00c4":8,"\u00c3":8,"\u00c2":8,"\u00c1":8,"\u00c0":8,"_":19,",":12,"*":3,"'":4}},"\u00d3":{"d":"76,3v-65,0,-65,-61,-65,-130v0,-68,5,-128,69,-128v63,0,64,61,64,126v0,69,-3,132,-68,132xm79,-225v-40,6,-35,58,-35,105v0,43,-4,88,33,93v39,-5,35,-56,35,-101v0,-43,6,-92,-33,-97xm125,-314v-13,13,-34,28,-51,37v-7,-2,-8,-9,-11,-16v13,-16,32,-32,48,-43v8,3,12,13,14,22","w":154,"k":{"\"":4,"\u201e":12,"\u201d":4,"\u201c":4,"x":7,"c":2,"]":7,"Y":8,"X":8,"W":5,"V":4,"T":8,"Q":1,"O":1,"J":12,"A":8,".":12,")":7,"\u2026":12,"\u201a":12,"\u2019":4,"\u2018":4,"\u017d":8,"\u0178":8,"\u0160":8,"\u0152":1,"\u00e7":2,"\u00dd":8,"\u00dc":8,"\u00db":8,"\u00d8":1,"\u00d6":1,"\u00d5":1,"\u00d4":1,"\u00d3":1,"\u00d2":1,"\u00d1":8,"\u00cb":8,"\u00ca":8,"\u00c6":8,"\u00c5":8,"\u00c4":8,"\u00c3":8,"\u00c2":8,"\u00c1":8,"\u00c0":8,"_":19,",":12,"*":3,"'":4}},"\u00d4":{"d":"76,3v-65,0,-65,-61,-65,-130v0,-68,5,-128,69,-128v63,0,64,61,64,126v0,69,-3,132,-68,132xm79,-225v-40,6,-35,58,-35,105v0,43,-4,88,33,93v39,-5,35,-56,35,-101v0,-43,6,-92,-33,-97xm75,-330v23,-4,37,31,50,44v-1,6,-13,9,-21,9v-8,-9,-18,-18,-24,-28v-10,15,-28,38,-46,19","w":154,"k":{"\"":4,"\u201e":12,"\u201d":4,"\u201c":4,"\u00f8":5,"\u00ab":4,"y":17,"x":7,"w":15,"v":18,"u":4,"t":14,"s":2,"o":5,"f":8,"e":5,"d":5,"c":2,"b":2,"]":7,"Y":8,"X":8,"W":5,"V":4,"T":8,"O":1,"J":12,"G":6,"C":9,"A":8,".":12,")":7,"\ufb04":8,"\ufb03":8,"\ufb00":8,"\u2122":8,"\u2039":4,"\u2026":12,"\u201a":12,"\u2019":4,"\u2018":4,"\u2014":7,"\u2013":7,"\u017d":8,"\u0178":8,"\u0161":2,"\u0160":8,"\u0153":5,"\u0152":1,"\u00ff":17,"\u00fd":17,"\u00fc":4,"\u00fb":4,"\u00fa":4,"\u00f9":4,"\u00f6":5,"\u00f5":5,"\u00f4":5,"\u00f3":5,"\u00f2":5,"\u00eb":5,"\u00ea":5,"\u00e9":5,"\u00e8":5,"\u00e7":2,"\u00e6":2,"\u00dd":8,"\u00dc":8,"\u00db":8,"\u00d8":1,"\u00d6":1,"\u00d5":1,"\u00d4":1,"\u00d3":1,"\u00d2":1,"\u00d1":8,"\u00cb":8,"\u00ca":8,"\u00c7":9,"\u00c6":8,"\u00c5":8,"\u00c4":8,"\u00c3":8,"\u00c2":8,"\u00c1":8,"\u00c0":8,"q":6,"_":19,"\\":25,"Q":1,"7":7,"\/":3,",":12,"*":3,"'":4}},"\u00d5":{"d":"76,3v-65,0,-65,-61,-65,-130v0,-68,5,-128,69,-128v63,0,64,61,64,126v0,69,-3,132,-68,132xm79,-225v-40,6,-35,58,-35,105v0,43,-4,88,33,93v39,-5,35,-56,35,-101v0,-43,6,-92,-33,-97xm82,-281v-10,-18,-31,-16,-41,-1v-9,-1,-11,-8,-14,-15v11,-24,47,-38,63,-12v20,12,35,-29,43,5v-8,13,-27,31,-51,23","w":154,"k":{"\"":4,"\u201e":12,"\u201d":4,"\u201c":4,"\u00f8":5,"\u00ab":4,"y":17,"x":7,"w":15,"v":18,"u":4,"t":14,"s":2,"o":5,"f":8,"e":5,"d":5,"c":2,"b":2,"]":7,"Y":8,"X":8,"W":5,"V":4,"T":8,"O":1,"J":12,"G":6,"C":9,"A":8,".":12,")":7,"\ufb04":8,"\ufb03":8,"\ufb00":8,"\u2122":8,"\u2039":4,"\u2026":12,"\u201a":12,"\u2019":4,"\u2018":4,"\u2014":7,"\u2013":7,"\u017d":8,"\u0178":8,"\u0161":2,"\u0160":8,"\u0153":5,"\u0152":1,"\u00ff":17,"\u00fd":17,"\u00fc":4,"\u00fb":4,"\u00fa":4,"\u00f9":4,"\u00f6":5,"\u00f5":5,"\u00f4":5,"\u00f3":5,"\u00f2":5,"\u00eb":5,"\u00ea":5,"\u00e9":5,"\u00e8":5,"\u00e7":2,"\u00e6":2,"\u00dd":8,"\u00dc":8,"\u00db":8,"\u00d8":1,"\u00d6":1,"\u00d5":1,"\u00d4":1,"\u00d3":1,"\u00d2":1,"\u00d1":8,"\u00cb":8,"\u00ca":8,"\u00c7":9,"\u00c6":8,"\u00c5":8,"\u00c4":8,"\u00c3":8,"\u00c2":8,"\u00c1":8,"\u00c0":8,"q":6,"_":19,"\\":25,"Q":1,"7":7,"\/":4,",":12,"*":3,"'":4}},"\u00d6":{"d":"76,3v-65,0,-65,-61,-65,-130v0,-68,5,-128,69,-128v63,0,64,61,64,126v0,69,-3,132,-68,132xm79,-225v-40,6,-35,58,-35,105v0,43,-4,88,33,93v39,-5,35,-56,35,-101v0,-43,6,-92,-33,-97xm55,-284v-12,0,-18,-6,-18,-18v0,-9,7,-19,18,-18v12,0,18,6,18,18v0,11,-7,18,-18,18xm106,-284v-12,0,-18,-6,-18,-18v0,-9,7,-19,18,-18v12,0,18,6,18,18v0,11,-7,18,-18,18","w":154,"k":{"\"":4,"\u201e":12,"\u201d":4,"\u201c":4,"\u00f8":5,"\u00ab":4,"y":17,"x":7,"w":15,"v":18,"u":4,"t":14,"s":2,"o":5,"f":8,"e":5,"d":5,"c":2,"b":2,"]":7,"Y":8,"X":8,"W":5,"V":4,"T":8,"O":1,"J":12,"G":6,"C":9,"A":8,".":12,")":7,"\ufb04":8,"\ufb03":8,"\ufb00":8,"\u2122":8,"\u2039":4,"\u2026":12,"\u201a":12,"\u2019":4,"\u2018":4,"\u2014":7,"\u2013":7,"\u017d":8,"\u0178":8,"\u0161":2,"\u0160":8,"\u0153":5,"\u0152":1,"\u00ff":17,"\u00fd":17,"\u00fc":4,"\u00fb":4,"\u00fa":4,"\u00f9":4,"\u00f6":5,"\u00f5":5,"\u00f4":5,"\u00f3":5,"\u00f2":5,"\u00eb":5,"\u00ea":5,"\u00e9":5,"\u00e8":5,"\u00e7":2,"\u00e6":2,"\u00dd":8,"\u00dc":8,"\u00db":8,"\u00d8":1,"\u00d6":1,"\u00d5":1,"\u00d4":1,"\u00d3":1,"\u00d2":1,"\u00d1":8,"\u00cb":8,"\u00ca":8,"\u00c7":9,"\u00c6":8,"\u00c5":8,"\u00c4":8,"\u00c3":8,"\u00c2":8,"\u00c1":8,"\u00c0":8,"q":6,"_":19,"\\":25,"Q":1,"7":7,"\/":2,",":12,"*":3,"'":4}},"\u00d7":{"d":"125,-66v-9,6,-13,17,-23,14r-27,-30r-27,30v-10,3,-13,-8,-22,-14r32,-35r-32,-36v9,-7,12,-17,22,-14r27,30r27,-30v10,-3,14,8,23,14r-32,35","k":{"\/":6}},"\u00d8":{"d":"39,-13v-5,6,-3,21,-13,18v-25,-2,-4,-30,0,-42v-13,-73,-30,-220,59,-219v19,0,33,6,42,17v3,-18,15,-26,27,-11v-2,14,-8,28,-12,40v10,69,28,217,-60,214v-20,-1,-34,-5,-43,-17xm85,-226v-50,12,-33,100,-33,162r53,-151v-5,-7,-11,-11,-20,-11xm81,-27v54,0,34,-98,34,-158r-53,150v5,6,11,8,19,8","w":166,"k":{"\"":4,"\u2212":7,"\u201e":12,"\u201d":4,"\u201c":4,"z":7,"y":7,"x":7,"w":7,"u":5,"t":5,"s":5,"p":5,"h":3,"g":7,"e":7,"d":7,"c":2,"a":8,"]":7,"Y":8,"X":8,"W":5,"V":4,"T":8,"Q":1,"O":1,"J":12,"A":8,".":12,"-":7,")":7,"\u2026":12,"\u201a":12,"\u2019":4,"\u2018":4,"\u2014":7,"\u2013":7,"\u017e":9,"\u017d":8,"\u0178":8,"\u0161":7,"\u0160":8,"\u0152":1,"\u00ff":9,"\u00fd":7,"\u00fc":7,"\u00fb":7,"\u00fa":5,"\u00f9":5,"\u00f6":8,"\u00f5":8,"\u00f4":8,"\u00f1":8,"\u00ef":8,"\u00ee":8,"\u00eb":9,"\u00ea":9,"\u00e9":7,"\u00e8":7,"\u00e7":2,"\u00e6":8,"\u00e5":8,"\u00e4":8,"\u00e3":8,"\u00e2":8,"\u00e1":8,"\u00e0":8,"\u00dd":8,"\u00dc":8,"\u00db":8,"\u00d8":1,"\u00d6":1,"\u00d5":1,"\u00d4":1,"\u00d3":1,"\u00d2":1,"\u00d1":8,"\u00cb":8,"\u00ca":8,"\u00c6":8,"\u00c5":8,"\u00c4":8,"\u00c3":8,"\u00c2":8,"\u00c1":8,"\u00c0":8,"r":7,"q":5,"k":3,"_":19,"0":6,",":12,"*":3,"'":4}},"\u00d9":{"d":"80,4v-48,0,-65,-28,-65,-77r1,-176v4,-5,20,-2,30,-3r0,179v0,29,5,50,34,50v11,0,26,-3,32,-7r0,-219v4,-5,19,-2,29,-3r0,243v-13,7,-39,13,-61,13xm37,-314v2,-10,9,-31,21,-17v14,10,30,26,41,37v-2,7,-4,15,-12,16v-17,-8,-38,-24,-50,-36","w":157},"\u00da":{"d":"80,4v-48,0,-65,-28,-65,-77r1,-176v4,-5,20,-2,30,-3r0,179v0,29,5,50,34,50v11,0,26,-3,32,-7r0,-219v4,-5,19,-2,29,-3r0,243v-13,7,-39,13,-61,13xm125,-314v-13,13,-34,28,-51,37v-7,-2,-8,-9,-11,-16v13,-16,32,-32,48,-43v8,3,12,13,14,22","w":157},"\u00db":{"d":"80,4v-48,0,-65,-28,-65,-77r1,-176v4,-5,20,-2,30,-3r0,179v0,29,5,50,34,50v11,0,26,-3,32,-7r0,-219v4,-5,19,-2,29,-3r0,243v-13,7,-39,13,-61,13xm75,-330v23,-4,37,31,50,44v-1,6,-13,9,-21,9v-8,-9,-18,-18,-24,-28v-10,15,-28,38,-46,19","w":157,"k":{"\"":2,"\u201d":2,"\u201c":2,"\u00f8":5,"\u00ab":4,"y":17,"w":15,"v":18,"u":4,"t":14,"s":2,"o":5,"f":8,"e":5,"d":5,"c":2,"b":2,"Y":28,"W":19,"V":24,"T":22,"O":6,"G":6,"C":9,"\ufb04":8,"\ufb03":8,"\ufb00":8,"\u2122":8,"\u2039":4,"\u2019":2,"\u2018":2,"\u2014":7,"\u2013":7,"\u0178":28,"\u0161":2,"\u0153":5,"\u0152":6,"\u00ff":17,"\u00fd":17,"\u00fc":4,"\u00fb":4,"\u00fa":4,"\u00f9":4,"\u00f6":5,"\u00f5":5,"\u00f4":5,"\u00f3":5,"\u00f2":5,"\u00eb":5,"\u00ea":5,"\u00e9":5,"\u00e8":5,"\u00e7":2,"\u00e6":2,"\u00dd":28,"\u00d8":6,"\u00d6":6,"\u00d5":6,"\u00d4":6,"\u00d3":6,"\u00d2":6,"\u00c7":9,"q":6,"\\":25,"Q":4,"7":7,"\/":-8,"'":2}},"\u00dc":{"d":"80,4v-48,0,-65,-28,-65,-77r1,-176v4,-5,20,-2,30,-3r0,179v0,29,5,50,34,50v11,0,26,-3,32,-7r0,-219v4,-5,19,-2,29,-3r0,243v-13,7,-39,13,-61,13xm55,-284v-12,0,-18,-6,-18,-18v0,-9,7,-19,18,-18v12,0,18,6,18,18v0,11,-7,18,-18,18xm106,-284v-12,0,-18,-6,-18,-18v0,-9,7,-19,18,-18v12,0,18,6,18,18v0,11,-7,18,-18,18","w":157,"k":{"\"":5,"\u201d":5,"\u201c":5,"\u00f8":5,"\u00ab":4,"y":17,"w":15,"v":18,"u":4,"t":14,"s":2,"o":5,"f":8,"e":5,"d":5,"c":2,"b":2,"Y":28,"W":19,"V":24,"T":22,"O":6,"G":6,"C":9,"\ufb04":8,"\ufb03":8,"\ufb00":8,"\u2122":8,"\u2039":4,"\u2019":5,"\u2018":5,"\u2014":7,"\u2013":7,"\u0178":28,"\u0161":2,"\u0153":5,"\u0152":6,"\u00ff":17,"\u00fd":17,"\u00fc":4,"\u00fb":4,"\u00fa":4,"\u00f9":4,"\u00f6":5,"\u00f5":5,"\u00f4":5,"\u00f3":5,"\u00f2":5,"\u00eb":5,"\u00ea":5,"\u00e9":5,"\u00e8":5,"\u00e7":2,"\u00e6":2,"\u00dd":28,"\u00d8":6,"\u00d6":6,"\u00d5":6,"\u00d4":6,"\u00d3":6,"\u00d2":6,"\u00c7":9,"q":6,"\\":25,"Q":4,"7":7,"\/":-4,"'":5}},"\u00dd":{"d":"52,-102r-50,-148v7,-3,23,-2,33,-2r32,125r32,-123v9,-2,20,-2,31,-2r-49,148r0,102v-5,3,-19,2,-29,2r0,-102xm112,-314v-13,13,-34,28,-51,37v-7,-2,-8,-9,-11,-16v13,-16,32,-32,48,-43v8,3,12,13,14,22","w":131,"k":{"\"":-7,"\u2212":23,"\u201e":22,"\u201d":-7,"\u201c":-7,"\u00f8":25,"\u00c6":28,"z":18,"y":16,"x":16,"w":15,"v":14,"u":21,"t":12,"s":24,"p":26,"o":25,"n":23,"j":10,"i":5,"g":24,"f":10,"e":27,"d":28,"c":25,"a":22,"S":3,"O":8,"J":31,"G":10,"C":12,"A":28,";":19,":":19,".":22,"-":23,"\ufb04":10,"\ufb03":10,"\ufb00":10,"\u203a":16,"\u2039":21,"\u2026":22,"\u201a":22,"\u2019":-7,"\u2018":-7,"\u2014":23,"\u2013":23,"\u017e":18,"\u017d":28,"\u0161":24,"\u0160":3,"\u0153":25,"\u0152":8,"\u0131":5,"\u00ff":16,"\u00fd":16,"\u00fc":21,"\u00fb":21,"\u00fa":21,"\u00f9":21,"\u00f6":25,"\u00f5":25,"\u00f4":25,"\u00f3":25,"\u00f2":25,"\u00f1":23,"\u00ef":5,"\u00ee":5,"\u00ed":5,"\u00ec":5,"\u00eb":27,"\u00ea":27,"\u00e9":27,"\u00e8":27,"\u00e7":25,"\u00e6":22,"\u00e5":22,"\u00e4":22,"\u00e3":22,"\u00e2":22,"\u00e1":22,"\u00e0":22,"\u00dc":28,"\u00db":28,"\u00d8":8,"\u00d6":8,"\u00d5":8,"\u00d4":8,"\u00d3":8,"\u00d2":8,"\u00d1":28,"\u00cb":28,"\u00ca":28,"\u00c7":12,"\u00c5":28,"\u00c4":28,"\u00c3":28,"\u00c2":28,"\u00c1":28,"\u00c0":28,"r":23,"q":28,"m":23,"_":26,"Q":8,"@":5,"0":17,"\/":18,",":22,"'":-7,"\u00ab":21,"\u00bb":16}},"\u00df":{"d":"48,-16v4,21,-22,22,-34,15v9,-58,3,-132,3,-197v0,-37,23,-56,58,-56v40,0,70,15,72,52v3,34,-51,34,-35,68v21,24,47,41,52,84v6,54,-74,69,-97,37v0,-9,5,-15,8,-20v14,14,58,15,56,-16v-3,-44,-53,-52,-55,-95v-2,-32,36,-31,40,-58v-2,-15,-17,-25,-39,-24v-28,1,-31,16,-31,45","w":167,"k":{"]":3,")":3,"\/":-3}},"\u00e0":{"d":"85,-134v2,-35,-53,-19,-70,-13v-17,-33,23,-36,54,-37v74,-4,37,100,43,175v-34,22,-111,19,-102,-42v-4,-47,33,-70,75,-54r0,-29xm41,-52v-5,29,23,39,43,25r1,-58v-26,-8,-48,2,-44,33xm22,-242v2,-10,9,-31,21,-17v14,10,30,26,41,37v-2,7,-4,15,-12,16v-17,-8,-38,-24,-50,-36","w":127,"k":{"\"":30,"\u201d":30,"\u201c":30,"y":3,"x":3,"t":6,"f":3,"]":9,")":9,"\ufb04":3,"\ufb03":3,"\ufb00":3,"\u2019":30,"\u2018":30,"\u00ff":3,"\u00fd":3,"'":30}},"\u00e1":{"d":"85,-134v2,-35,-53,-19,-70,-13v-17,-33,23,-36,54,-37v74,-4,37,100,43,175v-34,22,-111,19,-102,-42v-4,-47,33,-70,75,-54r0,-29xm41,-52v-5,29,23,39,43,25r1,-58v-26,-8,-48,2,-44,33xm109,-242v-13,13,-34,28,-51,37v-7,-2,-8,-9,-11,-16v13,-16,32,-32,48,-43v8,3,12,13,14,22","w":127,"k":{"\"":30,"\u201d":30,"\u201c":30,"y":3,"x":3,"t":6,"f":3,"]":9,")":9,"\ufb04":3,"\ufb03":3,"\ufb00":3,"\u2019":30,"\u2018":30,"\u00ff":3,"\u00fd":3,"'":30}},"\u00e2":{"d":"85,-134v2,-35,-53,-19,-70,-13v-17,-33,23,-36,54,-37v74,-4,37,100,43,175v-34,22,-111,19,-102,-42v-4,-47,33,-70,75,-54r0,-29xm41,-52v-5,29,23,39,43,25r1,-58v-26,-8,-48,2,-44,33xm59,-258v23,-4,37,31,50,44v-1,6,-13,9,-21,9v-8,-9,-18,-18,-24,-28v-10,15,-28,38,-46,19","w":127,"k":{"\"":30,"\u201d":30,"\u201c":30,"y":3,"x":3,"t":6,"f":3,"]":9,")":9,"\ufb04":3,"\ufb03":3,"\ufb00":3,"\u2019":30,"\u2018":30,"\u00ff":3,"\u00fd":3,"'":30}},"\u00e3":{"d":"85,-134v2,-35,-53,-19,-70,-13v-17,-33,23,-36,54,-37v74,-4,37,100,43,175v-34,22,-111,19,-102,-42v-4,-47,33,-70,75,-54r0,-29xm41,-52v-5,29,23,39,43,25r1,-58v-26,-8,-48,2,-44,33xm66,-209v-10,-18,-31,-16,-41,-1v-9,-1,-11,-8,-14,-15v11,-24,47,-38,63,-12v20,12,35,-29,43,5v-8,13,-27,31,-51,23","w":127,"k":{"\"":30,"\u201d":30,"\u201c":30,"y":3,"x":3,"f":3,"]":9,")":9,"\ufb04":3,"\ufb03":3,"\ufb00":3,"\u2019":30,"\u2018":30,"\u00ff":3,"\u00fd":3,"'":30,"t":6}},"\u00e4":{"d":"85,-134v2,-35,-53,-19,-70,-13v-17,-33,23,-36,54,-37v74,-4,37,100,43,175v-34,22,-111,19,-102,-42v-4,-47,33,-70,75,-54r0,-29xm41,-52v-5,29,23,39,43,25r1,-58v-26,-8,-48,2,-44,33xm40,-212v-12,0,-18,-6,-18,-18v0,-9,7,-19,18,-18v12,0,18,6,18,18v0,11,-7,18,-18,18xm91,-212v-12,0,-18,-6,-18,-18v0,-9,7,-19,18,-18v12,0,18,6,18,18v0,11,-7,18,-18,18","w":127,"k":{"\"":30,"\u201d":30,"\u201c":30,"y":3,"x":3,"t":6,"f":3,"]":9,")":9,"\ufb04":3,"\ufb03":3,"\ufb00":3,"\u2019":30,"\u2018":30,"\u00ff":3,"\u00fd":3,"'":30}},"\u00e5":{"d":"85,-134v2,-35,-53,-19,-70,-13v-17,-33,23,-36,54,-37v74,-4,37,100,43,175v-34,22,-111,19,-102,-42v-4,-47,33,-70,75,-54r0,-29xm41,-52v-5,29,23,39,43,25r1,-58v-26,-8,-48,2,-44,33xm63,-202v-23,-1,-34,-10,-34,-35v0,-23,13,-36,36,-36v25,1,32,10,33,35v0,24,-11,36,-35,36xm65,-252v-10,0,-15,4,-15,15v0,10,4,15,13,15v10,-1,15,-4,15,-16v0,-10,-5,-14,-13,-14","w":127,"k":{"\"":30,"\u201d":30,"\u201c":30,"y":3,"x":3,"t":6,"f":3,"\ufb04":3,"\ufb03":3,"\ufb00":3,"\u2019":30,"\u2018":30,"\u00ff":3,"\u00fd":3,"'":30,")":9,"]":9}},"\u00e6":{"d":"85,-136v1,-33,-53,-21,-70,-12v-16,-34,23,-35,56,-36v19,0,31,6,35,21v25,-37,90,-26,90,37v0,15,-2,35,-4,47v-25,3,-54,3,-75,-2v1,31,0,57,30,56v18,0,32,-5,44,-11v2,6,2,19,3,26v-15,15,-67,19,-85,3v-13,6,-26,10,-47,10v-39,0,-52,-19,-52,-57v0,-47,33,-73,75,-56r0,-26xm41,-54v-6,31,25,41,44,27r0,-63v-27,-9,-47,5,-44,36xm166,-101v3,-28,3,-67,-29,-55v-14,10,-18,28,-20,52v14,3,33,6,49,3","w":209,"k":{"\"":22,"\u201d":22,"\u201c":22,"z":1,"y":3,"x":3,"t":1,"f":3,"]":7,")":7,"\ufb04":3,"\ufb03":3,"\ufb00":3,"\u2019":22,"\u2018":22,"\u017e":1,"\u00ff":3,"\u00fd":3,"\u00eb":4,"\u00ea":4,"\u00e9":4,"\u00e8":4,"\/":-2,"'":22,"w":1,"e":4}},"\u00e7":{"d":"76,-184v20,0,37,12,27,33v-6,-4,-17,-7,-26,-7v-33,2,-35,34,-35,72v0,34,1,62,32,64v11,0,22,-5,28,-9v9,21,-6,33,-29,34r-3,18v16,-1,24,7,24,23v0,26,-26,36,-49,26v1,-6,2,-11,4,-15v7,1,28,10,28,-9v0,-15,-14,-11,-26,-10r6,-33v-41,-4,-46,-41,-46,-89v1,-57,12,-97,65,-98","w":112,"k":{"\"":16,"\u2212":13,"\u201d":16,"\u201c":16,"\u00f8":4,"y":-1,"w":-1,"t":-2,"o":4,"e":6,"d":6,"c":5,"]":3,"-":13,")":3,"\u2039":10,"\u2019":16,"\u2018":16,"\u2014":13,"\u2013":13,"\u0153":4,"\u00ff":-1,"\u00fd":-1,"\u00f6":4,"\u00f5":4,"\u00f4":4,"\u00f3":4,"\u00f2":4,"\u00eb":6,"\u00ea":6,"\u00e9":6,"\u00e8":6,"\u00e7":5,"q":6,"\/":-6,"'":16,"\u00ab":10}},"\u00e8":{"d":"11,-81v1,-58,10,-99,64,-103v47,-3,52,58,42,105v-25,2,-48,6,-76,6v1,28,5,49,34,48v16,0,30,-5,41,-11v12,31,-19,41,-47,40v-47,-1,-59,-34,-58,-85xm92,-112v11,-49,-40,-62,-47,-15v-2,8,-3,18,-3,30v20,-2,51,6,50,-15xm30,-242v2,-10,9,-31,21,-17v14,10,30,26,41,37v-2,7,-4,15,-12,16v-17,-8,-38,-24,-50,-36","w":129,"k":{"\"":22,"\u201d":22,"\u201c":22,"e":4,"]":7,")":7,"\u2019":22,"\u2018":22,"\u00eb":4,"\u00ea":4,"\u00e9":4,"\u00e8":4,"\/":-4,"'":22,"t":1,"w":1,"x":3}},"\u00e9":{"d":"11,-81v1,-58,10,-99,64,-103v47,-3,52,58,42,105v-25,2,-48,6,-76,6v1,28,5,49,34,48v16,0,30,-5,41,-11v12,31,-19,41,-47,40v-47,-1,-59,-34,-58,-85xm92,-112v11,-49,-40,-62,-47,-15v-2,8,-3,18,-3,30v20,-2,51,6,50,-15xm117,-242v-13,13,-34,28,-51,37v-7,-2,-8,-9,-11,-16v13,-16,32,-32,48,-43v8,3,12,13,14,22","w":129,"k":{"\"":22,"\u201d":22,"\u201c":22,"x":3,"w":1,"t":1,"e":4,"]":7,")":7,"\u2019":22,"\u2018":22,"\u00eb":4,"\u00ea":4,"\u00e9":4,"\u00e8":4,"\/":-4,"'":22}},"\u00ea":{"d":"11,-81v1,-58,10,-99,64,-103v47,-3,52,58,42,105v-25,2,-48,6,-76,6v1,28,5,49,34,48v16,0,30,-5,41,-11v12,31,-19,41,-47,40v-47,-1,-59,-34,-58,-85xm92,-112v11,-49,-40,-62,-47,-15v-2,8,-3,18,-3,30v20,-2,51,6,50,-15xm67,-258v23,-4,37,31,50,44v-1,6,-13,9,-21,9v-8,-9,-18,-18,-24,-28v-10,15,-28,38,-46,19","w":129,"k":{"\"":22,"\u201d":22,"\u201c":22,"y":3,"x":3,"w":1,"t":1,"e":4,"]":7,")":7,"\u2019":22,"\u2018":22,"\u00ff":3,"\u00fd":3,"\u00eb":4,"\u00ea":4,"\u00e9":4,"\u00e8":4,"\/":-4,"'":22}},"\u00eb":{"d":"11,-81v1,-58,10,-99,64,-103v47,-3,52,58,42,105v-25,2,-48,6,-76,6v1,28,5,49,34,48v16,0,30,-5,41,-11v12,31,-19,41,-47,40v-47,-1,-59,-34,-58,-85xm92,-112v11,-49,-40,-62,-47,-15v-2,8,-3,18,-3,30v20,-2,51,6,50,-15xm47,-212v-12,0,-18,-6,-18,-18v0,-9,7,-19,18,-18v12,0,18,6,18,18v0,11,-7,18,-18,18xm98,-212v-12,0,-18,-6,-18,-18v0,-9,7,-19,18,-18v12,0,18,6,18,18v0,11,-7,18,-18,18","w":129,"k":{"\"":22,"\u201d":22,"\u201c":22,"y":3,"x":3,"w":1,"t":1,"e":4,"]":7,")":7,"\u2019":22,"\u2018":22,"\u00ff":3,"\u00fd":3,"\u00eb":4,"\u00ea":4,"\u00e9":4,"\u00e8":4,"\/":-4,"'":22}},"\u00ec":{"d":"17,-167v-2,-15,15,-13,29,-13r0,178v-8,2,-18,2,-29,2r0,-167xm-10,-242v2,-10,9,-31,21,-17v14,10,30,26,41,37v-2,7,-4,15,-12,16v-17,-8,-38,-24,-50,-36","w":63,"k":{"\"":5,"\u201d":5,"\u201c":5,"]":6,")":6,"\u2019":5,"\u2018":5,"\/":-8,"'":5}},"\u00ed":{"d":"17,-167v-2,-15,15,-13,29,-13r0,178v-8,2,-18,2,-29,2r0,-167xm77,-242v-13,13,-34,28,-51,37v-7,-2,-8,-9,-11,-16v13,-16,32,-32,48,-43v8,3,12,13,14,22","w":63,"k":{"\"":-13,"\u201d":-13,"\u201c":-13,"k":-2,"h":-2,"]":-5,")":-5,"\u2019":-13,"\u2018":-13,"\/":-8,"'":-13}},"\u00ee":{"d":"17,-167v-2,-15,15,-13,29,-13r0,178v-8,2,-18,2,-29,2r0,-167xm28,-258v23,-4,37,31,50,44v-1,6,-13,9,-21,9v-8,-9,-18,-18,-24,-28v-10,15,-28,38,-46,19","w":63,"k":{"\"":-15,"\u201d":-15,"\u201c":-15,"y":3,"x":3,"k":-5,"h":-5,"\u2019":-15,"\u2018":-15,"\u00ff":3,"\u00fd":3,"\/":-8,"'":-15}},"\u00ef":{"d":"17,-167v-2,-15,15,-13,29,-13r0,178v-8,2,-18,2,-29,2r0,-167xm8,-212v-12,0,-18,-6,-18,-18v0,-9,7,-19,18,-18v12,0,18,6,18,18v0,11,-7,18,-18,18xm59,-212v-12,0,-18,-6,-18,-18v0,-9,7,-19,18,-18v12,0,18,6,18,18v0,11,-7,18,-18,18","w":63,"k":{"\"":-21,"\u201d":-21,"\u201c":-21,"y":3,"x":3,"k":-7,"h":-7,"]":-5,")":-5,"\u2019":-21,"\u2018":-21,"\u00ff":3,"\u00fd":3,"\/":-8,"'":-21}},"\u00f1":{"d":"94,-127v6,-36,-27,-34,-49,-25r0,150v-8,2,-18,2,-29,2r0,-171v36,-17,108,-28,108,36r-1,133v-5,3,-19,2,-29,2r0,-127xm73,-209v-10,-18,-31,-16,-41,-1v-9,-1,-11,-8,-14,-15v11,-24,47,-38,63,-12v20,12,35,-29,43,5v-8,13,-27,31,-51,23","w":137,"k":{"\"":32,"\u201d":32,"\u201c":32,"y":3,"x":1,"]":10,")":10,"\u2019":32,"\u2018":32,"\u00ff":3,"\u00fd":3,"\/":-11,"'":32}},"\u00f2":{"d":"65,4v-51,0,-57,-39,-56,-94v0,-56,13,-94,59,-94v49,0,57,40,56,93v0,57,-13,95,-59,95xm67,-158v-28,4,-27,36,-27,69v0,33,-2,64,26,68v27,-5,27,-36,27,-70v0,-31,3,-65,-26,-67xm25,-242v2,-10,9,-31,21,-17v14,10,30,26,41,37v-2,7,-4,15,-12,16v-17,-8,-38,-24,-50,-36","w":132,"k":{"\"":30,"\u201e":7,"\u201d":30,"\u201c":30,"z":3,"y":7,"x":9,"w":4,"v":4,"t":5,"f":4,"a":2,"]":12,".":7,")":12,"\ufb04":4,"\ufb03":4,"\ufb00":4,"\u2026":7,"\u201a":7,"\u2019":30,"\u2018":30,"\u017e":3,"\u0161":2,"\u00ff":7,"\u00fd":7,"\u00fc":2,"\u00fb":2,"\u00f6":2,"\u00f5":2,"\u00f4":2,"\u00f1":2,"\u00ef":2,"\u00ee":2,"\u00eb":2,"\u00ea":2,"\u00e6":2,"\u00e5":2,"\u00e4":2,"\u00e3":2,"\u00e2":2,"\u00e1":2,"\u00e0":2,"k":5,"_":16,"\/":-6,",":7,"*":4,"'":30}},"\u00f3":{"d":"65,4v-51,0,-57,-39,-56,-94v0,-56,13,-94,59,-94v49,0,57,40,56,93v0,57,-13,95,-59,95xm67,-158v-28,4,-27,36,-27,69v0,33,-2,64,26,68v27,-5,27,-36,27,-70v0,-31,3,-65,-26,-67xm113,-242v-13,13,-34,28,-51,37v-7,-2,-8,-9,-11,-16v13,-16,32,-32,48,-43v8,3,12,13,14,22","w":132,"k":{"\"":30,"\u201e":7,"\u201d":30,"\u201c":30,"z":3,"y":7,"x":9,"w":4,"v":4,"t":5,"f":4,"a":2,"]":12,".":7,")":12,"\ufb04":4,"\ufb03":4,"\ufb00":4,"\u2026":7,"\u201a":7,"\u2019":30,"\u2018":30,"\u017e":3,"\u0161":2,"\u00ff":7,"\u00fd":7,"\u00fc":2,"\u00fb":2,"\u00f6":2,"\u00f5":2,"\u00f4":2,"\u00f1":2,"\u00ef":2,"\u00ee":2,"\u00eb":2,"\u00ea":2,"\u00e6":2,"\u00e5":2,"\u00e4":2,"\u00e3":2,"\u00e2":2,"\u00e1":2,"\u00e0":2,"k":5,"_":16,"\/":-6,",":7,"*":4,"'":30}},"\u00f4":{"d":"65,4v-51,0,-57,-39,-56,-94v0,-56,13,-94,59,-94v49,0,57,40,56,93v0,57,-13,95,-59,95xm67,-158v-28,4,-27,36,-27,69v0,33,-2,64,26,68v27,-5,27,-36,27,-70v0,-31,3,-65,-26,-67xm63,-258v23,-4,37,31,50,44v-1,6,-13,9,-21,9v-8,-9,-18,-18,-24,-28v-10,15,-28,38,-46,19","w":132,"k":{"\"":30,"\u201e":7,"\u201d":30,"\u201c":30,"z":3,"y":7,"x":9,"w":4,"v":4,"t":5,"f":4,"a":2,"]":12,".":7,")":12,"\ufb04":4,"\ufb03":4,"\ufb00":4,"\u2026":7,"\u201a":7,"\u2019":30,"\u2018":30,"\u017e":3,"\u0161":2,"\u00ff":7,"\u00fd":7,"\u00fc":2,"\u00fb":2,"\u00f6":2,"\u00f5":2,"\u00f4":2,"\u00f1":2,"\u00ef":2,"\u00ee":2,"\u00eb":2,"\u00ea":2,"\u00e6":2,"\u00e5":2,"\u00e4":2,"\u00e3":2,"\u00e2":2,"\u00e1":2,"\u00e0":2,"k":5,"_":16,"\/":-6,",":7,"*":4,"'":30}},"\u00f5":{"d":"65,4v-51,0,-57,-39,-56,-94v0,-56,13,-94,59,-94v49,0,57,40,56,93v0,57,-13,95,-59,95xm67,-158v-28,4,-27,36,-27,69v0,33,-2,64,26,68v27,-5,27,-36,27,-70v0,-31,3,-65,-26,-67xm70,-209v-10,-18,-31,-16,-41,-1v-9,-1,-11,-8,-14,-15v11,-24,47,-38,63,-12v20,12,35,-29,43,5v-8,13,-27,31,-51,23","w":132,"k":{"\"":30,"\u201e":7,"\u201d":30,"\u201c":30,"z":3,"y":7,"x":9,"w":4,"v":4,"t":5,"f":4,"a":2,"]":12,".":7,")":12,"\ufb04":4,"\ufb03":4,"\ufb00":4,"\u2026":7,"\u201a":7,"\u2019":30,"\u2018":30,"\u017e":3,"\u0161":2,"\u00ff":7,"\u00fd":7,"\u00fc":2,"\u00fb":2,"\u00f6":2,"\u00f5":2,"\u00f4":2,"\u00f1":2,"\u00ef":2,"\u00ee":2,"\u00eb":2,"\u00ea":2,"\u00e6":2,"\u00e5":2,"\u00e4":2,"\u00e3":2,"\u00e2":2,"\u00e1":2,"\u00e0":2,"k":5,"_":16,"\/":-6,",":7,"*":4,"'":30}},"\u00f6":{"d":"65,4v-51,0,-57,-39,-56,-94v0,-56,13,-94,59,-94v49,0,57,40,56,93v0,57,-13,95,-59,95xm67,-158v-28,4,-27,36,-27,69v0,33,-2,64,26,68v27,-5,27,-36,27,-70v0,-31,3,-65,-26,-67xm43,-212v-12,0,-18,-6,-18,-18v0,-9,7,-19,18,-18v12,0,18,6,18,18v0,11,-7,18,-18,18xm94,-212v-12,0,-18,-6,-18,-18v0,-9,7,-19,18,-18v12,0,18,6,18,18v0,11,-7,18,-18,18","w":132,"k":{"\"":30,"\u201e":7,"\u201d":30,"\u201c":30,"z":3,"y":7,"x":9,"w":4,"v":4,"t":5,"f":4,"a":2,"]":12,".":7,")":12,"\ufb04":4,"\ufb03":4,"\ufb00":4,"\u2026":7,"\u201a":7,"\u2019":30,"\u2018":30,"\u017e":3,"\u0161":2,"\u00ff":7,"\u00fd":7,"\u00fc":2,"\u00fb":2,"\u00f6":2,"\u00f5":2,"\u00f4":2,"\u00f1":2,"\u00ef":2,"\u00ee":2,"\u00eb":2,"\u00ea":2,"\u00e6":2,"\u00e5":2,"\u00e4":2,"\u00e3":2,"\u00e2":2,"\u00e1":2,"\u00e0":2,"k":5,"_":16,"\/":-6,",":7,"*":4,"'":30}},"\u00f7":{"d":"12,-89v2,-13,-2,-22,6,-25r120,0v-1,9,4,25,-6,25r-120,0xm75,-29v-12,0,-18,-6,-18,-18v1,-10,7,-19,18,-19v13,0,18,6,18,19v0,9,-7,19,-18,18xm75,-135v-12,0,-19,-6,-18,-19v0,-9,7,-19,18,-18v13,0,18,6,18,18v-1,10,-7,19,-18,19"},"\u00f8":{"d":"33,-10v-4,14,-19,27,-27,7r16,-30v-11,-60,-9,-154,55,-151v17,1,31,5,39,16r13,-20v7,2,14,5,16,12v-5,11,-10,24,-17,34v10,56,11,148,-53,146v-19,0,-33,-3,-42,-14xm75,-21v34,0,25,-58,25,-97r-46,82v4,11,8,15,21,15xm76,-158v-35,0,-26,55,-26,94r45,-81v-4,-8,-9,-13,-19,-13","w":148,"k":{"\"":30,"\u201d":30,"\u201c":30,"y":7,"x":9,"w":4,"t":5,"g":5,"f":4,"a":2,"]":12,")":12,"\ufb04":-5,"\ufb03":-5,"\ufb00":-5,"\u2026":7,"\u201a":7,"\u2019":30,"\u2018":30,"\u017e":3,"\u0161":2,"\u00fd":7,"\u00fc":2,"\u00fb":2,"\u00f6":2,"\u00f5":2,"\u00f4":2,"\u00f1":2,"\u00ef":2,"\u00ee":2,"\u00eb":2,"\u00ea":2,"\u00e6":2,"\u00e5":2,"\u00e4":2,"\u00e3":2,"\u00e2":2,"\u00e1":2,"\u00e0":2,"_":16,"\/":-6,",":7,"*":4,"'":30,"v":4,"\u00ff":7,".":7,"\u201e":7,"z":3}},"\u00f9":{"d":"46,-54v-6,34,27,38,48,26r1,-149v4,-5,18,-2,28,-3r0,171v-41,23,-107,20,-107,-47r0,-121v5,-5,20,-2,30,-3r0,126xm28,-242v2,-10,9,-31,21,-17v14,10,30,26,41,37v-2,7,-4,15,-12,16v-17,-8,-38,-24,-50,-36","w":140,"k":{"\"":23,"\u201d":23,"\u201c":23,"]":11,")":11,"\u2019":23,"\u2018":23,"\/":-6,"'":23}},"\u00fa":{"d":"46,-54v-6,34,27,38,48,26r1,-149v4,-5,18,-2,28,-3r0,171v-41,23,-107,20,-107,-47r0,-121v5,-5,20,-2,30,-3r0,126xm116,-242v-13,13,-34,28,-51,37v-7,-2,-8,-9,-11,-16v13,-16,32,-32,48,-43v8,3,12,13,14,22","w":140,"k":{"\"":23,"\u201d":23,"\u201c":23,"]":11,")":11,"\u2019":23,"\u2018":23,"\/":-6,"'":23}},"\u00fb":{"d":"46,-54v-6,34,27,38,48,26r1,-149v4,-5,18,-2,28,-3r0,171v-41,23,-107,20,-107,-47r0,-121v5,-5,20,-2,30,-3r0,126xm66,-258v23,-4,37,31,50,44v-1,6,-13,9,-21,9v-8,-9,-18,-18,-24,-28v-10,15,-28,38,-46,19","w":140,"k":{"\"":23,"\u201d":23,"\u201c":23,"y":3,"x":3,"]":11,")":11,"\u2019":23,"\u2018":23,"\u00ff":3,"\u00fd":3,"\/":-6,"'":23}},"\u00fc":{"d":"46,-54v-6,34,27,38,48,26r1,-149v4,-5,18,-2,28,-3r0,171v-41,23,-107,20,-107,-47r0,-121v5,-5,20,-2,30,-3r0,126xm46,-212v-12,0,-18,-6,-18,-18v0,-9,7,-19,18,-18v12,0,18,6,18,18v0,11,-7,18,-18,18xm97,-212v-12,0,-18,-6,-18,-18v0,-9,7,-19,18,-18v12,0,18,6,18,18v0,11,-7,18,-18,18","w":140,"k":{"\"":23,"\u201d":23,"\u201c":23,"y":3,"x":3,"]":11,")":11,"\u2019":23,"\u2018":23,"\u00ff":3,"\u00fd":3,"\/":-6,"'":23}},"\u00fd":{"d":"-1,55v-3,-32,31,5,42,-19v5,-6,8,-15,11,-30r-44,-183v4,-5,19,-2,29,-3r29,149v6,-49,15,-95,25,-140v-1,-13,19,-8,31,-9r-44,190v-10,30,-12,59,-50,59v-18,0,-28,-2,-29,-14xm111,-242v-13,13,-34,28,-51,37v-7,-2,-8,-9,-11,-16v13,-16,32,-32,48,-43v8,3,12,13,14,22","w":128,"k":{"\"":22,"\u2212":10,"\u201e":20,"\u201d":22,"\u201c":22,"z":3,"x":3,"u":5,"t":3,"s":4,"p":5,"o":7,"g":9,"e":8,"d":6,"c":9,"a":4,".":20,"-":10,"\u2039":5,"\u2026":20,"\u201a":20,"\u2019":22,"\u2018":22,"\u2014":10,"\u2013":10,"\u017e":3,"\u0161":4,"\u0153":7,"\u00ff":3,"\u00fc":5,"\u00fb":5,"\u00fa":5,"\u00f9":5,"\u00f8":7,"\u00f6":7,"\u00f5":7,"\u00f4":7,"\u00f3":7,"\u00f2":7,"\u00f1":3,"\u00ef":4,"\u00ee":4,"\u00eb":8,"\u00ea":8,"\u00e9":8,"\u00e8":8,"\u00e7":9,"\u00e6":4,"\u00e5":4,"\u00e4":4,"\u00e3":4,"\u00e2":4,"\u00e1":4,"\u00e0":4,"r":7,"q":6,"m":3,"k":5,"_":19,"\/":11,",":20,"'":22,")":13,"]":13,":":3,";":3}},"\u00ff":{"d":"-1,55v-3,-32,31,5,42,-19v5,-6,8,-15,11,-30r-44,-183v4,-5,19,-2,29,-3r29,149v6,-49,15,-95,25,-140v-1,-13,19,-8,31,-9r-44,190v-10,30,-12,59,-50,59v-18,0,-28,-2,-29,-14xm42,-212v-12,0,-18,-6,-18,-18v0,-9,7,-19,18,-18v12,0,18,6,18,18v0,11,-7,18,-18,18xm93,-212v-12,0,-18,-6,-18,-18v0,-9,7,-19,18,-18v12,0,18,6,18,18v0,11,-7,18,-18,18","w":128,"k":{"\"":22,"\u2212":10,"\u201e":20,"\u201d":22,"\u201c":22,"z":3,"y":3,"x":3,"u":5,"t":3,"s":4,"p":5,"o":7,"g":9,"e":8,"d":6,"c":9,"a":4,"]":13,".":20,"-":10,")":13,"\u2039":5,"\u2026":20,"\u201a":20,"\u2019":22,"\u2018":22,"\u2014":10,"\u2013":10,"\u017e":3,"\u0161":4,"\u0153":7,"\u00ff":3,"\u00fd":3,"\u00fc":5,"\u00fb":5,"\u00fa":5,"\u00f9":5,"\u00f8":7,"\u00f6":7,"\u00f5":7,"\u00f4":7,"\u00f3":7,"\u00f2":7,"\u00f1":3,"\u00ef":4,"\u00ee":4,"\u00eb":8,"\u00ea":8,"\u00e9":8,"\u00e8":8,"\u00e7":9,"\u00e6":4,"\u00e5":4,"\u00e4":4,"\u00e3":4,"\u00e2":4,"\u00e1":4,"\u00e0":4,"r":7,"q":6,"m":3,"k":5,"_":19,"\/":11,",":20,"'":22,":":3,";":3}},"\u0131":{"d":"17,-167v-2,-15,15,-13,29,-13r0,178v-8,2,-18,2,-29,2r0,-167","w":63,"k":{"\/":-8}},"\u0152":{"d":"197,-150v-1,10,2,25,-5,27r-49,0r0,97r61,0v-2,9,5,26,-5,26r-81,0r0,-14v-10,12,-24,17,-43,17v-65,-2,-65,-61,-65,-130v0,-68,5,-126,68,-128v19,0,31,4,40,15v1,-5,0,-12,6,-12r82,0v-2,8,4,25,-6,26r-57,0r0,76r54,0xm77,-228v-39,8,-35,61,-35,108v0,42,-3,89,34,94v39,-6,33,-57,33,-102v0,-45,6,-94,-32,-100","w":212,"k":{"\"":-4,"\u2212":10,"\u201e":12,"\u201d":-4,"\u201c":-4,"\u00f8":7,"z":1,"y":5,"x":3,"w":5,"u":3,"o":7,"g":4,"e":5,"d":6,"c":2,"a":4,"Y":8,"X":8,"W":5,"V":5,"T":8,"Q":1,"O":1,"J":12,"A":8,".":12,"-":10,"\u2026":12,"\u201a":12,"\u2019":-4,"\u2018":-4,"\u2014":10,"\u2013":10,"\u017e":1,"\u017d":8,"\u0178":8,"\u0161":4,"\u0160":8,"\u0153":7,"\u0152":1,"\u00ff":5,"\u00fd":5,"\u00fc":3,"\u00fb":3,"\u00fa":3,"\u00f9":3,"\u00f6":7,"\u00f5":7,"\u00f4":7,"\u00f3":7,"\u00f2":7,"\u00f1":4,"\u00ef":4,"\u00ee":4,"\u00eb":5,"\u00ea":5,"\u00e9":5,"\u00e8":5,"\u00e7":2,"\u00e6":4,"\u00e5":4,"\u00e4":4,"\u00e3":4,"\u00e2":4,"\u00e1":4,"\u00e0":4,"\u00dd":8,"\u00dc":8,"\u00db":8,"\u00d8":1,"\u00d6":6,"\u00d5":6,"\u00d4":6,"\u00d3":1,"\u00d2":1,"\u00d1":8,"\u00cb":8,"\u00ca":8,"\u00c6":19,"\u00c5":8,"\u00c4":8,"\u00c3":8,"\u00c2":8,"\u00c1":8,"\u00c0":8,"r":3,"q":6,"0":2,"\/":-3,",":12,"'":-4}},"\u0153":{"d":"67,4v-52,0,-58,-39,-57,-94v0,-56,13,-93,59,-93v22,0,34,5,43,20v26,-36,93,-27,93,37v0,15,-2,35,-4,47v-25,2,-48,6,-75,6v2,27,2,48,31,48v18,0,31,-5,44,-11r2,26v-20,18,-83,22,-95,-6v-9,13,-23,20,-41,20xm68,-158v-28,0,-27,36,-27,69v0,33,-2,64,26,68v28,-4,27,-37,27,-70v0,-31,4,-67,-26,-67xm176,-112v15,-46,-40,-64,-46,-15v-1,8,-4,18,-4,30v20,-2,52,7,50,-15","w":215,"k":{"\"":22,"\u201e":7,"\u201d":22,"\u201c":22,"z":5,"y":7,"x":3,"f":4,"a":2,"]":7,".":7,")":7,"\ufb04":4,"\ufb03":4,"\ufb00":4,"\u2026":7,"\u201a":7,"\u2019":22,"\u2018":22,"\u017e":5,"\u0161":2,"\u00ff":7,"\u00fd":7,"\u00fc":2,"\u00fb":2,"\u00f6":2,"\u00f5":2,"\u00f4":2,"\u00f1":2,"\u00ef":2,"\u00ee":2,"\u00eb":4,"\u00ea":4,"\u00e9":4,"\u00e8":4,"\u00e6":2,"\u00e5":2,"\u00e4":2,"\u00e3":2,"\u00e2":2,"\u00e1":2,"\u00e0":2,"k":3,"\/":-2,",":7,"'":22,"t":1,"w":1,"e":4}},"\u0160":{"d":"32,-152v-40,-36,-25,-104,39,-104v32,0,60,12,40,35v-17,-13,-74,-15,-70,16v8,62,80,69,80,141v0,42,-21,66,-65,68v-34,1,-60,-17,-39,-43v20,20,77,19,72,-24v-5,-42,-38,-61,-57,-89xm101,-334v29,18,-15,44,-28,58v-17,-7,-33,-28,-45,-40v2,-8,11,-25,21,-14r25,27v7,-13,17,-21,27,-31","w":128,"k":{"\"":-6,"\u2212":-4,"\u201d":-6,"\u201c":-6,"\u00f8":5,"\u00ab":4,"y":12,"x":9,"w":12,"v":10,"u":4,"t":14,"s":2,"o":5,"f":11,"e":5,"d":5,"c":2,"b":2,"Y":28,"W":19,"V":24,"T":22,"O":6,"J":4,"G":6,"C":9,"-":-4,"\ufb04":11,"\ufb03":11,"\ufb00":11,"\u2122":8,"\u2039":4,"\u2019":-6,"\u2018":-6,"\u2014":-4,"\u2013":-4,"\u0178":28,"\u0161":2,"\u0153":5,"\u0152":6,"\u00ff":12,"\u00fd":12,"\u00fc":4,"\u00fb":4,"\u00fa":4,"\u00f9":4,"\u00f6":5,"\u00f5":5,"\u00f4":5,"\u00f3":5,"\u00f2":5,"\u00eb":5,"\u00ea":5,"\u00e9":5,"\u00e8":5,"\u00e7":2,"\u00e6":2,"\u00dd":28,"\u00d8":6,"\u00d6":6,"\u00d5":6,"\u00d4":6,"\u00d3":6,"\u00d2":6,"\u00c7":9,"\u00c6":16,"q":6,"_":7,"\\":25,"Q":4,"7":7,"\/":-4,"'":-6}},"\u0161":{"d":"32,-103v-38,-30,-18,-81,38,-81v27,0,57,11,39,35v-19,-14,-78,-13,-61,18v16,30,66,38,66,85v1,33,-25,50,-59,50v-28,0,-55,-10,-39,-36v23,17,80,11,62,-27v-10,-18,-30,-32,-46,-44xm99,-262v29,18,-15,44,-28,58v-17,-7,-33,-28,-45,-40v2,-8,11,-25,21,-14r25,27v7,-13,17,-21,27,-31","w":124,"k":{"\"":20,"\u2212":12,"\u201d":20,"\u201c":20,"y":1,"x":3,"-":12,"\u2019":20,"\u2018":20,"\u2014":12,"\u2013":12,"\u00ff":1,"\u00fd":1,"\/":-3,"'":20,")":3,"]":3}},"\u0178":{"d":"52,-102r-50,-148v7,-3,23,-2,33,-2r32,125r32,-123v9,-2,20,-2,31,-2r-49,148r0,102v-5,3,-19,2,-29,2r0,-102xm42,-284v-12,0,-18,-6,-18,-18v0,-9,7,-19,18,-18v12,0,18,6,18,18v0,11,-7,18,-18,18xm93,-284v-12,0,-18,-6,-18,-18v0,-9,7,-19,18,-18v12,0,18,6,18,18v0,11,-7,18,-18,18","w":131,"k":{"\"":-7,"\u2212":23,"\u201e":22,"\u201d":-7,"\u201c":-7,"\u00f8":25,"\u00c6":28,"z":18,"y":16,"x":16,"w":15,"v":14,"u":21,"t":12,"s":24,"p":26,"o":25,"n":23,"j":10,"i":5,"g":24,"f":10,"e":27,"d":28,"c":25,"a":22,"S":3,"O":8,"J":31,"G":10,"C":12,"A":28,";":19,":":19,".":22,"-":23,"\ufb04":10,"\ufb03":10,"\ufb00":10,"\u203a":16,"\u2039":21,"\u2026":22,"\u201a":22,"\u2019":-7,"\u2018":-7,"\u2014":23,"\u2013":23,"\u017e":18,"\u017d":28,"\u0161":24,"\u0160":3,"\u0153":25,"\u0152":8,"\u0131":5,"\u00ff":16,"\u00fd":16,"\u00fc":21,"\u00fb":21,"\u00fa":21,"\u00f9":21,"\u00f6":25,"\u00f5":25,"\u00f4":25,"\u00f3":25,"\u00f2":25,"\u00f1":23,"\u00ef":5,"\u00ee":5,"\u00ed":5,"\u00ec":5,"\u00eb":27,"\u00ea":27,"\u00e9":27,"\u00e8":27,"\u00e7":25,"\u00e6":22,"\u00e5":22,"\u00e4":22,"\u00e3":22,"\u00e2":22,"\u00e1":22,"\u00e0":22,"\u00dc":28,"\u00db":28,"\u00d8":8,"\u00d6":8,"\u00d5":8,"\u00d4":8,"\u00d3":8,"\u00d2":8,"\u00d1":28,"\u00cb":28,"\u00ca":28,"\u00c7":12,"\u00c5":28,"\u00c4":28,"\u00c3":28,"\u00c2":28,"\u00c1":28,"\u00c0":28,"r":23,"q":28,"m":23,"_":26,"Q":8,"@":5,"0":17,"\/":18,",":22,"'":-7,"\u00ab":21,"\u00bb":16}},"\u017d":{"d":"10,0v-5,-6,-7,-15,-2,-24r91,-202r-83,1v1,-10,-5,-27,6,-27r108,0v4,5,2,17,0,23r-92,203v30,-2,65,2,91,-3v-2,11,5,29,-7,29r-112,0xm105,-334v29,18,-15,44,-28,58v-17,-7,-33,-28,-45,-40v2,-8,11,-25,21,-14r25,27v7,-13,17,-21,27,-31","w":138,"k":{"\"":-5,"\u2212":36,"\u201d":-5,"\u201c":-5,"\u00f8":7,"\u00ab":3,"y":13,"x":7,"w":11,"v":18,"u":10,"t":6,"s":2,"p":5,"o":7,"g":5,"f":10,"e":10,"d":9,"c":7,"b":2,"a":6,"Y":28,"W":19,"V":24,"T":22,"O":6,"G":6,"C":9,"-":36,"\ufb04":10,"\ufb03":10,"\ufb00":10,"\u2122":8,"\u2039":3,"\u2019":-5,"\u2018":-5,"\u2014":36,"\u2013":36,"\u017e":6,"\u0178":28,"\u0161":6,"\u0153":7,"\u0152":6,"\u00ff":13,"\u00fd":13,"\u00fc":10,"\u00fb":10,"\u00fa":10,"\u00f9":10,"\u00f6":7,"\u00f5":7,"\u00f4":7,"\u00f3":7,"\u00f2":7,"\u00f1":6,"\u00ef":6,"\u00ee":6,"\u00eb":10,"\u00ea":10,"\u00e9":10,"\u00e8":10,"\u00e7":7,"\u00e6":6,"\u00e5":6,"\u00e4":6,"\u00e3":6,"\u00e2":6,"\u00e1":6,"\u00e0":6,"\u00dd":28,"\u00d8":6,"\u00d6":6,"\u00d5":6,"\u00d4":6,"\u00d3":6,"\u00d2":6,"\u00c7":9,"r":10,"q":9,"\\":25,"Q":4,"7":7,"0":4,"\/":-10,"'":-5,")":5,"]":5}},"\u017e":{"d":"12,0v-5,-5,-7,-18,-2,-26r70,-129v-23,1,-50,-2,-70,2v-1,-10,-3,-27,8,-27v30,2,67,-4,93,2v3,7,1,14,-2,21r-67,130v24,0,53,2,69,-4v0,13,5,31,-11,31r-88,0xm92,-262v29,18,-15,44,-28,58v-17,-7,-33,-28,-45,-40v2,-8,11,-25,21,-14r25,27v7,-13,17,-21,27,-31","w":120,"k":{"\"":17,"\u2212":13,"\u201d":17,"\u201c":17,"y":3,"x":5,"w":3,"u":5,"t":3,"p":3,"o":4,"g":4,"e":6,"d":6,"c":5,"a":4,"]":9,"-":13,")":9,"\u2039":4,"\u2019":17,"\u2018":17,"\u2014":13,"\u2013":13,"\u017e":4,"\u0161":4,"\u0153":4,"\u00ff":3,"\u00fd":3,"\u00fc":5,"\u00fb":5,"\u00fa":5,"\u00f9":5,"\u00f8":4,"\u00f6":4,"\u00f5":4,"\u00f4":4,"\u00f3":4,"\u00f2":4,"\u00f1":4,"\u00ef":4,"\u00ee":4,"\u00eb":6,"\u00ea":6,"\u00e9":6,"\u00e8":6,"\u00e7":5,"\u00e6":4,"\u00e5":4,"\u00e4":4,"\u00e3":4,"\u00e2":4,"\u00e1":4,"\u00e0":4,"q":6,"m":5,"k":7,"'":17}},"\u017f":{"d":"46,-11v2,18,-22,16,-32,10v7,-64,3,-141,3,-211v0,-40,24,-52,62,-54v27,-1,56,16,34,37v-23,-18,-67,-18,-67,28r0,190","w":62,"k":{"!":-31,"\ufb04":14,"\ufb03":14,"\ufb00":14,"\u2122":-34,"\u2039":8,"\u2030":-16,"\u2026":17,"\u201a":17,"\u2019":-44,"\u2018":-44,"\u2014":17,"\u2013":17,"\u0153":6,"\u00fc":3,"\u00fb":3,"\u00fa":3,"\u00f9":3,"\u00f8":6,"\u00f6":6,"\u00f5":6,"\u00f4":6,"\u00f3":6,"\u00f2":6,"\u00eb":7,"\u00ea":7,"\u00e9":7,"\u00e8":7,"\u00e7":5,"\u00ae":-23,"\u00a9":-22,"r":3,"q":8,"m":1,"_":18,"]":-40,"\\":-36,"?":-40,"8":-7,",":17,"*":-12,"'":-44,"&":-13,"d":8,"u":3,"c":5,"e":7,"o":6,"\"":-44,"-":17,"\u2212":17,"\u201c":-44,"\u201d":-44,"\u00ab":8,"b":-1,")":-40,".":17,"\u201e":17,"g":7,"p":12,"h":-1,"k":-1}},"\u02c6":{"d":"41,-258v23,-4,37,31,50,44v-1,6,-13,9,-21,9v-8,-9,-18,-18,-24,-28v-10,15,-28,38,-46,19","w":90},"\u02c7":{"d":"73,-262v29,18,-15,44,-28,58v-17,-7,-33,-28,-45,-40v2,-8,11,-25,21,-14r25,27v7,-13,17,-21,27,-31","w":84},"\u02d9":{"d":"15,-215v-11,-1,-15,-8,-15,-22v0,-12,5,-22,17,-22v13,1,13,7,14,21v0,13,-4,23,-16,23","w":31},"\u02da":{"d":"34,-202v-23,-1,-34,-10,-34,-35v0,-23,13,-36,36,-36v25,1,32,10,33,35v0,24,-11,36,-35,36xm36,-252v-10,0,-15,4,-15,15v0,10,4,15,13,15v10,-1,15,-4,15,-16v0,-10,-5,-14,-13,-14","w":69},"\u02dc":{"d":"55,-209v-10,-18,-31,-16,-41,-1v-9,-1,-11,-8,-14,-15v11,-24,47,-38,63,-12v20,12,35,-29,43,5v-8,13,-27,31,-51,23","w":105},"\u2013":{"d":"13,-89v2,-13,-2,-22,6,-25r120,0v-1,9,4,25,-6,25r-120,0","w":152,"k":{"\u203a":11,"\u00bb":11,"z":22,"y":12,"x":27,"w":7,"v":9,"t":10,"f":11,"]":11,"Z":17,"Y":23,"X":23,"W":10,"V":13,"T":38,"S":33,"J":44,"A":12,")":11,"\ufb04":11,"\ufb03":11,"\ufb00":11,"\u017e":22,"\u017d":17,"\u0178":23,"\u0160":33,"\u00ff":12,"\u00fd":12,"\u00dd":23,"\u00dc":9,"\u00db":9,"\u00d6":9,"\u00d5":9,"\u00d4":9,"\u00d1":9,"\u00cb":9,"\u00ca":9,"\u00c6":12,"\u00c5":12,"\u00c4":12,"\u00c3":12,"\u00c2":12,"\u00c1":12,"\u00c0":12,"\\":30}},"\u2014":{"d":"2,-89v2,-13,-2,-22,6,-25r242,0v-2,13,3,23,-6,25r-242,0","w":252,"k":{"\u203a":11,"\u00bb":11,"z":22,"y":12,"x":27,"w":7,"v":9,"t":10,"f":11,"]":11,"Z":17,"Y":23,"X":23,"W":10,"V":13,"T":38,"S":33,"J":44,"A":12,")":11,"\ufb04":11,"\ufb03":11,"\ufb00":11,"\u017e":22,"\u017d":17,"\u0178":23,"\u0160":33,"\u00ff":12,"\u00fd":12,"\u00dd":23,"\u00dc":9,"\u00db":9,"\u00d6":9,"\u00d5":9,"\u00d4":9,"\u00d1":9,"\u00cb":9,"\u00ca":9,"\u00c6":12,"\u00c5":12,"\u00c4":12,"\u00c3":12,"\u00c2":12,"\u00c1":12,"\u00c0":12,"\\":30}},"\u2018":{"d":"39,-286v23,4,-1,26,3,43v14,8,9,39,-10,36v-40,-4,-12,-71,7,-79","w":63,"k":{"z":25,"y":26,"x":23,"w":25,"v":25,"u":26,"t":6,"s":33,"p":36,"o":33,"n":35,"g":39,"f":16,"e":37,"d":40,"c":34,"a":26,"]":-7,"[":28,"Y":-7,"W":-6,"V":-6,"T":-5,"O":7,"J":48,"G":13,"C":20,"A":43,")":-7,"(":28,"\ufb04":16,"\ufb03":16,"\ufb00":16,"\u20ac":44,"\u017e":25,"\u0178":-7,"\u0161":33,"\u0160":4,"\u0153":33,"\u0152":7,"\u00ff":26,"\u00fd":26,"\u00fc":26,"\u00fb":26,"\u00fa":26,"\u00f9":26,"\u00f8":33,"\u00f6":33,"\u00f5":33,"\u00f4":33,"\u00f3":33,"\u00f2":33,"\u00f1":35,"\u00ef":-19,"\u00ee":-15,"\u00ec":-19,"\u00eb":37,"\u00ea":37,"\u00e9":37,"\u00e8":37,"\u00e7":34,"\u00e6":26,"\u00e5":26,"\u00e4":26,"\u00e3":26,"\u00e2":26,"\u00e1":26,"\u00e0":26,"\u00dd":-7,"\u00dc":4,"\u00db":4,"\u00d8":7,"\u00d6":7,"\u00d5":7,"\u00d4":7,"\u00d3":7,"\u00d2":7,"\u00d1":3,"\u00cf":-7,"\u00ce":-15,"\u00cb":6,"\u00ca":2,"\u00c7":20,"\u00c6":43,"\u00c5":43,"\u00c4":43,"\u00c3":43,"\u00c2":43,"\u00c1":43,"\u00c0":43,"\u00bf":37,"\u00a2":20,"r":35,"q":40,"m":35,"\\":-13,"Q":7,"@":27,"?":-7,"9":17,"6":11,"4":36,"3":1,"2":7,"1":14,"0":15,"\/":44,"+":8}},"\u2019":{"d":"24,-206v-23,-3,1,-26,-3,-43v-14,-8,-9,-38,10,-36v40,4,12,71,-7,79","w":63,"k":{"z":25,"y":26,"x":23,"w":25,"v":25,"u":26,"t":6,"s":33,"p":36,"o":33,"n":35,"g":39,"f":16,"e":37,"d":40,"c":34,"a":26,"]":-7,"[":28,"Y":-7,"W":-6,"V":-6,"T":-5,"O":7,"J":48,"G":13,"C":20,"A":43,")":-7,"(":28,"\ufb04":16,"\ufb03":16,"\ufb00":16,"\u20ac":44,"\u017e":25,"\u0178":-7,"\u0161":33,"\u0160":4,"\u0153":33,"\u0152":7,"\u00ff":26,"\u00fd":26,"\u00fc":26,"\u00fb":26,"\u00fa":26,"\u00f9":26,"\u00f8":33,"\u00f6":33,"\u00f5":33,"\u00f4":33,"\u00f3":33,"\u00f2":33,"\u00f1":35,"\u00ef":-19,"\u00ee":-15,"\u00ec":-19,"\u00eb":37,"\u00ea":37,"\u00e9":37,"\u00e8":37,"\u00e7":34,"\u00e6":26,"\u00e5":26,"\u00e4":26,"\u00e3":26,"\u00e2":26,"\u00e1":26,"\u00e0":26,"\u00dd":-7,"\u00dc":4,"\u00db":4,"\u00d8":7,"\u00d6":7,"\u00d5":7,"\u00d4":7,"\u00d3":7,"\u00d2":7,"\u00d1":3,"\u00cf":-7,"\u00ce":-15,"\u00cb":6,"\u00ca":2,"\u00c7":20,"\u00c6":43,"\u00c5":43,"\u00c4":43,"\u00c3":43,"\u00c2":43,"\u00c1":43,"\u00c0":43,"\u00bf":37,"\u00a2":20,"r":35,"q":40,"m":35,"\\":-13,"Q":7,"@":27,"?":-7,"9":17,"6":11,"4":36,"3":1,"2":7,"1":14,"0":15,"\/":44,"+":8}},"\u201a":{"d":"24,41v-23,-4,1,-26,-3,-43v-15,-8,-8,-39,10,-36v40,4,12,71,-7,79","w":61,"k":{"\u00f8":7,"y":17,"w":12,"v":16,"u":9,"t":17,"o":7,"j":-29,"f":14,"e":7,"d":7,"c":3,"Y":22,"W":11,"V":17,"U":3,"T":32,"O":10,"G":5,"C":11,"\ufb04":14,"\ufb03":14,"\ufb00":14,"\u0178":22,"\u0153":7,"\u0152":10,"\u00ff":17,"\u00fd":17,"\u00fc":9,"\u00fb":9,"\u00fa":9,"\u00f9":9,"\u00f6":7,"\u00f5":7,"\u00f4":7,"\u00f3":7,"\u00f2":7,"\u00eb":7,"\u00ea":7,"\u00e9":7,"\u00e8":7,"\u00e7":3,"\u00dd":22,"\u00dc":3,"\u00db":3,"\u00da":3,"\u00d9":3,"\u00d8":10,"\u00d6":10,"\u00d5":10,"\u00d4":10,"\u00d3":10,"\u00d2":10,"\u00c7":11,"q":7,"\\":46,"Q":10}},"\u201c":{"d":"39,-286v23,4,-1,26,3,43v14,8,9,39,-10,36v-40,-4,-12,-71,7,-79xm93,-286v23,4,-1,26,3,43v15,8,8,39,-10,36v-40,-4,-12,-71,7,-79","w":117,"k":{"\ufb04":16,"\ufb03":16,"\ufb00":16,"\u20ac":44,"\u017e":25,"\u0178":-7,"\u0161":33,"\u0160":4,"\u0153":33,"\u0152":7,"\u00ff":26,"\u00fd":26,"\u00fc":26,"\u00fb":26,"\u00fa":26,"\u00f9":26,"\u00f8":33,"\u00f6":33,"\u00f5":33,"\u00f4":33,"\u00f3":33,"\u00f2":33,"\u00f1":35,"\u00ef":-19,"\u00ee":-15,"\u00ec":-19,"\u00eb":37,"\u00ea":37,"\u00e9":37,"\u00e8":37,"\u00e7":34,"\u00e6":26,"\u00e5":26,"\u00e4":26,"\u00e3":26,"\u00e2":26,"\u00e1":26,"\u00e0":26,"\u00dd":-7,"\u00dc":4,"\u00db":4,"\u00d8":7,"\u00d6":7,"\u00d5":7,"\u00d4":7,"\u00d3":7,"\u00d2":7,"\u00d1":3,"\u00cf":-7,"\u00ce":-15,"\u00cb":6,"\u00ca":2,"\u00c7":20,"\u00c6":43,"\u00c5":43,"\u00c4":43,"\u00c3":43,"\u00c2":43,"\u00c1":43,"\u00c0":43,"\u00bf":37,"\u00a2":20,"r":35,"q":40,"m":35,"\\":-13,"Q":7,"@":27,"?":-7,"9":17,"6":11,"4":36,"3":1,"2":7,"1":14,"0":15,"\/":44,"+":8,"C":20,"G":13,"T":-5,"V":-6,"W":-6,"Y":-7,"d":40,"f":16,"t":6,"u":26,"v":25,"w":25,"y":26,"c":34,"e":37,"o":33,"O":7,")":-7,"]":-7,"A":43,"J":48,"x":23,"a":26,"z":25,"g":39,"n":35,"p":36,"s":33,"(":28,"[":28}},"\u201d":{"d":"78,-206v-22,-3,1,-27,-3,-43v-14,-8,-9,-38,10,-36v40,4,12,71,-7,79xm24,-206v-23,-3,1,-26,-3,-43v-14,-8,-9,-38,10,-36v40,4,12,71,-7,79","w":117,"k":{"\ufb04":16,"\ufb03":16,"\ufb00":16,"\u20ac":44,"\u017e":25,"\u0178":-7,"\u0161":33,"\u0160":4,"\u0153":33,"\u0152":7,"\u00ff":26,"\u00fd":26,"\u00fc":26,"\u00fb":26,"\u00fa":26,"\u00f9":26,"\u00f8":33,"\u00f6":33,"\u00f5":33,"\u00f4":33,"\u00f3":33,"\u00f2":33,"\u00f1":35,"\u00ef":-19,"\u00ee":-15,"\u00ec":-19,"\u00eb":37,"\u00ea":37,"\u00e9":37,"\u00e8":37,"\u00e7":34,"\u00e6":26,"\u00e5":26,"\u00e4":26,"\u00e3":26,"\u00e2":26,"\u00e1":26,"\u00e0":26,"\u00dd":-7,"\u00dc":4,"\u00db":4,"\u00d8":7,"\u00d6":7,"\u00d5":7,"\u00d4":7,"\u00d3":7,"\u00d2":7,"\u00d1":3,"\u00cf":-7,"\u00ce":-15,"\u00cb":6,"\u00ca":2,"\u00c7":20,"\u00c6":43,"\u00c5":43,"\u00c4":43,"\u00c3":43,"\u00c2":43,"\u00c1":43,"\u00c0":43,"\u00bf":37,"\u00a2":20,"r":35,"q":40,"m":35,"\\":-13,"Q":7,"@":27,"?":-7,"9":17,"6":11,"4":36,"3":1,"2":7,"1":14,"0":15,"\/":44,"+":8,"C":20,"G":13,"T":-5,"V":-6,"W":-6,"Y":-7,"d":40,"f":16,"t":6,"u":26,"v":25,"w":25,"y":26,"c":34,"e":37,"o":33,"O":7,")":-7,"]":-7,"A":43,"J":48,"x":23,"a":26,"z":25,"g":39,"n":35,"p":36,"s":33,"(":28,"[":28}},"\u201e":{"d":"78,41v-22,-4,1,-27,-3,-43v-14,-8,-9,-39,10,-36v40,4,12,71,-7,79xm24,41v-23,-4,1,-26,-3,-43v-15,-8,-8,-39,10,-36v40,4,12,71,-7,79","w":115,"k":{"\ufb04":14,"\ufb03":14,"\ufb00":14,"\u0178":22,"\u0153":7,"\u0152":10,"\u00ff":17,"\u00fd":17,"\u00fc":9,"\u00fb":9,"\u00fa":9,"\u00f9":9,"\u00f6":7,"\u00f5":7,"\u00f4":7,"\u00f3":7,"\u00f2":7,"\u00eb":7,"\u00ea":7,"\u00e9":7,"\u00e8":7,"\u00e7":3,"\u00dd":22,"\u00dc":3,"\u00db":3,"\u00da":3,"\u00d9":3,"\u00d8":10,"\u00d6":10,"\u00d5":10,"\u00d4":10,"\u00d3":10,"\u00d2":10,"\u00c7":11,"q":7,"\\":46,"Q":10,"C":11,"G":5,"T":32,"V":17,"W":11,"Y":22,"d":7,"f":14,"t":17,"u":9,"v":16,"w":12,"y":17,"c":3,"e":7,"o":7,"\u00f8":7,"O":10,"j":-29,"U":3}},"\u2022":{"d":"41,-75v-19,1,-25,-10,-26,-27v-1,-14,10,-28,26,-28v19,0,27,11,27,28v1,16,-12,27,-27,27","w":80},"\u2026":{"d":"33,2v-15,1,-20,-8,-20,-20v0,-11,8,-21,20,-21v14,0,21,8,21,21v0,11,-10,20,-21,20xm93,2v-15,1,-20,-8,-20,-20v0,-11,8,-21,20,-21v14,0,21,8,21,21v0,11,-10,20,-21,20xm155,2v-15,1,-20,-8,-20,-20v0,-11,8,-21,20,-21v14,0,21,8,21,21v0,11,-10,20,-21,20","w":187,"k":{"\u00f8":7,"y":17,"w":12,"v":16,"u":9,"t":17,"o":7,"f":14,"e":7,"d":7,"c":3,"Y":22,"W":11,"V":17,"U":3,"T":32,"O":10,"G":5,"C":11,"\ufb04":14,"\ufb03":14,"\ufb00":14,"\u0178":22,"\u0153":7,"\u0152":10,"\u00ff":17,"\u00fd":17,"\u00fc":9,"\u00fb":9,"\u00fa":9,"\u00f9":9,"\u00f6":7,"\u00f5":7,"\u00f4":7,"\u00f3":7,"\u00f2":7,"\u00eb":7,"\u00ea":7,"\u00e9":7,"\u00e8":7,"\u00e7":3,"\u00dd":22,"\u00dc":3,"\u00db":3,"\u00da":3,"\u00d9":3,"\u00d8":10,"\u00d6":10,"\u00d5":10,"\u00d4":10,"\u00d3":10,"\u00d2":10,"\u00c7":11,"q":7,"\\":46,"Q":10,"\/":-3}},"\u2030":{"d":"183,-255v31,8,7,31,-6,53r-121,205v-6,-4,-17,-2,-18,-11xm65,-122v-40,1,-49,-25,-49,-67v0,-41,15,-65,51,-66v39,-1,48,25,48,65v1,41,-14,67,-50,68xm67,-233v-22,0,-22,22,-23,44v-1,24,0,44,22,44v30,0,33,-88,1,-88xm180,3v-41,2,-49,-25,-49,-66v0,-42,14,-65,51,-66v39,-1,48,25,48,65v0,41,-13,66,-50,67xm182,-107v-22,1,-23,22,-23,44v0,22,0,44,22,44v18,-4,22,-22,22,-45v0,-22,0,-43,-21,-43xm287,3v-41,1,-48,-26,-48,-66v-1,-42,13,-65,50,-66v39,-1,48,25,48,65v0,42,-13,66,-50,67xm289,-107v-32,0,-33,87,-1,88v18,-3,22,-18,22,-45v0,-23,0,-43,-21,-43","w":353,"k":{"\"":27,"\u201d":27,"\u201c":27,"\u2019":27,"\u2018":27,"'":27}},"\u2039":{"d":"76,-165v-8,31,-26,49,-42,75v14,25,32,46,43,73v-2,8,-8,16,-17,17v-18,-30,-39,-57,-54,-90v14,-33,34,-62,53,-90v10,1,14,8,17,15","w":88,"k":{"\u0178":14,"\u00dd":14,"Y":14,"V":9,"T":23,"W":10}},"\u203a":{"d":"55,-90v-17,-26,-33,-43,-42,-75v0,-10,10,-11,17,-15v17,31,38,57,52,90v-11,37,-35,60,-53,90v-32,-6,-6,-45,4,-58v10,-13,10,-15,22,-32","w":88,"k":{"\u017e":9,"\u0178":20,"\u00ff":1,"\u00fd":1,"\u00dd":20,"\u00c6":3,"z":9,"y":1,"x":5,"w":1,"t":8,"f":12,"]":5,"Y":20,"X":10,"W":11,"V":11,"T":23,"J":15,"A":3,")":5,"\u2014":-4,"\u2013":-4,"\u017d":3,"\u0160":3,"\u00dc":3,"\u00db":3,"\u00d6":3,"\u00d5":3,"\u00d4":3,"\u00d1":3,"\u00cb":3,"\u00ca":3,"\u00c5":3,"\u00c4":3,"\u00c3":3,"\u00c2":3,"\u00c1":3,"\u00c0":3,"v":3,"-":-4,"\u2212":-4,"Z":3}},"\u2044":{"d":"-9,-2v-5,12,-25,2,-30,-5r124,-247v10,-5,22,2,27,9","w":70},"\u20ac":{"d":"40,-147v7,-41,23,-69,67,-71v26,-1,43,12,31,34v-30,-20,-64,4,-66,37r51,0v8,36,-27,23,-54,25r-1,27r44,0v5,30,-19,24,-43,24v4,26,7,46,35,46v11,0,26,-4,32,-9v14,24,-12,37,-38,37v-47,0,-57,-30,-61,-74r-31,0v-3,-24,8,-26,31,-24r0,-27r-31,0v-3,-26,10,-27,34,-25","k":{"\u2212":4,"\u2014":4,"\u2013":4,"]":6,"-":4,")":6}},"\u2122":{"d":"128,-187v8,-21,12,-47,23,-65r12,0v-2,37,4,81,-2,114r-13,0r3,-81v-7,19,-12,40,-21,57r-8,0r-19,-59v-1,27,6,60,1,83r-13,0r1,-112v1,-3,9,-2,13,-2xm55,-238v-2,32,4,72,-2,100r-13,0r0,-100r-29,0v1,-5,-3,-14,3,-14r68,0v-1,5,3,14,-3,14r-24,0","w":181,"k":{"\/":28}},"\u2212":{"d":"12,-89v2,-13,-2,-22,6,-25r120,0v-1,9,4,25,-6,25r-120,0","k":{"\ufb04":11,"\ufb03":11,"\ufb00":11,"\u017e":22,"\u017d":17,"\u0178":23,"\u0160":33,"\u00ff":12,"\u00fd":12,"\u00dd":23,"\u00c6":12,"\u00c5":12,"\u00c4":12,"\u00c3":12,"\u00c2":12,"\u00c1":12,"\u00c0":12,"\\":30,"T":38,"V":13,"W":10,"Y":23,"f":11,"t":10,"v":9,"w":7,"y":12,")":11,"]":11,"A":12,"J":44,"X":23,"x":27,"S":33,"z":22,"\u00bb":11,"\u203a":11,"Z":17}},"\ufb00":{"d":"193,-235v-28,-10,-66,-4,-62,31r0,24r32,0v-2,9,5,25,-6,25r-26,0r0,152v-5,6,-20,2,-29,3r0,-155r-44,0r0,152v-5,6,-19,2,-29,3r0,-155r-25,0v2,-9,-4,-25,8,-25r17,0v-4,-51,9,-87,57,-84v14,0,26,5,36,10v17,-18,89,-21,71,19xm107,-234v-20,-12,-54,-4,-49,26r0,28r44,0v0,-20,0,-41,5,-54","w":164,"k":{"\"":-44,"\u201e":17,"\u201d":-44,"\u201c":-44,"u":3,"p":12,"o":6,"k":-1,"h":-1,"g":7,"f":14,"e":7,"d":8,"c":5,"b":-1,".":17,")":-40,"!":-31,"\ufb04":14,"\ufb03":14,"\ufb00":14,"\u2122":-34,"\u2030":-16,"\u2026":17,"\u201a":17,"\u2019":-44,"\u2018":-44,"\u017e":5,"\u0153":7,"\u00fc":3,"\u00fb":3,"\u00fa":3,"\u00f9":3,"\u00f8":10,"\u00f6":7,"\u00f5":7,"\u00f4":7,"\u00f3":7,"\u00f2":7,"\u00eb":7,"\u00ea":7,"\u00e9":7,"\u00e8":7,"\u00e7":5,"\u00ae":-23,"\u00a9":-22,"r":3,"q":10,"m":1,"]":-18,"\\":-36,"?":-30,"8":-7,",":17,"*":-9,"'":-44,"&":-13}},"\ufb03":{"d":"204,-231v-27,-13,-81,-14,-74,29r0,22r26,0v-2,9,4,24,-7,25r-19,0r0,152v-5,6,-19,2,-29,3r0,-155r-43,0r-1,152v-5,6,-20,2,-29,3r0,-155r-24,0v2,-9,-4,-24,7,-25r17,0v-4,-51,9,-87,57,-84v14,0,27,5,36,10v20,-19,106,-21,83,23xm172,-167v-1,-15,16,-13,30,-13r-1,178v-5,3,-19,2,-29,2r0,-167xm106,-234v-20,-12,-54,-5,-48,26r0,28r43,0v0,-20,0,-41,5,-54","w":218},"\ufb04":{"d":"176,-237v-36,-13,-52,15,-46,57r25,0v-2,8,3,25,-6,25r-19,0r0,152v-5,6,-19,2,-29,3r0,-155r-43,0r-1,152v-5,6,-20,2,-29,3r0,-155r-24,0v2,-9,-4,-24,7,-25r17,0v-4,-51,9,-84,57,-84v15,0,26,4,35,9v20,-18,66,-11,85,1r0,252v-8,2,-18,2,-29,2r0,-237xm106,-234v-20,-12,-54,-5,-48,26r0,28r43,0v0,-20,0,-41,5,-54","w":221},"\u00d0":{"d":"16,-245v3,-14,30,-6,44,-7v61,-2,72,46,71,110v-2,72,-3,138,-70,142r-45,0r0,-119r-15,0v1,-17,-4,-28,15,-26r0,-100xm45,-28v62,4,53,-58,53,-114v0,-47,1,-89,-53,-83r0,80r28,0v-1,9,4,25,-5,26r-23,0r0,91","w":141},"\u0141":{"d":"45,-147r35,-9v2,13,8,20,0,26r-35,10r0,93r62,0v-1,10,4,27,-6,27r-86,0r0,-112r-12,3v-7,-19,-5,-27,12,-30r1,-110v4,-5,19,-2,29,-3r0,105","w":114},"\u0142":{"d":"17,-251v-2,-17,14,-12,29,-14r0,120r15,-4v8,20,3,28,-15,31r-1,116v-5,3,-19,2,-28,2r0,-111r-15,4v-8,-20,-3,-28,15,-30r0,-114","w":62},"\u00b9":{"d":"18,-104v-3,-10,-5,-29,8,-28r33,0r0,-92r-38,8v-15,-35,38,-39,68,-39r0,123r31,0v1,11,5,29,-7,28r-95,0","w":137},"\u00b3":{"d":"84,-213v-1,-26,-49,-16,-60,-4v-20,-28,20,-39,49,-39v48,0,57,47,25,70v49,26,15,92,-39,86v-29,3,-55,-14,-36,-36v17,12,69,16,69,-14v0,-20,-24,-20,-46,-20v-3,-8,-9,-24,6,-23v19,2,32,-3,32,-20","w":137},"\u00b2":{"d":"83,-207v3,-30,-48,-19,-59,-5v-20,-28,21,-44,50,-44v29,0,45,11,44,39v-2,42,-39,59,-59,85r63,0v1,10,2,28,-8,28r-97,0v-1,-4,-3,-7,-3,-10v10,-43,64,-49,69,-93","w":138},"\u2074":{"d":"130,-157v5,17,1,34,-22,28v3,20,-3,32,-27,26r0,-26r-62,0v-13,-45,30,-84,52,-115v8,-12,21,-14,37,-10r0,97r22,0xm82,-155r2,-67v-20,15,-33,41,-43,67r41,0","w":142},"\u00bd":{"d":"18,-104v-3,-10,-5,-29,8,-28r33,0r0,-92r-38,8v-15,-35,38,-39,68,-39r0,123r31,0v1,11,5,29,-7,28r-95,0xm119,-2v-5,12,-25,2,-29,-5r123,-247v10,-5,22,2,27,9xm267,-103v2,-30,-48,-19,-59,-5v-18,-31,22,-41,50,-44v56,-5,50,57,23,85r-38,39r63,0v3,10,3,28,-8,28r-97,0v-7,-53,63,-55,66,-103","w":324},"\u00bc":{"d":"18,-104v-3,-10,-5,-29,8,-28r33,0r0,-92r-38,8v-15,-35,38,-39,68,-39r0,123r31,0v1,11,5,29,-7,28r-95,0xm295,-53v5,17,1,34,-22,28v3,20,-3,32,-27,26r0,-26r-62,0v-13,-45,30,-84,52,-115v8,-12,21,-14,37,-10r0,97r22,0xm247,-51r2,-67v-20,15,-33,41,-43,67r41,0xm119,-2v-5,12,-25,2,-30,-5r124,-247v10,-5,22,2,27,9","w":312},"\u00be":{"d":"84,-213v-1,-26,-49,-16,-60,-4v-20,-28,20,-39,49,-39v48,0,57,47,25,70v49,26,15,92,-39,86v-29,3,-55,-14,-36,-36v17,12,69,16,69,-14v0,-20,-24,-20,-46,-20v-3,-8,-9,-24,6,-23v19,2,32,-3,32,-20xm294,-53v5,17,1,34,-22,28v3,20,-3,32,-27,26r0,-26r-62,0v-13,-45,30,-84,52,-115v8,-12,21,-14,37,-10r0,97r22,0xm246,-51r2,-67v-20,15,-33,41,-43,67r41,0xm118,-2v-5,12,-25,2,-30,-5r124,-247v10,-5,22,2,27,9","w":311},"\u00a6":{"d":"26,-256v-2,-14,19,-13,29,-9r0,138v2,15,-17,9,-29,8r0,-137xm26,-69v-1,-15,17,-12,29,-10r0,140v3,14,-18,10,-29,8r0,-138","w":81},"<":{"d":"118,-155v7,6,18,22,5,28r-71,35r78,35v-1,13,-7,27,-23,20r-88,-39v-7,-11,-7,-27,4,-33","w":144},">":{"d":"27,-31v-8,-5,-17,-22,-5,-28r71,-35r-78,-35v1,-14,9,-28,24,-20r87,39v7,10,8,27,-4,33","w":144},"^":{"d":"76,-105v-17,8,-33,38,-55,25v-2,-3,-4,-6,-4,-10r63,-53v18,19,44,31,57,55v0,6,-7,14,-14,14","w":154},"{":{"d":"37,-154v-5,-52,-21,-118,51,-114v5,6,8,25,0,29v-58,4,7,112,-42,131v41,14,1,90,23,127v5,6,13,6,22,8v2,12,1,26,-9,27v-77,6,-35,-85,-50,-140v-4,-8,-19,-4,-17,-19v2,-23,25,-20,22,-49","w":99},"}":{"d":"63,-60v4,52,21,119,-51,114v-5,-7,-11,-25,0,-28v58,-4,-7,-112,41,-132v-41,-14,2,-93,-23,-127v-5,-6,-12,-6,-21,-8v-2,-12,-2,-27,9,-27v77,-5,35,85,50,140v5,7,19,7,17,20v-3,21,-24,19,-22,48","w":99},"~":{"d":"48,-92v-18,-2,-26,23,-40,9v-12,-22,19,-35,42,-35v27,0,49,29,72,2v15,-7,26,17,12,24v-9,9,-21,16,-39,16v-22,1,-27,-15,-47,-16","w":144},"\u2020":{"d":"71,-181v0,-23,-15,-52,-5,-70v9,-6,21,-5,28,3r-8,64v-2,8,-10,7,-15,3xm90,-177v24,-8,70,-16,48,23v-16,-7,-56,2,-48,-23xm65,-162v-24,10,-72,12,-47,-24v16,6,58,0,47,24xm70,-153v0,-8,10,-8,15,-4r8,145v2,17,-24,17,-31,8","w":154},"\u00b0":{"d":"64,-199v-24,0,-34,-9,-34,-35v0,-24,13,-35,36,-35v25,1,32,10,33,35v0,23,-11,36,-35,35xm66,-250v-10,0,-17,6,-16,17v0,11,4,16,14,16v10,-1,17,-5,16,-17v-1,-11,-4,-15,-14,-16","w":128},"\u00a3":{"d":"118,-177v-21,-16,-58,-5,-58,22v-2,8,-3,18,-3,30r47,0v-2,13,2,22,-6,25r-41,0r3,71r56,2v6,13,0,27,-16,27r-68,0r-4,-100r-23,0v-1,-21,0,-28,23,-25v2,-49,10,-87,58,-89v25,-1,43,12,32,37","w":131},"\u00a7":{"d":"33,-176v-32,-28,-11,-77,38,-77v29,0,49,15,34,39v-15,-14,-68,-10,-53,18v16,30,60,41,60,84v0,15,-9,28,-20,36v31,27,13,77,-38,77v-30,0,-50,-15,-34,-39v15,14,68,10,52,-18v-17,-29,-59,-41,-59,-84v0,-16,9,-29,20,-36xm54,-156v-31,16,0,51,16,61v32,-16,1,-52,-16,-61","w":125},"\u00b6":{"d":"83,-256v18,0,33,4,44,10r0,237v-1,14,-19,9,-30,8r0,-73v-52,21,-88,-19,-85,-77v3,-59,16,-102,71,-105xm42,-154v0,42,18,74,55,57r0,-130v-42,-14,-55,26,-55,73xm149,-237v-2,-15,18,-11,30,-9r0,237v2,14,-19,11,-30,8r0,-236","w":194},"\u2260":{"d":"70,-42v-7,22,-14,63,-43,35r12,-35r-30,0v2,-13,-2,-22,6,-25r33,0r15,-42r-54,0v2,-13,-2,-22,6,-25r56,0v8,-22,16,-68,45,-39r-14,39r33,0v-2,13,2,22,-6,25r-36,0r-14,42r56,0v-2,13,2,22,-6,25r-59,0","w":144},"\u221e":{"d":"62,-42v-32,0,-48,-20,-48,-51v1,-33,16,-53,49,-54v26,-1,38,15,48,30v11,-14,22,-30,46,-30v29,1,47,21,47,53v0,63,-78,68,-96,24v-12,13,-23,28,-46,28xm60,-116v-24,3,-20,49,5,47v30,-2,39,-40,8,-47v-5,-1,-9,-1,-13,0xm175,-94v0,-31,-38,-29,-45,-7v-13,10,6,33,22,33v15,0,23,-10,23,-26","w":218},"\u00b1":{"d":"89,-104r0,44v-2,9,-13,4,-26,6r0,-50r-50,0v1,-9,-4,-26,6,-26r44,0r0,-44v2,-9,13,-4,26,-6r0,50r50,0v-2,13,2,23,-6,26r-44,0xm12,-5v2,-13,-2,-23,6,-26r120,0v-1,9,4,26,-6,26r-120,0"},"\u00b5":{"d":"96,-169v-2,-16,17,-14,30,-11r0,171v-19,9,-63,21,-81,4r0,64v1,13,-19,13,-29,9r0,-237v-2,-16,16,-14,29,-11r0,133v-2,28,33,25,51,18r0,-140","w":141},"\u03bc":{"d":"96,-169v-2,-16,17,-14,30,-11r0,171v-19,9,-63,21,-81,4r0,64v1,13,-19,13,-29,9r0,-237v-2,-16,16,-14,29,-11r0,133v-2,28,33,25,51,18r0,-140","w":141},"\u2202":{"d":"16,-93v-3,-63,37,-110,89,-80v-10,-37,-28,-59,-55,-81v4,-10,23,-18,33,-9v40,35,59,83,59,159v0,56,-7,108,-61,108v-54,0,-63,-41,-65,-97xm80,-21v44,0,30,-71,31,-118v-7,-10,-15,-18,-30,-18v-30,0,-35,36,-35,69v0,37,5,67,34,67","w":153},"\u2211":{"d":"115,-252v3,9,3,26,-6,28r-52,0r44,149r-45,116r61,0v2,11,2,27,-8,27r-92,0r54,-145r-54,-175r98,0","w":140},"\u220f":{"d":"144,-252v7,13,2,32,-17,28r0,283v0,12,-20,12,-30,8r0,-291r-39,0r0,283v0,12,-19,11,-29,8r0,-291v-11,1,-19,1,-18,-13v1,-7,1,-15,9,-15r124,0","w":157},"\u03c0":{"d":"144,-180v7,13,2,32,-17,28r0,143v-1,12,-19,11,-30,9r0,-152r-39,0r0,143v0,12,-18,11,-29,9r0,-152v-11,1,-19,1,-18,-13v1,-7,1,-15,9,-15r124,0","w":157},"\u222b":{"d":"8,40v28,9,61,7,61,-30r0,-213v0,-43,20,-63,61,-63v26,0,40,11,30,31v-26,-8,-61,-7,-61,29r0,214v0,43,-20,63,-61,63v-26,0,-39,-9,-30,-31","w":168},"\u00aa":{"d":"21,-222v-14,-24,15,-34,42,-34v61,0,33,88,39,142v-31,15,-96,19,-88,-34v-3,-39,29,-50,63,-41v2,-23,-1,-41,-23,-41v-11,0,-25,5,-33,8xm38,-147v-3,25,24,25,39,18r0,-39v-18,-6,-42,-4,-39,21","w":115},"\u00ba":{"d":"59,-104v-41,2,-46,-34,-46,-76v-1,-46,13,-76,50,-76v40,0,46,33,46,76v1,45,-13,74,-50,76xm63,-230v-24,0,-26,26,-26,52v0,25,-1,50,23,50v22,0,24,-23,24,-52v0,-25,1,-50,-21,-50","w":121},"\u03a9":{"d":"141,-28v4,9,5,28,-7,28r-47,0v14,-35,28,-76,26,-126v-2,-45,3,-92,-34,-99v-37,5,-35,48,-35,91v0,52,10,98,25,134r-54,0v-2,-10,-5,-28,7,-28r19,0v-36,-55,-52,-231,42,-228v57,2,60,56,60,116v0,46,-9,85,-27,112r25,0","w":156},"\u2126":{"d":"141,-28v4,9,5,28,-7,28r-47,0v14,-35,28,-76,26,-126v-2,-45,3,-92,-34,-99v-37,5,-35,48,-35,91v0,52,10,98,25,134r-54,0v-2,-10,-5,-28,7,-28r19,0v-36,-55,-52,-231,42,-228v57,2,60,56,60,116v0,46,-9,85,-27,112r25,0","w":156},"\u00ac":{"d":"14,-84v-3,-10,-4,-27,8,-27r107,0r0,71v-10,4,-28,5,-28,-7r0,-37r-87,0","w":144},"\u221a":{"d":"91,56v-2,17,-22,14,-37,12r-37,-146v4,-8,27,-11,29,1r22,90r32,-265r59,0v4,8,4,28,-8,28r-25,0","w":168},"\u0192":{"d":"160,-235v-28,-9,-65,-6,-61,29r0,26r52,0v-2,13,2,23,-6,26r-46,0r0,162v0,43,-20,63,-61,63v-26,0,-39,-9,-30,-31v26,9,61,7,61,-30r0,-164r-44,0v2,-13,-2,-23,6,-26r38,0v-4,-54,10,-86,61,-86v26,0,40,11,30,31","w":168},"\u2248":{"d":"49,-113v-19,-1,-40,27,-43,-4v10,-16,47,-34,68,-15v11,11,39,8,47,-5v10,-7,18,6,16,18v-7,10,-23,21,-42,21v-23,0,-26,-14,-46,-15xm50,-63v-19,0,-39,28,-45,-6v9,-8,25,-24,43,-21v28,4,53,26,80,4v7,0,11,8,11,15v-10,12,-24,23,-46,23v-22,0,-25,-15,-43,-15","w":144},"\u0394":{"d":"59,-235v1,-16,21,-24,36,-14r52,249r-138,0xm42,-28r73,0r-36,-184r-2,0","w":153},"\u2206":{"d":"59,-235v1,-16,21,-24,36,-14r52,249r-138,0xm42,-28r73,0r-36,-184r-2,0","w":153},"\u00a0":{"w":56},"\u25ca":{"d":"82,2r-72,-128r72,-128r72,128xm82,-196r-40,70r40,70r40,-70","w":163},"\u2021":{"d":"68,-91v5,-23,-15,-78,19,-67r0,61v0,9,-10,9,-19,6xm71,-181v0,-23,-15,-52,-5,-70v9,-6,21,-5,28,3r-8,64v-2,8,-10,7,-15,3xm90,-177v24,-8,70,-16,48,23v-16,-7,-56,2,-48,-23xm65,-162v-24,10,-72,12,-47,-24v16,6,58,0,47,24xm84,-69v6,28,21,88,-23,64r8,-60v2,-9,9,-8,15,-4xm64,-72v-24,9,-70,14,-47,-24v16,7,56,-2,47,24xm89,-87v25,-9,72,-13,48,24v-16,-7,-56,0,-48,-24","w":154},"\u00af":{"d":"94,-241v4,11,2,28,-9,28r-83,0v-4,-11,-3,-29,10,-28r82,0","w":96},"\u02d8":{"d":"45,-204v-26,0,-52,-24,-42,-50v2,-2,6,-4,12,-6v5,13,13,26,30,28v24,3,23,-43,45,-19v2,2,3,5,3,7v-8,20,-20,40,-48,40","w":92},"\u02dd":{"d":"45,-268v7,-17,24,1,35,-5v9,-1,19,10,18,20v-17,16,-29,38,-49,51v-4,0,-7,-2,-10,-5v-7,9,-21,1,-23,-6","w":115},"\u02db":{"d":"0,40v1,-28,23,-56,48,-45v2,2,3,3,3,5v-12,8,-22,20,-25,36v-1,14,13,16,22,10v8,15,-2,25,-18,24v-18,-1,-31,-7,-30,-30","w":51},"\u2264":{"d":"120,-168v7,5,16,22,5,28r-71,35r77,35v1,15,-8,27,-23,20r-87,-39v-7,-11,-7,-27,4,-33xm18,0v1,-9,-4,-25,5,-26r109,0v-2,13,2,23,-6,26r-108,0","w":148},"\u2265":{"d":"27,-46v-7,-6,-17,-23,-5,-29r71,-35r-77,-34v0,-14,8,-28,23,-21r88,39v6,12,6,27,-5,33xm18,0v1,-9,-4,-26,6,-26r107,0v-2,13,2,23,-6,26r-107,0","w":147},"\u00f0":{"d":"50,-255v12,-22,39,-9,48,7r24,-10v9,16,10,27,-8,31v18,31,29,72,28,123v0,56,-7,108,-61,108v-54,0,-63,-41,-65,-97v-3,-63,37,-110,89,-80v-4,-16,-11,-31,-19,-43r-34,13v-3,-11,-12,-20,-4,-26r21,-8v-6,-7,-12,-12,-19,-18xm80,-21v44,0,30,-71,31,-118v-7,-10,-15,-18,-30,-18v-30,0,-35,36,-35,69v0,37,5,67,34,67","w":153},"\u00fe":{"d":"17,-251v-2,-17,14,-12,29,-14r0,84v54,-11,82,17,82,73v0,66,-26,135,-82,102r0,76v-11,1,-33,8,-29,-10r0,-311xm95,-105v5,-41,-20,-67,-49,-45r0,118v4,7,9,9,18,10v31,-6,27,-44,31,-83","w":137},"\u00de":{"d":"123,-136v0,54,-23,82,-78,79v-1,18,1,39,-1,55v-5,3,-19,2,-29,2r0,-245v0,-11,17,-6,30,-7r0,45v54,-2,78,18,78,71xm45,-85v37,5,46,-15,46,-54v0,-31,-11,-47,-46,-42r0,96","w":129},"!":{"d":"35,3v-15,0,-20,-8,-20,-21v0,-12,7,-21,20,-21v14,0,20,8,20,21v0,12,-9,21,-20,21xm50,-91v2,16,-14,14,-29,14r-5,-169v3,-12,26,-7,40,-8","w":70},"\u0237":{"d":"19,-167v0,-14,15,-13,30,-13r0,193v0,36,-12,57,-48,58v-27,1,-47,-13,-33,-35v22,14,51,13,51,-28r0,-175","w":66},"\"":{"d":"40,-282v-7,23,11,75,-24,72v-1,-24,-6,-49,-4,-72v9,0,20,-2,28,0xm84,-282v-1,22,-3,53,-7,71r-17,1v-1,-24,-6,-49,-4,-72v9,0,20,-2,28,0","w":95,"k":{"\ufb04":16,"\ufb03":16,"\ufb00":16,"\u20ac":44,"\u017e":25,"\u0178":-7,"\u0161":33,"\u0160":4,"\u0153":33,"\u0152":7,"\u00ff":26,"\u00fd":26,"\u00fc":26,"\u00fb":26,"\u00fa":26,"\u00f9":26,"\u00f8":33,"\u00f6":33,"\u00f5":33,"\u00f4":33,"\u00f3":33,"\u00f2":33,"\u00f1":35,"\u00ef":-19,"\u00ee":-15,"\u00ec":-19,"\u00eb":37,"\u00ea":37,"\u00e9":37,"\u00e8":37,"\u00e7":34,"\u00e6":26,"\u00e5":26,"\u00e4":26,"\u00e3":26,"\u00e2":26,"\u00e1":26,"\u00e0":26,"\u00dd":-7,"\u00dc":4,"\u00db":4,"\u00d8":7,"\u00d6":7,"\u00d5":7,"\u00d4":7,"\u00d3":7,"\u00d2":7,"\u00d1":3,"\u00cf":-7,"\u00ce":-15,"\u00cb":6,"\u00ca":2,"\u00c7":20,"\u00c6":43,"\u00c5":43,"\u00c4":43,"\u00c3":43,"\u00c2":43,"\u00c1":43,"\u00c0":43,"\u00bf":37,"\u00a2":20,"r":35,"q":40,"m":35,"\\":-13,"Q":7,"@":27,"?":-7,"9":17,"6":11,"4":36,"3":1,"2":7,"1":14,"0":15,"\/":47,"+":8,"C":20,"G":13,"T":-5,"V":-6,"W":-6,"Y":-7,"d":40,"f":16,"t":6,"u":26,"v":25,"w":25,"y":26,"c":34,"e":37,"o":33,"O":7,")":-7,"]":-7,"A":43,"J":48,"x":23,"a":26,"z":25,"g":39,"n":35,"p":36,"s":33,"(":28,"[":28}}}});
