/*!
 * The following copyright notice may not be removed under any circumstances.
 * 
 * Copyright:
 * Data by Eraman Ltd., and Monotype Typography Inc.  1995. Microsoft
 * Corporation. All rights reserved.
 * 
 * Description:
 * Haettenschweiler derives from a more condensed typeface, called Schmalfette
 * Grotesk, first shown in the early 1960s in a splendid book called Lettera by
 * Walter Haettenschweiler and Armin Haab. Schmalfette Grotesk was a very
 * condensed, very bold alphabet of all capitals  schmalfette means "bold
 * condensed" in German, and grotesk indicates it is without serifs.
 * It was immediately picked up by designers at Paris Match who cut up pictures of
 * it to make headlines. Soon everybody wanted it. In due course, extra-bold
 * extra-condensed faces for families like Helvetica began to appear, looking
 * remarkably like the original Schmalfette.
 * Photoscript had made a lowercase version quite early on. Later, they made a
 * less condensed version and called it Haettenschweiler Extended as a tribute to a
 * designer whose idea so greatly affected the graphic scene in the second half of
 * the century. Use this distinguished face in large sizes for headlines.
 */
Cufon.registerFont({"w":128,"face":{"font-family":"Haettenschweiler","font-weight":400,"font-stretch":"normal","units-per-em":"360","panose-1":"2 11 7 6 4 9 2 6 2 4","ascent":"288","descent":"-72","x-height":"3","bbox":"-40 -370 362 119","underline-thickness":"17.9297","underline-position":"-27.0703","unicode-range":"U+0020-U+F005"},"glyphs":{" ":{"w":64},"\u00a0":{"w":64},"!":{"d":"55,-48r-50,0r0,-204r50,0r0,204xm55,0r-50,0r0,-37r50,0r0,37","w":60},"\"":{"d":"131,-252r-51,87r-21,-3r23,-84r49,0xm76,-252r-51,87r-21,-3r23,-84r49,0","w":134},"#":{"d":"284,-202r-9,50r-50,0r-9,52r50,0r-9,50r-50,0r-8,50r-50,0r8,-50r-52,0r-9,50r-50,0r9,-50r-50,0r9,-50r49,0r10,-52r-50,0r9,-50r50,0r8,-50r50,0r-8,50r52,0r9,-50r50,0r-9,50r50,0xm175,-152r-52,0r-9,52r52,0","w":289},"$":{"d":"58,-205v-2,61,73,77,73,125v0,42,0,76,-38,81r0,16r-50,0r0,-17v-46,-8,-38,-51,-38,-100r51,0r0,57v0,6,3,9,10,9v17,0,10,-24,10,-38v0,-41,-85,-62,-71,-133v0,-26,13,-41,38,-46r0,-18r50,0r0,18v39,7,35,43,34,85r-51,0r0,-46v0,-5,-2,-8,-8,-8v-6,0,-10,5,-10,15","w":136},"%":{"d":"32,-153v-41,2,-24,-50,-24,-83v0,-12,8,-18,24,-18v42,-2,25,51,25,84v0,11,-9,17,-25,17xm36,-169r0,-69v0,-2,-2,-3,-4,-3v-8,17,0,50,-3,72v0,2,1,3,3,3v2,0,4,-1,4,-3xm120,-252r-91,252r-24,0r91,-252r24,0xm92,3v-42,2,-24,-51,-24,-83v0,-12,8,-18,24,-18v42,-2,25,52,25,85v0,11,-9,16,-25,16xm96,-13r0,-69v0,-2,-2,-3,-4,-3v-8,17,0,50,-3,72v0,2,1,3,3,3v2,0,4,-1,4,-3","w":124},"&":{"d":"79,-121v-38,-6,-13,51,-20,78v0,7,3,11,10,11v7,0,10,-4,10,-11r0,-56r70,0r0,29r-19,0v8,50,-17,74,-61,73v-34,0,-63,-16,-63,-50v0,0,-6,-83,33,-89v-35,-10,-32,-35,-31,-73v0,-29,28,-45,58,-45v42,0,68,27,60,77r-48,0v1,-15,3,-43,-10,-42v-19,1,-8,33,-10,50v-2,17,4,17,21,17r0,31","w":153},"'":{"d":"76,-252r-51,87r-21,-3r23,-84r49,0","w":79},"(":{"d":"5,-204v-7,-55,28,-50,79,-50r0,28v-19,0,-29,4,-29,12r0,177v0,8,10,13,29,13r0,27v-47,2,-79,-1,-79,-49r0,-158","w":88},")":{"d":"84,-46v4,50,-32,51,-79,49r0,-27v19,0,29,-5,29,-13r0,-177v0,-8,-10,-12,-29,-12r0,-28v49,0,79,-6,79,50r0,158","w":88},"*":{"d":"147,-190r-48,15r29,41r-23,17r-29,-41r-29,41r-24,-17r30,-41r-48,-15r9,-27r47,15r0,-50r29,0r0,50r48,-15","w":151},"+":{"d":"130,-49r-49,0r0,49r-28,0r0,-49r-49,0r0,-28r49,0r0,-49r28,0r0,49r49,0r0,28","w":134},",":{"d":"22,30r-10,-8v8,-8,12,-15,13,-22r-20,0r0,-37r46,0v2,36,-2,48,-29,67","w":56},"-":{"d":"78,-90r-71,0r0,-28r71,0r0,28","w":81},"\u00ad":{"d":"78,-90r-71,0r0,-28r71,0r0,28","w":81},".":{"d":"51,0r-46,0r0,-37r46,0r0,37","w":55},"\/":{"d":"115,-252r-80,252r-30,0r80,-252r30,0","w":120},"0":{"d":"70,2v-35,1,-65,-13,-65,-45r0,-162v0,-33,22,-49,65,-49v43,0,64,16,64,48r0,163v0,31,-31,45,-64,45xm79,-40r0,-172v0,-5,-3,-8,-9,-8v-6,0,-9,3,-9,8r0,172v0,5,3,7,9,7v6,0,9,-2,9,-7","w":139},"1":{"d":"5,-221v14,1,30,-17,29,-31r48,0r0,252r-56,0r0,-185r-21,0r0,-36","w":87},"2":{"d":"67,-254v64,0,70,51,59,102r-63,120r68,0r0,32r-126,0r0,-33r62,-115v7,-12,10,-29,10,-51v0,-21,-23,-22,-23,-6r0,43r-49,0v-3,-56,-1,-92,62,-92","w":135},"3":{"d":"68,-254v48,0,62,26,62,79v0,20,-10,34,-29,41v32,7,30,45,29,84v0,35,-20,52,-62,52v-70,0,-65,-46,-63,-108r51,0r0,60v0,6,3,9,10,9v7,0,10,-3,10,-9v-5,-29,16,-81,-24,-75r0,-29v36,3,21,-32,24,-59v0,-5,-3,-8,-10,-8v-22,1,-7,36,-11,54r-49,0v-3,-56,-2,-91,62,-91","w":135},"4":{"d":"158,-32r-28,0r0,32r-54,0r0,-32r-75,0r0,-36r55,-184r74,0r0,182r28,0r0,38xm76,-70r0,-100r-25,100r25,0","w":158},"5":{"d":"131,-43v0,32,-30,44,-63,45v-72,3,-64,-46,-63,-108r54,0r0,65v0,6,3,8,9,8v6,0,9,-2,9,-8r0,-84v0,-6,-3,-9,-10,-9v-6,0,-10,6,-10,16r-52,-2r3,-132r124,0r-8,38r-63,0r-2,52v22,-18,72,-7,72,29r0,90","w":135},"6":{"d":"131,-43v0,31,-30,45,-63,45v-42,0,-64,-15,-64,-45r0,-162v0,-33,22,-49,64,-49v54,0,67,24,63,74r-54,0v1,-14,4,-41,-9,-40v-20,2,-6,39,-10,57v22,-19,73,-4,73,30r0,90xm77,-41r0,-83v0,-6,-3,-8,-9,-8v-6,0,-10,2,-10,8r0,83v0,6,4,8,10,8v6,0,9,-2,9,-8","w":135},"7":{"d":"133,-216r-70,216r-59,0r69,-217r-65,0r0,-35r125,0r0,36","w":135},"8":{"d":"68,-254v44,0,62,21,62,71v0,26,-9,41,-28,47v36,6,28,50,29,90v0,32,-21,48,-63,48v-65,0,-63,-40,-63,-99v0,-21,10,-34,29,-39v-27,-6,-28,-38,-28,-74v0,-30,21,-44,62,-44xm68,-152v19,-4,5,-41,9,-60v0,-5,-3,-8,-9,-8v-19,4,-5,41,-9,60v0,5,3,8,9,8xm77,-40r0,-74v0,-5,-3,-7,-9,-7v-6,0,-9,2,-9,7r0,74v0,5,3,7,9,7v6,0,9,-2,9,-7","w":136},"9":{"d":"68,-254v34,-1,64,13,63,45r0,162v0,33,-20,49,-63,49v-69,0,-65,-46,-63,-107r54,0r0,64v0,6,3,8,9,8v6,0,10,-2,10,-8r0,-75v-26,15,-73,1,-73,-34r0,-59v0,-32,30,-45,63,-45xm78,-151r0,-61v0,-6,-4,-8,-10,-8v-6,0,-9,2,-9,8r0,61v0,6,3,8,9,8v6,0,10,-2,10,-8","w":136},":":{"d":"51,-121r-46,0r0,-37r46,0r0,37xm51,0r-46,0r0,-36r46,0r0,36","w":55},";":{"d":"51,-121r-46,0r0,-37r46,0r0,37xm22,30r-10,-8v8,-8,12,-15,13,-22r-20,0r0,-37r46,0v2,36,-2,48,-29,67","w":55},"\u037e":{"d":"51,-121r-46,0r0,-37r46,0r0,37xm22,30r-10,-8v8,-8,12,-15,13,-22r-20,0r0,-37r46,0v2,36,-2,48,-29,67","w":55},"<":{"d":"132,-2r-126,-47r0,-28r126,-46r0,28r-88,32r88,32r0,29","w":137},"=":{"d":"132,-77r-126,0r0,-29r126,0r0,29xm132,-21r-126,0r0,-28r126,0r0,28","w":137},">":{"d":"132,-49r-127,47r0,-29r88,-32r-88,-32r0,-28r127,46r0,28","w":137},"?":{"d":"123,-172v0,55,-57,54,-46,125r-50,0v-11,-78,58,-80,44,-165v0,-5,-3,-8,-9,-8v-6,0,-8,3,-8,8r0,64r-48,0v-1,-57,-9,-106,57,-106v52,0,60,28,60,82xm77,0r-50,0r0,-37r50,0r0,37","w":127},"@":{"d":"284,-106v0,62,-73,109,-118,65v-15,24,-93,25,-88,-16v6,-51,-22,-122,41,-122v17,0,27,4,32,11r0,-10r44,0r0,101v0,16,5,24,15,24v29,0,43,-18,43,-54v0,-78,-35,-118,-106,-118v-74,0,-112,50,-112,118v0,68,38,120,112,120v30,0,57,-3,80,-9r0,30v-24,6,-51,9,-80,9v-81,1,-142,-67,-142,-149v0,-82,61,-149,142,-148v90,1,137,53,137,148xm145,-66r0,-72v0,-6,-2,-9,-8,-9v-6,0,-9,3,-9,10r0,71v0,6,3,10,9,10v6,0,8,-4,8,-10","w":288},"A":{"d":"156,0r-55,0r-9,-68r-25,0r-10,68r-54,0r41,-252r70,0xm87,-103r-8,-75r-7,75r15,0","w":158},"B":{"d":"131,-50v1,59,-67,51,-125,50r0,-252v55,1,123,-10,123,45v1,38,3,63,-32,72v42,7,34,42,34,85xm61,-150v26,1,16,-34,16,-56v0,-9,-6,-14,-16,-14r0,70xm61,-32v30,-2,16,-51,16,-78v0,-9,-6,-13,-16,-13r0,91","w":136},"C":{"d":"127,-37v1,26,-31,39,-57,39v-43,0,-64,-15,-64,-45r0,-162v0,-33,21,-49,64,-49v59,0,60,36,57,90r-50,0r0,-50v0,-4,-3,-6,-8,-6v-5,0,-8,2,-8,6r0,175v0,4,3,6,8,6v5,0,8,-2,8,-6r0,-62r50,0r0,64","w":133},"D":{"d":"132,-50v1,58,-68,51,-127,50r0,-252v59,0,127,-8,127,50r0,152xm76,-46r0,-160v0,-9,-5,-14,-15,-14r0,188v10,0,15,-5,15,-14","w":137},"E":{"d":"114,0r-108,0r0,-252r108,0r0,32r-52,0r0,68r47,0r0,31r-47,0r0,89r52,0r0,32","w":117},"F":{"d":"110,-220r-48,0r0,68r43,0r0,31r-43,0r0,121r-56,0r0,-252r104,0r0,32","w":112},"G":{"d":"94,-14v-28,29,-88,19,-88,-27r0,-164v0,-33,20,-49,62,-49v62,0,63,35,60,91r-50,0r0,-51v0,-4,-3,-6,-9,-6v-6,0,-8,2,-8,6r0,175v0,4,2,6,8,6v19,-2,5,-36,9,-53r-12,0r0,-39r62,0r0,125r-27,0","w":133},"H":{"d":"131,0r-55,0r0,-121r-15,0r0,121r-56,0r0,-252r56,0r0,100r15,0r0,-100r55,0r0,252","w":136},"I":{"d":"60,0r-55,0r0,-252r55,0r0,252","w":65},"J":{"d":"63,2v-26,0,-58,-13,-57,-39r0,-64r48,0r0,62v0,4,3,6,8,6v5,0,8,-2,8,-6r0,-213r55,0r0,209v0,30,-20,45,-62,45","w":130},"K":{"d":"144,0r-61,0r-21,-94r0,94r-55,0r0,-252r55,0r0,84r24,-84r52,0r-34,115","w":146},"L":{"d":"111,0r-104,0r0,-252r55,0r0,220r49,0r0,32","w":113},"M":{"d":"199,0r-49,0r0,-142r-29,142r-38,0r-33,-142r0,142r-44,0r0,-252r72,0r25,131r22,-131r74,0r0,252","w":205},"N":{"d":"147,0r-57,0r-38,-134r0,134r-46,0r0,-252r63,0r32,115r0,-115r46,0r0,252","w":152},"O":{"d":"132,-43v0,32,-30,45,-63,45v-42,0,-63,-15,-63,-45r0,-162v0,-33,21,-49,63,-49v42,0,63,16,63,48r0,163xm78,-40r0,-172v0,-5,-3,-8,-9,-8v-6,0,-9,3,-9,8r0,172v0,5,3,7,9,7v6,0,9,-2,9,-7","w":137},"P":{"d":"133,-137v-3,42,-21,43,-73,44r0,93r-54,0r0,-252v55,3,127,-14,127,45r0,70xm60,-129v34,1,14,-47,19,-74v0,-9,-7,-13,-19,-13r0,87","w":136},"Q":{"d":"104,-4v2,12,8,8,28,9r0,29v-31,2,-58,-2,-56,-32v-47,0,-70,-15,-70,-45r0,-162v0,-33,21,-49,63,-49v42,0,63,16,63,48r0,163v0,18,-9,30,-28,39xm78,-40r0,-172v0,-5,-3,-8,-9,-8v-6,0,-9,3,-9,8r0,172v0,5,3,7,9,7v6,0,9,-2,9,-7","w":137},"R":{"d":"7,-252v56,1,125,-10,126,45v1,38,0,61,-34,70v33,6,34,32,34,69v0,40,3,63,10,68r-55,0v-11,-10,-9,-76,-9,-108v0,-9,-6,-13,-17,-13r0,121r-55,0r0,-252xm62,-152v27,2,17,-32,17,-54v0,-9,-6,-14,-17,-14r0,68","w":144},"S":{"d":"59,-205v-2,62,73,73,73,125v0,54,-6,82,-64,82v-68,0,-64,-43,-62,-103r50,0r0,58v0,6,4,9,11,9v17,0,7,-25,10,-39v-9,-43,-71,-64,-71,-104v0,-52,8,-77,64,-77v58,0,60,35,57,88r-50,0r0,-47v0,-5,-2,-7,-8,-7v-6,0,-10,5,-10,15","w":137},"T":{"d":"122,-219r-31,0r0,219r-56,0r0,-219r-31,0r0,-33r118,0r0,33","w":126},"U":{"d":"70,2v-32,0,-64,-12,-64,-45r0,-209r55,0r0,212v0,5,3,7,9,7v6,0,10,-2,10,-7r0,-212r55,0r0,209v0,32,-31,45,-65,45","w":140},"V":{"d":"147,-252r-33,252r-79,0r-34,-252r54,0r19,176r19,-176r54,0","w":148},"W":{"d":"226,-252r-33,252r-65,0r-20,-139r-19,139r-56,0r-32,-252r50,0r14,116r19,-116r63,0r15,116r18,-116r46,0","w":226},"X":{"d":"163,0r-60,0r-25,-81r-24,81r-53,0r44,-143r-32,-109r53,0r20,73r22,-73r49,0r-37,117","w":163},"Y":{"d":"157,-252r-54,152r0,100r-55,0v-2,-62,2,-97,-15,-150r-32,-102r53,0r25,89r29,-89r49,0","w":158},"Z":{"d":"128,0r-124,0r0,-32r61,-187r-58,0r0,-33r117,0r0,33r-60,187r64,0r0,32","w":132},"[":{"d":"52,0r-46,0r0,-252r46,0r0,14r-23,0r0,225r23,0r0,13","w":56},"\\":{"d":"115,0r-29,0r-81,-252r30,0","w":120},"]":{"d":"51,0r-47,0r0,-13r24,0r0,-225r-24,0r0,-14r47,0r0,252","w":56},"^":{"d":"42,-121r-33,0r63,-141r25,0r62,141r-31,0r-44,-105","w":168},"_":{"d":"135,43r-135,0r0,-28r135,0r0,28","w":133},"`":{"d":"52,-220r-27,0r-21,-32r38,0","w":55},"a":{"d":"6,-70v-2,-36,51,-42,68,-64v-2,-14,6,-40,-9,-40v-14,0,-9,33,-9,51r-48,0v-3,-53,0,-82,60,-82v37,0,56,14,56,43r0,162r-45,0r0,-8v-13,20,-82,13,-73,-21r0,-41xm65,-29v19,-5,5,-42,9,-62v-26,3,-17,28,-18,53v0,6,3,9,9,9","w":129},"b":{"d":"123,-31v-1,33,-50,44,-76,24v-3,13,-28,5,-42,7r0,-252r50,0r0,54v19,-14,68,-8,68,21r0,146xm73,-38r0,-127v0,-6,-3,-9,-9,-9v-6,0,-9,3,-9,9r0,127v0,6,3,9,9,9v6,0,9,-3,9,-9"},"c":{"d":"123,-114r-50,0v-3,-19,9,-56,-9,-60v-6,0,-9,3,-9,10r0,125v0,7,3,11,9,11v18,-4,5,-41,9,-60r50,0v2,54,5,91,-58,91v-92,0,-60,-93,-60,-165v0,-29,20,-43,60,-43v63,0,60,36,58,91"},"d":{"d":"5,-177v-2,-30,48,-34,68,-21r0,-54r50,0r0,252v-14,-2,-39,6,-42,-7v-24,20,-76,8,-76,-24r0,-146xm73,-38r0,-127v0,-6,-3,-9,-9,-9v-6,0,-9,3,-9,9r0,127v0,6,3,9,9,9v6,0,9,-3,9,-9"},"e":{"d":"123,-86r-67,0v3,19,-8,53,8,58v17,-3,6,-35,9,-52r50,0v3,52,1,83,-59,83v-90,0,-58,-94,-58,-165v0,-29,19,-43,58,-43v75,0,57,57,59,119xm73,-117v-3,-18,9,-53,-9,-57v-17,4,-4,39,-8,57r17,0"},"f":{"d":"21,-204v-7,-54,31,-48,79,-48r0,27v-20,-1,-31,1,-29,21r29,0r0,30r-29,0r0,174r-50,0r0,-174r-17,0r0,-30r17,0","w":100},"g":{"d":"123,-3v8,56,-56,45,-109,46r0,-29v24,-2,61,9,59,-19v-19,15,-69,9,-68,-20r0,-147v-2,-33,40,-42,68,-25v7,-12,33,-5,50,-7r0,201xm73,-36r0,-129v0,-6,-3,-9,-9,-9v-6,0,-9,3,-9,9r0,128v0,6,3,10,9,10v6,0,9,-3,9,-9"},"h":{"d":"56,-198v18,-13,67,-9,67,21r0,177r-50,0r0,-165v0,-6,-2,-9,-8,-9v-6,0,-9,3,-9,9r0,165r-50,0r0,-252r50,0r0,54"},"i":{"d":"55,-215r-50,0r0,-37r50,0r0,37xm55,0r-50,0r0,-204r50,0r0,204","w":59},"j":{"d":"57,-215r-50,0r0,-37r50,0r0,37xm-21,14v21,-2,27,4,28,-14r0,-204r50,0r0,209v3,40,-38,40,-78,38r0,-29","w":64},"k":{"d":"146,0r-59,0r-31,-74r0,74r-50,0r0,-252r50,0r0,113r26,-65r51,0r-36,89","w":147},"l":{"d":"56,0r-50,0r0,-252r50,0r0,252","w":61},"m":{"d":"119,-192v19,-21,72,-17,72,16r0,176r-50,0r0,-163v0,-6,-3,-9,-9,-9v-6,0,-9,3,-9,9r0,163r-50,0r0,-163v0,-6,-2,-10,-8,-10v-6,0,-9,3,-9,9r0,164r-50,0r0,-204r50,0r0,7v16,-12,49,-11,63,5","w":196},"n":{"d":"56,-197v19,-16,67,-8,67,21r0,176r-50,0r0,-164v0,-6,-3,-9,-9,-9v-6,0,-8,3,-8,9r0,164r-51,0r0,-204r51,0r0,7"},"o":{"d":"64,-205v28,0,58,12,58,41r0,126v0,28,-19,41,-58,41v-91,0,-59,-94,-59,-165v0,-29,19,-43,59,-43xm72,-39r0,-125v0,-7,-3,-10,-9,-10v-6,0,-8,3,-8,10r0,125v0,7,2,11,8,11v6,0,9,-4,9,-11","w":126},"p":{"d":"123,-25v1,30,-49,34,-68,20r0,48r-50,0r0,-247v15,2,40,-6,42,8v24,-19,76,-8,76,24r0,147xm73,-38r0,-127v0,-6,-3,-9,-9,-9v-6,0,-9,3,-9,9r0,127v0,6,3,9,9,9v6,0,9,-3,9,-9"},"q":{"d":"5,-172v0,-32,50,-43,76,-24v2,-14,27,-6,42,-8r0,247r-50,0r0,-48v-19,15,-69,9,-68,-20r0,-147xm73,-38r0,-127v0,-6,-3,-9,-9,-9v-6,0,-9,3,-9,9r0,127v0,6,3,9,9,9v6,0,9,-3,9,-9"},"r":{"d":"57,-197v19,-15,67,-10,67,21r0,56r-50,0v-3,-17,8,-49,-8,-53v-6,0,-9,3,-9,9r0,164r-50,0r0,-204r50,0r0,7"},"s":{"d":"55,-158v-13,50,66,37,68,87v2,49,-6,74,-60,74v-60,0,-61,-32,-58,-85r50,0v3,18,-8,50,9,54v14,-2,8,-52,-2,-54v-46,-26,-57,-18,-55,-80v0,-29,19,-43,58,-43v57,0,60,30,57,81r-49,0v1,-15,3,-51,-8,-50v-6,0,-10,5,-10,16","w":127},"t":{"d":"76,-50v0,16,10,14,29,15r0,35r-32,0v-45,0,-47,-8,-47,-49r0,-125r-22,0r0,-30r22,0r0,-41r50,0r0,41r27,0r0,30r-27,0r0,124","w":108},"u":{"d":"73,-7v-16,17,-68,12,-68,-18r0,-179r50,0r0,166v0,6,3,9,9,9v6,0,9,-3,9,-9r0,-166r50,0r0,204r-50,0r0,-7"},"v":{"d":"135,-204r-37,204r-60,0r-37,-204r51,0r17,121r17,-121r49,0","w":136},"w":{"d":"214,-204r-35,204r-55,0r-16,-83r-14,83r-58,0r-35,-204r49,0r17,111r15,-111r51,0r15,111r17,-111r49,0","w":214},"x":{"d":"140,0r-55,0r-18,-55r-16,55r-50,0r39,-108r-38,-96r53,0r17,53r14,-53r47,0r-33,99","w":140},"y":{"d":"20,16v22,-1,27,3,29,-14v-3,-22,-37,-161,-48,-206r50,0r21,108r17,-108r49,0r-39,203v-3,49,-32,44,-79,44r0,-27","w":139},"z":{"d":"125,0r-120,0r0,-28r57,-143r-54,0r0,-33r112,0r0,28r-58,144r63,0r0,32"},"{":{"d":"107,3v-67,9,-79,-20,-79,-91v0,-14,-8,-22,-24,-22r0,-32v31,2,25,-35,24,-66v-2,-44,34,-49,79,-46r0,28v-64,-10,4,85,-53,100v36,9,21,51,24,89v0,8,10,13,29,13r0,27","w":111},"|":{"d":"56,0r-50,0r0,-252r50,0r0,252","w":61},"}":{"d":"107,-110v-31,-3,-26,40,-24,67v3,44,-34,49,-79,46r0,-27v64,9,-4,-87,53,-102v-36,-7,-21,-51,-24,-88v0,-8,-10,-12,-29,-12r0,-28v53,-5,86,8,78,64v-4,25,1,51,25,48r0,32","w":111},"~":{"d":"195,-118v-53,60,-130,-46,-180,20r0,-36v33,-42,91,-7,135,3v16,0,30,-9,45,-25r0,38","w":210},"\u00c4":{"d":"156,0r-55,0r-9,-68r-25,0r-10,68r-54,0r41,-252r70,0xm87,-103r-8,-75r-7,75r15,0xm88,-281v0,-10,7,-17,17,-17v11,0,18,6,18,17v-1,9,-8,17,-18,17v-12,0,-17,-6,-17,-17xm38,-281v0,-10,7,-17,17,-17v11,0,17,6,17,17v0,10,-8,18,-17,17v-12,0,-17,-6,-17,-17","w":158},"\u00c5":{"d":"156,0r-55,0r-9,-68r-25,0r-10,68r-54,0r41,-252r70,0xm87,-103r-8,-75r-7,75r15,0xm79,-332v21,1,33,14,34,36v0,18,-15,33,-34,32v-19,-1,-33,-15,-34,-34v-1,-17,17,-35,34,-34xm79,-286v8,0,13,-4,13,-13v0,-8,-5,-11,-13,-11v-8,0,-12,4,-12,12v0,8,4,12,12,12","w":158},"\u00c7":{"d":"127,-37v1,26,-31,39,-57,39v-43,0,-64,-15,-64,-45r0,-162v0,-33,21,-49,64,-49v59,0,60,36,57,90r-50,0r0,-50v0,-4,-3,-6,-8,-6v-5,0,-8,2,-8,6r0,175v0,4,3,6,8,6v5,0,8,-2,8,-6r0,-62r50,0r0,64xm50,37v3,-14,19,-1,21,-15v-1,-8,-5,-10,-13,-6r0,-17r20,0r0,6v24,8,19,40,-13,38v-6,0,-11,-2,-15,-6","w":133},"\u00c9":{"d":"114,0r-108,0r0,-252r108,0r0,32r-52,0r0,68r47,0r0,31r-47,0r0,89r52,0r0,32xm82,-294r-21,32r-27,0r10,-32r38,0","w":117},"\u00d1":{"d":"147,0r-57,0r-38,-134r0,134r-46,0r0,-252r63,0r32,115r0,-115r46,0r0,252xm18,-262v-4,-47,50,-45,81,-32v4,0,7,-3,7,-9r32,0v-1,20,-16,43,-40,41v-12,3,-47,-25,-47,0r-33,0","w":152},"\u00d6":{"d":"132,-43v0,32,-30,45,-63,45v-42,0,-63,-15,-63,-45r0,-162v0,-33,21,-49,63,-49v42,0,63,16,63,48r0,163xm78,-40r0,-172v0,-5,-3,-8,-9,-8v-6,0,-9,3,-9,8r0,172v0,5,3,7,9,7v6,0,9,-2,9,-7xm78,-281v0,-10,7,-17,17,-17v11,0,18,6,18,17v-1,9,-8,17,-18,17v-12,0,-17,-6,-17,-17xm28,-281v0,-10,7,-17,17,-17v11,0,17,6,17,17v0,10,-8,18,-17,17v-12,0,-17,-6,-17,-17","w":137},"\u00dc":{"d":"70,2v-32,0,-64,-12,-64,-45r0,-209r55,0r0,212v0,5,3,7,9,7v6,0,10,-2,10,-7r0,-212r55,0r0,209v0,32,-31,45,-65,45xm80,-281v0,-10,7,-17,17,-17v11,0,18,6,18,17v-1,9,-8,17,-18,17v-12,0,-17,-6,-17,-17xm30,-281v0,-10,7,-17,17,-17v11,0,17,6,17,17v0,10,-8,18,-17,17v-12,0,-17,-6,-17,-17","w":140},"\u00e1":{"d":"6,-70v-2,-36,51,-42,68,-64v-2,-14,6,-40,-9,-40v-14,0,-9,33,-9,51r-48,0v-3,-53,0,-82,60,-82v37,0,56,14,56,43r0,162r-45,0r0,-8v-13,20,-82,13,-73,-21r0,-41xm65,-29v19,-5,5,-42,9,-62v-26,3,-17,28,-18,53v0,6,3,9,9,9xm98,-252r-21,32r-27,0r10,-32r38,0","w":129},"\u00e0":{"d":"6,-70v-2,-36,51,-42,68,-64v-2,-14,6,-40,-9,-40v-14,0,-9,33,-9,51r-48,0v-3,-53,0,-82,60,-82v37,0,56,14,56,43r0,162r-45,0r0,-8v-13,20,-82,13,-73,-21r0,-41xm65,-29v19,-5,5,-42,9,-62v-26,3,-17,28,-18,53v0,6,3,9,9,9xm82,-220r-27,0r-21,-32r38,0","w":129},"\u00e2":{"d":"6,-70v-2,-36,51,-42,68,-64v-2,-14,6,-40,-9,-40v-14,0,-9,33,-9,51r-48,0v-3,-53,0,-82,60,-82v37,0,56,14,56,43r0,162r-45,0r0,-8v-13,20,-82,13,-73,-21r0,-41xm65,-29v19,-5,5,-42,9,-62v-26,3,-17,28,-18,53v0,6,3,9,9,9xm119,-220r-36,0r-15,-23r-16,23r-35,0r27,-41r47,0","w":129},"\u00e4":{"d":"6,-70v-2,-36,51,-42,68,-64v-2,-14,6,-40,-9,-40v-14,0,-9,33,-9,51r-48,0v-3,-53,0,-82,60,-82v37,0,56,14,56,43r0,162r-45,0r0,-8v-13,20,-82,13,-73,-21r0,-41xm65,-29v19,-5,5,-42,9,-62v-26,3,-17,28,-18,53v0,6,3,9,9,9xm75,-237v0,-10,7,-17,17,-17v11,0,18,6,18,17v-1,9,-8,17,-18,17v-12,0,-17,-6,-17,-17xm25,-237v0,-10,7,-17,17,-17v11,0,17,6,17,17v0,10,-8,18,-17,17v-12,0,-17,-6,-17,-17","w":129},"\u00e3":{"d":"6,-70v-2,-36,51,-42,68,-64v-2,-14,6,-40,-9,-40v-14,0,-9,33,-9,51r-48,0v-3,-53,0,-82,60,-82v37,0,56,14,56,43r0,162r-45,0r0,-8v-13,20,-82,13,-73,-21r0,-41xm65,-29v19,-5,5,-42,9,-62v-26,3,-17,28,-18,53v0,6,3,9,9,9xm8,-220v-4,-47,50,-45,81,-32v4,0,7,-3,7,-9r32,0v-1,20,-16,43,-40,41v-12,3,-47,-25,-47,0r-33,0","w":129},"\u00e5":{"d":"6,-70v-2,-36,51,-42,68,-64v-2,-14,6,-40,-9,-40v-14,0,-9,33,-9,51r-48,0v-3,-53,0,-82,60,-82v37,0,56,14,56,43r0,162r-45,0r0,-8v-13,20,-82,13,-73,-21r0,-41xm65,-29v19,-5,5,-42,9,-62v-26,3,-17,28,-18,53v0,6,3,9,9,9xm68,-288v21,1,33,14,34,36v0,18,-15,33,-34,32v-19,-1,-33,-15,-34,-34v-1,-17,17,-35,34,-34xm68,-242v8,0,13,-4,13,-13v0,-8,-5,-11,-13,-11v-8,0,-12,4,-12,12v0,8,4,12,12,12","w":129},"\u00e7":{"d":"123,-114r-50,0v-3,-19,9,-56,-9,-60v-6,0,-9,3,-9,10r0,125v0,7,3,11,9,11v18,-4,5,-41,9,-60r50,0v2,54,5,91,-58,91v-92,0,-60,-93,-60,-165v0,-29,20,-43,60,-43v63,0,60,36,58,91xm46,37v3,-14,19,-1,21,-15v-1,-8,-5,-10,-13,-6r0,-17r20,0r0,6v24,8,19,40,-13,38v-6,0,-11,-2,-15,-6"},"\u00e9":{"d":"123,-86r-67,0v3,19,-8,53,8,58v17,-3,6,-35,9,-52r50,0v3,52,1,83,-59,83v-90,0,-58,-94,-58,-165v0,-29,19,-43,58,-43v75,0,57,57,59,119xm73,-117v-3,-18,9,-53,-9,-57v-17,4,-4,39,-8,57r17,0xm98,-252r-21,32r-27,0r10,-32r38,0"},"\u00e8":{"d":"123,-86r-67,0v3,19,-8,53,8,58v17,-3,6,-35,9,-52r50,0v3,52,1,83,-59,83v-90,0,-58,-94,-58,-165v0,-29,19,-43,58,-43v75,0,57,57,59,119xm73,-117v-3,-18,9,-53,-9,-57v-17,4,-4,39,-8,57r17,0xm81,-220r-27,0r-21,-32r38,0"},"\u00ea":{"d":"123,-86r-67,0v3,19,-8,53,8,58v17,-3,6,-35,9,-52r50,0v3,52,1,83,-59,83v-90,0,-58,-94,-58,-165v0,-29,19,-43,58,-43v75,0,57,57,59,119xm73,-117v-3,-18,9,-53,-9,-57v-17,4,-4,39,-8,57r17,0xm116,-220r-36,0r-15,-23r-16,23r-35,0r27,-41r47,0"},"\u00eb":{"d":"123,-86r-67,0v3,19,-8,53,8,58v17,-3,6,-35,9,-52r50,0v3,52,1,83,-59,83v-90,0,-58,-94,-58,-165v0,-29,19,-43,58,-43v75,0,57,57,59,119xm73,-117v-3,-18,9,-53,-9,-57v-17,4,-4,39,-8,57r17,0xm73,-237v0,-10,7,-17,17,-17v11,0,18,6,18,17v-1,9,-8,17,-18,17v-12,0,-17,-6,-17,-17xm23,-237v0,-10,7,-17,17,-17v11,0,17,6,17,17v0,10,-8,18,-17,17v-12,0,-17,-6,-17,-17"},"\u00ed":{"d":"55,0r-50,0r0,-204r50,0r0,204xm64,-252r-21,32r-27,0r10,-32r38,0","w":59},"\u00ec":{"d":"55,0r-50,0r0,-204r50,0r0,204xm45,-220r-27,0r-21,-32r38,0","w":59},"\u00ee":{"d":"55,0r-50,0r0,-204r50,0r0,204xm81,-220r-36,0r-15,-23r-16,23r-35,0r27,-41r47,0","w":59},"\u00ef":{"d":"55,0r-50,0r0,-204r50,0r0,204xm39,-237v0,-10,7,-17,17,-17v11,0,18,6,18,17v-1,9,-8,17,-18,17v-12,0,-17,-6,-17,-17xm-11,-237v0,-10,7,-17,17,-17v11,0,17,6,17,17v0,10,-8,18,-17,17v-12,0,-17,-6,-17,-17","w":59},"\u00f1":{"d":"56,-197v19,-16,67,-8,67,21r0,176r-50,0r0,-164v0,-6,-3,-9,-9,-9v-6,0,-8,3,-8,9r0,164r-51,0r0,-204r51,0r0,7xm6,-220v-4,-47,50,-45,81,-32v4,0,7,-3,7,-9r32,0v-1,20,-16,43,-40,41v-12,3,-47,-25,-47,0r-33,0"},"\u00f3":{"d":"64,-205v28,0,58,12,58,41r0,126v0,28,-19,41,-58,41v-91,0,-59,-94,-59,-165v0,-29,19,-43,59,-43xm72,-39r0,-125v0,-7,-3,-10,-9,-10v-6,0,-8,3,-8,10r0,125v0,7,2,11,8,11v6,0,9,-4,9,-11xm94,-252r-21,32r-27,0r10,-32r38,0","w":126},"\u00f2":{"d":"64,-205v28,0,58,12,58,41r0,126v0,28,-19,41,-58,41v-91,0,-59,-94,-59,-165v0,-29,19,-43,59,-43xm72,-39r0,-125v0,-7,-3,-10,-9,-10v-6,0,-8,3,-8,10r0,125v0,7,2,11,8,11v6,0,9,-4,9,-11xm78,-220r-27,0r-21,-32r38,0","w":126},"\u00f4":{"d":"64,-205v28,0,58,12,58,41r0,126v0,28,-19,41,-58,41v-91,0,-59,-94,-59,-165v0,-29,19,-43,59,-43xm72,-39r0,-125v0,-7,-3,-10,-9,-10v-6,0,-8,3,-8,10r0,125v0,7,2,11,8,11v6,0,9,-4,9,-11xm116,-220r-36,0r-15,-23r-16,23r-35,0r27,-41r47,0","w":126},"\u00f6":{"d":"64,-205v28,0,58,12,58,41r0,126v0,28,-19,41,-58,41v-91,0,-59,-94,-59,-165v0,-29,19,-43,59,-43xm72,-39r0,-125v0,-7,-3,-10,-9,-10v-6,0,-8,3,-8,10r0,125v0,7,2,11,8,11v6,0,9,-4,9,-11xm71,-237v0,-10,7,-17,17,-17v11,0,18,6,18,17v-1,9,-8,17,-18,17v-12,0,-17,-6,-17,-17xm21,-237v0,-10,7,-17,17,-17v11,0,17,6,17,17v0,10,-8,18,-17,17v-12,0,-17,-6,-17,-17","w":126},"\u00f5":{"d":"64,-205v28,0,58,12,58,41r0,126v0,28,-19,41,-58,41v-91,0,-59,-94,-59,-165v0,-29,19,-43,59,-43xm72,-39r0,-125v0,-7,-3,-10,-9,-10v-6,0,-8,3,-8,10r0,125v0,7,2,11,8,11v6,0,9,-4,9,-11xm6,-220v-4,-47,50,-45,81,-32v4,0,7,-3,7,-9r32,0v-1,20,-16,43,-40,41v-12,3,-47,-25,-47,0r-33,0","w":126},"\u00fa":{"d":"73,-7v-16,17,-68,12,-68,-18r0,-179r50,0r0,166v0,6,3,9,9,9v6,0,9,-3,9,-9r0,-166r50,0r0,204r-50,0r0,-7xm94,-252r-21,32r-27,0r10,-32r38,0"},"\u00f9":{"d":"73,-7v-16,17,-68,12,-68,-18r0,-179r50,0r0,166v0,6,3,9,9,9v6,0,9,-3,9,-9r0,-166r50,0r0,204r-50,0r0,-7xm85,-220r-27,0r-21,-32r38,0"},"\u00fb":{"d":"73,-7v-16,17,-68,12,-68,-18r0,-179r50,0r0,166v0,6,3,9,9,9v6,0,9,-3,9,-9r0,-166r50,0r0,204r-50,0r0,-7xm118,-220r-36,0r-15,-23r-16,23r-35,0r27,-41r47,0"},"\u00fc":{"d":"73,-7v-16,17,-68,12,-68,-18r0,-179r50,0r0,166v0,6,3,9,9,9v6,0,9,-3,9,-9r0,-166r50,0r0,204r-50,0r0,-7xm73,-237v0,-10,7,-17,17,-17v11,0,18,6,18,17v-1,9,-8,17,-18,17v-12,0,-17,-6,-17,-17xm23,-237v0,-10,7,-17,17,-17v11,0,17,6,17,17v0,10,-8,18,-17,17v-12,0,-17,-6,-17,-17"},"\u2020":{"d":"156,-148r-48,0r0,148r-55,0r0,-148r-48,0r0,-55r48,0r0,-49r55,0r0,49r48,0r0,55","w":160},"\u00b0":{"d":"42,-254v21,0,38,17,38,38v0,20,-17,37,-37,37v-22,1,-39,-15,-39,-37v0,-19,16,-38,38,-38xm53,-216v0,-7,-3,-11,-10,-11v-8,0,-12,4,-12,11v0,8,3,11,11,11v7,0,11,-3,11,-11","w":83},"\u00a2":{"d":"87,1r0,21r-44,0r0,-21v-25,-5,-37,-18,-37,-41r0,-122v0,-22,12,-36,37,-41r0,-23r44,0r0,22v44,-4,37,48,37,90r-50,0v-3,-19,9,-56,-9,-60v-6,0,-9,3,-9,10r0,125v0,7,3,11,9,11v18,-4,5,-41,9,-60r50,0v0,44,8,85,-37,89","w":129},"\u00a3":{"d":"92,-198v5,-22,-10,-23,-15,-13r0,63r31,0r0,32r-31,0r0,84r46,0r0,32r-103,0r0,-116r-14,0r0,-32r14,0v-2,-61,-6,-106,64,-106v32,0,51,10,59,30","w":146},"\u00a7":{"d":"112,-129v14,19,9,71,-15,75v11,9,17,21,17,38v-1,48,-10,58,-54,59v-27,0,-53,-10,-53,-37r0,-37r42,0v3,17,-8,47,10,48v16,1,10,-45,4,-47v-41,-44,-54,-34,-58,-87v0,-14,8,-41,23,-40v-11,-9,-17,-21,-17,-37v1,-49,10,-58,54,-60v52,-1,55,28,52,75r-42,0v-3,-16,8,-46,-9,-48v-16,-1,-10,44,-4,46v28,26,45,44,50,52xm85,-68v20,-30,-7,-38,-46,-74v-9,10,-7,22,1,32v5,6,20,20,45,42","w":124},"\u2022":{"d":"42,-130v22,0,37,16,38,38v0,20,-18,37,-38,37v-20,0,-39,-15,-38,-37v1,-23,16,-38,38,-38","w":84},"\u00b6":{"d":"6,-185v0,-99,114,-60,198,-67r0,32r-20,0r0,220r-50,0r0,-220r-21,0r0,220r-50,0r0,-134v-30,-1,-57,-18,-57,-51","w":209},"\u00df":{"d":"22,-252v56,0,124,-9,125,45v1,39,3,63,-33,72v42,7,34,42,34,85v0,33,-22,50,-66,50r0,-28v8,0,12,-4,12,-13r0,-69v0,-9,-4,-13,-12,-13r0,-27v22,-1,12,-39,12,-59v0,-7,-2,-11,-9,-11v-7,0,-10,4,-10,11r0,160v3,51,-22,49,-71,49r0,-32v13,-2,18,0,18,-15r0,-205","w":154},"\u00ae":{"d":"73,-254v41,1,69,28,70,70v0,39,-31,69,-70,69v-35,0,-69,-29,-69,-69v0,-39,31,-70,69,-70xm73,-126v34,-1,57,-22,58,-58v1,-32,-25,-58,-58,-58v-33,0,-58,25,-58,58v0,32,26,59,58,58xm100,-137v-13,0,-27,2,-25,-13v0,-11,6,-32,-6,-32r0,45r-20,0r0,-95v26,-1,53,-3,47,28v0,7,-5,12,-13,15v22,1,7,39,17,52xm69,-194v11,0,6,-12,7,-21v0,-3,-3,-5,-7,-5r0,26","w":146},"\u00a9":{"d":"73,-254v41,1,69,28,70,70v0,39,-31,69,-70,69v-35,0,-69,-29,-69,-69v0,-39,31,-70,69,-70xm73,-126v34,-1,57,-22,58,-58v1,-32,-25,-58,-58,-58v-33,0,-58,25,-58,58v0,32,26,59,58,58xm95,-198r-19,0v0,0,2,-28,-6,-19v2,22,-4,52,3,68v6,-1,3,-18,3,-26r19,0v0,22,4,39,-22,39v-39,0,-23,-47,-23,-78v0,-12,7,-19,23,-19v22,-1,23,14,22,35","w":146},"\u2122":{"d":"166,-126r-24,0r0,-71r-15,71r-19,0r-17,-71r0,71r-21,0r0,-126r35,0r13,65r11,-65r37,0r0,126xm65,-236r-16,0r0,110r-27,0r0,-110r-16,0r0,-16r59,0r0,16","w":170},"\u00b4":{"d":"52,-252r-21,32r-27,0r10,-32r38,0","w":55},"\u00a8":{"d":"55,-237v0,-10,7,-17,17,-17v11,0,18,6,18,17v-1,9,-8,17,-18,17v-12,0,-17,-6,-17,-17xm5,-237v0,-10,7,-17,17,-17v11,0,17,6,17,17v0,10,-8,18,-17,17v-12,0,-17,-6,-17,-17","w":94},"\u2260":{"d":"133,-21r-75,0r-15,21r-36,0r14,-21r-14,0r0,-28r34,0r21,-28r-55,0r0,-29r75,0r15,-20r36,0r-15,20r15,0r0,29r-35,0r-20,28r55,0r0,28","w":136},"\u00c6":{"d":"199,0r-109,0r0,-68r-22,0r-11,68r-52,0r41,-252r152,0r0,32r-52,0r0,68r47,0r0,31r-47,0r0,89r53,0r0,32xm90,-103r0,-101r-17,101r17,0","w":203},"\u00d8":{"d":"132,-43v2,43,-56,54,-95,41r-7,19r-30,0r13,-36v-5,-7,-7,-15,-7,-24r0,-162v-6,-43,51,-57,93,-45r8,-18r30,0r-13,34v6,8,8,18,8,29r0,162xm60,-143v6,-23,20,-38,18,-69v0,-5,-3,-7,-9,-7v-6,0,-9,2,-9,7r0,69xm78,-40r0,-72v-7,23,-21,39,-18,72v0,5,3,8,9,8v6,0,9,-3,9,-8","w":136},"\u221e":{"d":"183,-37v-36,0,-67,-5,-67,-35v-6,35,-30,35,-68,35v-30,0,-44,-21,-44,-62v-1,-56,25,-61,75,-61v20,0,32,13,37,41v8,-42,26,-41,67,-41v30,0,45,20,45,61v0,41,-15,62,-45,62xm134,-99v7,16,29,10,49,11v8,0,13,-4,13,-11v0,-18,-28,-11,-44,-11v-8,0,-14,3,-18,11xm98,-99v-7,-17,-29,-10,-50,-11v-8,0,-12,3,-12,11v2,19,53,16,62,0","w":232},"\u00b1":{"d":"132,0r-126,0r0,-29r49,0r0,-33r-49,0r0,-28r49,0r0,-49r28,0r0,49r49,0r0,28r-49,0r0,33r49,0r0,29","w":137},"\u2264":{"d":"133,-41r-126,-47r0,-28r126,-46r0,28r-88,32r88,32r0,29xm133,0r-126,0r0,-28r126,0r0,28","w":138},"\u2265":{"d":"133,-88r-127,47r0,-29r88,-32r-88,-32r0,-28r127,46r0,28xm133,0r-127,0r0,-28r127,0r0,28","w":137},"\u00a5":{"d":"161,-252r-51,141r38,0r0,27r-42,0r0,18r42,0r0,27r-42,0r0,39r-55,0r0,-39r-42,0r0,-27r42,0r0,-18r-42,0r0,-27r39,0r-43,-141r53,0r25,89r28,-89r50,0","w":165},"\u00b5":{"d":"54,-2r0,49r-49,0r0,-251r50,0r0,166v0,6,3,9,9,9v6,0,9,-3,9,-9r0,-166r50,0r0,204r-50,0r0,-7v-6,7,-12,9,-19,5"},"\u2202":{"d":"69,-220v-10,1,-8,5,-9,16r-54,0v0,-33,21,-50,63,-50v43,0,64,16,64,49r0,162v0,30,-22,46,-64,46v-66,0,-63,-39,-63,-98v0,-38,55,-42,72,-67v-3,-19,9,-54,-9,-58xm78,-41r0,-76v-31,5,-13,46,-18,76v0,6,3,9,9,9v6,0,9,-3,9,-9","w":137},"\u2211":{"d":"165,0r-161,0r78,-136r-78,-116r153,0r0,32r-98,0r61,84r-61,104r106,0r0,32","w":169},"\u220f":{"d":"207,-220r-25,0r0,220r-50,0r0,-220r-52,0r0,220r-50,0r0,-220r-26,0r0,-32r203,0r0,32","w":210},"\u222b":{"d":"22,-204v-8,-56,28,-50,78,-50r0,28v-19,0,-28,3,-28,10r0,210v7,55,-29,49,-79,49r0,-27v19,0,29,-3,29,-10r0,-210","w":104},"\u00aa":{"d":"64,-151r-22,0r0,-4v-7,11,-42,6,-37,-11v-6,-31,15,-40,34,-52v2,-10,-3,-30,-9,-14r0,17r-24,0v-2,-26,1,-39,30,-39v49,0,21,64,28,103xm35,-166v9,-2,2,-21,4,-30v-14,2,-8,13,-9,26v0,3,2,4,5,4xm64,-128r-59,0r0,-17r59,0r0,17","w":68},"\u00ba":{"d":"34,-149v-46,0,-30,-47,-30,-83v0,-14,10,-22,30,-22v45,0,29,48,29,84v0,14,-10,21,-29,21xm38,-170r0,-63v0,-3,-1,-5,-4,-5v-3,0,-5,2,-5,5r0,63v0,3,1,5,4,5v3,0,5,-2,5,-5xm63,-128r-59,0r0,-17r59,0r0,17","w":67},"\u2126":{"d":"70,-254v62,0,141,-9,141,49v0,73,27,167,-64,160v-6,0,-10,2,-10,7v0,6,4,9,10,9r64,0r0,29v-44,-3,-93,15,-93,-40v0,-25,9,-39,26,-41v9,-1,13,-7,13,-20r0,-97v0,-32,-45,-22,-75,-22v-13,0,-22,9,-22,22v0,37,-4,83,3,114v42,-3,50,84,7,84r-64,0r0,-29r64,0v6,0,10,-3,10,-9v0,-5,-4,-7,-10,-7v-91,7,-60,-87,-64,-160v-2,-30,35,-49,64,-49","w":216},"\u00e6":{"d":"97,-198v37,-13,88,-9,88,35r0,77r-68,0v3,18,-9,55,9,57v13,2,9,-30,9,-47r50,0v4,54,-5,79,-67,79v-11,0,-19,-4,-25,-13v-18,21,-87,18,-87,-19r0,-41v-2,-35,51,-41,67,-64v-2,-13,6,-37,-8,-38v-13,-1,-11,34,-9,49r-48,0r0,-40v-5,-46,54,-46,89,-35xm135,-117v-3,-18,8,-52,-9,-55v-18,3,-6,37,-9,55r18,0xm73,-38r0,-53v-26,4,-15,29,-17,53v0,6,3,9,9,9v6,0,8,-3,8,-9","w":191},"\u00f8":{"d":"127,-213r-11,26v16,37,1,101,7,149v4,38,-49,48,-87,37v-1,13,-21,7,-34,8r11,-24v-16,-36,-2,-98,-7,-145v-4,-37,46,-50,86,-40r5,-11r30,0xm56,-117v5,-17,16,-28,17,-49v0,-7,-2,-10,-8,-10v-19,0,-5,41,-9,59xm63,-29v19,-3,7,-39,10,-59v-5,17,-16,28,-17,49v0,7,2,10,7,10"},"\u00bf":{"d":"102,-215r-50,0r0,-37r50,0r0,37xm6,-80v0,-56,56,-52,46,-125r50,0v11,61,-35,80,-44,120r0,46v0,5,2,8,8,8v6,0,9,-3,9,-8r0,-65r48,0v0,57,10,107,-57,107v-55,0,-60,-30,-60,-83"},"\u00a1":{"d":"55,-215r-50,0r0,-37r50,0r0,37xm55,0r-50,0r0,-204r50,0r0,204","w":59},"\u00ac":{"d":"199,-57r-33,0r0,-49r-160,0r0,-38r193,0r0,87","w":204},"\u221a":{"d":"156,-252r-52,252r-45,0r-27,-99r-26,0r0,-28r49,0r24,86r43,-211r34,0","w":157},"\u0192":{"d":"36,-186v-3,-68,22,-67,81,-66r0,27v-38,1,-27,1,-32,39r28,0r0,30r-30,0r-12,150v0,50,-30,50,-79,49r0,-27v19,0,29,-3,29,-10r13,-162r-21,0r0,-30r23,0","w":114},"\u2248":{"d":"7,-103v34,-33,82,33,115,-8r0,29v-31,41,-78,-25,-115,7r0,-28xm7,-46v34,-33,82,33,115,-8r0,29v-31,41,-78,-25,-115,7r0,-28","w":127},"\u2206":{"d":"184,0r-180,0r90,-252xm125,-42r-31,-86r-32,86r63,0","w":187},"\u00ab":{"d":"192,0r-101,-62r0,-29r101,-62r0,39r-62,38r62,37r0,39xm107,0r-101,-62r0,-29r101,-62r0,39r-62,38r62,37r0,39","w":198},"\u00bb":{"d":"192,-62r-101,62r0,-39r62,-37r-62,-38r0,-39r101,62r0,29xm106,-62r-101,62r0,-39r62,-37r-62,-38r0,-39r101,62r0,29","w":196},"\u2026":{"d":"165,0r-45,0r0,-37r45,0r0,37xm108,0r-46,0r0,-37r46,0r0,37xm50,0r-46,0r0,-37r46,0r0,37","w":169},"\u00c0":{"d":"156,0r-55,0r-9,-68r-25,0r-10,68r-54,0r41,-252r70,0xm87,-103r-8,-75r-7,75r15,0xm96,-264r-27,0r-21,-32r38,0","w":158},"\u00c3":{"d":"156,0r-55,0r-9,-68r-25,0r-10,68r-54,0r41,-252r70,0xm87,-103r-8,-75r-7,75r15,0xm20,-264v-4,-47,50,-45,81,-32v4,0,7,-3,7,-9r32,0v-1,20,-16,43,-40,41v-12,3,-47,-25,-47,0r-33,0","w":158},"\u00d5":{"d":"132,-43v0,32,-30,45,-63,45v-42,0,-63,-15,-63,-45r0,-162v0,-33,21,-49,63,-49v42,0,63,16,63,48r0,163xm78,-40r0,-172v0,-5,-3,-8,-9,-8v-6,0,-9,3,-9,8r0,172v0,5,3,7,9,7v6,0,9,-2,9,-7xm9,-264v-4,-47,50,-45,81,-32v4,0,7,-3,7,-9r32,0v-1,20,-16,43,-40,41v-12,3,-47,-25,-47,0r-33,0","w":137},"\u0152":{"d":"6,-205v4,-72,107,-41,180,-47r0,32r-52,0r0,68r47,0r0,31r-47,0r0,89r53,0r0,32v-67,-7,-181,27,-181,-43r0,-162xm78,-40r0,-172v0,-5,-3,-7,-9,-7v-6,0,-9,2,-9,7r0,172v0,5,3,8,9,8v6,0,9,-3,9,-8","w":190},"\u0153":{"d":"99,-4v-35,16,-99,5,-94,-36v9,-71,-31,-164,60,-164v13,0,24,2,34,6v36,-14,94,-5,94,35r0,77r-67,0v3,19,-8,54,9,58v16,-4,5,-35,8,-52r50,0v3,52,0,85,-59,83v-15,0,-26,-3,-35,-7xm143,-117v-3,-18,8,-51,-8,-55v-18,3,-6,37,-9,55r17,0xm55,-162r0,123v0,7,3,11,9,11v6,0,8,-3,8,-10r0,-125v0,-6,-2,-9,-8,-9v-6,0,-9,3,-9,10","w":198},"\u2013":{"d":"141,-49r-141,0r0,-28r141,0r0,28","w":140},"\u2014":{"d":"193,-49r-193,0r0,-28r193,0r0,28","w":192},"\u201c":{"d":"100,-185r-46,0v-2,-36,2,-48,29,-67r10,8v-8,8,-12,15,-13,22r20,0r0,37xm49,-185r-46,0v-2,-36,2,-48,29,-67r10,8v-8,8,-12,15,-13,22r20,0r0,37","w":103},"\u201d":{"d":"75,-186r-10,-8v8,-8,12,-15,13,-22r-20,0r0,-37r46,0v2,36,-2,49,-29,67xm23,-186r-10,-8v8,-8,12,-15,13,-22r-20,0r0,-37r46,0v2,36,-2,49,-29,67","w":103},"\u2018":{"d":"50,-185r-46,0v-2,-36,2,-48,29,-67r10,8v-8,8,-12,15,-13,22r20,0r0,37","w":53},"\u2019":{"d":"20,-185r-11,-8v8,-8,12,-15,13,-22r-20,0r0,-37r46,0v2,35,-1,48,-28,67","w":50},"\u00f7":{"d":"83,-105v0,10,-4,15,-15,15v-11,0,-16,-5,-16,-15v0,-11,5,-16,16,-16v11,0,15,5,15,16xm131,-49r-126,0r0,-28r126,0r0,28xm84,-20v0,10,-5,15,-16,15v-11,0,-16,-5,-16,-15v0,-11,5,-16,16,-16v11,0,16,5,16,16","w":135},"\u25ca":{"d":"132,-132r-63,106r-62,-105r62,-107xm125,-132r-56,-95r-56,96r56,94","w":139},"\u00ff":{"d":"20,16v22,-1,27,3,29,-14v-3,-22,-37,-161,-48,-206r50,0r21,108r17,-108r49,0r-39,203v-3,49,-32,44,-79,44r0,-27xm81,-237v0,-10,7,-17,17,-17v11,0,18,6,18,17v-1,9,-8,17,-18,17v-12,0,-17,-6,-17,-17xm31,-237v0,-10,7,-17,17,-17v11,0,17,6,17,17v0,10,-8,18,-17,17v-12,0,-17,-6,-17,-17","w":139},"\u0178":{"d":"157,-252r-54,152r0,100r-55,0v-2,-62,2,-97,-15,-150r-32,-102r53,0r25,89r29,-89r49,0xm90,-281v0,-10,7,-17,17,-17v11,0,18,6,18,17v-1,9,-8,17,-18,17v-12,0,-17,-6,-17,-17xm40,-281v0,-10,7,-17,17,-17v11,0,17,6,17,17v0,10,-8,18,-17,17v-12,0,-17,-6,-17,-17","w":158},"\u2044":{"d":"115,-252r-80,252r-30,0r80,-252r30,0","w":120},"\u2215":{"d":"115,-252r-80,252r-30,0r80,-252r30,0","w":120},"\u20ac":{"d":"127,-37v1,25,-31,39,-57,39v-73,0,-66,-47,-64,-110r-23,0r4,-18r19,0r0,-14r-23,0r4,-18r19,0v-3,-58,0,-97,64,-97v52,0,61,27,57,76r-50,0v-3,-14,8,-40,-8,-41v-5,0,-8,2,-8,6r0,56r62,0r-5,18r-57,0r0,14r53,0r-4,18r-49,0r0,69v0,4,3,6,8,6v16,-2,5,-29,8,-43r50,0r0,39","w":133},"\u2039":{"d":"106,0r-100,-62r0,-29r100,-62r0,39r-62,38r62,37r0,39","w":111},"\u203a":{"d":"106,-62r-100,62r0,-39r62,-37r-62,-38r0,-39r100,62r0,29","w":111},"\uf001":{"d":"21,-204v-8,-57,31,-47,79,-48r0,27v-25,1,-28,-2,-29,21r72,0r0,204r-50,0r0,-174r-22,0r0,174r-50,0r0,-174r-17,0r0,-30r17,0","w":150},"\ufb01":{"d":"21,-204v-8,-57,31,-47,79,-48r0,27v-25,1,-28,-2,-29,21r72,0r0,204r-50,0r0,-174r-22,0r0,174r-50,0r0,-174r-17,0r0,-30r17,0","w":150},"\uf002":{"d":"21,-204v-12,-75,74,-40,129,-48r0,252r-50,0r0,-174r-29,0r0,174r-50,0r0,-174r-17,0r0,-30r17,0xm100,-204r0,-21v-25,1,-31,2,-29,21r29,0","w":155},"\ufb02":{"d":"21,-204v-12,-75,74,-40,129,-48r0,252r-50,0r0,-174r-29,0r0,174r-50,0r0,-174r-17,0r0,-30r17,0xm100,-204r0,-21v-25,1,-31,2,-29,21r29,0","w":155},"\u2021":{"d":"156,-49r-48,0r0,49r-55,0r0,-49r-48,0r0,-56r48,0r0,-43r-48,0r0,-55r48,0r0,-49r55,0r0,49r48,0r0,55r-48,0r0,43r48,0r0,56","w":160},"\u2219":{"d":"51,-121r-46,0r0,-37r46,0r0,37","w":55},"\u201a":{"d":"22,30r-10,-8v8,-8,12,-15,13,-22r-20,0r0,-37r46,0v2,36,-2,48,-29,67","w":56},"\u201e":{"d":"75,30r-10,-8v8,-8,12,-15,13,-22r-20,0r0,-37r46,0v2,36,-2,49,-29,67xm23,30r-10,-8v8,-8,12,-15,13,-22r-20,0r0,-37r46,0v2,36,-2,49,-29,67","w":109},"\u2030":{"d":"33,-153v-41,2,-24,-50,-24,-83v0,-12,8,-18,24,-18v42,-2,25,51,25,84v0,11,-9,17,-25,17xm33,-166v8,-17,0,-50,3,-72v0,-2,-1,-3,-3,-3v-8,17,0,50,-3,72v0,2,1,3,3,3xm119,-252r-91,252r-24,0r91,-252r24,0xm93,3v-42,2,-24,-51,-24,-83v0,-12,8,-18,24,-18v42,-2,25,52,25,85v0,11,-9,16,-25,16xm97,-13r0,-69v0,-2,-2,-3,-4,-3v-8,17,0,50,-3,72v0,2,1,3,3,3v2,0,4,-1,4,-3xm150,3v-43,0,-25,-50,-25,-83v0,-12,9,-17,25,-17v42,-2,24,52,24,84v0,11,-8,16,-24,16xm150,-9v8,-17,0,-50,3,-73v0,-2,-1,-3,-3,-3v-2,0,-4,1,-4,3r0,70v0,2,2,3,4,3","w":181},"\u00c2":{"d":"156,0r-55,0r-9,-68r-25,0r-10,68r-54,0r41,-252r70,0xm87,-103r-8,-75r-7,75r15,0xm132,-264r-36,0r-15,-23r-16,23r-35,0r27,-41r47,0","w":158},"\u00ca":{"d":"114,0r-108,0r0,-252r108,0r0,32r-52,0r0,68r47,0r0,31r-47,0r0,89r52,0r0,32xm111,-264r-36,0r-15,-23r-16,23r-35,0r27,-41r47,0","w":117},"\u00c1":{"d":"156,0r-55,0r-9,-68r-25,0r-10,68r-54,0r41,-252r70,0xm87,-103r-8,-75r-7,75r15,0xm114,-296r-21,32r-27,0r10,-32r38,0","w":158},"\u00cb":{"d":"114,0r-108,0r0,-252r108,0r0,32r-52,0r0,68r47,0r0,31r-47,0r0,89r52,0r0,32xm69,-281v0,-10,7,-17,17,-17v11,0,18,6,18,17v-1,9,-8,17,-18,17v-12,0,-17,-6,-17,-17xm19,-281v0,-10,7,-17,17,-17v11,0,17,6,17,17v0,10,-8,18,-17,17v-12,0,-17,-6,-17,-17","w":117},"\u00c8":{"d":"114,0r-108,0r0,-252r108,0r0,32r-52,0r0,68r47,0r0,31r-47,0r0,89r52,0r0,32xm73,-264r-27,0r-21,-32r38,0","w":117},"\u00cd":{"d":"60,0r-55,0r0,-252r55,0r0,252xm63,-296r-21,32r-27,0r10,-32r38,0","w":65},"\u00ce":{"d":"60,0r-55,0r0,-252r55,0r0,252xm86,-264r-36,0r-15,-23r-16,23r-35,0r27,-41r47,0","w":65},"\u00cf":{"d":"60,0r-55,0r0,-252r55,0r0,252xm41,-281v0,-10,7,-17,17,-17v11,0,18,6,18,17v-1,9,-8,17,-18,17v-12,0,-17,-6,-17,-17xm-9,-281v0,-10,7,-17,17,-17v11,0,17,6,17,17v0,10,-8,18,-17,17v-12,0,-17,-6,-17,-17","w":65},"\u00cc":{"d":"60,0r-55,0r0,-252r55,0r0,252xm49,-264r-27,0r-21,-32r38,0","w":65},"\u00d3":{"d":"132,-43v0,32,-30,45,-63,45v-42,0,-63,-15,-63,-45r0,-162v0,-33,21,-49,63,-49v42,0,63,16,63,48r0,163xm78,-40r0,-172v0,-5,-3,-8,-9,-8v-6,0,-9,3,-9,8r0,172v0,5,3,7,9,7v6,0,9,-2,9,-7xm103,-296r-21,32r-27,0r10,-32r38,0","w":137},"\u00d4":{"d":"132,-43v0,32,-30,45,-63,45v-42,0,-63,-15,-63,-45r0,-162v0,-33,21,-49,63,-49v42,0,63,16,63,48r0,163xm78,-40r0,-172v0,-5,-3,-8,-9,-8v-6,0,-9,3,-9,8r0,172v0,5,3,7,9,7v6,0,9,-2,9,-7xm121,-264r-36,0r-15,-23r-16,23r-35,0r27,-41r47,0","w":137},"\u00d2":{"d":"132,-43v0,32,-30,45,-63,45v-42,0,-63,-15,-63,-45r0,-162v0,-33,21,-49,63,-49v42,0,63,16,63,48r0,163xm78,-40r0,-172v0,-5,-3,-8,-9,-8v-6,0,-9,3,-9,8r0,172v0,5,3,7,9,7v6,0,9,-2,9,-7xm89,-264r-27,0r-21,-32r38,0","w":137},"\u00da":{"d":"70,2v-32,0,-64,-12,-64,-45r0,-209r55,0r0,212v0,5,3,7,9,7v6,0,10,-2,10,-7r0,-212r55,0r0,209v0,32,-31,45,-65,45xm101,-296r-21,32r-27,0r10,-32r38,0","w":140},"\u00db":{"d":"70,2v-32,0,-64,-12,-64,-45r0,-209r55,0r0,212v0,5,3,7,9,7v6,0,10,-2,10,-7r0,-212r55,0r0,209v0,32,-31,45,-65,45xm123,-264r-36,0r-15,-23r-16,23r-35,0r27,-41r47,0","w":140},"\u00d9":{"d":"70,2v-32,0,-64,-12,-64,-45r0,-209r55,0r0,212v0,5,3,7,9,7v6,0,10,-2,10,-7r0,-212r55,0r0,209v0,32,-31,45,-65,45xm86,-264r-27,0r-21,-32r38,0","w":140},"\u0131":{"d":"55,0r-50,0r0,-204r50,0r0,204","w":59},"\u02c6":{"d":"107,-220r-36,0r-15,-23r-16,23r-35,0r27,-41r47,0","w":111},"\u02dc":{"d":"4,-220v-4,-47,50,-45,81,-32v4,0,7,-3,7,-9r32,0v-1,20,-16,43,-40,41v-12,3,-47,-25,-47,0r-33,0","w":127},"\u02c9":{"d":"76,-226r-72,0r0,-29r72,0r0,29","w":80},"\u02d8":{"d":"106,-261v-3,28,-20,41,-51,41v-31,0,-49,-13,-51,-41r27,0v2,24,46,24,47,0r28,0","w":109},"\u02d9":{"d":"50,-220r-46,0r0,-36r46,0r0,36","w":53},"\u02da":{"d":"38,-288v21,1,33,14,34,36v0,18,-15,33,-34,32v-19,-1,-33,-15,-34,-34v-1,-17,17,-35,34,-34xm38,-242v8,0,13,-4,13,-13v0,-8,-5,-11,-13,-11v-8,0,-12,4,-12,12v0,8,4,12,12,12","w":75},"\u00b8":{"d":"50,37v3,-14,19,-1,21,-15v-1,-8,-5,-10,-13,-6r0,-17r20,0r0,6v24,8,19,40,-13,38v-6,0,-11,-2,-15,-6","w":295},"\u02dd":{"d":"134,-265r-28,42r-35,0r13,-42r50,0xm72,-265r-28,42r-35,0r13,-42r50,0","w":142},"\u02db":{"d":"96,37v-14,12,-48,7,-48,-17v0,-8,4,-14,10,-20r24,0v-9,4,-13,28,1,28v5,0,10,-1,13,-4r0,13","w":127},"\u02c7":{"d":"107,-261r-28,41r-47,0r-27,-41r35,0r16,23r15,-23r36,0","w":111},"\u0141":{"d":"136,0r-105,0r0,-115r-25,10r0,-40r25,-11r0,-96r56,0r0,74r29,-12r0,40r-29,12r0,106r49,0r0,32","w":141},"\u0142":{"d":"104,-148r-24,11r0,137r-50,0r0,-115r-25,10r0,-40r25,-11r0,-96r50,0r0,75r24,-11r0,40","w":108},"\u0160":{"d":"59,-205v-2,62,73,73,73,125v0,54,-6,82,-64,82v-68,0,-64,-43,-62,-103r50,0r0,58v0,6,4,9,11,9v17,0,7,-25,10,-39v-9,-43,-71,-64,-71,-104v0,-52,8,-77,64,-77v58,0,60,35,57,88r-50,0r0,-47v0,-5,-2,-7,-8,-7v-6,0,-10,5,-10,15xm122,-305r-28,41r-47,0r-27,-41r35,0r16,23r15,-23r36,0","w":137},"\u0161":{"d":"55,-158v-13,50,66,37,68,87v2,49,-6,74,-60,74v-60,0,-61,-32,-58,-85r50,0v3,18,-8,50,9,54v14,-2,8,-52,-2,-54v-46,-26,-57,-18,-55,-80v0,-29,19,-43,58,-43v57,0,60,30,57,81r-49,0v1,-15,3,-51,-8,-50v-6,0,-10,5,-10,16xm117,-261r-28,41r-47,0r-27,-41r35,0r16,23r15,-23r36,0","w":127},"\u017d":{"d":"128,0r-124,0r0,-32r61,-187r-58,0r0,-33r117,0r0,33r-60,187r64,0r0,32xm125,-305r-28,41r-47,0r-27,-41r35,0r16,23r15,-23r36,0","w":132},"\u017e":{"d":"125,0r-120,0r0,-28r57,-143r-54,0r0,-33r112,0r0,28r-58,144r63,0r0,32xm121,-261r-28,41r-47,0r-27,-41r35,0r16,23r15,-23r36,0"},"\u00a6":{"d":"60,-136r-54,0r0,-116r54,0r0,116xm60,0r-54,0r0,-116r54,0r0,116","w":65},"\u00d0":{"d":"143,-50v0,57,-69,51,-128,50r0,-121r-8,0r0,-31r8,0r0,-100v59,0,128,-9,128,50r0,152xm88,-46r0,-160v0,-9,-6,-14,-17,-14r0,68r12,0r0,31r-12,0r0,89v11,0,17,-5,17,-14","w":152},"\u00f0":{"d":"133,-43v0,32,-31,46,-64,46v-66,0,-63,-39,-63,-98v0,-39,59,-36,72,-72r-42,18r0,-40r42,-18v1,-8,-1,-13,-9,-13v-6,0,-9,6,-9,16r-54,0v0,-33,21,-50,63,-50v32,0,51,9,59,26r24,-11r0,40r-19,9r0,147xm78,-41r0,-76v-31,5,-13,46,-18,76v0,6,3,9,9,9v6,0,9,-3,9,-9","w":151},"\u00dd":{"d":"157,-252r-54,152r0,100r-55,0v-2,-62,2,-97,-15,-150r-32,-102r53,0r25,89r29,-89r49,0xm114,-296r-21,32r-27,0r10,-32r38,0","w":158},"\u00fd":{"d":"20,16v22,-1,27,3,29,-14v-3,-22,-37,-161,-48,-206r50,0r21,108r17,-108r49,0r-39,203v-3,49,-32,44,-79,44r0,-27xm103,-252r-21,32r-27,0r10,-32r38,0","w":139},"\u00de":{"d":"60,-207v52,1,73,6,73,44r0,70v0,30,-25,45,-73,45r0,48r-53,0r0,-252r53,0r0,45xm60,-84v34,0,19,-46,19,-74v0,-9,-7,-13,-19,-13r0,87","w":139},"\u00fe":{"d":"124,-25v1,29,-48,34,-67,20r0,48r-50,0r0,-295r50,0r0,54v18,-14,67,-8,67,21r0,152xm74,-38r0,-127v0,-6,-3,-9,-9,-9v-6,0,-8,3,-8,9r0,127v0,6,2,9,8,9v6,0,9,-3,9,-9","w":132},"\u2212":{"d":"133,-122r-126,0r0,-28r126,0r0,28","w":134},"\u00d7":{"d":"28,-72r56,-55r-56,-55r22,-22r55,55r55,-55r21,22r-55,55r56,55r-22,21r-55,-55r-55,55","w":210},"\u00b9":{"d":"49,-126r-28,0r0,-93r-11,0r0,-18v9,0,14,-5,14,-15r25,0r0,126","w":59},"\u00b2":{"d":"29,-209r-25,0v-1,-28,0,-46,31,-45v22,0,33,12,33,34v0,11,-11,36,-34,76r34,0r0,17r-64,0v0,-46,36,-56,37,-101v0,-5,-2,-7,-6,-7v-10,0,-5,17,-6,26","w":72},"\u00b3":{"d":"5,-179r25,0v2,11,-6,32,6,34v6,-6,12,-43,-8,-42r0,-15v13,1,13,-9,13,-22v0,-11,-10,-14,-11,-4r0,20r-25,0v-1,-28,-2,-47,31,-46v40,-7,40,49,17,61v25,9,23,76,-17,68v-35,2,-32,-23,-31,-54","w":72},"\u00bd":{"d":"50,-126r-27,0r0,-93r-11,0r0,-18v10,0,14,-5,14,-15r24,0r0,126xm162,-252r-126,252r-29,0r125,-252r30,0xm145,-127v26,1,31,12,32,38v0,9,-12,33,-34,73r34,0r0,16r-63,0v0,-46,35,-54,36,-99v0,-5,-2,-8,-6,-8v-9,-1,-8,18,-5,26r-25,0v-1,-28,0,-47,31,-46","w":183},"\u00bc":{"d":"14,-237v7,0,14,-7,14,-15r24,0r0,126r-28,0r0,-93r-10,0r0,-18xm164,-252r-126,252r-30,0r126,-252r30,0xm175,-16r-13,0r0,16r-28,0r0,-16r-37,0v1,-45,19,-72,27,-110r38,0r0,91r13,0r0,19xm134,-35r0,-50r-12,50r12,0","w":183},"\u00be":{"d":"5,-179r25,0v2,11,-6,32,6,34v6,-6,12,-43,-8,-42r0,-15v13,1,13,-9,13,-22v0,-11,-10,-14,-11,-4r0,20r-25,0v-1,-28,-2,-47,31,-46v40,-7,40,49,17,61v25,9,23,76,-17,68v-35,2,-32,-23,-31,-54xm165,-252r-127,252r-29,0r126,-252r30,0xm169,-16r-14,0r0,16r-27,0r0,-16r-37,0v1,-45,19,-72,27,-110r37,0r0,91r14,0r0,19xm128,-35r0,-50r-12,50r12,0","w":173},"\u20a3":{"d":"129,-220r-48,0r0,68r43,0r0,31r-43,0r0,48r31,0r0,30r-31,0r0,43r-55,0r0,-43r-19,0r0,-30r19,0r0,-179r103,0r0,32","w":133},"\u011e":{"d":"94,-14v-28,29,-88,19,-88,-27r0,-164v0,-33,20,-49,62,-49v62,0,63,35,60,91r-50,0r0,-51v0,-4,-3,-6,-9,-6v-6,0,-8,2,-8,6r0,175v0,4,2,6,8,6v19,-2,5,-36,9,-53r-12,0r0,-39r62,0r0,125r-27,0xm120,-305v-3,28,-20,41,-51,41v-31,0,-49,-13,-51,-41r27,0v2,24,46,24,47,0r28,0","w":133},"\u011f":{"d":"123,-3v8,56,-56,45,-109,46r0,-29v24,-2,61,9,59,-19v-19,15,-69,9,-68,-20r0,-147v-2,-33,40,-42,68,-25v7,-12,33,-5,50,-7r0,201xm73,-36r0,-129v0,-6,-3,-9,-9,-9v-6,0,-9,3,-9,9r0,128v0,6,3,10,9,10v6,0,9,-3,9,-9xm117,-261v-3,28,-20,41,-51,41v-31,0,-49,-13,-51,-41r27,0v2,24,46,24,47,0r28,0"},"\u0130":{"d":"60,0r-55,0r0,-252r55,0r0,252xm56,-282r-46,0r0,-36r46,0r0,36","w":65},"\u015e":{"d":"59,-205v-2,62,73,73,73,125v0,54,-6,82,-64,82v-68,0,-64,-43,-62,-103r50,0r0,58v0,6,4,9,11,9v17,0,7,-25,10,-39v-9,-43,-71,-64,-71,-104v0,-52,8,-77,64,-77v58,0,60,35,57,88r-50,0r0,-47v0,-5,-2,-7,-8,-7v-6,0,-10,5,-10,15xm50,37v3,-14,19,-1,21,-15v-1,-8,-5,-10,-13,-6r0,-17r20,0r0,6v24,8,19,40,-13,38v-6,0,-11,-2,-15,-6","w":137},"\u015f":{"d":"55,-158v-13,50,66,37,68,87v2,49,-6,74,-60,74v-60,0,-61,-32,-58,-85r50,0v3,18,-8,50,9,54v14,-2,8,-52,-2,-54v-46,-26,-57,-18,-55,-80v0,-29,19,-43,58,-43v57,0,60,30,57,81r-49,0v1,-15,3,-51,-8,-50v-6,0,-10,5,-10,16xm46,37v3,-14,19,-1,21,-15v-1,-8,-5,-10,-13,-6r0,-17r20,0r0,6v24,8,19,40,-13,38v-6,0,-11,-2,-15,-6","w":127},"\u0106":{"d":"127,-37v1,26,-31,39,-57,39v-43,0,-64,-15,-64,-45r0,-162v0,-33,21,-49,64,-49v59,0,60,36,57,90r-50,0r0,-50v0,-4,-3,-6,-8,-6v-5,0,-8,2,-8,6r0,175v0,4,3,6,8,6v5,0,8,-2,8,-6r0,-62r50,0r0,64xm101,-296r-21,32r-27,0r10,-32r38,0","w":133},"\u0107":{"d":"123,-114r-50,0v-3,-19,9,-56,-9,-60v-6,0,-9,3,-9,10r0,125v0,7,3,11,9,11v18,-4,5,-41,9,-60r50,0v2,54,5,91,-58,91v-92,0,-60,-93,-60,-165v0,-29,20,-43,60,-43v63,0,60,36,58,91xm98,-252r-21,32r-27,0r10,-32r38,0"},"\u010c":{"d":"127,-37v1,26,-31,39,-57,39v-43,0,-64,-15,-64,-45r0,-162v0,-33,21,-49,64,-49v59,0,60,36,57,90r-50,0r0,-50v0,-4,-3,-6,-8,-6v-5,0,-8,2,-8,6r0,175v0,4,3,6,8,6v5,0,8,-2,8,-6r0,-62r50,0r0,64xm121,-305r-28,41r-47,0r-27,-41r35,0r16,23r15,-23r36,0","w":133},"\u010d":{"d":"123,-114r-50,0v-3,-19,9,-56,-9,-60v-6,0,-9,3,-9,10r0,125v0,7,3,11,9,11v18,-4,5,-41,9,-60r50,0v2,54,5,91,-58,91v-92,0,-60,-93,-60,-165v0,-29,20,-43,60,-43v63,0,60,36,58,91xm118,-261r-28,41r-47,0r-27,-41r35,0r16,23r15,-23r36,0"},"\u0111":{"d":"7,-176v-2,-30,47,-34,67,-21r0,-20r-29,0r0,-16r29,0r0,-19r50,0r0,19r23,0r0,16r-23,0r0,217v-14,-2,-39,6,-42,-7v-24,20,-75,9,-75,-24r0,-145xm74,-38r0,-125v0,-6,-3,-9,-9,-9v-6,0,-8,3,-8,9r0,125v0,6,2,9,8,9v6,0,9,-3,9,-9","w":149},"\u00af":{"d":"134,-276r-135,0r0,-29r135,0r0,29","w":133},"\u00b7":{"d":"51,-121r-46,0r0,-37r46,0r0,37","w":55},"\u0102":{"d":"156,0r-55,0r-9,-68r-25,0r-10,68r-54,0r41,-252r70,0xm87,-103r-8,-75r-7,75r15,0xm131,-305v-3,28,-20,41,-51,41v-31,0,-49,-13,-51,-41r27,0v2,24,46,24,47,0r28,0","w":158},"\u0103":{"d":"6,-70v-2,-36,51,-42,68,-64v-2,-14,6,-40,-9,-40v-14,0,-9,33,-9,51r-48,0v-3,-53,0,-82,60,-82v37,0,56,14,56,43r0,162r-45,0r0,-8v-13,20,-82,13,-73,-21r0,-41xm65,-29v19,-5,5,-42,9,-62v-26,3,-17,28,-18,53v0,6,3,9,9,9xm117,-261v-3,28,-20,41,-51,41v-31,0,-49,-13,-51,-41r27,0v2,24,46,24,47,0r28,0","w":129},"\u0104":{"d":"156,0r-55,0r-9,-68r-25,0r-10,68r-54,0r41,-252r70,0xm87,-103r-8,-75r-7,75r15,0xm163,37v-14,12,-48,7,-48,-17v0,-8,4,-14,10,-20r24,0v-9,4,-13,28,1,28v5,0,10,-1,13,-4r0,13","w":158},"\u0105":{"d":"6,-70v-2,-36,51,-42,68,-64v-2,-14,6,-40,-9,-40v-14,0,-9,33,-9,51r-48,0v-3,-53,0,-82,60,-82v37,0,56,14,56,43r0,162r-45,0r0,-8v-13,20,-82,13,-73,-21r0,-41xm65,-29v19,-5,5,-42,9,-62v-26,3,-17,28,-18,53v0,6,3,9,9,9xm126,37v-14,12,-48,7,-48,-17v0,-8,4,-14,10,-20r24,0v-9,4,-13,28,1,28v5,0,10,-1,13,-4r0,13","w":129},"\u010e":{"d":"132,-50v1,58,-68,51,-127,50r0,-252v59,0,127,-8,127,50r0,152xm76,-46r0,-160v0,-9,-5,-14,-15,-14r0,188v10,0,15,-5,15,-14xm119,-305r-28,41r-47,0r-27,-41r35,0r16,23r15,-23r36,0","w":137},"\u010f":{"d":"5,-177v-2,-30,48,-34,68,-21r0,-54r50,0r0,252v-14,-2,-39,6,-42,-7v-24,20,-76,8,-76,-24r0,-146xm73,-38r0,-127v0,-6,-3,-9,-9,-9v-6,0,-9,3,-9,9r0,127v0,6,3,9,9,9v6,0,9,-3,9,-9xm150,-185r-10,-8v8,-8,12,-15,13,-22r-20,0r0,-37r46,0v2,36,-1,48,-29,67","w":184},"\u0110":{"d":"139,-50v1,58,-68,51,-127,50r0,-121r-9,0r0,-31r9,0r0,-100v59,0,127,-8,127,50r0,152xm84,-46r0,-160v0,-9,-6,-14,-17,-14r0,68r12,0r0,31r-12,0r0,89v11,0,17,-5,17,-14","w":146},"\u0118":{"d":"114,0r-108,0r0,-252r108,0r0,32r-52,0r0,68r47,0r0,31r-47,0r0,89r52,0r0,32xm114,37v-14,12,-48,7,-48,-17v0,-8,4,-14,10,-20r24,0v-9,4,-13,28,1,28v5,0,10,-1,13,-4r0,13","w":117},"\u0119":{"d":"123,-86r-67,0v3,19,-8,53,8,58v17,-3,6,-35,9,-52r50,0v3,52,1,83,-59,83v-90,0,-58,-94,-58,-165v0,-29,19,-43,58,-43v75,0,57,57,59,119xm73,-117v-3,-18,9,-53,-9,-57v-17,4,-4,39,-8,57r17,0xm100,37v-14,12,-48,7,-48,-17v0,-8,4,-14,10,-20r24,0v-9,4,-13,28,1,28v5,0,10,-1,13,-4r0,13"},"\u011a":{"d":"114,0r-108,0r0,-252r108,0r0,32r-52,0r0,68r47,0r0,31r-47,0r0,89r52,0r0,32xm111,-305r-28,41r-47,0r-27,-41r35,0r16,23r15,-23r36,0","w":117},"\u011b":{"d":"123,-86r-67,0v3,19,-8,53,8,58v17,-3,6,-35,9,-52r50,0v3,52,1,83,-59,83v-90,0,-58,-94,-58,-165v0,-29,19,-43,58,-43v75,0,57,57,59,119xm73,-117v-3,-18,9,-53,-9,-57v-17,4,-4,39,-8,57r17,0xm118,-261r-28,41r-47,0r-27,-41r35,0r16,23r15,-23r36,0"},"\u0139":{"d":"111,0r-104,0r0,-252r55,0r0,220r49,0r0,32xm73,-296r-21,32r-27,0r10,-32r38,0","w":113},"\u013a":{"d":"56,0r-50,0r0,-252r50,0r0,252xm63,-296r-21,32r-27,0r10,-32r38,0","w":61},"\u013d":{"d":"111,0r-104,0r0,-252r55,0r0,220r49,0r0,32xm99,-185r-10,-8v8,-8,12,-15,13,-22r-20,0r0,-37r46,0v2,36,-1,48,-29,67","w":131},"\u013e":{"d":"56,0r-50,0r0,-252r50,0r0,252xm84,-185r-10,-8v8,-8,12,-15,13,-22r-20,0r0,-37r46,0v2,36,-1,48,-29,67","w":118},"\u013f":{"d":"111,0r-104,0r0,-252r55,0r0,220r49,0r0,32xm115,-122r-46,0r0,-37r46,0r0,37","w":113},"\u0140":{"d":"56,0r-50,0r0,-252r50,0r0,252xm112,-121r-46,0r0,-37r46,0r0,37","w":116},"\u0143":{"d":"147,0r-57,0r-38,-134r0,134r-46,0r0,-252r63,0r32,115r0,-115r46,0r0,252xm110,-296r-21,32r-27,0r10,-32r38,0","w":152},"\u0144":{"d":"56,-197v19,-16,67,-8,67,21r0,176r-50,0r0,-164v0,-6,-3,-9,-9,-9v-6,0,-8,3,-8,9r0,164r-51,0r0,-204r51,0r0,7xm94,-252r-21,32r-27,0r10,-32r38,0"},"\u0147":{"d":"147,0r-57,0r-38,-134r0,134r-46,0r0,-252r63,0r32,115r0,-115r46,0r0,252xm128,-305r-28,41r-47,0r-27,-41r35,0r16,23r15,-23r36,0","w":152},"\u0148":{"d":"56,-197v19,-16,67,-8,67,21r0,176r-50,0r0,-164v0,-6,-3,-9,-9,-9v-6,0,-8,3,-8,9r0,164r-51,0r0,-204r51,0r0,7xm116,-261r-28,41r-47,0r-27,-41r35,0r16,23r15,-23r36,0"},"\u0150":{"d":"132,-43v0,32,-30,45,-63,45v-42,0,-63,-15,-63,-45r0,-162v0,-33,21,-49,63,-49v42,0,63,16,63,48r0,163xm78,-40r0,-172v0,-5,-3,-8,-9,-8v-6,0,-9,3,-9,8r0,172v0,5,3,7,9,7v6,0,9,-2,9,-7xm141,-309r-28,42r-35,0r13,-42r50,0xm79,-309r-28,42r-35,0r13,-42r50,0","w":137},"\u0151":{"d":"64,-205v28,0,58,12,58,41r0,126v0,28,-19,41,-58,41v-91,0,-59,-94,-59,-165v0,-29,19,-43,59,-43xm72,-39r0,-125v0,-7,-3,-10,-9,-10v-6,0,-8,3,-8,10r0,125v0,7,2,11,8,11v6,0,9,-4,9,-11xm136,-265r-28,42r-35,0r13,-42r50,0xm74,-265r-28,42r-35,0r13,-42r50,0","w":126},"\u0154":{"d":"7,-252v56,1,125,-10,126,45v1,38,0,61,-34,70v33,6,34,32,34,69v0,40,3,63,10,68r-55,0v-11,-10,-9,-76,-9,-108v0,-9,-6,-13,-17,-13r0,121r-55,0r0,-252xm62,-152v27,2,17,-32,17,-54v0,-9,-6,-14,-17,-14r0,68xm95,-296r-21,32r-27,0r10,-32r38,0","w":144},"\u0155":{"d":"57,-197v19,-15,67,-10,67,21r0,56r-50,0v-3,-17,8,-49,-8,-53v-6,0,-9,3,-9,9r0,164r-50,0r0,-204r50,0r0,7xm87,-252r-21,32r-27,0r10,-32r38,0"},"\u0158":{"d":"7,-252v56,1,125,-10,126,45v1,38,0,61,-34,70v33,6,34,32,34,69v0,40,3,63,10,68r-55,0v-11,-10,-9,-76,-9,-108v0,-9,-6,-13,-17,-13r0,121r-55,0r0,-252xm62,-152v27,2,17,-32,17,-54v0,-9,-6,-14,-17,-14r0,68xm119,-305r-28,41r-47,0r-27,-41r35,0r16,23r15,-23r36,0","w":144},"\u0159":{"d":"57,-197v19,-15,67,-10,67,21r0,56r-50,0v-3,-17,8,-49,-8,-53v-6,0,-9,3,-9,9r0,164r-50,0r0,-204r50,0r0,7xm114,-261r-28,41r-47,0r-27,-41r35,0r16,23r15,-23r36,0"},"\u015a":{"d":"59,-205v-2,62,73,73,73,125v0,54,-6,82,-64,82v-68,0,-64,-43,-62,-103r50,0r0,58v0,6,4,9,11,9v17,0,7,-25,10,-39v-9,-43,-71,-64,-71,-104v0,-52,8,-77,64,-77v58,0,60,35,57,88r-50,0r0,-47v0,-5,-2,-7,-8,-7v-6,0,-10,5,-10,15xm99,-296r-21,32r-27,0r10,-32r38,0","w":137},"\u015b":{"d":"55,-158v-13,50,66,37,68,87v2,49,-6,74,-60,74v-60,0,-61,-32,-58,-85r50,0v3,18,-8,50,9,54v14,-2,8,-52,-2,-54v-46,-26,-57,-18,-55,-80v0,-29,19,-43,58,-43v57,0,60,30,57,81r-49,0v1,-15,3,-51,-8,-50v-6,0,-10,5,-10,16xm96,-252r-21,32r-27,0r10,-32r38,0","w":127},"\u0162":{"d":"122,-219r-31,0r0,219r-56,0r0,-219r-31,0r0,-33r118,0r0,33xm57,75r-10,-9v8,-8,12,-15,13,-22r-20,0r0,-36r46,0v2,36,-2,49,-29,67","w":126},"\u0163":{"d":"76,-50v0,16,10,14,29,15r0,35r-32,0v-45,0,-47,-8,-47,-49r0,-125r-22,0r0,-30r22,0r0,-41r50,0r0,41r27,0r0,30r-27,0r0,124xm61,75r-10,-9v8,-8,12,-15,13,-22r-20,0r0,-36r46,0v2,36,-2,49,-29,67","w":108},"\u0164":{"d":"122,-219r-31,0r0,219r-56,0r0,-219r-31,0r0,-33r118,0r0,33xm116,-305r-28,41r-47,0r-27,-41r35,0r16,23r15,-23r36,0","w":126},"\u0165":{"d":"76,-50v0,16,10,14,29,15r0,35r-32,0v-45,0,-47,-8,-47,-49r0,-125r-22,0r0,-30r22,0r0,-41r50,0r0,41r27,0r0,30r-27,0r0,124xm124,-185r-10,-8v8,-8,12,-15,13,-22r-20,0r0,-37r46,0v2,36,-1,48,-29,67","w":158},"\u016e":{"d":"70,2v-32,0,-64,-12,-64,-45r0,-209r55,0r0,212v0,5,3,7,9,7v6,0,10,-2,10,-7r0,-212r55,0r0,209v0,32,-31,45,-65,45xm71,-332v21,1,33,14,34,36v0,18,-15,33,-34,32v-19,-1,-33,-15,-34,-34v-1,-17,17,-35,34,-34xm71,-286v8,0,13,-4,13,-13v0,-8,-5,-11,-13,-11v-8,0,-12,4,-12,12v0,8,4,12,12,12","w":140},"\u016f":{"d":"73,-7v-16,17,-68,12,-68,-18r0,-179r50,0r0,166v0,6,3,9,9,9v6,0,9,-3,9,-9r0,-166r50,0r0,204r-50,0r0,-7xm64,-288v21,1,33,14,34,36v0,18,-15,33,-34,32v-19,-1,-33,-15,-34,-34v-1,-17,17,-35,34,-34xm64,-242v8,0,13,-4,13,-13v0,-8,-5,-11,-13,-11v-8,0,-12,4,-12,12v0,8,4,12,12,12"},"\u0170":{"d":"70,2v-32,0,-64,-12,-64,-45r0,-209r55,0r0,212v0,5,3,7,9,7v6,0,10,-2,10,-7r0,-212r55,0r0,209v0,32,-31,45,-65,45xm144,-309r-28,42r-35,0r13,-42r50,0xm82,-309r-28,42r-35,0r13,-42r50,0","w":140},"\u0171":{"d":"73,-7v-16,17,-68,12,-68,-18r0,-179r50,0r0,166v0,6,3,9,9,9v6,0,9,-3,9,-9r0,-166r50,0r0,204r-50,0r0,-7xm138,-265r-28,42r-35,0r13,-42r50,0xm76,-265r-28,42r-35,0r13,-42r50,0"},"\u0179":{"d":"128,0r-124,0r0,-32r61,-187r-58,0r0,-33r117,0r0,33r-60,187r64,0r0,32xm103,-296r-21,32r-27,0r10,-32r38,0","w":132},"\u017a":{"d":"125,0r-120,0r0,-28r57,-143r-54,0r0,-33r112,0r0,28r-58,144r63,0r0,32xm96,-252r-21,32r-27,0r10,-32r38,0"},"\u017b":{"d":"128,0r-124,0r0,-32r61,-187r-58,0r0,-33r117,0r0,33r-60,187r64,0r0,32xm85,-264r-46,0r0,-36r46,0r0,36","w":132},"\u017c":{"d":"125,0r-120,0r0,-28r57,-143r-54,0r0,-33r112,0r0,28r-58,144r63,0r0,32xm89,-220r-46,0r0,-36r46,0r0,36"},"\u0393":{"d":"85,-225v-22,1,-29,-2,-29,16r0,209r-50,0r0,-212v-8,-49,38,-39,79,-40r0,27","w":86},"\u0398":{"d":"5,-43r0,-162v0,-33,23,-49,69,-49v46,0,69,17,69,49r0,162v0,30,-23,46,-69,46v-46,0,-69,-16,-69,-46xm88,-46r0,-160v0,-9,-5,-13,-14,-13v-10,0,-15,4,-15,13r0,160v0,9,5,14,15,14v9,0,14,-5,14,-14xm65,-148r18,0r0,43r-18,0r0,-43","w":148},"\u03a6":{"d":"97,-37r0,37r-56,0r0,-37v-54,-11,-35,-77,-35,-132v0,-25,11,-40,35,-46r0,-37r56,0r0,37v53,10,35,81,35,136v0,21,-11,35,-35,42xm78,-76r0,-100v0,-5,-3,-7,-9,-7v-6,0,-9,2,-9,7r0,100v0,5,3,8,9,8v6,0,9,-3,9,-8","w":137},"\u03b1":{"d":"6,-171v-3,-31,57,-42,73,-21r0,-11r45,0r0,203r-45,0r0,-11v-14,20,-73,12,-73,-21r0,-139xm74,-41r0,-121v0,-6,-3,-9,-9,-9v-6,0,-9,3,-9,10r0,120v0,6,3,9,9,9v6,0,9,-3,9,-9","w":129},"\u03b4":{"d":"6,-43v0,-43,-12,-94,30,-99v-30,-14,-27,-36,-27,-77v0,-23,18,-35,55,-35v56,-1,60,26,57,75r-48,0v4,-19,-3,-64,-15,-34v2,21,2,34,18,45v36,23,48,25,48,75r0,50v1,31,-27,46,-58,46v-33,1,-60,-16,-60,-46xm74,-41r0,-76v-31,5,-13,46,-18,76v0,6,3,9,10,9v5,0,8,-3,8,-9","w":129},"\u03b5":{"d":"123,0v-52,0,-123,8,-118,-44v7,-67,-29,-166,55,-160r63,0r0,39v-23,3,-68,-10,-68,13r0,30r68,0r0,37r-68,0v2,20,-8,45,17,45r51,0r0,40"},"\u03c3":{"d":"170,-174r-46,0r0,136v0,28,-19,41,-58,41v-91,0,-53,-94,-59,-165v-5,-62,104,-37,163,-42r0,30xm74,-39r0,-125v0,-7,-3,-10,-9,-10v-6,0,-8,3,-8,10r0,125v0,7,2,11,8,11v6,0,9,-4,9,-11","w":174},"\u03c4":{"d":"154,-175r-49,0r0,174r-50,0r0,-174r-48,0r0,-30r147,0r0,30","w":159},"\u03c6":{"d":"196,-55v0,54,-19,59,-72,60r0,36r-45,0r0,-36v-49,0,-74,-9,-73,-60v2,-72,-17,-155,66,-149r0,31v-18,1,-16,7,-16,29v0,35,-5,80,4,108v3,2,9,3,19,3v5,-70,-24,-171,55,-171v80,0,62,79,62,149xm124,-33v14,1,25,1,24,-15r0,-111v0,-9,-5,-14,-13,-14v-7,0,-11,5,-11,14r0,126","w":202},"\u2017":{"d":"133,18r-133,0r0,-18r133,0r0,18xm133,43r-133,0r0,-18r133,0r0,18","w":132},"\u203c":{"d":"55,-48r-50,0r0,-204r50,0r0,204xm55,0r-50,0r0,-37r50,0r0,37xm117,-48r-50,0r0,-204r50,0r0,204xm117,0r-50,0r0,-37r50,0r0,37","w":122},"\u207f":{"d":"62,-151r-25,0r0,-82v0,-3,-1,-5,-4,-5v-3,0,-4,2,-4,5r0,82r-25,0r0,-102r25,0r0,4v8,-9,33,-7,33,10r0,88","w":67},"\u20a7":{"d":"295,-158v-13,53,67,35,67,87v0,49,-4,74,-59,74v-60,0,-61,-32,-58,-85r50,0v3,18,-8,50,8,54v9,0,8,-16,8,-27v11,-42,-65,-33,-65,-80v0,-21,1,-33,1,-36r-42,0r0,121v0,16,10,14,29,15r0,35r-32,0v-45,0,-47,-8,-47,-49r0,-122r-22,0v6,72,-16,73,-73,78r0,93r-54,0r0,-252v60,4,132,-16,127,51r22,0r0,-41r50,0r0,41v58,5,155,-26,156,37r0,40r-49,0v-3,-16,8,-47,-8,-50v-6,0,-9,5,-9,16xm60,-129v33,1,12,-48,18,-74v0,-9,-6,-13,-18,-13r0,87","w":368},"\u2190":{"d":"14,-95v33,-17,46,-30,72,-59r14,0v-11,23,-15,29,-29,48r275,0r0,31r-275,0v13,18,19,25,29,47r-14,0v-26,-29,-39,-41,-72,-59r0,-8","w":360},"\u2191":{"d":"94,-235v18,33,30,44,59,72r0,14v-22,-11,-30,-16,-48,-30r0,254r-30,0r0,-254v-18,13,-26,20,-48,30r0,-14v29,-27,41,-40,59,-72r8,0","w":180},"\u2192":{"d":"346,-87v-33,18,-45,30,-73,59r-13,0v11,-22,15,-29,29,-47r-275,0r0,-31r275,0v-13,-18,-19,-26,-29,-48r13,0v27,29,40,41,73,59r0,8","w":360},"\u2193":{"d":"86,75v-18,-33,-30,-44,-59,-72r0,-14v22,11,30,16,48,30r0,-254r30,0r0,254v18,-13,26,-20,48,-30r0,14v-29,27,-41,40,-59,72r-8,0","w":180},"\u2194":{"d":"14,-95v33,-17,46,-30,72,-59r14,0v-11,23,-15,29,-29,48r218,0v-13,-18,-19,-26,-29,-48r13,0v27,29,40,41,73,59r0,8v-33,18,-45,30,-73,59r-13,0v11,-22,15,-28,29,-47r-218,0v13,18,19,25,29,47r-14,0v-26,-29,-39,-41,-72,-59r0,-8","w":360},"\u2195":{"d":"94,-257v18,33,30,45,59,73r0,13v-22,-11,-30,-15,-48,-29r0,218v18,-13,26,-19,48,-29r0,13v-29,27,-41,40,-59,73r-8,0v-18,-33,-30,-46,-59,-73r0,-13v23,12,29,15,48,29r0,-218v-18,13,-26,19,-48,29r0,-13v29,-27,41,-40,59,-73r8,0","w":180},"\u21a8":{"d":"94,-257v18,33,30,45,59,73r0,13v-22,-11,-30,-15,-48,-29r0,218v18,-13,26,-19,48,-29r0,13v-29,27,-41,40,-59,73r-8,0v-18,-33,-30,-46,-59,-73r0,-13v23,12,29,15,48,29r0,-218v-18,13,-26,19,-48,29r0,-13v29,-27,41,-40,59,-73r8,0xm27,88r126,0r0,31r-126,0r0,-31","w":180},"\u221f":{"d":"22,0r0,-313r23,0r0,289r293,0r0,24r-316,0","w":360},"\u2229":{"d":"70,-254v55,-2,114,0,114,49r0,206r-54,-1r0,-198v0,-23,-24,-24,-48,-22v-13,1,-21,9,-22,22r0,198r-54,0r0,-205v-1,-30,35,-48,64,-49","w":188},"\u2261":{"d":"133,-115r-127,0r0,-28r127,0r0,28xm133,-58r-127,0r0,-28r127,0r0,28xm133,0r-127,0r0,-28r127,0r0,28","w":137},"\u2302":{"d":"27,0r0,-111r81,-92r81,92r0,111r-162,0xm41,-14r134,0r0,-91r-67,-76r-67,76r0,91","w":216},"\u2310":{"d":"200,-106r-161,0r0,49r-32,0r0,-87r193,0r0,38","w":204},"\u2320":{"d":"156,-270v-15,2,-23,-30,-33,-10r-2,371r-25,0r0,-319v-1,-42,18,-73,51,-77v26,-3,34,32,9,35","w":217},"\u2321":{"d":"61,55v16,-2,23,30,34,10r1,-370r25,0r0,318v2,43,-18,74,-51,78v-25,3,-33,-33,-9,-36","w":217},"\u2500":{"d":"259,-94r-263,0r0,-31r263,0r0,31","w":255},"\u2502":{"d":"112,109r0,-437r31,0r0,437r-31,0","w":255},"\u250c":{"d":"259,-125r0,31r-116,0r0,203r-31,0r0,-234r147,0","w":255},"\u2510":{"d":"112,-94r-116,0r0,-31r147,0r0,234r-31,0r0,-203","w":255},"\u2514":{"d":"112,-94r0,-234r31,0r0,203r116,0r0,31r-147,0","w":255},"\u2518":{"d":"143,-94r-147,0r0,-31r116,0r0,-203r31,0r0,234","w":255},"\u251c":{"d":"112,109r0,-437r31,0r0,203r116,0r0,31r-116,0r0,203r-31,0","w":255},"\u2524":{"d":"112,109r0,-203r-116,0r0,-31r116,0r0,-203r31,0r0,437r-31,0","w":255},"\u252c":{"d":"112,-94r-116,0r0,-31r263,0r0,31r-116,0r0,203r-31,0r0,-203","w":255},"\u2534":{"d":"259,-94r-263,0r0,-31r116,0r0,-203r31,0r0,203r116,0r0,31","w":255},"\u253c":{"d":"112,-94r-116,0r0,-31r116,0r0,-203r31,0r0,203r116,0r0,31r-116,0r0,203r-31,0r0,-203","w":255},"\u2550":{"d":"259,-127r-263,0r0,-31r263,0r0,31xm259,-60r-263,0r0,-31r263,0r0,31","w":255},"\u2551":{"d":"146,109r0,-437r30,0r0,437r-30,0xm79,109r0,-437r31,0r0,437r-31,0","w":255},"\u2552":{"d":"112,109r0,-267r147,0r0,31r-116,0r0,36r116,0r0,31r-116,0r0,169r-31,0","w":255},"\u2553":{"d":"79,109r0,-234r180,0r0,31r-83,0r0,203r-30,0r0,-203r-36,0r0,203r-31,0","w":255},"\u2554":{"d":"110,109r-31,0r0,-267r180,0r0,31r-149,0r0,236xm176,-60r0,169r-30,0r0,-200r113,0r0,31r-83,0","w":255},"\u2555":{"d":"112,-60r-116,0r0,-31r116,0r0,-36r-116,0r0,-31r147,0r0,267r-31,0r0,-169","w":255},"\u2556":{"d":"79,109r0,-203r-83,0r0,-31r180,0r0,234r-30,0r0,-203r-37,0r0,203r-30,0","w":255},"\u2557":{"d":"146,109r0,-236r-150,0r0,-31r180,0r0,267r-30,0xm79,-60r-83,0r0,-31r113,0r0,200r-30,0r0,-169","w":255},"\u2558":{"d":"112,-60r0,-268r31,0r0,170r116,0r0,31r-116,0r0,36r116,0r0,31r-147,0","w":255},"\u2559":{"d":"259,-94r-180,0r0,-234r31,0r0,203r36,0r0,-203r30,0r0,203r83,0r0,31","w":255},"\u255a":{"d":"110,-328r0,237r149,0r0,31r-180,0r0,-268r31,0xm176,-158r83,0r0,31r-113,0r0,-201r30,0r0,170","w":255},"\u255b":{"d":"143,-60r-147,0r0,-31r116,0r0,-36r-116,0r0,-31r116,0r0,-170r31,0r0,268","w":255},"\u255c":{"d":"176,-94r-180,0r0,-31r83,0r0,-203r30,0r0,203r37,0r0,-203r30,0r0,234","w":255},"\u255d":{"d":"146,-328r30,0r0,268r-180,0r0,-31r150,0r0,-237xm79,-158r0,-170r30,0r0,201r-113,0r0,-31r83,0","w":255},"\u255e":{"d":"112,109r0,-437r31,0r0,170r116,0r0,31r-116,0r0,36r116,0r0,31r-116,0r0,169r-31,0","w":255},"\u255f":{"d":"146,109r0,-437r30,0r0,203r83,0r0,31r-83,0r0,203r-30,0xm79,109r0,-437r31,0r0,437r-31,0","w":255},"\u2560":{"d":"79,109r0,-437r31,0r0,437r-31,0xm146,-127r0,-201r30,0r0,170r83,0r0,31r-113,0xm146,109r0,-200r113,0r0,31r-83,0r0,169r-30,0","w":255},"\u2561":{"d":"112,-60r-116,0r0,-31r116,0r0,-36r-116,0r0,-31r116,0r0,-170r31,0r0,437r-31,0r0,-169","w":255},"\u2562":{"d":"79,109r0,-203r-83,0r0,-31r83,0r0,-203r30,0r0,437r-30,0xm146,109r0,-437r30,0r0,437r-30,0","w":255},"\u2563":{"d":"146,109r0,-437r30,0r0,437r-30,0xm109,-328r0,201r-113,0r0,-31r83,0r0,-170r30,0xm79,-60r-83,0r0,-31r113,0r0,200r-30,0r0,-169","w":255},"\u2564":{"d":"259,-127r-263,0r0,-31r263,0r0,31xm112,-60r-116,0r0,-31r263,0r0,31r-116,0r0,169r-31,0r0,-169","w":255},"\u2565":{"d":"79,109r0,-203r-83,0r0,-31r263,0r0,31r-83,0r0,203r-30,0r0,-203r-37,0r0,203r-30,0","w":255},"\u2566":{"d":"259,-127r-263,0r0,-31r263,0r0,31xm79,-60r-83,0r0,-31r113,0r0,200r-30,0r0,-169xm146,109r0,-200r113,0r0,31r-83,0r0,169r-30,0","w":255},"\u2567":{"d":"259,-127r-263,0r0,-31r116,0r0,-170r31,0r0,170r116,0r0,31xm259,-60r-263,0r0,-31r263,0r0,31","w":255},"\u2568":{"d":"259,-94r-263,0r0,-31r83,0r0,-203r30,0r0,203r37,0r0,-203r30,0r0,203r83,0r0,31","w":255},"\u2569":{"d":"109,-127r-113,0r0,-31r83,0r0,-170r30,0r0,201xm259,-127r-113,0r0,-201r30,0r0,170r83,0r0,31xm259,-60r-263,0r0,-31r263,0r0,31","w":255},"\u256a":{"d":"112,-60r-116,0r0,-31r116,0r0,-36r-116,0r0,-31r116,0r0,-170r31,0r0,170r116,0r0,31r-116,0r0,36r116,0r0,31r-116,0r0,169r-31,0r0,-169","w":255},"\u256b":{"d":"79,109r0,-203r-83,0r0,-31r83,0r0,-203r30,0r0,203r37,0r0,-203r30,0r0,203r83,0r0,31r-83,0r0,203r-30,0r0,-203r-37,0r0,203r-30,0","w":255},"\u256c":{"d":"176,-158r83,0r0,31r-113,0r0,-201r30,0r0,170xm79,-158r0,-170r30,0r0,201r-113,0r0,-31r83,0xm79,-60r-83,0r0,-31r113,0r0,200r-30,0r0,-169xm176,-60r0,169r-30,0r0,-200r113,0r0,31r-83,0","w":255},"\u2580":{"d":"259,-109r-263,0r0,-219r263,0r0,219","w":255},"\u2584":{"d":"259,109r-263,0r0,-218r263,0r0,218","w":255},"\u2588":{"d":"-4,109r0,-437r263,0r0,437r-263,0","w":255},"\u258c":{"d":"-4,109r0,-437r131,0r0,437r-131,0","w":255},"\u2590":{"d":"128,109r0,-437r131,0r0,437r-131,0","w":255},"\u2591":{"d":"0,-328r21,0r0,22r-21,0r0,-22xm85,-328r21,0r0,22r-21,0r0,-22xm170,-328r21,0r0,22r-21,0r0,-22xm42,-284r22,0r0,22r-22,0r0,-22xm127,-284r21,0r0,22r-21,0r0,-22xm212,-284r21,0r0,22r-21,0r0,-22xm170,-240r21,0r0,22r-21,0r0,-22xm85,-240r21,0r0,22r-21,0r0,-22xm0,-240r21,0r0,22r-21,0r0,-22xm212,-196r21,0r0,22r-21,0r0,-22xm127,-196r21,0r0,22r-21,0r0,-22xm42,-196r22,0r0,22r-22,0r0,-22xm0,-152r21,0r0,22r-21,0r0,-22xm85,-152r21,0r0,22r-21,0r0,-22xm170,-152r21,0r0,22r-21,0r0,-22xm212,-109r21,0r0,22r-21,0r0,-22xm127,-109r21,0r0,22r-21,0r0,-22xm42,-109r22,0r0,22r-22,0r0,-22xm0,-65r21,0r0,22r-21,0r0,-22xm85,-65r21,0r0,22r-21,0r0,-22xm170,-65r21,0r0,22r-21,0r0,-22xm42,-21r22,0r0,22r-22,0r0,-22xm127,-21r21,0r0,22r-21,0r0,-22xm212,-21r21,0r0,22r-21,0r0,-22xm170,23r21,0r0,22r-21,0r0,-22xm85,23r21,0r0,22r-21,0r0,-22xm0,23r21,0r0,22r-21,0r0,-22xm42,67r22,0r0,22r-22,0r0,-22xm127,67r21,0r0,22r-21,0r0,-22xm212,67r21,0r0,22r-21,0r0,-22","w":255},"\u2592":{"d":"21,-328r21,0r0,22r-21,0r0,-22xm64,-328r21,0r0,22r-21,0r0,-22xm106,-328r21,0r0,22r-21,0r0,-22xm148,-328r22,0r0,22r-22,0r0,-22xm191,-328r21,0r0,22r-21,0r0,-22xm233,-328r21,0r0,22r-21,0r0,-22xm0,-284r21,0r0,22r-21,0r0,-22xm42,-284r22,0r0,22r-22,0r0,-22xm85,-284r21,0r0,22r-21,0r0,-22xm127,-284r21,0r0,22r-21,0r0,-22xm170,-284r21,0r0,22r-21,0r0,-22xm212,-284r21,0r0,22r-21,0r0,-22xm21,-240r21,0r0,22r-21,0r0,-22xm64,-240r21,0r0,22r-21,0r0,-22xm106,-240r21,0r0,22r-21,0r0,-22xm148,-240r22,0r0,22r-22,0r0,-22xm191,-240r21,0r0,22r-21,0r0,-22xm233,-240r21,0r0,22r-21,0r0,-22xm42,-196r22,0r0,22r-22,0r0,-22xm85,-196r21,0r0,22r-21,0r0,-22xm127,-196r21,0r0,22r-21,0r0,-22xm170,-196r21,0r0,22r-21,0r0,-22xm212,-196r21,0r0,22r-21,0r0,-22xm0,-196r21,0r0,22r-21,0r0,-22xm21,-152r21,0r0,22r-21,0r0,-22xm64,-152r21,0r0,22r-21,0r0,-22xm106,-152r21,0r0,22r-21,0r0,-22xm148,-152r22,0r0,22r-22,0r0,-22xm191,-152r21,0r0,22r-21,0r0,-22xm233,-152r21,0r0,22r-21,0r0,-22xm0,-109r21,0r0,22r-21,0r0,-22xm85,-109r21,0r0,22r-21,0r0,-22xm127,-109r21,0r0,22r-21,0r0,-22xm170,-109r21,0r0,22r-21,0r0,-22xm212,-109r21,0r0,22r-21,0r0,-22xm42,-109r22,0r0,22r-22,0r0,-22xm233,-65r21,0r0,22r-21,0r0,-22xm191,-65r21,0r0,22r-21,0r0,-22xm148,-65r22,0r0,22r-22,0r0,-22xm106,-65r21,0r0,22r-21,0r0,-22xm64,-65r21,0r0,22r-21,0r0,-22xm21,-65r21,0r0,22r-21,0r0,-22xm0,-21r21,0r0,22r-21,0r0,-22xm42,-21r22,0r0,22r-22,0r0,-22xm85,-21r21,0r0,22r-21,0r0,-22xm127,-21r21,0r0,22r-21,0r0,-22xm170,-21r21,0r0,22r-21,0r0,-22xm212,-21r21,0r0,22r-21,0r0,-22xm233,23r21,0r0,22r-21,0r0,-22xm191,23r21,0r0,22r-21,0r0,-22xm148,23r22,0r0,22r-22,0r0,-22xm106,23r21,0r0,22r-21,0r0,-22xm64,23r21,0r0,22r-21,0r0,-22xm21,23r21,0r0,22r-21,0r0,-22xm0,67r21,0r0,22r-21,0r0,-22xm42,67r22,0r0,22r-22,0r0,-22xm85,67r21,0r0,22r-21,0r0,-22xm127,67r21,0r0,22r-21,0r0,-22xm170,67r21,0r0,22r-21,0r0,-22xm212,67r21,0r0,22r-21,0r0,-22","w":255},"\u2593":{"d":"254,-262r0,66r-21,0r0,22r21,0r0,65r-21,0r0,22r21,0r0,66r-21,0r0,22r21,0r0,66r-21,0r0,22r21,0r0,21r-254,0r0,-65r21,0r0,-22r-21,0r0,-66r21,0r0,-22r-21,0r0,-65r21,0r0,-22r-21,0r0,-66r21,0r0,-22r-21,0r0,-66r21,0r0,-22r21,0r0,22r22,0r0,-22r21,0r0,22r21,0r0,-22r21,0r0,22r21,0r0,-22r22,0r0,22r21,0r0,-22r21,0r0,22r21,0r0,-22r21,0r0,44r-21,0r0,22r21,0xm21,-284r0,22r21,0r0,-22r-21,0xm64,-284r0,22r21,0r0,-22r-21,0xm106,-284r0,22r21,0r0,-22r-21,0xm148,-284r0,22r22,0r0,-22r-22,0xm191,-284r0,22r21,0r0,-22r-21,0xm233,-240r-21,0r0,22r21,0r0,-22xm191,-240r-21,0r0,22r21,0r0,-22xm148,-240r-21,0r0,22r21,0r0,-22xm106,-240r-21,0r0,22r21,0r0,-22xm64,-240r-22,0r0,22r22,0r0,-22xm21,-196r0,22r21,0r0,-22r-21,0xm64,-196r0,22r21,0r0,-22r-21,0xm106,-196r0,22r21,0r0,-22r-21,0xm148,-196r0,22r22,0r0,-22r-22,0xm191,-196r0,22r21,0r0,-22r-21,0xm64,-152r-22,0r0,22r22,0r0,-22xm85,-152r0,22r21,0r0,-22r-21,0xm127,-152r0,22r21,0r0,-22r-21,0xm170,-152r0,22r21,0r0,-22r-21,0xm212,-152r0,22r21,0r0,-22r-21,0xm21,-109r0,22r21,0r0,-22r-21,0xm106,-109r0,22r21,0r0,-22r-21,0xm85,-87r0,-22r-21,0r0,22r21,0xm148,-109r0,22r22,0r0,-22r-22,0xm191,-109r0,22r21,0r0,-22r-21,0xm233,-43r0,-22r-21,0r0,22r21,0xm191,-43r0,-22r-21,0r0,22r21,0xm148,-43r0,-22r-21,0r0,22r21,0xm106,-43r0,-22r-21,0r0,22r21,0xm64,-43r0,-22r-22,0r0,22r22,0xm21,-21r0,22r21,0r0,-22r-21,0xm64,-21r0,22r21,0r0,-22r-21,0xm106,-21r0,22r21,0r0,-22r-21,0xm148,-21r0,22r22,0r0,-22r-22,0xm191,-21r0,22r21,0r0,-22r-21,0xm233,45r0,-22r-21,0r0,22r21,0xm191,45r0,-22r-21,0r0,22r21,0xm148,45r0,-22r-21,0r0,22r21,0xm106,45r0,-22r-21,0r0,22r21,0xm64,45r0,-22r-22,0r0,22r22,0xm21,67r0,22r21,0r0,-22r-21,0xm64,67r0,22r21,0r0,-22r-21,0xm106,67r0,22r21,0r0,-22r-21,0xm148,67r0,22r22,0r0,-22r-22,0xm191,67r0,22r21,0r0,-22r-21,0","w":255},"\u25a0":{"d":"26,-166r166,0r0,166r-166,0r0,-166","w":217},"\u25ac":{"d":"60,-68r240,0r0,68r-240,0r0,-68","w":360},"\u25b2":{"d":"53,0r125,-249r125,249r-250,0","w":356},"\u25ba":{"d":"51,-249r255,127r-255,127r0,-254","w":356},"\u25bc":{"d":"303,-244r-125,249r-125,-249r250,0","w":356},"\u25c4":{"d":"306,-249r0,254r-255,-127","w":356},"\u25cb":{"d":"31,-102v2,-43,34,-77,78,-77v44,0,76,33,77,77v1,41,-36,78,-77,78v-41,0,-80,-37,-78,-78xm173,-102v-1,-36,-28,-64,-64,-64v-36,0,-64,26,-64,64v0,35,29,65,64,65v35,0,64,-31,64,-65","w":217},"\u25d8":{"d":"22,0r0,-172r173,0r0,172r-173,0xm144,-86v0,-19,-16,-36,-35,-36v-19,0,-37,16,-36,36v0,19,17,35,36,35v19,0,35,-16,35,-35","w":217},"\u25d9":{"d":"7,0r0,-203r203,0r0,203r-203,0xm186,-101v-1,-44,-33,-78,-77,-78v-45,0,-76,34,-78,78v-1,41,37,77,78,77v41,0,79,-35,77,-77xm45,-101v0,-38,28,-65,64,-65v36,0,63,28,64,65v0,35,-29,64,-64,64v-35,0,-64,-29,-64,-64","w":217},"\u263a":{"d":"68,-91v0,-63,47,-112,112,-112v65,0,112,49,112,112v0,64,-48,112,-112,112v-64,0,-112,-48,-112,-112xm276,-91v0,-56,-42,-96,-96,-96v-54,0,-96,40,-96,96v0,55,40,96,96,96v56,0,96,-41,96,-96xm123,-114v0,-7,7,-14,14,-14v7,0,14,7,14,14v0,7,-7,14,-14,14v-7,0,-14,-7,-14,-14xm209,-114v0,-7,7,-14,14,-14v7,0,14,7,14,14v0,7,-7,14,-14,14v-7,0,-14,-7,-14,-14xm232,-55v-15,42,-88,44,-104,0r11,-6v16,34,66,33,82,0","w":360},"\u263b":{"d":"68,-91v0,-63,47,-112,112,-112v65,0,112,49,112,112v0,64,-48,112,-112,112v-64,0,-112,-48,-112,-112xm151,-114v0,-7,-7,-14,-14,-14v-7,0,-14,7,-14,14v0,7,7,14,14,14v7,0,14,-7,14,-14xm237,-114v0,-7,-7,-14,-14,-14v-7,0,-14,7,-14,14v0,7,7,14,14,14v7,0,14,-7,14,-14xm128,-55v15,42,88,44,104,0r-11,-6v-16,34,-66,33,-82,0","w":360},"\u263c":{"d":"97,-201v21,-13,34,-22,62,-25r0,-59r13,0r0,59v28,2,42,11,61,25r51,-50r9,9r-50,51v15,18,23,36,25,62r59,0r0,12r-59,0v-2,23,-10,43,-25,62r50,51r-10,9r-49,-50v-21,15,-32,22,-62,25r0,59r-13,0r0,-59v-28,-4,-43,-10,-61,-24r-52,49r-9,-9r50,-51v-14,-18,-22,-35,-25,-62r-59,0r0,-12r59,0v2,-28,10,-43,25,-61r-50,-51r9,-10xm255,-123v0,-52,-39,-90,-90,-90v-51,0,-90,38,-90,90v0,52,38,90,90,90v52,0,90,-38,90,-90","w":329},"\u2640":{"d":"227,-173v2,48,-40,92,-87,92r0,71r81,0r0,10r-81,0r0,77r-10,0r0,-77r-81,0r0,-10r81,0r0,-71v-47,-3,-87,-42,-87,-92v0,-53,39,-92,92,-92v53,0,91,39,92,92xm217,-173v-1,-47,-35,-82,-82,-82v-47,0,-82,35,-83,82v-1,44,38,83,83,83v45,0,83,-38,82,-83","w":270},"\u2642":{"d":"20,-46v-1,-59,58,-109,121,-87r63,-136r-94,47r-4,-10r108,-53r6,3r29,117r-10,3r-25,-102r-63,135v30,15,53,44,53,83v0,52,-40,92,-93,92v-52,0,-90,-39,-91,-92xm194,-46v-2,-47,-35,-82,-83,-82v-48,1,-80,35,-82,82v-1,45,38,83,82,83v44,1,84,-38,83,-83","w":270},"\u2660":{"d":"117,-82v-10,43,-87,45,-84,-5v3,-61,81,-67,85,-129v6,56,81,73,86,128v2,20,-18,40,-39,40v-23,-1,-35,-15,-45,-34v0,50,20,72,67,75r1,7r-139,0r1,-7v46,1,68,-28,67,-75","w":236},"\u2663":{"d":"178,-48v-32,-3,-44,-17,-58,-42v2,56,20,74,72,84r1,6r-149,0r1,-6v52,-7,68,-32,71,-84v-13,52,-106,57,-106,-7v0,-38,36,-63,71,-40v-27,-30,-5,-79,37,-79v41,0,64,47,37,79v31,-22,71,0,71,39v0,27,-20,52,-48,50","w":236},"\u2665":{"d":"118,-172v6,-54,96,-58,96,0v0,72,-83,110,-96,176v-11,-65,-87,-105,-96,-174v-3,-25,21,-47,45,-46v27,1,44,19,51,44","w":236},"\u2666":{"d":"118,4v-26,-44,-41,-62,-81,-110v21,-23,63,-78,81,-111v17,33,60,87,81,111v-17,18,-66,81,-81,110","w":236},"\u266a":{"d":"7,-33v-1,-37,44,-54,78,-35r0,-172v69,-5,91,20,88,87r-17,0v3,-35,-20,-48,-53,-47r0,147v12,65,-94,84,-96,20","w":180},"\u266b":{"d":"15,-17v-1,-38,45,-54,79,-35r0,-171r140,-44r0,195v12,66,-94,79,-97,19v-1,-37,46,-54,79,-36r0,-127r-105,32r0,147v3,41,-20,57,-55,59v-26,1,-41,-15,-41,-39","w":270},"\u0132":{"d":"60,0r-55,0r0,-252r55,0r0,252xm128,2v-26,0,-58,-13,-57,-39r0,-64r48,0r0,62v0,4,3,6,8,6v5,0,8,-2,8,-6r0,-213r55,0r0,209v0,30,-20,45,-62,45","w":193},"\u0133":{"d":"55,-215r-50,0r0,-37r50,0r0,37xm55,0r-50,0r0,-204r50,0r0,204xm119,-215r-50,0r0,-37r50,0r0,37xm41,14v21,-2,27,4,28,-14r0,-204r50,0r0,209v3,40,-38,40,-78,38r0,-29","w":125},"\u0149":{"d":"-13,-185r-11,-8v8,-8,12,-15,13,-22r-20,0r0,-37r46,0v2,35,-1,48,-28,67xm74,-197v19,-16,67,-8,67,21r0,176r-50,0r0,-164v0,-6,-3,-9,-9,-9v-6,0,-8,3,-8,9r0,164r-51,0r0,-204r51,0r0,7","w":182},"\u2032":{"d":"76,-252r-51,87r-21,-3r23,-84r49,0","w":79},"\u2033":{"d":"81,-252r-51,87r-21,-3r23,-84r49,0xm148,-252r-51,87r-21,-3r23,-84r49,0","w":134},"\u2105":{"d":"31,-170v12,3,5,-6,7,-28r24,0v1,26,2,44,-27,44v-44,0,-29,-44,-29,-79v0,-14,10,-21,29,-21v29,-1,28,18,27,44r-24,0v3,-13,-1,-39,-8,-24xm123,-252r-92,252r-23,0r91,-252r24,0xm97,2v-44,0,-28,-45,-28,-79v0,-14,9,-20,28,-20v44,0,28,45,28,79v0,13,-9,20,-28,20xm101,-77v0,-3,-1,-5,-4,-5v-10,12,-3,48,-3,68v3,3,7,0,7,-3r0,-60","w":129},"\u2113":{"d":"139,-194v-9,49,-15,32,-64,75r0,87r49,0r0,32r-104,0r0,-78r-14,9r0,-58r14,-8r0,-81v2,-30,30,-40,65,-38v48,3,53,15,54,60xm75,-174v21,-19,18,-17,18,-44v0,-6,-3,-9,-9,-9v-18,3,-5,36,-9,53","w":145},"\u25a1":{"d":"26,-166r166,0r0,166r-166,0r0,-166xm39,-153r0,140r139,0r0,-140r-139,0","w":217},"\u25aa":{"d":"104,-160r0,82r-81,0r0,-82r81,0","w":127},"\u25ab":{"d":"104,-160r0,82r-81,0r0,-82r81,0xm91,-146r-55,0r0,54r55,0r0,-54","w":127},"\u25cf":{"d":"31,-102v2,-43,34,-77,78,-77v44,0,76,33,77,77v1,41,-36,78,-77,78v-41,0,-80,-37,-78,-78","w":217},"\u25e6":{"d":"20,-119v0,-23,21,-44,44,-44v23,0,44,21,44,44v0,23,-21,44,-44,44v-23,0,-44,-21,-44,-44xm95,-119v0,-16,-14,-31,-31,-31v-17,0,-31,15,-31,31v-1,17,15,31,31,31v16,0,31,-14,31,-31","w":127},"\u0100":{"d":"156,0r-55,0r-9,-68r-25,0r-10,68r-54,0r41,-252r70,0xm87,-103r-8,-75r-7,75r15,0xm116,-270r-72,0r0,-29r72,0r0,29","w":158},"\u0101":{"d":"6,-70v-2,-36,51,-42,68,-64v-2,-14,6,-40,-9,-40v-14,0,-9,33,-9,51r-48,0v-3,-53,0,-82,60,-82v37,0,56,14,56,43r0,162r-45,0r0,-8v-13,20,-82,13,-73,-21r0,-41xm65,-29v19,-5,5,-42,9,-62v-26,3,-17,28,-18,53v0,6,3,9,9,9xm101,-226r-72,0r0,-29r72,0r0,29","w":129},"\u0108":{"d":"127,-37v1,26,-31,39,-57,39v-43,0,-64,-15,-64,-45r0,-162v0,-33,21,-49,64,-49v59,0,60,36,57,90r-50,0r0,-50v0,-4,-3,-6,-8,-6v-5,0,-8,2,-8,6r0,175v0,4,3,6,8,6v5,0,8,-2,8,-6r0,-62r50,0r0,64xm121,-264r-36,0r-15,-23r-16,23r-35,0r27,-41r47,0","w":133},"\u0109":{"d":"123,-114r-50,0v-3,-19,9,-56,-9,-60v-6,0,-9,3,-9,10r0,125v0,7,3,11,9,11v18,-4,5,-41,9,-60r50,0v2,54,5,91,-58,91v-92,0,-60,-93,-60,-165v0,-29,20,-43,60,-43v63,0,60,36,58,91xm118,-220r-36,0r-15,-23r-16,23r-35,0r27,-41r47,0"},"\u010a":{"d":"127,-37v1,26,-31,39,-57,39v-43,0,-64,-15,-64,-45r0,-162v0,-33,21,-49,64,-49v59,0,60,36,57,90r-50,0r0,-50v0,-4,-3,-6,-8,-6v-5,0,-8,2,-8,6r0,175v0,4,3,6,8,6v5,0,8,-2,8,-6r0,-62r50,0r0,64xm94,-264r-46,0r0,-36r46,0r0,36","w":133},"\u010b":{"d":"123,-114r-50,0v-3,-19,9,-56,-9,-60v-6,0,-9,3,-9,10r0,125v0,7,3,11,9,11v18,-4,5,-41,9,-60r50,0v2,54,5,91,-58,91v-92,0,-60,-93,-60,-165v0,-29,20,-43,60,-43v63,0,60,36,58,91xm89,-220r-46,0r0,-36r46,0r0,36"},"\u0112":{"d":"114,0r-108,0r0,-252r108,0r0,32r-52,0r0,68r47,0r0,31r-47,0r0,89r52,0r0,32xm95,-270r-72,0r0,-29r72,0r0,29","w":117},"\u0113":{"d":"123,-86r-67,0v3,19,-8,53,8,58v17,-3,6,-35,9,-52r50,0v3,52,1,83,-59,83v-90,0,-58,-94,-58,-165v0,-29,19,-43,58,-43v75,0,57,57,59,119xm73,-117v-3,-18,9,-53,-9,-57v-17,4,-4,39,-8,57r17,0xm101,-226r-72,0r0,-29r72,0r0,29"},"\u0114":{"d":"114,0r-108,0r0,-252r108,0r0,32r-52,0r0,68r47,0r0,31r-47,0r0,89r52,0r0,32xm110,-305v-3,28,-20,41,-51,41v-31,0,-49,-13,-51,-41r27,0v2,24,46,24,47,0r28,0","w":117},"\u0115":{"d":"123,-86r-67,0v3,19,-8,53,8,58v17,-3,6,-35,9,-52r50,0v3,52,1,83,-59,83v-90,0,-58,-94,-58,-165v0,-29,19,-43,58,-43v75,0,57,57,59,119xm73,-117v-3,-18,9,-53,-9,-57v-17,4,-4,39,-8,57r17,0xm116,-261v-3,28,-20,41,-51,41v-31,0,-49,-13,-51,-41r27,0v2,24,46,24,47,0r28,0"},"\u0116":{"d":"114,0r-108,0r0,-252r108,0r0,32r-52,0r0,68r47,0r0,31r-47,0r0,89r52,0r0,32xm78,-264r-46,0r0,-36r46,0r0,36","w":117},"\u0117":{"d":"123,-86r-67,0v3,19,-8,53,8,58v17,-3,6,-35,9,-52r50,0v3,52,1,83,-59,83v-90,0,-58,-94,-58,-165v0,-29,19,-43,58,-43v75,0,57,57,59,119xm73,-117v-3,-18,9,-53,-9,-57v-17,4,-4,39,-8,57r17,0xm89,-220r-46,0r0,-36r46,0r0,36"},"\u011c":{"d":"94,-14v-28,29,-88,19,-88,-27r0,-164v0,-33,20,-49,62,-49v62,0,63,35,60,91r-50,0r0,-51v0,-4,-3,-6,-9,-6v-6,0,-8,2,-8,6r0,175v0,4,2,6,8,6v19,-2,5,-36,9,-53r-12,0r0,-39r62,0r0,125r-27,0xm121,-264r-36,0r-15,-23r-16,23r-35,0r27,-41r47,0","w":133},"\u011d":{"d":"123,-3v8,56,-56,45,-109,46r0,-29v24,-2,61,9,59,-19v-19,15,-69,9,-68,-20r0,-147v-2,-33,40,-42,68,-25v7,-12,33,-5,50,-7r0,201xm73,-36r0,-129v0,-6,-3,-9,-9,-9v-6,0,-9,3,-9,9r0,128v0,6,3,10,9,10v6,0,9,-3,9,-9xm116,-220r-36,0r-15,-23r-16,23r-35,0r27,-41r47,0"},"\u0120":{"d":"94,-14v-28,29,-88,19,-88,-27r0,-164v0,-33,20,-49,62,-49v62,0,63,35,60,91r-50,0r0,-51v0,-4,-3,-6,-9,-6v-6,0,-8,2,-8,6r0,175v0,4,2,6,8,6v19,-2,5,-36,9,-53r-12,0r0,-39r62,0r0,125r-27,0xm92,-264r-46,0r0,-36r46,0r0,36","w":133},"\u0121":{"d":"123,-3v8,56,-56,45,-109,46r0,-29v24,-2,61,9,59,-19v-19,15,-69,9,-68,-20r0,-147v-2,-33,40,-42,68,-25v7,-12,33,-5,50,-7r0,201xm73,-36r0,-129v0,-6,-3,-9,-9,-9v-6,0,-9,3,-9,9r0,128v0,6,3,10,9,10v6,0,9,-3,9,-9xm89,-220r-46,0r0,-36r46,0r0,36"},"\u0122":{"d":"94,-14v-28,29,-88,19,-88,-27r0,-164v0,-33,20,-49,62,-49v62,0,63,35,60,91r-50,0r0,-51v0,-4,-3,-6,-9,-6v-6,0,-8,2,-8,6r0,175v0,4,2,6,8,6v19,-2,5,-36,9,-53r-12,0r0,-39r62,0r0,125r-27,0xm39,37v3,-14,19,-1,21,-15v-1,-8,-5,-10,-13,-6r0,-17r20,0r0,6v24,8,19,40,-13,38v-6,0,-11,-2,-15,-6","w":133},"\u0123":{"d":"123,-3v8,56,-56,45,-109,46r0,-29v24,-2,61,9,59,-19v-19,15,-69,9,-68,-20r0,-147v-2,-33,40,-42,68,-25v7,-12,33,-5,50,-7r0,201xm73,-36r0,-129v0,-6,-3,-9,-9,-9v-6,0,-9,3,-9,9r0,128v0,6,3,10,9,10v6,0,9,-3,9,-9xm74,-285r10,8v-8,8,-11,15,-12,22r19,0r0,37r-45,0v-2,-35,1,-50,28,-67"},"\u0124":{"d":"131,0r-55,0r0,-121r-15,0r0,121r-56,0r0,-252r56,0r0,100r15,0r0,-100r55,0r0,252xm122,-264r-36,0r-15,-23r-16,23r-35,0r27,-41r47,0","w":136},"\u0125":{"d":"56,-198v18,-13,67,-9,67,21r0,177r-50,0r0,-165v0,-6,-2,-9,-8,-9v-6,0,-9,3,-9,9r0,165r-50,0r0,-252r50,0r0,54xm112,-264r-36,0r-15,-23r-16,23r-35,0r27,-41r47,0"},"\u0126":{"d":"147,-199r-10,0r0,199r-55,0r0,-121r-15,0r0,121r-55,0r0,-199r-9,0r0,-31r9,0r0,-22r55,0r0,22r15,0r0,-22r55,0r0,22r10,0r0,31xm82,-152r0,-47r-15,0r0,47r15,0","w":149},"\u0127":{"d":"61,-198v18,-13,68,-9,68,21r0,177r-50,0r0,-165v0,-6,-3,-9,-9,-9v-6,0,-9,3,-9,9r0,165r-50,0r0,-216r-7,0r0,-23r7,0r0,-13r50,0r0,13r31,0r0,23r-31,0r0,18","w":137},"\u0128":{"d":"60,0r-55,0r0,-252r55,0r0,252xm-26,-264v-4,-47,50,-45,81,-32v4,0,7,-3,7,-9r32,0v-1,20,-16,43,-40,41v-12,3,-47,-25,-47,0r-33,0","w":65},"\u0129":{"d":"55,0r-50,0r0,-204r50,0r0,204xm-29,-220v-4,-47,50,-45,81,-32v4,0,7,-3,7,-9r32,0v-1,20,-16,43,-40,41v-12,3,-47,-25,-47,0r-33,0","w":59},"\u012a":{"d":"60,0r-55,0r0,-252r55,0r0,252xm69,-270r-72,0r0,-29r72,0r0,29","w":65},"\u012b":{"d":"55,0r-50,0r0,-204r50,0r0,204xm65,-226r-72,0r0,-29r72,0r0,29","w":59},"\u012c":{"d":"60,0r-55,0r0,-252r55,0r0,252xm85,-302v-3,28,-20,41,-51,41v-31,0,-49,-13,-51,-41r27,0v2,24,46,24,47,0r28,0","w":65},"\u012d":{"d":"55,0r-50,0r0,-204r50,0r0,204xm83,-261v-3,28,-20,41,-51,41v-31,0,-49,-13,-51,-41r27,0v2,24,46,24,47,0r28,0","w":59},"\u012e":{"d":"60,0r-55,0r0,-252r55,0r0,252xm67,37v-14,12,-48,7,-48,-17v0,-8,4,-14,10,-20r24,0v-9,4,-13,28,1,28v5,0,10,-1,13,-4r0,13","w":65},"\u012f":{"d":"55,-215r-50,0r0,-37r50,0r0,37xm55,0r-50,0r0,-204r50,0r0,204xm63,37v-14,12,-48,7,-48,-17v0,-8,4,-14,10,-20r24,0v-9,4,-13,28,1,28v5,0,10,-1,13,-4r0,13","w":59},"\u0134":{"d":"63,2v-26,0,-58,-13,-57,-39r0,-64r48,0r0,62v0,4,3,6,8,6v5,0,8,-2,8,-6r0,-213r55,0r0,209v0,30,-20,45,-62,45xm149,-264r-36,0r-15,-23r-16,23r-35,0r27,-41r47,0","w":130},"\u0135":{"d":"82,-223r-36,0r-15,-23r-16,23r-35,0r28,-42r46,0xm-21,14v21,-2,27,4,28,-14r0,-204r50,0r0,209v3,40,-38,40,-78,38r0,-29","w":64},"\u0136":{"d":"144,0r-61,0r-21,-94r0,94r-55,0r0,-252r55,0r0,84r24,-84r52,0r-34,115xm65,75r-10,-8v8,-8,11,-15,12,-22r-19,0r0,-37r45,0v2,35,-1,50,-28,67","w":146},"\u0137":{"d":"146,0r-59,0r-31,-74r0,74r-50,0r0,-252r50,0r0,113r26,-65r51,0r-36,89xm63,75r-10,-8v8,-8,11,-15,12,-22r-19,0r0,-37r45,0v2,35,-1,50,-28,67","w":147},"\u0138":{"d":"146,0r-59,0r-31,-74r0,74r-50,0r0,-204r50,0r0,65r26,-65r52,0r-37,89","w":147},"\u013b":{"d":"111,0r-104,0r0,-252r55,0r0,220r49,0r0,32xm49,75r-10,-8v8,-8,11,-15,12,-22r-19,0r0,-37r45,0v2,35,-1,50,-28,67","w":113},"\u013c":{"d":"56,0r-50,0r0,-252r50,0r0,252xm26,75r-10,-8v8,-8,11,-15,12,-22r-19,0r0,-37r45,0v2,35,-1,50,-28,67","w":61},"\u0145":{"d":"147,0r-57,0r-38,-134r0,134r-46,0r0,-252r63,0r32,115r0,-115r46,0r0,252xm67,75r-10,-8v8,-8,11,-15,12,-22r-19,0r0,-37r45,0v2,35,-1,50,-28,67","w":152},"\u0146":{"d":"56,-197v19,-16,67,-8,67,21r0,176r-50,0r0,-164v0,-6,-3,-9,-9,-9v-6,0,-8,3,-8,9r0,164r-51,0r0,-204r51,0r0,7xm59,75r-10,-8v8,-8,11,-15,12,-22r-19,0r0,-37r45,0v2,35,-1,50,-28,67"},"\u014a":{"d":"68,-35v16,-2,14,-8,14,-29r0,-112v0,-10,-3,-15,-10,-15v-8,0,-12,5,-12,16r0,175r-55,0r0,-228r55,0r0,7v35,-20,76,-2,72,52v-5,72,28,181,-64,169r0,-35","w":138},"\u014b":{"d":"59,18v13,-2,14,-3,14,-20r0,-156v0,-10,-2,-15,-8,-15v-6,0,-9,4,-9,13r0,160r-50,0r0,-204r50,0r0,7v21,-16,68,-9,68,23r0,175v0,38,-22,57,-65,57r0,-40","w":129},"\u014c":{"d":"132,-43v0,32,-30,45,-63,45v-42,0,-63,-15,-63,-45r0,-162v0,-33,21,-49,63,-49v42,0,63,16,63,48r0,163xm78,-40r0,-172v0,-5,-3,-8,-9,-8v-6,0,-9,3,-9,8r0,172v0,5,3,7,9,7v6,0,9,-2,9,-7xm108,-270r-72,0r0,-29r72,0r0,29","w":137},"\u014d":{"d":"64,-205v28,0,58,12,58,41r0,126v0,28,-19,41,-58,41v-91,0,-59,-94,-59,-165v0,-29,19,-43,59,-43xm72,-39r0,-125v0,-7,-3,-10,-9,-10v-6,0,-8,3,-8,10r0,125v0,7,2,11,8,11v6,0,9,-4,9,-11xm101,-226r-72,0r0,-29r72,0r0,29","w":126},"\u014e":{"d":"132,-43v0,32,-30,45,-63,45v-42,0,-63,-15,-63,-45r0,-162v0,-33,21,-49,63,-49v42,0,63,16,63,48r0,163xm78,-40r0,-172v0,-5,-3,-8,-9,-8v-6,0,-9,3,-9,8r0,172v0,5,3,7,9,7v6,0,9,-2,9,-7xm120,-305v-3,28,-20,41,-51,41v-31,0,-49,-13,-51,-41r27,0v2,24,46,24,47,0r28,0","w":137},"\u014f":{"d":"64,-205v28,0,58,12,58,41r0,126v0,28,-19,41,-58,41v-91,0,-59,-94,-59,-165v0,-29,19,-43,59,-43xm72,-39r0,-125v0,-7,-3,-10,-9,-10v-6,0,-8,3,-8,10r0,125v0,7,2,11,8,11v6,0,9,-4,9,-11xm115,-261v-3,28,-20,41,-51,41v-31,0,-49,-13,-51,-41r27,0v2,24,46,24,47,0r28,0","w":126},"\u0156":{"d":"7,-252v56,1,125,-10,126,45v1,38,0,61,-34,70v33,6,34,32,34,69v0,40,3,63,10,68r-55,0v-11,-10,-9,-76,-9,-108v0,-9,-6,-13,-17,-13r0,121r-55,0r0,-252xm62,-152v27,2,17,-32,17,-54v0,-9,-6,-14,-17,-14r0,68xm66,75r-10,-8v8,-8,11,-15,12,-22r-19,0r0,-37r45,0v2,35,-1,50,-28,67","w":144},"\u0157":{"d":"57,-197v19,-15,67,-10,67,21r0,56r-50,0v-3,-17,8,-49,-8,-53v-6,0,-9,3,-9,9r0,164r-50,0r0,-204r50,0r0,7xm27,75r-10,-8v8,-8,11,-15,12,-22r-19,0r0,-37r45,0v2,35,-1,50,-28,67"},"\u015c":{"d":"59,-205v-2,62,73,73,73,125v0,54,-6,82,-64,82v-68,0,-64,-43,-62,-103r50,0r0,58v0,6,4,9,11,9v17,0,7,-25,10,-39v-9,-43,-71,-64,-71,-104v0,-52,8,-77,64,-77v58,0,60,35,57,88r-50,0r0,-47v0,-5,-2,-7,-8,-7v-6,0,-10,5,-10,15xm121,-264r-36,0r-15,-23r-16,23r-35,0r27,-41r47,0","w":137},"\u015d":{"d":"55,-158v-13,50,66,37,68,87v2,49,-6,74,-60,74v-60,0,-61,-32,-58,-85r50,0v3,18,-8,50,9,54v14,-2,8,-52,-2,-54v-46,-26,-57,-18,-55,-80v0,-29,19,-43,58,-43v57,0,60,30,57,81r-49,0v1,-15,3,-51,-8,-50v-6,0,-10,5,-10,16xm117,-220r-36,0r-15,-23r-16,23r-35,0r27,-41r47,0","w":127},"\u0166":{"d":"5,-132r0,-32r31,0r0,-55r-31,0r0,-33r117,0r0,33r-31,0r0,55r31,0r0,32r-31,0r0,132r-55,0r0,-132r-31,0","w":126},"\u0167":{"d":"73,0v-67,10,-41,-52,-47,-102r-22,0r0,-30r22,0r0,-42r-22,0r0,-30r22,0r0,-41r50,0r0,41r27,0r0,30r-27,0r0,42r27,0r0,30r-27,0v3,32,-14,76,29,67r0,35r-32,0","w":108},"\u0168":{"d":"70,2v-32,0,-64,-12,-64,-45r0,-209r55,0r0,212v0,5,3,7,9,7v6,0,10,-2,10,-7r0,-212r55,0r0,209v0,32,-31,45,-65,45xm11,-264v-4,-47,50,-45,81,-32v4,0,7,-3,7,-9r32,0v-1,20,-16,43,-40,41v-12,3,-47,-25,-47,0r-33,0","w":140},"\u0169":{"d":"73,-7v-16,17,-68,12,-68,-18r0,-179r50,0r0,166v0,6,3,9,9,9v6,0,9,-3,9,-9r0,-166r50,0r0,204r-50,0r0,-7xm5,-220v-4,-47,50,-45,81,-32v4,0,7,-3,7,-9r32,0v-1,20,-16,43,-40,41v-12,3,-47,-25,-47,0r-33,0"},"\u016a":{"d":"70,2v-32,0,-64,-12,-64,-45r0,-209r55,0r0,212v0,5,3,7,9,7v6,0,10,-2,10,-7r0,-212r55,0r0,209v0,32,-31,45,-65,45xm108,-270r-72,0r0,-29r72,0r0,29","w":140},"\u016b":{"d":"73,-7v-16,17,-68,12,-68,-18r0,-179r50,0r0,166v0,6,3,9,9,9v6,0,9,-3,9,-9r0,-166r50,0r0,204r-50,0r0,-7xm101,-226r-72,0r0,-29r72,0r0,29"},"\u016c":{"d":"70,2v-32,0,-64,-12,-64,-45r0,-209r55,0r0,212v0,5,3,7,9,7v6,0,10,-2,10,-7r0,-212r55,0r0,209v0,32,-31,45,-65,45xm122,-305v-3,28,-20,41,-51,41v-31,0,-49,-13,-51,-41r27,0v2,24,46,24,47,0r28,0","w":140},"\u016d":{"d":"73,-7v-16,17,-68,12,-68,-18r0,-179r50,0r0,166v0,6,3,9,9,9v6,0,9,-3,9,-9r0,-166r50,0r0,204r-50,0r0,-7xm117,-261v-3,28,-20,41,-51,41v-31,0,-49,-13,-51,-41r27,0v2,24,46,24,47,0r28,0"},"\u0172":{"d":"70,2v-32,0,-64,-12,-64,-45r0,-209r55,0r0,212v0,5,3,7,9,7v6,0,10,-2,10,-7r0,-212r55,0r0,209v0,32,-31,45,-65,45xm96,37v-14,12,-48,7,-48,-17v0,-8,4,-14,10,-20r24,0v-9,4,-13,28,1,28v5,0,10,-1,13,-4r0,13","w":140},"\u0173":{"d":"73,-7v-16,17,-68,12,-68,-18r0,-179r50,0r0,166v0,6,3,9,9,9v6,0,9,-3,9,-9r0,-166r50,0r0,204r-50,0r0,-7xm122,37v-14,12,-48,7,-48,-17v0,-8,4,-14,10,-20r24,0v-9,4,-13,28,1,28v5,0,10,-1,13,-4r0,13"},"\u0174":{"d":"226,-252r-33,252r-65,0r-20,-139r-19,139r-56,0r-32,-252r50,0r14,116r19,-116r63,0r15,116r18,-116r46,0xm164,-264r-36,0r-15,-23r-16,23r-35,0r27,-41r47,0","w":226},"\u0175":{"d":"214,-204r-35,204r-55,0r-16,-83r-14,83r-58,0r-35,-204r49,0r17,111r15,-111r51,0r15,111r17,-111r49,0xm160,-220r-36,0r-15,-23r-16,23r-35,0r27,-41r47,0","w":214},"\u0176":{"d":"157,-252r-54,152r0,100r-55,0v-2,-62,2,-97,-15,-150r-32,-102r53,0r25,89r29,-89r49,0xm137,-264r-36,0r-15,-23r-16,23r-35,0r27,-41r47,0","w":158},"\u0177":{"d":"20,16v22,-1,27,3,29,-14v-3,-22,-37,-161,-48,-206r50,0r21,108r17,-108r49,0r-39,203v-3,49,-32,44,-79,44r0,-27xm125,-220r-36,0r-15,-23r-16,23r-35,0r27,-41r47,0","w":139},"\u017f":{"d":"85,-225v-22,1,-29,-2,-29,16r0,209r-50,0r0,-212v-8,-49,38,-39,79,-40r0,27","w":86},"\u01fa":{"d":"156,0r-55,0r-9,-68r-25,0r-10,68r-54,0r41,-252r70,0xm87,-103r-8,-75r-7,75r15,0xm79,-332v21,1,33,14,34,36v0,18,-15,33,-34,32v-19,-1,-33,-15,-34,-34v-1,-17,17,-35,34,-34xm79,-286v8,0,13,-4,13,-13v0,-8,-5,-11,-13,-11v-8,0,-12,4,-12,12v0,8,4,12,12,12xm114,-370r-21,32r-27,0r10,-32r38,0","w":158},"\u01fb":{"d":"6,-70v-2,-36,51,-42,68,-64v-2,-14,6,-40,-9,-40v-14,0,-9,33,-9,51r-48,0v-3,-53,0,-82,60,-82v37,0,56,14,56,43r0,162r-45,0r0,-8v-13,20,-82,13,-73,-21r0,-41xm65,-29v19,-5,5,-42,9,-62v-26,3,-17,28,-18,53v0,6,3,9,9,9xm68,-288v21,1,33,14,34,36v0,18,-15,33,-34,32v-19,-1,-33,-15,-34,-34v-1,-17,17,-35,34,-34xm68,-242v8,0,13,-4,13,-13v0,-8,-5,-11,-13,-11v-8,0,-12,4,-12,12v0,8,4,12,12,12xm99,-330r-21,32r-27,0r10,-32r38,0","w":129},"\u01fc":{"d":"199,0r-109,0r0,-68r-22,0r-11,68r-52,0r41,-252r152,0r0,32r-52,0r0,68r47,0r0,31r-47,0r0,89r53,0r0,32xm90,-103r0,-101r-17,101r17,0xm140,-296r-21,32r-27,0r10,-32r38,0","w":203},"\u01fd":{"d":"97,-198v37,-13,88,-9,88,35r0,77r-68,0v3,18,-9,55,9,57v13,2,9,-30,9,-47r50,0v4,54,-5,79,-67,79v-11,0,-19,-4,-25,-13v-18,21,-87,18,-87,-19r0,-41v-2,-35,51,-41,67,-64v-2,-13,6,-37,-8,-38v-13,-1,-11,34,-9,49r-48,0r0,-40v-5,-46,54,-46,89,-35xm135,-117v-3,-18,8,-52,-9,-55v-18,3,-6,37,-9,55r18,0xm73,-38r0,-53v-26,4,-15,29,-17,53v0,6,3,9,9,9v6,0,8,-3,8,-9xm128,-252r-21,32r-27,0r10,-32r38,0","w":191},"\u01fe":{"d":"132,-43v2,43,-56,54,-95,41r-7,19r-30,0r13,-36v-5,-7,-7,-15,-7,-24r0,-162v-6,-43,51,-57,93,-45r8,-18r30,0r-13,34v6,8,8,18,8,29r0,162xm60,-143v6,-23,20,-38,18,-69v0,-5,-3,-7,-9,-7v-6,0,-9,2,-9,7r0,69xm78,-40r0,-72v-7,23,-21,39,-18,72v0,5,3,8,9,8v6,0,9,-3,9,-8xm105,-301r-21,32r-27,0r10,-32r38,0","w":136},"\u01ff":{"d":"127,-213r-11,26v16,37,1,101,7,149v4,38,-49,48,-87,37v-1,13,-21,7,-34,8r11,-24v-16,-36,-2,-98,-7,-145v-4,-37,46,-50,86,-40r5,-11r30,0xm56,-117v5,-17,16,-28,17,-49v0,-7,-2,-10,-8,-10v-19,0,-5,41,-9,59xm63,-29v19,-3,7,-39,10,-59v-5,17,-16,28,-17,49v0,7,2,10,7,10xm98,-252r-21,32r-27,0r10,-32r38,0"},"\u0387":{"d":"38,-237v0,11,-6,17,-17,17v-11,0,-17,-6,-17,-17v0,-11,6,-17,17,-17v11,0,17,6,17,17","w":41},"\u1e80":{"d":"226,-252r-33,252r-65,0r-20,-139r-19,139r-56,0r-32,-252r50,0r14,116r19,-116r63,0r15,116r18,-116r46,0xm131,-264r-27,0r-21,-32r38,0","w":226},"\u1e81":{"d":"214,-204r-35,204r-55,0r-16,-83r-14,83r-58,0r-35,-204r49,0r17,111r15,-111r51,0r15,111r17,-111r49,0xm122,-220r-27,0r-21,-32r38,0","w":214},"\u1e82":{"d":"226,-252r-33,252r-65,0r-20,-139r-19,139r-56,0r-32,-252r50,0r14,116r19,-116r63,0r15,116r18,-116r46,0xm149,-296r-21,32r-27,0r10,-32r38,0","w":226},"\u1e83":{"d":"214,-204r-35,204r-55,0r-16,-83r-14,83r-58,0r-35,-204r49,0r17,111r15,-111r51,0r15,111r17,-111r49,0xm143,-252r-21,32r-27,0r10,-32r38,0","w":214},"\u1e84":{"d":"226,-252r-33,252r-65,0r-20,-139r-19,139r-56,0r-32,-252r50,0r14,116r19,-116r63,0r15,116r18,-116r46,0xm122,-281v0,-10,7,-17,17,-17v11,0,18,6,18,17v-1,9,-8,17,-18,17v-12,0,-17,-6,-17,-17xm72,-281v0,-10,7,-17,17,-17v11,0,17,6,17,17v0,10,-8,18,-17,17v-12,0,-17,-6,-17,-17","w":226},"\u1e85":{"d":"214,-204r-35,204r-55,0r-16,-83r-14,83r-58,0r-35,-204r49,0r17,111r15,-111r51,0r15,111r17,-111r49,0xm115,-237v0,-10,7,-17,17,-17v11,0,18,6,18,17v-1,9,-8,17,-18,17v-12,0,-17,-6,-17,-17xm65,-237v0,-10,7,-17,17,-17v11,0,17,6,17,17v0,10,-8,18,-17,17v-12,0,-17,-6,-17,-17","w":214},"\u1ef2":{"d":"157,-252r-54,152r0,100r-55,0v-2,-62,2,-97,-15,-150r-32,-102r53,0r25,89r29,-89r49,0xm99,-264r-27,0r-21,-32r38,0","w":158},"\u1ef3":{"d":"20,16v22,-1,27,3,29,-14v-3,-22,-37,-161,-48,-206r50,0r21,108r17,-108r49,0r-39,203v-3,49,-32,44,-79,44r0,-27xm94,-220r-27,0r-21,-32r38,0","w":139},"\u201b":{"d":"50,-252r0,37r-20,0v1,7,5,14,13,22r-10,8v-27,-19,-31,-31,-29,-67r46,0","w":53},"\u203e":{"d":"134,-276r-135,0r0,-29r135,0r0,29","w":133},"\u20a4":{"d":"92,-198v-1,-14,3,-19,-8,-20v-14,3,-4,30,-7,44r31,0r0,32r-31,0r0,12r31,0r0,32r-31,0r0,66r46,0r0,32r-103,0r0,-98r-14,0r0,-32r14,0r0,-12r-14,0r0,-32r14,0v-4,-52,7,-80,64,-80v32,0,51,10,59,30","w":146},"\u212e":{"d":"16,-93v0,-84,99,-133,157,-75v18,18,28,43,29,75r-146,0r0,65v37,35,99,25,122,-22r13,7v-23,30,-37,48,-82,49v-56,1,-93,-44,-93,-99xm161,-106r0,-53v-28,-28,-79,-28,-105,1r0,52r105,0","w":216},"\u215b":{"d":"9,-237v7,0,16,-7,15,-15r24,0r0,126r-28,0r0,-93r-11,0r0,-18xm160,-252r-126,252r-30,0r126,-252r30,0xm166,-49v1,30,2,50,-32,50v-34,0,-32,-21,-31,-50v0,-11,4,-17,14,-19v-22,-8,-23,-67,17,-59v40,-7,40,49,17,59v10,2,15,8,15,19xm134,-110v-7,5,-6,31,0,34v10,-2,4,-23,4,-33xm130,-57v3,13,-8,43,8,40v2,-11,0,-27,1,-40v0,-2,-2,-3,-5,-3v-3,0,-4,1,-4,3","w":183},"\u215c":{"d":"5,-179r25,0v2,11,-6,32,6,34v6,-6,12,-43,-8,-42r0,-15v13,1,13,-9,13,-22v0,-11,-10,-14,-11,-4r0,20r-25,0v-1,-28,-2,-47,31,-46v40,-7,40,49,17,61v25,9,23,76,-17,68v-35,2,-32,-23,-31,-54xm164,-252r-126,252r-30,0r126,-252r30,0xm123,-68v-22,-8,-23,-67,17,-59v40,-7,40,49,17,59v19,2,13,26,14,46v0,16,-11,23,-32,23v-34,0,-32,-21,-31,-50v0,-11,5,-17,15,-19xm136,-109v-2,10,-4,41,8,29v-2,-10,6,-33,-8,-29xm135,-20v0,5,9,5,9,0r0,-37v0,-2,-1,-3,-4,-3v-12,4,-2,28,-5,40","w":173},"\u215d":{"d":"67,-252r-4,19r-32,0r-1,26v12,-9,38,-3,36,15v-4,33,11,67,-31,67v-36,0,-33,-23,-32,-54r27,0v1,12,-1,26,1,36v17,3,6,-31,9,-45v-1,-3,-2,-5,-6,-5v-3,0,-4,3,-4,8r-26,-1r1,-66r62,0xm164,-252r-126,252r-30,0r126,-252r30,0xm123,-68v-22,-8,-23,-67,17,-59v40,-7,40,49,17,59v19,2,13,26,14,46v0,16,-11,23,-32,23v-34,0,-32,-21,-31,-50v0,-11,5,-17,15,-19xm136,-109v-2,10,-4,41,8,29v-2,-10,6,-33,-8,-29xm135,-20v0,5,9,5,9,0r0,-37v0,-2,-1,-3,-4,-3v-12,4,-2,28,-5,40","w":174},"\u215e":{"d":"159,-252r-126,252r-30,0r126,-252r30,0xm78,-252v-3,51,-25,83,-35,126r-30,0r35,-108r-33,0r0,-18r63,0xm117,-68v-22,-8,-23,-67,17,-59v40,-7,40,49,17,59v19,2,14,26,15,46v0,16,-11,23,-32,23v-34,0,-32,-21,-31,-50v0,-11,4,-17,14,-19xm134,-110v-7,5,-6,31,0,34v10,-2,4,-23,4,-33xm130,-57v3,13,-8,43,8,40v2,-11,0,-27,1,-40v0,-2,-2,-3,-5,-3v-3,0,-4,1,-4,3","w":173},"\uf004":{"d":"54,93r-10,-8v8,-8,11,-15,12,-22r-19,0r0,-37r45,0v2,35,-1,50,-28,67","w":119},"\uf005":{"d":"54,93r-10,-8v8,-8,11,-15,12,-22r-19,0r0,-37r45,0v2,35,-1,50,-28,67","w":119},"\u0384":{"d":"42,-252r-7,39r-28,0r-7,-39r42,0","w":42},"\u0385":{"d":"79,-305r-7,40r-28,0r-7,-40r42,0xm45,-236v0,11,-6,18,-17,18v-11,0,-18,-7,-18,-18v0,-11,7,-17,18,-17v11,0,17,6,17,17xm71,-236v0,-10,7,-17,17,-17v11,0,18,6,18,17v1,10,-10,18,-18,18v-12,0,-17,-7,-17,-18","w":119},"\u0386":{"d":"167,0r-55,0r-9,-68r-25,0r-10,68r-54,0r41,-252r70,0xm98,-103r-8,-75r-7,75r15,0xm38,-252r-7,39r-28,0r-7,-39r42,0","w":170},"\u0388":{"d":"161,0r-108,0r0,-252r108,0r0,32r-52,0r0,68r47,0r0,31r-47,0r0,89r52,0r0,32xm38,-252r-7,39r-28,0r-7,-39r42,0","w":168},"\u0389":{"d":"180,0r-55,0r0,-121r-15,0r0,121r-56,0r0,-252r56,0r0,100r15,0r0,-100r55,0r0,252xm38,-252r-7,39r-28,0r-7,-39r42,0","w":188},"\u038a":{"d":"109,0r-55,0r0,-252r55,0r0,252xm38,-252r-7,39r-28,0r-7,-39r42,0","w":118},"\u038c":{"d":"167,-43v0,32,-30,45,-63,45v-42,0,-63,-15,-63,-45r0,-162v0,-33,21,-49,63,-49v42,0,63,16,63,48r0,163xm113,-40r0,-172v0,-5,-3,-8,-9,-8v-6,0,-9,3,-9,8r0,172v0,5,3,7,9,7v6,0,9,-2,9,-7xm38,-252r-7,39r-28,0r-7,-39r42,0","w":178},"\u038e":{"d":"211,-252r-54,152r0,100r-55,0v-2,-62,2,-97,-15,-150r-32,-102r53,0r25,89r29,-89r49,0xm38,-252r-7,39r-28,0r-7,-39r42,0","w":209},"\u038f":{"d":"6,-205v0,-66,144,-66,144,0r0,118v5,31,-23,18,-27,33v-1,10,17,8,27,7r0,47v0,0,-66,7,-66,-33r0,-44v-2,-15,12,-16,12,-28r0,-91v0,-12,-5,-19,-18,-18v-12,0,-18,6,-18,18r0,91v0,12,13,13,12,28v-2,33,7,77,-27,77r-39,0r0,-47v10,1,28,3,27,-7v-1,-18,-27,2,-27,-33r0,-118xm1,-252r-7,39r-27,0r-7,-39r41,0","w":156},"\u0390":{"d":"55,0r-50,0r0,-204r50,0r0,204xm54,-305r-7,40r-28,0r-7,-40r42,0xm20,-236v0,11,-6,18,-17,18v-11,0,-18,-7,-18,-18v0,-11,7,-17,18,-17v11,0,17,6,17,17xm46,-236v0,-10,7,-17,17,-17v11,0,18,6,18,17v1,10,-10,18,-18,18v-12,0,-17,-7,-17,-18","w":59},"\u0391":{"d":"156,0r-55,0r-9,-68r-25,0r-10,68r-54,0r41,-252r70,0xm87,-103r-8,-75r-7,75r15,0","w":158},"\u0392":{"d":"131,-50v1,59,-67,51,-125,50r0,-252v55,1,123,-10,123,45v1,38,3,63,-32,72v42,7,34,42,34,85xm61,-150v26,1,16,-34,16,-56v0,-9,-6,-14,-16,-14r0,70xm61,-32v30,-2,16,-51,16,-78v0,-9,-6,-13,-16,-13r0,91","w":136},"\u0394":{"d":"148,0r-147,0r34,-252r79,0xm91,-33r-16,-143r-18,143r34,0","w":149},"\u0395":{"d":"114,0r-108,0r0,-252r108,0r0,32r-52,0r0,68r47,0r0,31r-47,0r0,89r52,0r0,32","w":117},"\u0396":{"d":"128,0r-124,0r0,-32r61,-187r-58,0r0,-33r117,0r0,33r-60,187r64,0r0,32","w":132},"\u0397":{"d":"131,0r-55,0r0,-121r-15,0r0,121r-56,0r0,-252r56,0r0,100r15,0r0,-100r55,0r0,252","w":136},"\u0399":{"d":"60,0r-55,0r0,-252r55,0r0,252","w":65},"\u039a":{"d":"144,0r-61,0r-21,-94r0,94r-55,0r0,-252r55,0r0,84r24,-84r52,0r-34,115","w":146},"\u039b":{"d":"148,0r-54,0r-19,-176r-20,176r-54,0r34,-252r79,0","w":148},"\u039c":{"d":"199,0r-49,0r0,-142r-29,142r-38,0r-33,-142r0,142r-44,0r0,-252r72,0r25,131r22,-131r74,0r0,252","w":205},"\u039d":{"d":"147,0r-57,0r-38,-134r0,134r-46,0r0,-252r63,0r32,115r0,-115r46,0r0,252","w":152},"\u039e":{"d":"127,-202r-123,0r0,-50r123,0r0,50xm117,-101r-104,0r0,-50r104,0r0,50xm127,0r-123,0r0,-50r123,0r0,50","w":131},"\u039f":{"d":"132,-43v0,32,-30,45,-63,45v-42,0,-63,-15,-63,-45r0,-162v0,-33,21,-49,63,-49v42,0,63,16,63,48r0,163xm78,-40r0,-172v0,-5,-3,-8,-9,-8v-6,0,-9,3,-9,8r0,172v0,5,3,7,9,7v6,0,9,-2,9,-7","w":137},"\u03a0":{"d":"158,-202r-14,0r0,202r-56,0r0,-202r-15,0r0,202r-55,0r0,-202r-14,0r0,-50r154,0r0,50","w":162},"\u03a1":{"d":"133,-137v-3,42,-21,43,-73,44r0,93r-54,0r0,-252v55,3,127,-14,127,45r0,70xm60,-129v34,1,14,-47,19,-74v0,-9,-7,-13,-19,-13r0,87","w":136},"\u03a3":{"d":"115,0r-113,0r36,-136r-36,-116r113,0r0,50r-44,0r21,66r-21,86r44,0r0,50","w":118},"\u03a4":{"d":"122,-219r-31,0r0,219r-56,0r0,-219r-31,0r0,-33r118,0r0,33","w":126},"\u03a5":{"d":"157,-252r-54,152r0,100r-55,0v-2,-62,2,-97,-15,-150r-32,-102r53,0r25,89r29,-89r49,0","w":158},"\u03a7":{"d":"163,0r-60,0r-25,-81r-24,81r-53,0r44,-143r-32,-109r53,0r20,73r22,-73r49,0r-37,117","w":163},"\u03a8":{"d":"81,-95v-52,5,-69,-24,-69,-83v0,-44,-3,-69,-10,-74r55,0v13,12,8,90,11,126v1,2,6,2,13,2r0,-128r55,0r0,128v27,5,14,-34,14,-60v0,-38,3,-61,9,-68r56,0v-11,1,-10,76,-10,110v0,30,-30,52,-69,47r0,95r-55,0r0,-95","w":216},"\u03a9":{"d":"6,-205v0,-66,144,-66,144,0r0,118v5,31,-23,18,-27,33v-1,10,17,8,27,7r0,47v0,0,-66,7,-66,-33r0,-44v-2,-15,12,-16,12,-28r0,-91v0,-12,-6,-18,-18,-18v-12,0,-18,6,-18,18r0,91v0,12,13,13,12,28v-2,33,7,77,-27,77r-39,0r0,-47v10,1,28,3,27,-7v-1,-18,-27,2,-27,-33r0,-118","w":156},"\u03aa":{"d":"60,0r-55,0r0,-252r55,0r0,252xm41,-281v0,-10,7,-17,17,-17v11,0,18,6,18,17v-1,9,-8,17,-18,17v-12,0,-17,-6,-17,-17xm-9,-281v0,-10,7,-17,17,-17v11,0,17,6,17,17v0,10,-8,18,-17,17v-12,0,-17,-6,-17,-17","w":65},"\u03ab":{"d":"157,-252r-54,152r0,100r-55,0v-2,-62,2,-97,-15,-150r-32,-102r53,0r25,89r29,-89r49,0xm90,-281v0,-10,7,-17,17,-17v11,0,18,6,18,17v-1,9,-8,17,-18,17v-12,0,-17,-6,-17,-17xm40,-281v0,-10,7,-17,17,-17v11,0,17,6,17,17v0,10,-8,18,-17,17v-12,0,-17,-6,-17,-17","w":158},"\u03ac":{"d":"6,-171v-3,-31,57,-42,73,-21r0,-11r45,0r0,203r-45,0r0,-11v-14,20,-73,12,-73,-21r0,-139xm74,-41r0,-121v0,-6,-3,-9,-9,-9v-6,0,-9,3,-9,10r0,120v0,6,3,9,9,9v6,0,9,-3,9,-9xm89,-252r-7,39r-28,0r-7,-39r42,0","w":129},"\u03ad":{"d":"123,0v-52,0,-123,8,-118,-44v7,-67,-29,-166,55,-160r63,0r0,39v-23,3,-68,-10,-68,13r0,30r68,0r0,37r-68,0v2,20,-8,45,17,45r51,0r0,40xm91,-252r-7,39r-28,0r-7,-39r42,0"},"\u03ae":{"d":"56,-197v19,-16,67,-8,67,21r0,219r-50,0r0,-207v0,-6,-3,-9,-9,-9v-6,0,-8,3,-8,9r0,164r-51,0r0,-204r51,0r0,7xm81,-252r-7,39r-28,0r-7,-39r42,0"},"\u03af":{"d":"67,0v-21,7,-60,10,-60,-31r0,-173r50,0r0,159v0,9,3,13,10,13r0,32xm56,-252r-7,39r-28,0r-7,-39r42,0","w":66},"\u03b0":{"d":"7,-204r50,0r0,165v0,7,2,11,8,11v6,0,9,-4,9,-11r0,-165r50,0r0,166v0,28,-19,41,-58,41v-40,0,-59,-14,-59,-43r0,-164xm87,-305r-7,40r-28,0r-7,-40r42,0xm53,-236v0,11,-6,18,-17,18v-11,0,-18,-7,-18,-18v0,-11,7,-17,18,-17v11,0,17,6,17,17xm79,-236v0,-10,7,-17,17,-17v11,0,18,6,18,17v1,10,-10,18,-18,18v-12,0,-17,-7,-17,-18","w":130},"\u03b2":{"d":"131,-40v2,37,-55,62,-75,28r0,73r-49,0r0,-263v0,-38,19,-58,58,-58v59,0,59,15,61,77v0,24,-13,37,-38,40v57,-4,41,54,43,103xm64,-127r0,-30v23,1,15,-32,15,-52v0,-11,-4,-17,-13,-17v-6,0,-10,9,-10,28r0,156v0,10,3,15,10,15v24,-5,13,-56,13,-83v0,-11,-5,-17,-15,-17","w":137},"\u03b3":{"d":"80,67v-51,0,-24,-51,-33,-89r-27,-121v-2,-11,-8,-19,-16,-22r0,-41v33,-7,50,-3,56,26r18,100r24,-124r49,0r-43,174v-17,39,19,97,-28,97","w":155},"\u03b6":{"d":"101,-11v5,60,-41,54,-95,54r0,-47v20,-2,53,8,51,-15v-3,-26,-52,-16,-49,-45v-5,-41,-2,-108,29,-127v-13,0,-23,-5,-31,-14r0,-47v14,14,23,19,36,19v1,-19,7,-19,28,-19v31,0,29,5,31,37v4,49,-45,60,-45,96v0,29,1,49,27,52v18,12,15,22,18,56","w":104},"\u03b7":{"d":"56,-197v19,-16,67,-8,67,21r0,219r-50,0r0,-207v0,-6,-3,-9,-9,-9v-6,0,-8,3,-8,9r0,164r-51,0r0,-204r51,0r0,7"},"\u03b8":{"d":"66,-253v30,0,58,12,58,41r0,174v0,28,-19,41,-58,41v-40,0,-59,-14,-59,-43r0,-170v0,-29,19,-43,59,-43xm74,-146r0,-65v0,-7,-3,-10,-9,-10v-6,0,-8,3,-8,9r0,66r17,0xm74,-117r-17,0r0,78v0,7,2,11,8,11v6,0,9,-3,9,-10r0,-79","w":130},"\u03b9":{"d":"67,0v-21,7,-60,10,-60,-31r0,-173r50,0r0,159v0,9,3,13,10,13r0,32","w":66},"\u03ba":{"d":"56,-139v17,-52,26,-72,79,-65r0,34v-28,1,-20,18,-38,55r49,115r-59,0r-31,-74r0,74r-50,0r0,-204r50,0r0,65","w":147},"\u03bb":{"d":"142,2v-28,6,-53,-3,-57,-27r-13,-83r-20,108r-51,0r42,-173v8,-27,14,-51,-23,-47r0,-27v44,-1,70,-4,79,44r29,150v2,12,7,18,14,18r0,37","w":145},"\u03bc":{"d":"54,-2r0,49r-49,0r0,-251r50,0r0,166v0,6,3,9,9,9v6,0,9,-3,9,-9r0,-166r50,0r0,204r-50,0r0,-7v-6,7,-12,9,-19,5"},"\u03bd":{"d":"135,-204r-36,204r-61,0r-37,-204r51,0r17,121r17,-121r49,0","w":136},"\u03be":{"d":"111,-16v0,57,-22,61,-73,59r0,-39v35,3,42,-25,14,-25v-47,0,-49,-31,-47,-80v0,-24,11,-38,32,-42v-40,-12,-37,-64,0,-73r-32,0r0,-36r99,0r0,36v-48,-10,-64,56,-16,56r0,33v-34,-8,-42,57,-18,67v27,3,41,8,41,44","w":115},"\u03bf":{"d":"64,-205v28,0,58,12,58,41r0,126v0,28,-19,41,-58,41v-91,0,-59,-94,-59,-165v0,-29,19,-43,59,-43xm72,-39r0,-125v0,-7,-3,-10,-9,-10v-6,0,-8,3,-8,10r0,125v0,7,2,11,8,11v6,0,9,-4,9,-11","w":126},"\u03c1":{"d":"124,-38v3,33,-41,52,-67,34r0,47r-50,0r0,-205v0,-29,19,-43,59,-43v28,0,59,13,58,41r0,126xm57,-164r0,126v0,7,2,10,8,10v6,0,9,-3,9,-10r0,-126v0,-6,-3,-10,-9,-10v-6,0,-8,4,-8,10","w":130},"\u03c2":{"d":"120,-45v4,48,4,94,-52,88r-55,0r0,-47v23,-3,61,11,63,-15v1,-18,-40,-21,-42,-29v-31,-14,-30,-54,-28,-103v2,-37,26,-55,66,-55v43,-1,60,24,54,64r-51,0v7,-20,-11,-47,-17,-19v4,41,-15,74,26,87v16,5,34,10,36,29","w":132},"\u03c5":{"d":"7,-204r50,0r0,165v0,7,2,11,8,11v6,0,9,-4,9,-11r0,-165r50,0r0,166v0,28,-19,41,-58,41v-40,0,-59,-14,-59,-43r0,-164","w":130},"\u03c7":{"d":"4,-205v53,-7,40,9,64,66r23,-65r49,0r-40,116r26,77v4,12,8,19,14,19r0,36v-17,6,-46,4,-48,-16r-22,-64r-20,79r-50,0r40,-132v-11,-21,-16,-61,-36,-70r0,-46","w":144},"\u03c8":{"d":"12,-107v0,-54,4,-74,-10,-97r53,0v13,9,6,85,10,113v1,2,6,2,13,2r0,-115r53,0r0,115v26,4,14,-35,14,-54v0,-34,3,-54,9,-61r53,0v-10,2,-10,67,-10,99v0,30,-22,45,-66,45r0,60r-53,0r0,-60v-44,0,-66,-16,-66,-47","w":208},"\u03c9":{"d":"124,-204v41,-2,73,16,71,57v-3,57,16,150,-41,150v-25,0,-43,-12,-54,-37v-9,25,-27,37,-53,37v-57,0,-41,-94,-41,-150v0,-38,24,-57,71,-57r0,31v-20,0,-21,8,-21,29r0,96v0,10,3,15,10,15v6,0,9,-5,9,-16r0,-100r50,0r0,100v0,11,3,16,10,16v7,0,10,-5,10,-15r0,-96v0,-22,-1,-28,-21,-29r0,-31","w":200},"\u03ca":{"d":"67,0v-21,7,-60,10,-60,-31r0,-173r50,0r0,159v0,9,3,13,10,13r0,32xm41,-237v0,-10,7,-17,17,-17v11,0,18,6,18,17v-1,9,-8,17,-18,17v-12,0,-17,-6,-17,-17xm-9,-237v0,-10,7,-17,17,-17v11,0,17,6,17,17v0,10,-8,18,-17,17v-12,0,-17,-6,-17,-17","w":66},"\u03cb":{"d":"7,-204r50,0r0,165v0,7,2,11,8,11v6,0,9,-4,9,-11r0,-165r50,0r0,166v0,28,-19,41,-58,41v-40,0,-59,-14,-59,-43r0,-164xm74,-237v0,-10,7,-17,17,-17v11,0,18,6,18,17v-1,9,-8,17,-18,17v-12,0,-17,-6,-17,-17xm24,-237v0,-10,7,-17,17,-17v11,0,17,6,17,17v0,10,-8,18,-17,17v-12,0,-17,-6,-17,-17","w":130},"\u03cc":{"d":"64,-205v28,0,58,12,58,41r0,126v0,28,-19,41,-58,41v-91,0,-59,-94,-59,-165v0,-29,19,-43,59,-43xm72,-39r0,-125v0,-7,-3,-10,-9,-10v-6,0,-8,3,-8,10r0,125v0,7,2,11,8,11v6,0,9,-4,9,-11xm84,-252r-7,39r-28,0r-7,-39r42,0","w":126},"\u03cd":{"d":"7,-204r50,0r0,165v0,7,2,11,8,11v6,0,9,-4,9,-11r0,-165r50,0r0,166v0,28,-19,41,-58,41v-40,0,-59,-14,-59,-43r0,-164xm89,-252r-7,39r-28,0r-7,-39r42,0","w":130},"\u03ce":{"d":"124,-204v41,-2,73,16,71,57v-3,57,16,150,-41,150v-25,0,-43,-12,-54,-37v-9,25,-27,37,-53,37v-57,0,-41,-94,-41,-150v0,-38,24,-57,71,-57r0,31v-20,0,-21,8,-21,29r0,96v0,10,3,15,10,15v6,0,9,-5,9,-16r0,-100r50,0r0,100v0,11,3,16,10,16v7,0,10,-5,10,-15r0,-96v0,-22,-1,-28,-21,-29r0,-31xm121,-252r-7,39r-28,0r-7,-39r42,0","w":200},"\u0401":{"d":"114,0r-108,0r0,-252r108,0r0,32r-52,0r0,68r47,0r0,31r-47,0r0,89r52,0r0,32xm69,-281v0,-10,7,-17,17,-17v11,0,18,6,18,17v-1,9,-8,17,-18,17v-12,0,-17,-6,-17,-17xm19,-281v0,-10,7,-17,17,-17v11,0,17,6,17,17v0,10,-8,18,-17,17v-12,0,-17,-6,-17,-17","w":117},"\u0402":{"d":"99,2r0,-31v9,-1,14,-9,14,-24r0,-101v0,-10,-4,-15,-12,-15v-6,0,-10,5,-10,16r0,153r-55,0r0,-219r-31,0r0,-33r139,0r0,33r-53,0r0,18v38,-12,75,1,72,54v-4,71,18,155,-64,149","w":170},"\u0403":{"d":"110,-252r0,32r-48,0r0,220r-56,0r0,-252r104,0xm82,-296r-21,32r-27,0r10,-32r38,0","w":113},"\u0404":{"d":"127,-37v1,26,-31,40,-57,40v-43,0,-64,-16,-64,-46r0,-162v0,-33,21,-49,64,-49v49,0,61,23,57,69r-50,0v-2,-24,5,-31,-8,-35v-5,0,-7,3,-7,8r0,64r49,0r0,33r-49,0r0,77v0,4,2,6,7,6v17,-2,4,-32,8,-47r50,0r0,42","w":133},"\u0405":{"d":"59,-205v-2,62,73,73,73,125v0,54,-6,82,-64,82v-68,0,-64,-43,-62,-103r50,0r0,58v0,6,4,9,11,9v17,0,7,-25,10,-39v-9,-43,-71,-64,-71,-104v0,-52,8,-77,64,-77v58,0,60,35,57,88r-50,0r0,-47v0,-5,-2,-7,-8,-7v-6,0,-10,5,-10,15","w":137},"\u0406":{"d":"60,0r-55,0r0,-252r55,0r0,252","w":65},"\u0407":{"d":"60,0r-55,0r0,-252r55,0r0,252xm41,-281v0,-10,7,-17,17,-17v11,0,18,6,18,17v-1,9,-8,17,-18,17v-12,0,-17,-6,-17,-17xm-9,-281v0,-10,7,-17,17,-17v11,0,17,6,17,17v0,10,-8,18,-17,17v-12,0,-17,-6,-17,-17","w":65},"\u0408":{"d":"63,2v-26,0,-58,-13,-57,-39r0,-64r48,0r0,62v0,4,3,6,8,6v5,0,8,-2,8,-6r0,-213r55,0r0,209v0,30,-20,45,-62,45","w":130},"\u0409":{"d":"226,-45v3,59,-72,42,-128,45r0,-219r-19,0r0,189v4,34,-43,37,-75,30r0,-35v12,5,23,3,23,-15r0,-202r127,0r0,93v50,2,72,0,72,45r0,69xm154,-36v33,1,12,-48,18,-74v0,-9,-6,-13,-18,-13r0,87","w":233},"\u040a":{"d":"204,-45v3,60,-72,42,-128,45r0,-121r-14,0r0,121r-56,0r0,-252r56,0r0,100r14,0r0,-100r56,0r0,93v50,2,72,0,72,45r0,69xm132,-36v33,1,12,-48,18,-74v0,-9,-6,-13,-18,-13r0,87","w":210},"\u040b":{"d":"87,-191v19,-13,67,-9,67,21r0,170r-50,0r0,-157v0,-6,-3,-10,-9,-10v-6,0,-8,3,-8,9r0,158r-50,0r0,-219r-33,0r0,-33r117,0r0,33r-34,0r0,28","w":160},"\u040c":{"d":"148,0r-59,0r-31,-99r0,99r-52,0r0,-252r52,0r0,88v14,-40,15,-106,79,-88r0,34v-28,5,-26,54,-38,78xm99,-296r-21,32r-27,0r10,-32r38,0","w":147},"\u040e":{"d":"20,-32v24,-1,33,1,28,-20r-47,-200r52,0r23,121r16,-121r50,0r-41,208v-4,43,-34,46,-81,44r0,-32xm123,-300v-3,28,-20,41,-51,41v-31,0,-49,-13,-51,-41r28,0v1,24,45,24,46,0r28,0","w":143},"\u040f":{"d":"134,0r-43,0r0,43r-41,0r0,-43r-44,0r0,-252r56,0r0,220r16,0r0,-220r56,0r0,252","w":140},"\u0410":{"d":"156,0r-55,0r-9,-68r-25,0r-10,68r-54,0r41,-252r70,0xm87,-103r-8,-75r-7,75r15,0","w":158},"\u0411":{"d":"133,-45v4,57,-71,43,-127,45r0,-252r103,0r0,32r-49,0r0,61v50,2,73,0,73,45r0,69xm60,-36v33,1,14,-48,18,-74v2,-10,-6,-13,-18,-13r0,87","w":140},"\u0412":{"d":"131,-50v1,59,-67,51,-125,50r0,-252v55,1,123,-10,123,45v1,38,3,63,-32,72v42,7,34,42,34,85xm61,-150v26,1,16,-34,16,-56v0,-9,-6,-14,-16,-14r0,70xm61,-32v30,-2,16,-51,16,-78v0,-9,-6,-13,-16,-13r0,91","w":136},"\u0413":{"d":"110,-252r0,32r-48,0r0,220r-56,0r0,-252r104,0","w":113},"\u0414":{"d":"28,-40v38,-65,38,-94,36,-212r132,0r0,212r41,0r0,94r-41,0r0,-54r-151,0r0,54r-38,0r0,-94r21,0xm142,-40r0,-172r-27,0v0,75,-9,131,-30,172r57,0","w":243},"\u0415":{"d":"114,0r-108,0r0,-252r108,0r0,32r-52,0r0,68r47,0r0,31r-47,0r0,89r52,0r0,32","w":117},"\u0416":{"d":"81,-127v-37,3,-68,-14,-69,-47v0,-49,-3,-75,-10,-78r55,0v12,10,8,68,10,93v1,2,6,3,14,3r0,-96r55,0r0,96v15,2,15,-6,16,-27v2,-44,-4,-51,7,-69r56,0v-7,3,-10,29,-10,78v0,31,-31,52,-69,47v46,8,69,24,69,49v0,47,3,73,10,78r-56,0v-12,-9,-3,-72,-11,-94v-2,-1,-6,-2,-12,-2r0,96r-55,0r0,-96v-15,-2,-15,6,-16,27v-1,45,4,50,-8,69r-55,0v7,-3,10,-29,10,-78v0,-25,23,-41,69,-49","w":216},"\u0417":{"d":"70,-254v46,0,61,26,61,79v0,21,-9,35,-28,41v32,5,30,46,29,84v0,35,-20,53,-62,53v-70,0,-65,-46,-63,-108r50,0r0,60v0,6,3,9,10,9v7,0,10,-3,10,-9v-5,-29,15,-80,-23,-76r0,-28v36,3,19,-33,23,-60v0,-5,-3,-7,-10,-7v-21,2,-6,36,-10,54r-49,0v-3,-56,-2,-92,62,-92","w":135},"\u0418":{"d":"7,0r0,-252r46,0r0,115r35,-115r59,0r0,252r-46,0r0,-134r-38,134r-56,0","w":152},"\u0419":{"d":"7,0r0,-252r46,0r0,115r35,-115r59,0r0,252r-46,0r0,-134r-38,134r-56,0xm128,-302v-3,28,-20,41,-51,41v-31,0,-49,-13,-51,-41r27,0v2,24,46,24,47,0r28,0","w":152},"\u041a":{"d":"148,0r-59,0r-31,-99r0,99r-52,0r0,-252r52,0r0,88v14,-40,15,-106,79,-88r0,34v-28,5,-26,54,-38,78","w":147},"\u041b":{"d":"4,-35v13,4,23,4,23,-15r0,-202r125,0r0,252r-54,0r0,-219r-19,0r0,189v4,34,-43,37,-75,30r0,-35","w":158},"\u041c":{"d":"199,0r-49,0r0,-142r-29,142r-38,0r-33,-142r0,142r-44,0r0,-252r72,0r25,131r22,-131r74,0r0,252","w":205},"\u041d":{"d":"131,0r-55,0r0,-121r-15,0r0,121r-56,0r0,-252r56,0r0,100r15,0r0,-100r55,0r0,252","w":136},"\u041e":{"d":"132,-43v0,32,-30,45,-63,45v-42,0,-63,-15,-63,-45r0,-162v0,-33,21,-49,63,-49v42,0,63,16,63,48r0,163xm78,-40r0,-172v0,-5,-3,-8,-9,-8v-6,0,-9,3,-9,8r0,172v0,5,3,7,9,7v6,0,9,-2,9,-7","w":137},"\u041f":{"d":"207,-220r-25,0r0,220r-50,0r0,-220r-52,0r0,220r-50,0r0,-220r-26,0r0,-32r203,0r0,32","w":210},"\u0420":{"d":"133,-137v-3,42,-21,43,-73,44r0,93r-54,0r0,-252v55,3,127,-14,127,45r0,70xm60,-129v34,1,14,-47,19,-74v0,-9,-7,-13,-19,-13r0,87","w":136},"\u0421":{"d":"127,-37v1,26,-31,39,-57,39v-43,0,-64,-15,-64,-45r0,-162v0,-33,21,-49,64,-49v59,0,60,36,57,90r-50,0r0,-50v0,-4,-3,-6,-8,-6v-5,0,-8,2,-8,6r0,175v0,4,3,6,8,6v5,0,8,-2,8,-6r0,-62r50,0r0,64","w":133},"\u0422":{"d":"122,-219r-31,0r0,219r-56,0r0,-219r-31,0r0,-33r118,0r0,33","w":126},"\u0423":{"d":"20,-32v24,-1,33,1,28,-20r-47,-200r52,0r23,121r16,-121r50,0r-41,208v-4,43,-34,46,-81,44r0,-32","w":143},"\u0424":{"d":"205,-125v1,48,-26,85,-72,85r0,40r-55,0r0,-40v-47,0,-71,-29,-71,-86v0,-56,24,-84,71,-84r0,-42r55,0r0,42v51,-2,72,38,72,85xm133,-174r1,98v30,6,36,-58,21,-83v-6,-10,-13,-15,-22,-15xm78,-174v-22,0,-30,25,-30,49v0,33,10,49,30,49r0,-98","w":211},"\u0425":{"d":"163,0r-60,0r-25,-81r-24,81r-53,0r44,-143r-32,-109r53,0r20,73r22,-73r49,0r-37,117","w":163},"\u0426":{"d":"176,36r-42,0r0,-36r-128,0r0,-252r56,0r0,220r16,0r0,-220r56,0r0,220r42,0r0,68","w":181},"\u0427":{"d":"73,-54v-18,15,-67,8,-67,-21r0,-177r50,0r0,164v0,6,3,10,9,10v6,0,8,-3,8,-9r0,-165r50,0r0,252r-50,0r0,-54"},"\u0428":{"d":"221,0r-214,0r0,-252r53,0r0,212r26,0r0,-212r54,0r0,212r27,0r0,-212r54,0r0,252","w":230},"\u0429":{"d":"262,36r-41,0r0,-36r-214,0r0,-252r53,0r0,212r26,0r0,-212r54,0r0,212r27,0r0,-212r54,0r0,220r41,0r0,68","w":270},"\u042a":{"d":"163,-45v3,59,-71,42,-126,45r0,-220r-36,0r0,-32r90,0r0,93v47,0,72,2,72,45r0,69xm91,-36v33,1,12,-48,18,-74v0,-9,-6,-13,-18,-13r0,87","w":169},"\u042b":{"d":"198,0r-55,0r0,-252r55,0r0,252xm133,-45v3,58,-71,42,-127,45r0,-252r54,0r0,93v50,2,73,0,73,45r0,69xm60,-123r0,87v34,0,13,-48,18,-75v2,-10,-7,-13,-18,-12","w":203},"\u042c":{"d":"133,-114v2,64,11,124,-67,114r-60,0r0,-252r54,0r0,93v50,2,72,0,73,45xm60,-36v33,1,14,-48,18,-74v2,-10,-6,-13,-18,-13r0,87","w":136},"\u042d":{"d":"6,-37v-1,26,31,40,57,40v43,0,64,-16,64,-46r0,-162v0,-33,-21,-49,-64,-49v-49,0,-61,23,-57,69r50,0v2,-24,-5,-31,8,-35v5,0,7,3,7,8r0,64r-49,0r0,33r49,0r0,77v0,4,-2,6,-7,6v-17,-2,-4,-32,-8,-47r-50,0r0,42","w":133},"\u042e":{"d":"82,-153v-1,-79,-3,-101,64,-101v42,0,62,17,62,49r0,162v0,30,-20,46,-62,46v-76,0,-64,-55,-64,-120r-20,0r0,117r-55,0r0,-252r55,0r0,99r20,0xm155,-40r0,-172v0,-5,-3,-7,-9,-7v-6,0,-10,2,-10,7r0,172v0,5,4,8,10,8v6,0,9,-3,9,-8","w":214},"\u042f":{"d":"137,-252v-56,1,-125,-10,-126,45v-1,38,0,61,34,70v-33,6,-34,32,-34,69v0,40,-3,63,-10,68r55,0v11,-10,9,-76,9,-108v0,-9,6,-13,17,-13r0,121r55,0r0,-252xm82,-152v-27,2,-17,-32,-17,-54v0,-9,6,-14,17,-14r0,68","w":144},"\u0430":{"d":"6,-70v-2,-36,51,-42,68,-64v-2,-14,6,-40,-9,-40v-14,0,-9,33,-9,51r-48,0v-3,-53,0,-82,60,-82v37,0,56,14,56,43r0,162r-45,0r0,-8v-13,20,-82,13,-73,-21r0,-41xm65,-29v19,-5,5,-42,9,-62v-26,3,-17,28,-18,53v0,6,3,9,9,9","w":129},"\u0431":{"d":"123,-31v1,33,-51,44,-75,24v-3,13,-28,5,-42,7r0,-185v-2,-66,37,-70,97,-70v8,0,15,-1,19,-2r0,43v-22,12,-75,-19,-66,34v19,-15,67,-9,67,21r0,128xm73,-38r0,-109v0,-6,-2,-9,-8,-9v-6,0,-9,3,-9,9r0,109v0,6,3,9,9,9v6,0,8,-3,8,-9"},"\u0432":{"d":"131,-50v2,59,-67,51,-125,50r0,-204v60,1,123,-12,123,60v0,17,-10,30,-32,38v32,10,33,14,34,56xm62,-121v19,1,14,-20,15,-37v0,-9,-5,-14,-15,-14r0,51xm62,-32v23,1,13,-29,15,-49v0,-9,-5,-13,-15,-13r0,62","w":136},"\u0433":{"d":"111,-172r-49,0r0,172r-56,0r0,-204r105,0r0,32","w":113},"\u0434":{"d":"223,54r-42,0r0,-54r-136,0r0,54r-38,0r0,-90r21,0v46,-37,35,-95,36,-168r117,0r0,168r42,0r0,90xm112,-168v0,70,1,85,-27,132r46,0r0,-132r-19,0","w":230},"\u0435":{"d":"123,-86r-67,0v3,19,-8,53,8,58v17,-3,6,-35,9,-52r50,0v3,52,1,83,-59,83v-90,0,-58,-94,-58,-165v0,-29,19,-43,58,-43v75,0,57,57,59,119xm73,-117v-3,-18,9,-53,-9,-57v-17,4,-4,39,-8,57r17,0"},"\u0436":{"d":"75,-103v-50,-1,-63,-16,-64,-66v0,-19,-3,-31,-9,-35r52,0v13,4,-3,78,21,72r0,-72r50,0r0,72v14,2,14,-7,14,-29v0,-23,3,-37,8,-43r50,0v-13,13,-8,88,-25,90v-13,10,-27,12,-47,11v41,8,62,24,62,49v0,31,4,49,10,54r-50,0v-14,-3,3,-78,-22,-72r0,72r-50,0r0,-72v-22,-6,-9,67,-21,72r-52,0v7,-6,10,-24,10,-54v0,-36,27,-40,63,-49","w":198},"\u0437":{"d":"64,3v-41,0,-66,-25,-57,-75r50,0v3,14,-7,39,8,40v5,0,7,-2,7,-6r0,-54r-49,0r0,-32r49,0v-3,-16,8,-45,-7,-49v-11,0,-9,17,-8,28r-50,0v-3,-42,12,-60,57,-62v92,-5,64,90,64,164v0,32,-30,46,-64,46","w":133},"\u0438":{"d":"6,0r0,-204r46,0r0,106r46,-106r49,0r0,204r-46,0r0,-94r-38,94r-57,0","w":152},"\u0439":{"d":"6,0r0,-204r46,0r0,106r46,-106r49,0r0,204r-46,0r0,-94r-38,94r-57,0xm127,-261v-3,28,-20,41,-51,41v-31,0,-49,-13,-51,-41r27,0v2,24,46,24,47,0r28,0","w":152},"\u043a":{"d":"58,-138v29,-56,18,-72,79,-66r0,37v-28,3,-16,16,-38,53r49,114r-59,0r-31,-76r0,76r-52,0r0,-204r52,0r0,66","w":147},"\u043b":{"d":"4,-35v13,4,23,4,23,-15r0,-154r125,0r0,204r-54,0r0,-171r-19,0r0,141v4,34,-43,37,-75,30r0,-35","w":158},"\u043c":{"d":"199,0r-49,0r0,-144r-29,144r-38,0r-33,-144r0,144r-43,0r0,-204r71,0r25,131r22,-131r74,0r0,204","w":205},"\u043d":{"d":"132,0r-56,0r0,-97r-14,0r0,97r-56,0r0,-204r56,0r0,76r14,0r0,-76r56,0r0,204","w":136},"\u043e":{"d":"64,-205v28,0,58,12,58,41r0,126v0,28,-19,41,-58,41v-91,0,-59,-94,-59,-165v0,-29,19,-43,59,-43xm72,-39r0,-125v0,-7,-3,-10,-9,-10v-6,0,-8,3,-8,10r0,125v0,7,2,11,8,11v6,0,9,-4,9,-11","w":126},"\u043f":{"d":"132,0r-54,0r0,-171r-19,0r0,171r-52,0r0,-204r125,0r0,204","w":136},"\u0440":{"d":"123,-25v1,30,-49,34,-68,20r0,48r-50,0r0,-247v15,2,40,-6,42,8v24,-19,76,-8,76,24r0,147xm73,-38r0,-127v0,-6,-3,-9,-9,-9v-6,0,-9,3,-9,9r0,127v0,6,3,9,9,9v6,0,9,-3,9,-9"},"\u0441":{"d":"123,-114r-50,0v-3,-19,9,-56,-9,-60v-6,0,-9,3,-9,10r0,125v0,7,3,11,9,11v18,-4,5,-41,9,-60r50,0v2,54,5,91,-58,91v-92,0,-60,-93,-60,-165v0,-29,20,-43,60,-43v63,0,60,36,58,91"},"\u0442":{"d":"122,-171r-31,0r0,171r-55,0r0,-171r-31,0r0,-33r117,0r0,33","w":126},"\u0443":{"d":"20,16v22,-1,27,3,29,-14v-3,-22,-37,-161,-48,-206r50,0r21,108r17,-108r49,0r-39,203v-3,49,-32,44,-79,44r0,-27","w":139},"\u0444":{"d":"191,-25v1,30,-49,34,-68,20r0,48r-50,0r0,-44v-26,11,-67,0,-67,-30r0,-146v-2,-30,47,-34,67,-21r0,-54r50,0r0,51v26,-11,69,1,68,29r0,147xm141,-38r0,-127v0,-6,-3,-9,-9,-9v-6,0,-9,3,-9,9r0,127v0,6,3,9,9,9v6,0,9,-3,9,-9xm73,-38r0,-127v0,-6,-2,-9,-8,-9v-6,0,-9,3,-9,9r0,127v0,6,3,9,9,9v6,0,8,-3,8,-9","w":196},"\u0445":{"d":"140,0r-55,0r-18,-55r-16,55r-50,0r39,-108r-38,-96r53,0r17,53r14,-53r47,0r-33,99","w":140},"\u0446":{"d":"176,36r-42,0r0,-36r-128,0r0,-204r56,0r0,172r16,0r0,-172r56,0r0,172r42,0r0,68","w":181},"\u0447":{"d":"73,-54v-18,15,-67,8,-67,-21r0,-129r50,0r0,116v0,6,3,10,9,10v6,0,8,-3,8,-9r0,-117r50,0r0,204r-50,0r0,-54"},"\u0448":{"d":"221,0r-214,0r0,-204r53,0r0,164r26,0r0,-164r54,0r0,164r27,0r0,-164r54,0r0,204","w":230},"\u0449":{"d":"262,36r-41,0r0,-36r-214,0r0,-204r53,0r0,164r26,0r0,-164r54,0r0,164r27,0r0,-164r54,0r0,172r41,0r0,68","w":270},"\u044a":{"d":"163,-45v5,60,-70,41,-126,45r0,-172r-36,0r0,-32r90,0r0,63v50,2,72,-1,72,44r0,52xm91,-36v29,2,18,-33,18,-56v0,-9,-6,-13,-18,-13r0,69","w":169},"\u044b":{"d":"198,0r-55,0r0,-204r55,0r0,204xm133,-45v3,58,-70,42,-127,45r0,-204r54,0r0,63v50,2,73,0,73,44r0,52xm60,-36v29,2,18,-33,18,-56v0,-9,-6,-13,-18,-13r0,69","w":203},"\u044c":{"d":"133,-45v3,58,-70,42,-127,45r0,-204r54,0r0,63v49,2,73,0,73,44r0,52xm60,-36v29,2,18,-33,18,-56v0,-9,-6,-13,-18,-13r0,69","w":136},"\u044d":{"d":"5,-132r50,0v-6,-19,5,-61,17,-32r0,49r-17,0r0,29r17,0v-3,19,8,54,-9,58v-12,2,-9,-29,-8,-42r-50,0v-3,48,4,73,58,73v91,0,59,-94,59,-165v0,-29,-19,-43,-59,-43v-54,-1,-62,24,-58,73"},"\u044e":{"d":"147,3v-64,0,-64,-33,-64,-93r-20,0r0,90r-55,0r0,-204r55,0r0,78r20,0v3,-62,1,-77,64,-80v90,-5,63,89,63,163v0,30,-21,46,-63,46xm156,-40r0,-124v0,-5,-3,-7,-9,-7v-6,0,-10,2,-10,7r0,124v0,5,4,8,10,8v6,0,9,-3,9,-8","w":217},"\u044f":{"d":"10,-159v0,-54,70,-45,126,-45r0,204r-55,0r0,-85v-36,-2,-4,65,-25,85r-56,0v6,-5,10,-19,10,-45v2,-40,1,-48,34,-57v-32,-11,-34,-15,-34,-57xm81,-115r0,-57v-23,-1,-16,23,-17,43v0,9,6,14,17,14","w":144},"\u0451":{"d":"123,-86r-67,0v3,19,-8,53,8,58v17,-3,6,-35,9,-52r50,0v3,52,1,83,-59,83v-90,0,-58,-94,-58,-165v0,-29,19,-43,58,-43v75,0,57,57,59,119xm73,-117v-3,-18,9,-53,-9,-57v-17,4,-4,39,-8,57r17,0xm73,-237v0,-10,7,-17,17,-17v11,0,18,6,18,17v-1,9,-8,17,-18,17v-12,0,-17,-6,-17,-17xm23,-237v0,-10,7,-17,17,-17v11,0,17,6,17,17v0,10,-8,18,-17,17v-12,0,-17,-6,-17,-17"},"\u0452":{"d":"88,-187v36,1,41,20,41,58v0,80,30,194,-64,189r0,-40v13,-1,14,-4,14,-20r0,-136v0,-10,-3,-15,-9,-15v-6,0,-8,5,-8,16r0,135r-50,0r0,-204r-12,0r0,-30r12,0r0,-18r50,0r0,18r43,0r0,30r-43,0r0,21v3,-3,12,-4,26,-4","w":136},"\u0453":{"d":"57,-197v19,-15,67,-10,67,21r0,56r-50,0v-3,-17,8,-49,-8,-53v-6,0,-9,3,-9,9r0,164r-50,0r0,-204r50,0r0,7xm74,-252r-7,39r-28,0r-7,-39r42,0"},"\u0454":{"d":"123,-132r-50,0v6,-19,-5,-61,-17,-32r0,49r17,0r0,29r-17,0v3,19,-8,54,9,58v12,2,9,-29,8,-42r50,0v3,48,-4,73,-58,73v-91,0,-59,-94,-59,-165v0,-29,19,-43,59,-43v54,-1,62,24,58,73"},"\u0455":{"d":"55,-158v-13,50,66,37,68,87v2,49,-6,74,-60,74v-60,0,-61,-32,-58,-85r50,0v3,18,-8,50,9,54v14,-2,8,-52,-2,-54v-46,-26,-57,-18,-55,-80v0,-29,19,-43,58,-43v57,0,60,30,57,81r-49,0v1,-15,3,-51,-8,-50v-6,0,-10,5,-10,16","w":127},"\u0456":{"d":"55,-215r-50,0r0,-37r50,0r0,37xm55,0r-50,0r0,-204r50,0r0,204","w":59},"\u0457":{"d":"55,0r-50,0r0,-204r50,0r0,204xm39,-237v0,-10,7,-17,17,-17v11,0,18,6,18,17v-1,9,-8,17,-18,17v-12,0,-17,-6,-17,-17xm-11,-237v0,-10,7,-17,17,-17v11,0,17,6,17,17v0,10,-8,18,-17,17v-12,0,-17,-6,-17,-17","w":59},"\u0458":{"d":"57,-215r-50,0r0,-37r50,0r0,37xm-21,14v21,-2,27,4,28,-14r0,-204r50,0r0,209v3,40,-38,40,-78,38r0,-29","w":64},"\u0459":{"d":"226,-45v4,60,-71,42,-128,45r0,-171r-19,0r0,141v4,34,-43,37,-75,30r0,-35v13,4,23,4,23,-15r0,-154r127,0r0,63v50,2,72,-1,72,44r0,52xm154,-36v29,2,18,-33,18,-56v0,-9,-6,-13,-18,-13r0,69","w":233},"\u045a":{"d":"204,-97v1,63,8,105,-72,97r-56,0r0,-92r-14,0r0,92r-56,0r0,-204r56,0r0,81r14,0r0,-81r56,0r0,63v50,2,71,-1,72,44xm132,-36v29,2,18,-33,18,-56v0,-9,-6,-13,-18,-13r0,69","w":210},"\u045b":{"d":"56,-176v18,-14,67,-10,67,20r0,156r-50,0r0,-143v0,-6,-2,-9,-8,-9v-6,0,-9,3,-9,9r0,143r-50,0r0,-204r-6,0r0,-30r6,0r0,-18r50,0r0,18r55,0r0,30r-55,0r0,28","w":129},"\u045c":{"d":"58,-138v29,-56,18,-72,79,-66r0,37v-28,3,-16,16,-38,53r49,114r-59,0r-31,-76r0,76r-52,0r0,-204r52,0r0,66xm88,-252r-7,39r-28,0r-7,-39r42,0","w":147},"\u045e":{"d":"20,16v22,-1,27,3,29,-14v-3,-22,-37,-161,-48,-206r50,0r21,108r17,-108r49,0r-39,203v-3,49,-32,44,-79,44r0,-27xm120,-261v-3,28,-20,41,-51,41v-31,0,-49,-13,-51,-41r27,0v2,24,46,24,47,0r28,0","w":139},"\u045f":{"d":"134,0r-43,0r0,43r-41,0r0,-43r-44,0r0,-204r56,0r0,172r16,0r0,-172r56,0r0,204","w":140},"\u0490":{"d":"149,-220r-87,0r0,220r-56,0r0,-252r105,0r0,-35r38,0r0,67","w":154},"\u0491":{"d":"149,-172r-87,0r0,172r-56,0r0,-204r105,0r0,-35r38,0r0,67","w":154},"\u2015":{"d":"11,-81r0,-25r338,0r0,25r-338,0","w":360},"\u2116":{"d":"147,0r-57,0r-37,-134r0,134r-46,0r0,-252r62,0r32,115r0,-115r46,0r0,252xm217,-202v31,0,58,13,58,42v-2,61,17,120,-58,120v-75,0,-57,-57,-59,-119v0,-29,19,-43,59,-43xm208,-160r0,78v0,7,2,10,8,10v6,0,9,-3,9,-10r0,-79v0,-6,-3,-9,-9,-9v-6,0,-8,3,-8,10xm266,0r-96,0r0,-23r96,0r0,23","w":286},"\u03c0":{"d":"203,-175r-27,0r0,175r-50,0r0,-175r-43,0r0,175r-50,0r0,-175r-26,0r0,-30r196,0r0,30","w":209},"\u00a4":{"d":"149,-31r-23,23r-21,-20v-18,10,-38,9,-56,0r-19,20r-23,-23r19,-19v-10,-19,-11,-39,0,-58r-19,-19r23,-23r19,20v17,-11,40,-10,57,0r20,-20r23,22r-21,20v10,15,11,42,0,57xm77,-55v14,0,24,-10,24,-24v0,-13,-11,-24,-24,-24v-15,0,-24,11,-24,24v0,13,11,24,24,24","w":155}}});
