<?php get_header(); ?>

<div id="contentwrap">

	<?php if (have_posts()) : ?>

		<?php while (have_posts()) : the_post(); ?>

			<div <?php post_class() ?> id="post-<?php the_ID(); ?>">
				<h2 class="title"><a href="<?php the_permalink() ?>" rel="bookmark" title="Permanent Link to <?php the_title_attribute(); ?>"><?php the_title(); ?></a></h2>
				<div class="entry">
                <?php if ( function_exists( 'get_the_image' ) ) {
            get_the_image( array( 'custom_key' => array( 'post_thumbnail' ), 'image_class' => 'alignleft', 'width' => '218', 'height' => '173' ) ); }
            ?>
                    <?php truncate_post(650, true); ?>
				</div>

            	<div class="meta">
                <span class="rest"><span class="author">Posted by <?php the_author(); ?> <?php edit_post_link('[Edit]', '', ' '); ?></span> <span class="date">on <?php the_time('d M, Y'); ?></span> <span class="cat">in <?php the_category(', ') ?></span></span>
                <a class="more-link" href="<?php the_permalink() ?>#more">Read More</a>
                </div>
			</div>

		<?php endwhile; ?>

		<div class="navigation">
        <?php
            include('includes/wp-pagenavi.php');
            if(function_exists('wp_pagenavi')) { wp_pagenavi(); }
        ?>
		</div>

	<?php else : ?>

        <div class="post">
    		<h2 class="center">Not Found</h2>
    		<p class="center">Sorry, but you are looking for something that isn't here.</p>
    		<?php get_search_form(); ?>
        </div>
	<?php endif; ?>
</div>
<?php get_sidebar(); ?>
</div>
</div>
<?php include('sidebar-bottom.php'); ?>
<?php get_footer(); ?>
