<?php get_header(); ?>

<div id="contentwrap">

	<?php if (have_posts()) : ?>

		<?php while (have_posts()) : the_post(); ?>

			<div <?php post_class() ?> id="post-<?php the_ID(); ?>">
				<h2 class="title"><a href="<?php the_permalink() ?>" rel="bookmark" title="Permanent Link to <?php the_title_attribute(); ?>"><?php the_title(); ?></a></h2>
                <div class="meta">
                 <span class="rest">Posted by <?php the_author(); ?> <?php edit_post_link('[Edit]', '', ' '); ?> on <?php the_time('d M, Y'); ?> in <?php the_category(', ') ?></span>
                <span class="comm"><?php comments_popup_link('Comments (<span>0</span>)', 'Comment (<span>1</span>)', 'Comments (<span>%</span>)'); ?></span>

                </div>
				<div class="entry">
                <?php if ( function_exists( 'get_the_image' ) ) {
            get_the_image( array( 'custom_key' => array( 'post_thumbnail' ), 'image_class' => 'alignleft', 'width' => '218', 'height' => '173' ) ); }
            ?>
                    <?php truncate_post(650, true); ?>
				</div>

            	<p class="postmetadata"><a class="more-link" href="<?php the_permalink() ?>#more">Read More</a></p>
			</div>

		<?php endwhile; ?>

		<div class="navigation">
        <?php
            include('includes/wp-pagenavi.php');
            if(function_exists('wp_pagenavi')) { wp_pagenavi(); }
        ?>
		</div>

	<?php else : ?>

		<h2 class="center">Not Found</h2>
		<p class="center">Sorry, but you are looking for something that isn't here.</p>
		<?php get_search_form(); ?>

	<?php endif; ?>
</div>
<?php get_sidebar(); ?>
</div>
<?php include('sidebar-bottom.php'); ?>
<?php get_footer(); ?>
