<?php
/*this function allows for the auto-creation of post excerpts*/
function truncate_post($amount,$quote_after=false) {
	$truncate = get_the_content();
	$truncate = apply_filters('the_content', $truncate);
	$truncate = preg_replace('@<script[^>]*?>.*?</script>@si', '', $truncate);
	$truncate = preg_replace('@<style[^>]*?>.*?</style>@si', '', $truncate);
	$truncate = strip_tags($truncate);
	$truncate = substr($truncate, 0, strrpos(substr($truncate, 0, $amount), ' '));
	echo $truncate;
	echo "...";
	if ($quote_after) echo('"');
}
?>
<div id="wrap">
<script type="text/javascript">
$(document).ready(function() {

	//Speed of the slideshow
	var speed = 5000;

	//You have to specify width and height in #slider CSS properties
	//After that, the following script will set the width and height accordingly
	$('#mask-gallery, #gallery li').width($('#slider').width());
	$('#gallery').width($('#slider').width() * $('#gallery li').length);
	$('#mask-gallery, #gallery li, #mask-excerpt, #excerpt li').height($('#slider').height());

	//Assign a timer, so it will run periodically
	var run = setInterval('newsscoller(0)', speed);

	$('#gallery li:first, #excerpt li:first').addClass('selected');

	//Pause the slidershow with clearInterval
	$('#btn-pause').click(function () {
		clearInterval(run);
		return false;
	});

	//Continue the slideshow with setInterval
	$('#btn-play').click(function () {
		run = setInterval('newsscoller(0)', speed);
		return false;
	});

	//Next Slide by calling the function
	$('#btn-next').click(function () {
		newsscoller(0);
		return false;
	});

	//Previous slide by passing prev=1
	$('#btn-prev').click(function () {
		newsscoller(1);
		return false;
	});

	//Mouse over, pause it, on mouse out, resume the slider show
	$('#slider').hover(

		function() {
			clearInterval(run);
		},
		function() {
			run = setInterval('newsscoller(0)', speed);
		}
	);

});


function newsscoller(prev) {

	//Get the current selected item (with selected class), if none was found, get the first item
	var current_image = $('#gallery li.selected').length ? $('#gallery li.selected') : $('#gallery li:first');
	var current_excerpt = $('#excerpt li.selected').length ? $('#excerpt li.selected') : $('#excerpt li:first');

	//if prev is set to 1 (previous item)
	if (prev) {

		//Get previous sibling
		var next_image = (current_image.prev().length) ? current_image.prev() : $('#gallery li:last');
		var next_excerpt = (current_excerpt.prev().length) ? current_excerpt.prev() : $('#excerpt li:last');

	//if prev is set to 0 (next item)
	} else {

		//Get next sibling
		var next_image = (current_image.next().length) ? current_image.next() : $('#gallery li:first');
		var next_excerpt = (current_excerpt.next().length) ? current_excerpt.next() : $('#excerpt li:first');
	}

	//clear the selected class
	$('#excerpt li, #gallery li').removeClass('selected');

	//reassign the selected class to current items
	next_image.addClass('selected');
	next_excerpt.addClass('selected');

	//Scroll the items
	$('#mask-gallery').scrollTo(next_image, 800);
	$('#mask-excerpt').scrollTo(next_excerpt, 800);

}
</script>
<div id="slider">
<?php
	$slidecat = get_option('swt_slide_category');
	$slidecount = get_option('swt_slide_count');
?>
	<div id="mask-gallery">
	<ul id="gallery">
    <?php
 	$my_query = new WP_Query('category_name= '. $slidecat .'&showposts='.$slidecount.'');
    while ($my_query->have_posts()) : $my_query->the_post();$do_not_duplicate = $post->ID;
    ?>
         <?php $screen = get_post_meta($post->ID,'slide', true); ?>
         <li><img src="<?php echo ($screen); ?>" width="640" height="245" alt="<?php the_title(); ?>" /></li>
    <?php endwhile; ?>

	</ul>
	</div>

	<div id="mask-excerpt">
	<ul id="excerpt">
        <?php
       	  $my_query = new WP_Query('category_name= '. $slidecat .'&showposts='.$slidecount.'');
          while ($my_query->have_posts()) : $my_query->the_post();$do_not_duplicate = $post->ID;
        ?>
		    <li>
            <h2><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h2>
             <?php truncate_post(120,true); ?>  
            </li>
        <?php endwhile; ?>
	</ul>
	</div>

</div>

<div id="buttons">
	<a href="#" id="btn-prev">prev</a>
	<a href="#" id="btn-pause">pause</a>
	<a href="#" id="btn-play">play</a>
	<a href="#" id="btn-next">next</a>
</div>


<div class="clear"></div>
</div>